/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.downloads;

import java.io.File;
import java.util.Date;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoveOldDownloads
extends TimerTask {
    private static final Log log = LogFactory.getLog(RemoveOldDownloads.class);
    private String downloadPath = null;
    private int folderAliveInSeconds = 86400;

    public RemoveOldDownloads(String path, int alive) {
        this.downloadPath = path;
        this.folderAliveInSeconds = alive;
    }

    public void run() {
        log.debug((Object)"BEGIN RemoveOldDownloads.");
        Date now = new Date();
        File workingDir = new File(this.downloadPath);
        if (workingDir.exists() && workingDir.isDirectory()) {
            File[] files = workingDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                long seconds = (now.getTime() - files[i].lastModified()) / 1000L;
                log.debug((Object)("CHECKING: " + files[i].toString() + " ALIVE: " + seconds));
                if (seconds <= (long)this.folderAliveInSeconds) continue;
                this.removeFilesAndFolder(files[i]);
            }
        }
        log.debug((Object)"END RemoveOldDownloads.");
    }

    private void removeFilesAndFolder(File folder) {
        if (folder.exists()) {
            log.debug((Object)("REMOVING: " + folder.toString()));
            if (folder.isDirectory()) {
                File[] files = folder.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    files[i].delete();
                }
            }
            folder.delete();
        }
    }
}

