/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.gis.geotools.DataStoreUtil;
import nl.b3p.gis.geotools.FilterBuilder;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.ThemaData;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.ObjectdataPdfInfo;
import nl.b3p.gis.viewer.services.SpatialUtil;
import nl.b3p.imagetool.CombineImageSettings;
import nl.b3p.imagetool.CombineImagesHandler;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.hibernate.Transaction;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.filter.Filter;

public class Data2PDF
extends HttpServlet {
    private static final Log log = LogFactory.getLog(Data2PDF.class);
    private static String HTMLTITLE = "Exporteren";
    private static String xsl_data2pdf = null;
    private static String xsl_data2html = null;
    private static Integer MAX_PDF_RECORDS = 25;
    public static String fopConfig = null;
    public static String fontPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String appCode = request.getParameter("appCode");
        String gegevensbronId = request.getParameter("gbId");
        String objectIds = request.getParameter("objectIds");
        String orientation = request.getParameter("orientation");
        String format = request.getParameter("format");
        if (gegevensbronId == null || gegevensbronId.equals("") || objectIds == null || objectIds.equals("")) {
            this.writeErrorMessage(response, "Ongeldige request parameters.");
            log.error((Object)"Ongeldige request parameters.");
            return;
        }
        if ((xsl_data2pdf == null || xsl_data2pdf.equals("")) && (format == null || format.equalsIgnoreCase("pdf"))) {
            this.writeErrorMessage(response, "Xsl PDF template niet geconfigureerd.");
            log.error((Object)"Xsl PDF template niet geconfigureerd.");
            return;
        }
        if ((xsl_data2html == null || xsl_data2html.equals("")) && format != null && format.equalsIgnoreCase("html")) {
            this.writeErrorMessage(response, "Xsl HTML template niet geconfigureerd.");
            log.error((Object)"Xsl HTML template niet geconfigureerd.");
            return;
        }
        Transaction tx = HibernateUtil.getSessionFactory().getCurrentSession().beginTransaction();
        try {
            Gegevensbron gb = SpatialUtil.getGegevensbron(gegevensbronId);
            String decoded = URLDecoder.decode(objectIds, "UTF-8");
            String[] ids = decoded.split(",");
            MAX_PDF_RECORDS = this.getMaxPDFRecords(gb, appCode);
            if (ids != null && ids.length > MAX_PDF_RECORDS) {
                String msg = "Er mogen maximaal " + MAX_PDF_RECORDS + " records  geexporteerd worden. Momenteel zijn er " + ids.length + " records geselecteerd.";
                this.writeErrorMessage(response, msg);
                log.debug((Object)msg);
                return;
            }
            GisPrincipal user = GisPrincipal.getGisPrincipal(request);
            if (user == null) {
                this.writeErrorMessage(response, "Kan de data niet ophalen omdat u niet bent ingelogd.");
                return;
            }
            Bron b = gb.getBron(request);
            if (b == null) {
                throw new ServletException("Gegevensbron (id " + gb.getId() + ") Bron null.");
            }
            List data = null;
            Boolean withDataOrder = this.displayAllWithDataOrder(gb, appCode);
            Boolean basisOnly = this.displayOnlyBasisRegel(gb, appCode);
            if (withDataOrder.booleanValue()) {
                basisOnly = false;
            }
            String[] propertyNames = this.getThemaPropertyNames(gb, basisOnly, withDataOrder);
            Map columnLabels = this.getThemaLabelNames(gb, basisOnly, withDataOrder);
            try {
                data = this.getData(b, gb, ids, propertyNames, appCode);
            }
            catch (Exception ex) {
                this.writeErrorMessage(response, ex.getMessage());
                log.error((Object)"Fout bij laden pdf data.", (Throwable)ex);
                HibernateUtil.getSessionFactory().getCurrentSession().close();
                return;
            }
            Date now = new Date();
            SimpleDateFormat df = new SimpleDateFormat("d MMMMM yyyy", new Locale("NL"));
            ObjectdataPdfInfo pdfInfo = new ObjectdataPdfInfo();
            pdfInfo.setTitel(gb.getNaam());
            pdfInfo.setDatum(df.format(now));
            HashMap<Integer, ObjectdataPdfInfo.Record> records = new HashMap<Integer, ObjectdataPdfInfo.Record>();
            Base64 enc = new Base64();
            String jsonSettingsParam = FormUtils.nullIfEmpty((String)request.getParameter("jsonSettings"));
            String legendUrls = FormUtils.nullIfEmpty((String)request.getParameter("legendUrls"));
            JSONObject jsonSettings = new JSONObject(jsonSettingsParam);
            String mimeType = FormUtils.nullIfEmpty((String)request.getParameter("FORMAT"));
            if (mimeType == null || !mimeType.equals("")) {
                // empty if block
            }
            int i = 0;
            for (Object obj : data) {
                CombineImageSettings settings = null;
                try {
                    settings = this.getCombineImageSettings(jsonSettings, legendUrls);
                }
                catch (Exception ex) {
                    log.error((Object)"Fout tijdens ophalen combine settings: ", (Throwable)ex);
                }
                settings.setWidth(Integer.valueOf(500));
                settings.setHeight(Integer.valueOf(375));
                settings.setMimeType(mimeType);
                String[] items = (String[])obj;
                ObjectdataPdfInfo.Record record = new ObjectdataPdfInfo.Record();
                record.setId(i);
                String wkt = items[items.length - 1];
                Geometry geom = null;
                try {
                    geom = DataStoreUtil.createGeomFromWKTString(wkt);
                }
                catch (Exception ex) {
                    log.error((Object)"Fout tijdens knutselen geometrie: ", (Throwable)ex);
                }
                Envelope bbox = geom.getEnvelopeInternal();
                double[] dbbox = new double[4];
                double bufferSize = 50.0;
                dbbox[0] = bbox.getMinX() - bufferSize;
                dbbox[1] = bbox.getMinY() - bufferSize;
                dbbox[2] = bbox.getMaxX() + bufferSize;
                dbbox[3] = bbox.getMaxY() + bufferSize;
                settings.setBbox(dbbox);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                String imageUrl = "";
                try {
                    CombineImagesHandler.combineImage((OutputStream)baos, (CombineImageSettings)settings);
                    byte[] imageBytes = baos.toByteArray();
                    imageUrl = enc.encodeToString(imageBytes);
                }
                catch (Exception imageBytes) {
                    // empty catch block
                }
                record.setImageUrl(imageUrl);
                for (int j = 0; j < items.length - 1; ++j) {
                    String string = items[j];
                    String propertyName = propertyNames[j];
                    String label = (String)columnLabels.get(propertyName);
                    record.addItem(label, string);
                }
                records.put(i, record);
                ++i;
            }
            pdfInfo.setRecords(records);
            if (format == null || format.isEmpty() || format.equalsIgnoreCase("pdf")) {
                Data2PDF.createPdfOutput(pdfInfo, xsl_data2pdf, response);
            } else if (format.equalsIgnoreCase("html")) {
                Data2PDF.createHtmlOutput(pdfInfo, xsl_data2html, response);
            } else if (format.equalsIgnoreCase("xml")) {
                Data2PDF.createXmlOutput(pdfInfo, response);
            }
        }
        catch (JSONException ex) {
            log.error((Object)"Error creating CombineImageSettings: ", (Throwable)ex);
        }
        finally {
            HibernateUtil.getSessionFactory().getCurrentSession().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createXmlOutput(ObjectdataPdfInfo pdfInfo, HttpServletResponse response) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectdataPdfInfo.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)pdfInfo, (OutputStream)out);
            response.setContentType("text/xml");
            response.setContentLength(out.size());
            SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy", new Locale("NL"));
            String date = df.format(new Date());
            String fileName = "Objectdata_Export_" + date + ".xml";
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.getOutputStream().write(out.toByteArray());
            response.getOutputStream().flush();
        }
        catch (JAXBException jex) {
            log.error((Object)"Fout tijdens objectdata xml export: ", (Throwable)jex);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createHtmlOutput(ObjectdataPdfInfo pdfInfo, String template, HttpServletResponse response) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        File xslFile = new File(template);
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ObjectdataPdfInfo.class});
            JAXBSource src = new JAXBSource(jc, (Object)pdfInfo);
            StreamSource xsltSrc = new StreamSource(xslFile);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(xsltSrc);
            if (transformer == null) {
                log.error((Object)"Fout tijdens inlezen xsl bestand.");
                return;
            }
            StreamResult res = new StreamResult((OutputStream)out);
            transformer.transform((Source)src, res);
            response.setContentType("text/html");
            response.setContentLength(out.size());
            SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy", new Locale("NL"));
            String date = df.format(new Date());
            String fileName = "Objectdata_Export_" + date + ".html";
            response.setHeader("Content-Disposition", "inline; filename=" + fileName);
            response.getOutputStream().write(out.toByteArray());
            response.getOutputStream().flush();
        }
        catch (JAXBException jex) {
            log.error((Object)"Fout tijdens objectdata html export: ", (Throwable)jex);
        }
        catch (TransformerConfigurationException ex) {
            log.error((Object)"Fout tijdens objectdata html export: ", (Throwable)ex);
        }
        catch (TransformerException ex) {
            log.error((Object)"Fout tijdens objectdata html export: ", (Throwable)ex);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPdfOutput(ObjectdataPdfInfo pdfInfo, String template, HttpServletResponse response) throws IOException {
        File xslFile = new File(template);
        String path = new File(xslFile.getParent()).toURI().toString();
        FopFactory fopFactory = FopFactory.newInstance();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            fopFactory.setBaseURL(path);
            fopFactory.getFontManager().setFontBaseURL(fontPath);
            fopFactory.setUserConfig(new File(fopConfig));
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            foUserAgent.setCreator("Gisviewer webapplicatie");
            foUserAgent.setProducer("B3Partners");
            Date now = new Date();
            foUserAgent.setCreationDate(now);
            foUserAgent.setTitle("Objectdata PDF Export");
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)out);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ObjectdataPdfInfo.class});
            JAXBSource src = new JAXBSource(jc, (Object)pdfInfo);
            StreamSource xsltSrc = new StreamSource(xslFile);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(xsltSrc);
            if (transformer == null) {
                log.error((Object)"Fout tijdens inlezen xsl bestand.");
                return;
            }
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            if (transformer != null) {
                transformer.transform((Source)src, res);
            }
            response.setContentType("application/pdf");
            response.setContentLength(out.size());
            SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy", new Locale("NL"));
            String date = df.format(now);
            String fileName = "Objectdata_Export_" + date + ".pdf";
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.getOutputStream().write(out.toByteArray());
            response.getOutputStream().flush();
        }
        catch (Exception ex) {
            log.error((Object)"Fout tijdens objectdata pdf export: ", (Throwable)ex);
        }
        finally {
            out.close();
        }
    }

    public String[] getThemaPropertyNames(Gegevensbron gb) {
        return this.getThemaPropertyNames(gb, true, false);
    }

    public String[] getThemaPropertyNames(Gegevensbron gb, boolean basisOnly, boolean withDataOrder) {
        ArrayList themadata = new ArrayList(gb.getThemaData());
        Collections.sort(themadata);
        Iterator it = themadata.iterator();
        ArrayList<String> columns = new ArrayList<String>();
        while (it.hasNext()) {
            ThemaData td = (ThemaData)it.next();
            if (td.getKolomnaam() == null || columns.contains(td.getKolomnaam()) || !td.isBasisregel() && basisOnly) continue;
            if (!td.getKolomnaam().equalsIgnoreCase("the_geom") && !td.getKolomnaam().equalsIgnoreCase("geometry")) {
                columns.add(td.getKolomnaam());
            }
            if (td.getDataorder() != null || !withDataOrder) continue;
            columns.remove(columns.size() - 1);
        }
        String[] s = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            s[i] = (String)columns.get(i);
        }
        return s;
    }

    public Map getThemaLabelNames(Gegevensbron gb) {
        return this.getThemaLabelNames(gb, true, false);
    }

    public Map getThemaLabelNames(Gegevensbron gb, boolean basisOnly, boolean withDataOrder) {
        ArrayList themadata = new ArrayList(gb.getThemaData());
        Collections.sort(themadata);
        Iterator it = themadata.iterator();
        ArrayList<String> columns = new ArrayList<String>();
        HashMap<String, String> labels = new HashMap<String, String>();
        while (it.hasNext()) {
            ThemaData td = (ThemaData)it.next();
            if (td.getKolomnaam() == null || columns.contains(td.getKolomnaam()) || !td.isBasisregel() && basisOnly || td.getKolomnaam().equalsIgnoreCase("the_geom") || td.getKolomnaam().equalsIgnoreCase("geometry")) continue;
            columns.add(td.getKolomnaam());
            if (td.getLabel() != null) {
                labels.put(td.getKolomnaam(), td.getLabel());
            } else {
                labels.put(td.getKolomnaam(), td.getKolomnaam());
            }
            if (td.getDataorder() != null || !withDataOrder) continue;
            labels.remove(td.getKolomnaam());
        }
        return labels;
    }

    public List getData(Bron b, Gegevensbron gb, String[] pks, String[] propertyNames, String appCode) throws IOException, Exception {
        Filter filter = FilterBuilder.createOrEqualsFilter(DataStoreUtil.convertColumnNameToQName(gb.getAdmin_pk()).getLocalPart(), pks);
        List<ThemaData> items = SpatialUtil.getThemaData(gb, false);
        List<String> propnames = DataStoreUtil.themaData2PropertyNames(items);
        Integer maximum = ConfigKeeper.getMaxNumberOfFeatures(appCode);
        ArrayList<Feature> features = DataStoreUtil.getFeatures(b, gb, null, filter, propnames, maximum, true);
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (int i = 0; i < features.size(); ++i) {
            Feature f = features.get(i);
            String[] row = new String[propertyNames.length + 1];
            for (int p = 0; p < propertyNames.length; ++p) {
                Property property = f.getProperty(propertyNames[p]);
                row[p] = property != null && property.getValue() != null && property.getValue().toString() != null ? property.getValue().toString().trim() : "";
            }
            SimpleFeatureImpl feature = (SimpleFeatureImpl)f;
            Geometry geom = (Geometry)feature.getDefaultGeometry();
            String wkt = null;
            wkt = geom != null && !geom.isEmpty() ? geom.toText() : "POINT (0 0)";
            row[row.length - 1] = wkt;
            result.add(row);
        }
        return result;
    }

    private void writeErrorMessage(HttpServletResponse response, String message) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter pw = response.getWriter();
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title>" + HTMLTITLE + "</title>");
        pw.println("<script type=\"text/javascript\"> if(window.parent && (typeof window.parent.showCsvError == 'function')) { window.parent.showCsvError(); } </script>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<h1>Fout</h1>");
        pw.println("<h3>" + message + "</h3>");
        pw.println("</body>");
        pw.println("</html>");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            if (config.getInitParameter("xsl_data2pdf") != null) {
                xsl_data2pdf = this.getServletContext().getRealPath(config.getInitParameter("xsl_data2pdf"));
            }
            if (config.getInitParameter("xsl_data2html") != null) {
                xsl_data2html = this.getServletContext().getRealPath(config.getInitParameter("xsl_data2html"));
            }
            fopConfig = this.getServletContext().getRealPath("/WEB-INF/xsl/fop.xml");
            fontPath = this.getServletContext().getRealPath("/WEB-INF/xsl/fonts");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private CombineImageSettings getCombineImageSettings(JSONObject jsonSettings, String legendUrls) throws Exception {
        CombineImageSettings settings = CombineImageSettings.fromJson((JSONObject)jsonSettings);
        HashMap<String, String> legendMap = new HashMap<String, String>();
        if (legendUrls != null) {
            log.debug((Object)("legendUrls: " + legendUrls));
            String[] arr = legendUrls.split(";");
            for (int i = 0; i < arr.length; ++i) {
                String[] legendUrlsArr = arr[i].split("#");
                legendMap.put(legendUrlsArr[0], legendUrlsArr[1]);
            }
            settings.setLegendMap(legendMap);
        }
        return settings;
    }

    public int getMaxPDFRecords(Gegevensbron gb, String appCode) {
        Integer maxPDFRecords = null;
        try {
            ConfigKeeper configKeeper = new ConfigKeeper();
            Map<String, Object> map = configKeeper.getConfigMap(appCode, true);
            if (map != null) {
                maxPDFRecords = (Integer)map.get("maxPDFRecords");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (maxPDFRecords != null) {
            return maxPDFRecords;
        }
        return MAX_PDF_RECORDS;
    }

    public boolean displayOnlyBasisRegel(Gegevensbron gb, String appCode) {
        Boolean basisRegelOnly = null;
        try {
            ConfigKeeper configKeeper = new ConfigKeeper();
            Map<String, Object> map = configKeeper.getConfigMap(appCode, true);
            if (map != null) {
                basisRegelOnly = (Boolean)map.get("displayOnlyBasisRegel");
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        if (basisRegelOnly != null) {
            return basisRegelOnly;
        }
        return true;
    }

    public boolean displayAllWithDataOrder(Gegevensbron gb, String appCode) {
        Boolean displayAllWithDataOrder = null;
        try {
            ConfigKeeper configKeeper = new ConfigKeeper();
            Map<String, Object> map = configKeeper.getConfigMap(appCode, true);
            if (map != null) {
                displayAllWithDataOrder = (Boolean)map.get("displayAllWithDataOrder");
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        if (displayAllWithDataOrder != null) {
            return displayAllWithDataOrder;
        }
        return false;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

