/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.utils.KaartSelectieUtil;
import nl.b3p.gis.viewer.BaseGisAction;
import nl.b3p.gis.viewer.db.Applicatie;
import nl.b3p.gis.viewer.db.CMSPagina;
import nl.b3p.gis.viewer.db.Clusters;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.GisSecurityRealm;
import nl.b3p.gis.viewer.services.HibernateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.RedirectingActionForward;
import org.apache.struts.validator.DynaValidatorForm;
import org.securityfilter.filter.SecurityFilter;
import org.securityfilter.filter.SecurityRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexAction
extends BaseGisAction {
    private static final Log logger = LogFactory.getLog(IndexAction.class);
    protected static final String LOGIN = "login";
    protected static final String LOGINERROR = "loginError";
    protected static final String LOGOUT = "logout";
    protected static final String LIST = "list";
    protected static final String HELP = "help";
    private static final String PAGE_GISVIEWER_HOME = "gisviewer_home";
    private static final String PAGE_GISVIEWER_HELP = "gisviewer_help";
    private static final String PAGE_GISVIEWER_LOGIN = "gisviewer_login";

    protected Map getActionMethodPropertiesMap() {
        HashMap<String, ExtendedMethodProperties> map = new HashMap<String, ExtendedMethodProperties>();
        ExtendedMethodProperties hibProp = null;
        hibProp = new ExtendedMethodProperties(LOGIN);
        hibProp.setDefaultForwardName(LOGIN);
        hibProp.setAlternateForwardName("failure");
        map.put(LOGIN, hibProp);
        hibProp = new ExtendedMethodProperties(LOGINERROR);
        hibProp.setDefaultMessageKey("error.inlog");
        hibProp.setDefaultForwardName(LOGINERROR);
        hibProp.setAlternateForwardName("failure");
        map.put(LOGINERROR, hibProp);
        hibProp = new ExtendedMethodProperties(LOGOUT);
        hibProp.setDefaultForwardName(LOGOUT);
        hibProp.setAlternateForwardName("failure");
        map.put(LOGOUT, hibProp);
        hibProp = new ExtendedMethodProperties(LIST);
        hibProp.setDefaultForwardName("success");
        hibProp.setAlternateForwardName("failure");
        map.put(LIST, hibProp);
        hibProp = new ExtendedMethodProperties(HELP);
        hibProp.setDefaultMessageKey("algemeen.resetcache.success");
        hibProp.setDefaultForwardName(HELP);
        hibProp.setAlternateMessageKey("algemeen.resetcache.failure");
        hibProp.setAlternateForwardName(HELP);
        map.put(HELP, hibProp);
        return map;
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer firstCmsPageId = this.getFirstCMSPageId();
        String webApp = request.getContextPath();
        if (firstCmsPageId != null && firstCmsPageId > 0) {
            CMSPagina cmsPage = this.getCMSPage(firstCmsPageId);
            String url = this.prettifyCMSPageUrl(request, cmsPage);
            response.sendRedirect(response.encodeRedirectURL(url));
            return null;
        }
        this.createLists(dynaForm, request);
        this.populateTekstblok(request, PAGE_GISVIEWER_HOME);
        request.setAttribute("theme", (Object)"");
        return mapping.findForward("success");
    }

    private String findCodeinUrl(String url) throws MalformedURLException {
        int pos;
        if (url == null) {
            return null;
        }
        String code = null;
        URL ourl = new URL(url);
        String qparams = ourl.getQuery();
        if (qparams != null && qparams.length() != 0 && (pos = qparams.indexOf("code")) >= 0 && qparams.length() > pos + "code".length() + 1 && (pos = (code = qparams.substring(pos + "code".length() + 1)).indexOf(38)) >= 0) {
            code = code.substring(0, pos);
        }
        return code;
    }

    private static String findAppCodeinUrl(String url) {
        int pos;
        if (url == null) {
            return null;
        }
        String appCode = null;
        URL ourl = null;
        try {
            ourl = new URL(url);
        }
        catch (MalformedURLException ex) {
            logger.error((Object)"Fout tijdens omzetten url voor ophalen applicatiecode.", (Throwable)ex);
        }
        String qparams = ourl.getQuery();
        if (qparams != null && qparams.length() != 0 && (pos = qparams.indexOf("appCode")) >= 0 && qparams.length() > pos + "appCode".length() + 1 && (pos = (appCode = qparams.substring(pos + "appCode".length() + 1)).indexOf(38)) >= 0) {
            appCode = appCode.substring(0, pos);
        }
        return appCode;
    }

    public ActionForward login(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request instanceof SecurityRequestWrapper) {
            SecurityRequestWrapper srw = (SecurityRequestWrapper)request;
            String savedURL = SecurityFilter.getContinueToURL((HttpServletRequest)request);
            logger.debug((Object)("savedURL: " + savedURL));
            String code = this.findCodeinUrl(savedURL);
            logger.debug((Object)("code: " + code));
            this.setCMSPageTheme(request);
            String appCode = IndexAction.findAppCodeinUrl(savedURL);
            if (appCode != null && appCode.length() > 0) {
                String gebruikersCode;
                Applicatie app = KaartSelectieUtil.getApplicatie(appCode);
                if (app == null) {
                    app = KaartSelectieUtil.getDefaultApplicatie();
                }
                if (app != null && (gebruikersCode = app.getGebruikersCode()) != null) {
                    code = gebruikersCode;
                }
            }
            GisPrincipal user = null;
            if (!HibernateUtil.isCheckLoginKaartenbalie()) {
                user = GisSecurityRealm.authenticateFake(HibernateUtil.ANONYMOUS_USER);
            } else {
                String url = GisSecurityRealm.createCapabilitiesURL(code);
                logger.debug((Object)("url: " + url));
                user = GisSecurityRealm.authenticateHttp(url, HibernateUtil.ANONYMOUS_USER, null, code, srw);
            }
            if (user != null) {
                if (request.getUserPrincipal() != null && !request.getUserPrincipal().equals(user)) {
                    request.getSession().invalidate();
                }
                srw.setUserPrincipal((Principal)user);
                logger.debug((Object)("Automatic login for user: " + HibernateUtil.ANONYMOUS_USER));
                response.sendRedirect(response.encodeRedirectURL(savedURL));
                return null;
            }
            logger.debug((Object)"Automatic login not possible, ask for credentials.");
        }
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        this.createLists(dynaForm, request);
        this.populateTekstblok(request, PAGE_GISVIEWER_LOGIN);
        return this.getDefaultForward(mapping, request);
    }

    private void setCMSPageTheme(HttpServletRequest request) {
        CMSPagina cmsPage;
        String savedURL = SecurityFilter.getContinueToURL((HttpServletRequest)request);
        Integer cmsPageId = null;
        Map<String, String> params = IndexAction.getQueryMap(savedURL);
        for (Map.Entry<String, String> pairs : params.entrySet()) {
            if (!pairs.getKey().equals("cmsPageId")) continue;
            String str = pairs.getValue();
            cmsPageId = new Integer(str);
        }
        if (cmsPageId != null && cmsPageId > 0 && (cmsPage = this.getCMSPage(cmsPageId)) != null) {
            if (cmsPage.getThema() == null || cmsPage.getThema().equals("")) {
                request.setAttribute("theme", (Object)"");
            } else {
                request.setAttribute("theme", (Object)cmsPage.getThema());
            }
        }
    }

    private static Map<String, String> getQueryMap(String query) {
        if (query == null || query.isEmpty()) {
            return new HashMap<String, String>();
        }
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            try {
                String name = param.split("=")[0];
                String value = param.split("=")[1];
                map.put(name, value);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return map;
    }

    public ActionForward loginError(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setCMSPageTheme(request);
        this.populateTekstblok(request, PAGE_GISVIEWER_LOGIN);
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward logout(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer cmsPageId = null;
        if (request.getParameter("cmsPageId") != null) {
            try {
                String nr = request.getParameter("cmsPageId");
                cmsPageId = new Integer(nr);
            }
            catch (NumberFormatException nfe) {
                logger.debug((Object)"Fout tijdens uitloggen met een cms page id.", (Throwable)nfe);
            }
        }
        HttpSession session = request.getSession();
        String sessionId = session.getId();
        session.invalidate();
        logger.debug((Object)("Logged out from session: " + sessionId));
        String logoutUrl = null;
        String appCode = request.getParameter("appCode");
        ConfigKeeper configKeeper = new ConfigKeeper();
        Map<String, Object> map = configKeeper.getConfigMap(appCode, true);
        if (map != null) {
            logoutUrl = (String)map.get("logoutUrl");
        }
        if (logoutUrl != null && !logoutUrl.isEmpty()) {
            return new RedirectingActionForward(logoutUrl);
        }
        if (cmsPageId != null && cmsPageId > 0) {
            CMSPagina cmsPage = this.getCMSPage(cmsPageId);
            String url = this.prettifyCMSPageUrl(request, cmsPage);
            return new RedirectingActionForward(url);
        }
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward list(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List validThemas = this.getValidThemas(false, null, request);
        ArrayList<Themas> themalist = new ArrayList<Themas>();
        List clusterlist = new ArrayList();
        if (validThemas != null) {
            for (int i = 0; i < validThemas.size(); ++i) {
                Themas t = (Themas)validThemas.get(i);
                Clusters c = t.getCluster();
                clusterlist = this.findParentClusters(c, clusterlist);
                if (c.isHide_tree() || c.isBackground_cluster()) continue;
                themalist.add(t);
            }
        }
        request.setAttribute("themalist", themalist);
        request.setAttribute("clusterlist", clusterlist);
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        this.createLists(dynaForm, request);
        this.populateTekstblok(request, PAGE_GISVIEWER_HOME);
        HttpSession session = request.getSession();
        session.setAttribute("loginForm", (Object)false);
        return this.getDefaultForward(mapping, request);
    }

    private List findParentClusters(Clusters c, List parents) {
        if (parents == null) {
            return null;
        }
        if (c == null || !c.isCallable() || c.isBackground_cluster()) {
            return parents;
        }
        if (!parents.contains(c)) {
            parents.add(c);
        }
        return this.findParentClusters(c.getParent(), parents);
    }

    public ActionForward help(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.populateTekstblok(request, PAGE_GISVIEWER_HELP);
        return this.getDefaultForward(mapping, request);
    }

    private void populateTekstblok(HttpServletRequest request, String page) {
        String param = request.getParameter("cmsPageId");
        Integer cmsPageId = null;
        if (param != null && !param.equals("")) {
            cmsPageId = new Integer(param);
        }
        List tekstBlokken = this.getTekstBlokken(cmsPageId);
        request.setAttribute("tekstBlokken", (Object)tekstBlokken);
    }

    private Integer getFirstCMSPageId() {
        Integer id = null;
        List<CMSPagina> paginas = this.getCMSPaginas();
        if (paginas != null && paginas.size() > 0) {
            id = paginas.get(0).getId();
        }
        return id;
    }
}

