/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.gis.viewer.BaseGisAction;
import nl.b3p.gis.viewer.db.Clusters;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.GisSecurityRealm;
import nl.b3p.gis.viewer.services.HibernateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;
import org.securityfilter.filter.SecurityFilter;
import org.securityfilter.filter.SecurityRequestWrapper;

public class IndexConfigAction
extends BaseGisAction {
    private static final Log logger = LogFactory.getLog(IndexConfigAction.class);
    protected static final String LOGIN = "login";
    protected static final String LOGINERROR = "loginError";
    protected static final String LOGOUT = "logout";
    protected static final String LIST = "list";
    protected static final String RESET_CACHE = "resetCache";
    protected static final String HELP = "help";
    private static final String PAGE_CONFIG_HOME = "config_home";
    private static final String PAGE_CONFIG_HELP = "config_help";

    protected Map getActionMethodPropertiesMap() {
        HashMap<String, ExtendedMethodProperties> map = new HashMap<String, ExtendedMethodProperties>();
        ExtendedMethodProperties hibProp = null;
        hibProp = new ExtendedMethodProperties(LOGIN);
        hibProp.setDefaultForwardName(LOGIN);
        hibProp.setAlternateForwardName("failure");
        map.put(LOGIN, hibProp);
        hibProp = new ExtendedMethodProperties(LOGINERROR);
        hibProp.setDefaultMessageKey("error.inlog");
        hibProp.setDefaultForwardName(LOGINERROR);
        hibProp.setAlternateForwardName("failure");
        map.put(LOGINERROR, hibProp);
        hibProp = new ExtendedMethodProperties(LOGOUT);
        hibProp.setDefaultForwardName(LOGOUT);
        hibProp.setAlternateForwardName("failure");
        map.put(LOGOUT, hibProp);
        hibProp = new ExtendedMethodProperties(LIST);
        hibProp.setDefaultForwardName("success");
        hibProp.setAlternateForwardName("failure");
        map.put(LIST, hibProp);
        hibProp = new ExtendedMethodProperties(RESET_CACHE);
        hibProp.setDefaultMessageKey("algemeen.resetcache.success");
        hibProp.setDefaultForwardName("success");
        hibProp.setAlternateMessageKey("algemeen.resetcache.failure");
        hibProp.setAlternateForwardName("success");
        map.put(RESET_CACHE, hibProp);
        hibProp = new ExtendedMethodProperties(HELP);
        hibProp.setDefaultMessageKey("algemeen.resetcache.success");
        hibProp.setDefaultForwardName(HELP);
        hibProp.setAlternateMessageKey("algemeen.resetcache.failure");
        hibProp.setAlternateForwardName(HELP);
        map.put(HELP, hibProp);
        return map;
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.createLists(dynaForm, request);
        String param = request.getParameter("cmsPageId");
        Integer cmsPageId = null;
        if (param != null && !param.equals("")) {
            cmsPageId = new Integer(param);
        }
        List tekstBlokken = this.getTekstBlokken(cmsPageId);
        request.setAttribute("tekstBlokken", (Object)tekstBlokken);
        return mapping.findForward("success");
    }

    private String findCodeinUrl(String url) throws MalformedURLException {
        int pos;
        if (url == null) {
            return null;
        }
        String code = null;
        URL ourl = new URL(url);
        String qparams = ourl.getQuery();
        if (qparams != null && qparams.length() != 0 && (pos = qparams.indexOf("code")) >= 0 && qparams.length() > pos + "code".length() + 1 && (pos = (code = qparams.substring(pos + "code".length() + 1)).indexOf(38)) >= 0) {
            code = code.substring(0, pos);
        }
        return code;
    }

    public ActionForward login(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request instanceof SecurityRequestWrapper) {
            SecurityRequestWrapper srw = (SecurityRequestWrapper)request;
            String savedURL = SecurityFilter.getContinueToURL((HttpServletRequest)request);
            String code = this.findCodeinUrl(savedURL);
            GisPrincipal user = null;
            if (!HibernateUtil.isCheckLoginKaartenbalie()) {
                user = GisSecurityRealm.authenticateFake(HibernateUtil.ANONYMOUS_USER);
            } else {
                String url = GisSecurityRealm.createCapabilitiesURL(code);
                user = GisSecurityRealm.authenticateHttp(url, HibernateUtil.ANONYMOUS_USER, null, code, null);
            }
            if (user != null) {
                if (request.getUserPrincipal() != null && !request.getUserPrincipal().equals(user)) {
                    request.getSession().invalidate();
                }
                srw.setUserPrincipal((Principal)user);
                logger.debug((Object)("Automatic login for user: " + HibernateUtil.ANONYMOUS_USER));
                response.sendRedirect(response.encodeRedirectURL(savedURL));
                return null;
            }
        }
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        this.createLists(dynaForm, request);
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward loginError(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward logout(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        String sesId = session.getId();
        session.invalidate();
        logger.info((Object)("Logged out from session: " + sesId));
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward list(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List validThemas = this.getValidThemas(false, null, request);
        ArrayList<Themas> themalist = new ArrayList<Themas>();
        List clusterlist = new ArrayList();
        if (validThemas != null) {
            for (int i = 0; i < validThemas.size(); ++i) {
                Themas t = (Themas)validThemas.get(i);
                Clusters c = t.getCluster();
                clusterlist = this.findParentClusters(c, clusterlist);
                if (c.isHide_tree() || c.isBackground_cluster()) continue;
                themalist.add(t);
            }
        }
        request.setAttribute("themalist", themalist);
        request.setAttribute("clusterlist", clusterlist);
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        this.createLists(dynaForm, request);
        String param = request.getParameter("cmsPageId");
        Integer cmsPageId = null;
        if (param != null && !param.equals("")) {
            cmsPageId = new Integer(param);
        }
        List tekstBlokken = this.getTekstBlokken(cmsPageId);
        request.setAttribute("tekstBlokken", (Object)tekstBlokken);
        return this.getDefaultForward(mapping, request);
    }

    private List findParentClusters(Clusters c, List parents) {
        if (parents == null) {
            return null;
        }
        if (c == null || !c.isCallable() || c.isBackground_cluster()) {
            return parents;
        }
        if (!parents.contains(c)) {
            parents.add(c);
        }
        return this.findParentClusters(c.getParent(), parents);
    }

    public ActionForward help(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String param = request.getParameter("cmsPageId");
        Integer cmsPageId = null;
        if (param != null && !param.equals("")) {
            cmsPageId = new Integer(param);
        }
        List tekstBlokken = this.getTekstBlokken(cmsPageId);
        request.setAttribute("tekstBlokken", (Object)tekstBlokken);
        return this.getDefaultForward(mapping, request);
    }
}

