/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.viewer.openbareruimte.entities.Maatregel;
import nl.b3p.viewer.openbareruimte.entities.MaatregelCustomInput;
import nl.b3p.viewer.openbareruimte.entities.MaatregelEigenschap;
import nl.b3p.viewer.openbareruimte.entities.MaatregelGepland;
import nl.b3p.viewer.openbareruimte.entities.RawCrow;
import nl.b3p.viewer.openbareruimte.vragen.Factory;
import nl.b3p.viewer.openbareruimte.vragen.MaatregelForm;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MaatregelService {
    private static final Log log = LogFactory.getLog(MaatregelService.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public String getMaatregelen(String vlakType) throws JSONException {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = null;
        JSONObject response = new JSONObject();
        response.put("success", false);
        try {
            JSONArray array = new JSONArray();
            tx = sess.beginTransaction();
            String hql = "FROM Maatregel";
            if (vlakType != null) {
                hql = hql + " m where m.id in (SELECT maatregel from VlakMaatregel where lower(vlakType) = :v)";
            }
            Query q = sess.createQuery(hql);
            if (vlakType != null) {
                q.setParameter("v", (Object)vlakType.toLowerCase());
            }
            List maatregelen = q.list();
            for (Maatregel m : maatregelen) {
                JSONObject js = new JSONObject();
                js.put("id", (Object)m.getId());
                js.put("omschrijving", (Object)m.getOmschrijving());
                array.put((Object)js);
            }
            response.put("results", (Object)array);
            sess.flush();
            tx.commit();
            response.put("success", true);
        }
        catch (Exception e) {
            log.error((Object)"Error while getting maatregelen", (Throwable)e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            response.put("error", (Object)("Error tijdens ophalen maatregelen" + e.getMessage()));
        }
        return response.toString();
    }

    public String getGeplandeMaatregelen(Integer bronId, String featureId) throws JSONException {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = null;
        String error = "";
        JSONObject json = new JSONObject();
        json.put("success", false);
        try {
            tx = sess.beginTransaction();
            List mgs = sess.createQuery("FROM MaatregelGepland where bronId= :b AND featureId= :f").setParameter("b", (Object)bronId).setParameter("f", (Object)featureId).list();
            StringWriter sw = new StringWriter();
            mapper.writeValue((Writer)sw, (Object)mgs);
            json.put("results", (Object)new JSONArray(sw.toString()));
            sess.flush();
            tx.commit();
            json.put("success", true);
        }
        catch (Exception e) {
            log.error((Object)"Error while getting saved maatregel", (Throwable)e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            json.put("error", (Object)("error while getting saved maatregel " + e.getMessage()));
        }
        return json.toString();
    }

    public String getVragen(String maatregel) throws JSONException {
        JSONObject response = new JSONObject();
        String error = "";
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = null;
        if (maatregel != null) {
            try {
                tx = sess.beginTransaction();
                response.put("success", false);
                String[] tokens = maatregel.split("\\.");
                if (tokens.length != 3) {
                    error = "Maatregel param moet xx.xx.xx zijn";
                } else {
                    Integer wc = new Integer(tokens[0]);
                    Integer swc = new Integer(tokens[1]);
                    Integer volgnr = new Integer(tokens[2]);
                    Criteria c = sess.createCriteria(RawCrow.class);
                    c.add((Criterion)Restrictions.eq((String)"wc", (Object)wc));
                    c.add((Criterion)Restrictions.eq((String)"swc", (Object)swc));
                    c.add((Criterion)Restrictions.eq((String)"volgnr", (Object)volgnr));
                    c.addOrder(Order.asc((String)"deficode"));
                    c.addOrder(Order.desc((String)"type"));
                    c.addOrder(Order.asc((String)"regelnr"));
                    List list = c.list();
                    MaatregelForm form = Factory.createVragenSorted((List)list);
                    StringWriter sw = new StringWriter();
                    mapper.writeValue((Writer)sw, (Object)form);
                    response.put("result", (Object)new JSONObject(sw.toString()));
                    response.put("success", true);
                }
                tx.commit();
            }
            catch (Exception e) {
                log.error((Object)"Error while getting maatregelen", (Throwable)e);
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                response.put("error", (Object)("Error tijdens ophalen van vragen" + e.getMessage()));
            }
        }
        return response.toString();
    }

    public String save(String geplandeMaatregel) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", false);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = null;
        String error = "";
        try {
            tx = sess.beginTransaction();
            JSONObject plan = new JSONObject(geplandeMaatregel);
            if (!plan.has("maatregel")) {
                throw new Exception("No maatregel found!");
            }
            MaatregelGepland mg = null;
            if (plan.has("id")) {
                mg = (MaatregelGepland)sess.get(MaatregelGepland.class, (Serializable)Long.valueOf(plan.getLong("id")));
            }
            if (mg == null) {
                mg = new MaatregelGepland();
            }
            Maatregel m = (Maatregel)sess.get(Maatregel.class, (Serializable)((Object)plan.getString("maatregel")));
            mg.setMaatregel(m);
            if (plan.has("hoeveelheid")) {
                mg.setHoeveelheid(Integer.valueOf(plan.getInt("hoeveelheid")));
            } else {
                mg.setHoeveelheid(null);
            }
            if (plan.has("objectType") && plan.get("objectType") != null) {
                mg.setObjectType(plan.getString("objectType"));
            } else {
                mg.setObjectType(null);
            }
            if (plan.has("featureId")) {
                mg.setFeatureId(plan.getString("featureId"));
            }
            if (plan.has("bronId")) {
                mg.setBronId(Integer.valueOf(plan.getInt("bronId")));
            }
            if (mg.getCustomInputs() != null) {
                for (MaatregelCustomInput mci : mg.getCustomInputs()) {
                    sess.delete((Object)mci);
                }
                mg.setCustomInputs(null);
                sess.flush();
            }
            if (plan.has("customInputs")) {
                JSONArray ciArray = plan.getJSONArray("customInputs");
                for (int i = 0; i < ciArray.length(); ++i) {
                    MaatregelCustomInput mci = (MaatregelCustomInput)mapper.readValue(ciArray.get(i).toString(), MaatregelCustomInput.class);
                    mg.addCustomInput(mci);
                }
            }
            if (mg.getEigenschappen() != null) {
                for (MaatregelEigenschap eigenschap : mg.getEigenschappen()) {
                    sess.delete((Object)eigenschap);
                }
                mg.setEigenschappen(null);
                sess.flush();
            }
            if (plan.has("eigenschappen")) {
                JSONArray eigenschappen = plan.getJSONArray("eigenschappen");
                for (int i = 0; i < eigenschappen.length(); ++i) {
                    JSONObject eigenschap = eigenschappen.getJSONObject(i);
                    MaatregelEigenschap me = (MaatregelEigenschap)mapper.readValue(eigenschap.toString(), MaatregelEigenschap.class);
                    mg.addEigenschap(me);
                }
            }
            if (mg.getId() != null) {
                sess.save((Object)mg);
            } else {
                sess.persist((Object)mg);
            }
            sess.flush();
            tx.commit();
            json.put("success", true);
            json.put("error", (Object)error);
        }
        catch (Exception e) {
            log.error((Object)"Error while saving", (Throwable)e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            json.put("error", (Object)("error while saving: " + e.getMessage()));
        }
        return json.toString();
    }

    public String deleteMaatregel(Long id) throws JSONException {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = null;
        JSONObject json = new JSONObject();
        json.put("success", false);
        try {
            tx = sess.beginTransaction();
            MaatregelGepland mg = (MaatregelGepland)sess.get(MaatregelGepland.class, (Serializable)id);
            sess.delete((Object)mg);
            sess.flush();
            tx.commit();
            json.put("success", true);
        }
        catch (Exception e) {
            log.error((Object)"Error while deleting maatregel", (Throwable)e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            json.put("error", (Object)("Error while deleting maatregel " + e.getMessage()));
        }
        return json.toString();
    }

    public String getSavedMaatregel(Long id) throws JSONException {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = null;
        String error = "";
        JSONObject json = new JSONObject();
        json.put("success", false);
        try {
            tx = sess.beginTransaction();
            MaatregelGepland mg = (MaatregelGepland)sess.get(MaatregelGepland.class, (Serializable)id);
            StringWriter sw = new StringWriter();
            mapper.writeValue((Writer)sw, (Object)mg);
            json.put("result", (Object)new JSONObject(sw.toString()));
            json.put("success", true);
            tx.commit();
        }
        catch (Exception e) {
            log.error((Object)"Error while getting saved maatregel", (Throwable)e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            json.put("error", (Object)("error while getting saved maatregel " + e.getMessage()));
        }
        return json.toString();
    }
}

