/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.struts;

import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.struts.ExtendedMethodAction;
import nl.b3p.gis.viewer.services.HibernateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.hibernate.JDBCException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public abstract class BaseHibernateAction
extends ExtendedMethodAction {
    private static final Log log = LogFactory.getLog(BaseHibernateAction.class);
    protected static final String SUCCESS = "success";
    protected static final String FAILURE = "failure";
    protected static final String VALIDATION_ERROR_KEY = "error.validation";
    protected static final String RIGHTS_ERROR_KEY = "error.rights";

    protected ActionForward getUnspecifiedDefaultForward(ActionMapping mapping, HttpServletRequest request) {
        return mapping.findForward(SUCCESS);
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Session sess = this.getHibernateSession();
        Transaction tx = sess.beginTransaction();
        ActionForward forward = null;
        String msg = null;
        try {
            forward = super.execute(mapping, form, request, response);
            tx.commit();
            return forward;
        }
        catch (Exception e) {
            if (tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)"Exception occured, rollback", (Throwable)e);
            if (e instanceof JDBCException) {
                msg = e.getMessage();
                SQLException sqle = ((JDBCException)e).getSQLException();
                msg = msg + ": " + sqle;
                SQLException nextSqlE = sqle.getNextException();
                if (nextSqlE != null) {
                    msg = msg + ": " + nextSqlE;
                }
            } else if (e instanceof SQLException) {
                msg = e.getMessage();
                SQLException nextSqlE = ((SQLException)e).getNextException();
                if (nextSqlE != null) {
                    msg = msg + ": " + nextSqlE;
                }
            } else {
                msg = e.getMessage();
            }
            this.addAlternateMessage(mapping, request, null, msg);
            return this.getAlternateForward(mapping, request);
        }
    }

    protected Session getHibernateSession() {
        return HibernateUtil.getSessionFactory().getCurrentSession();
    }
}

