/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.utils;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.PolygonExtracter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.gis.geotools.DataStoreUtil;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.ThemaData;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.SpatialUtil;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.geotools.data.DataStore;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.Feature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditUtil {
    private static final Log log = LogFactory.getLog(EditUtil.class);
    private static final int QUAD_SEGS = 8;
    protected static final double DEFAULTTOLERANCE = 5.0;

    public String buffer(String wkt, Double bufferafstand) throws Exception {
        if (wkt == null || wkt.length() < 1) {
            throw new Exception("Kan niet bufferen. Er is nog geen handeling geselecteerd.");
        }
        if (bufferafstand == null || bufferafstand == 0.0) {
            throw new Exception("De bufferafstand mag niet 0 zijn.");
        }
        String buffer = "";
        Geometry geom = null;
        geom = DataStoreUtil.createGeomFromWKTString(wkt);
        if (geom == null || geom.isEmpty()) {
            throw new Exception("Kan niet bufferen. Geometrie is incorrect.");
        }
        if (geom.toString().indexOf("POINT") != -1 && bufferafstand < 0.0) {
            throw new Exception("De bufferafstand moet groter dan 0 zijn.");
        }
        Geometry result = null;
        result = geom.toString().indexOf("POINT") != -1 ? geom.buffer(bufferafstand.doubleValue()) : geom.buffer(bufferafstand.doubleValue(), 8, 1);
        if (result == null || result.isEmpty()) {
            throw new Exception("Resultaat buffer geeft incorrecte geometrie.");
        }
        Geometry poly = this.getLargestPolygonFromMultiPolygon(result);
        if (poly == null || poly.isEmpty()) {
            throw new Exception("Bufferfout bij omzetten MultiPolygon naar grootste Polygon.");
        }
        buffer = poly.toText();
        return buffer;
    }

    public String getHighlightWktForThema(String themaIds, String wktPoint, String schaal, String tol, String currentWkt, String appCode) {
        String wkt;
        block12: {
            wkt = null;
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            Transaction tx = null;
            try {
                GisPrincipal user;
                WebContext ctx;
                HttpServletRequest request;
                Bron b;
                List<ThemaData> thema_items;
                Themas thema;
                tx = sess.beginTransaction();
                Geometry geom = DataStoreUtil.createGeomFromWKTString(wktPoint);
                if (geom != null && (thema = SpatialUtil.getThema(themaIds)) != null && (thema_items = SpatialUtil.getThemaData(thema.getGegevensbron(), true)).size() > 0 && (b = thema.getConnectie(request = (ctx = WebContextFactory.get()).getHttpServletRequest())) != null && thema.hasValidAdmindataSource(user = GisPrincipal.getGisPrincipal(request))) {
                    double distance = this.getDistance(schaal, tol);
                    if (distance > 0.0) {
                        geom = geom.buffer(distance);
                    }
                    Gegevensbron gb = thema.getGegevensbron();
                    Integer maximum = ConfigKeeper.getMaxNumberOfFeatures(appCode);
                    ArrayList<Feature> features = DataStoreUtil.getFeatures(b, gb, geom, null, DataStoreUtil.basisRegelThemaData2PropertyNames(thema_items), maximum, true);
                    if (features != null && features.size() > 0) {
                        Feature f = features.get(0);
                        if (features.size() > 1) {
                            log.debug((Object)("Service geeft meerdere features terug. Eerste feature gebruikt. Wkt string = " + wkt));
                        }
                        if (f != null || f.getDefaultGeometryProperty() != null) {
                            wkt = DataStoreUtil.selecteerKaartObjectWkt(f);
                        }
                    }
                }
                tx.commit();
            }
            catch (Exception ex) {
                log.error((Object)("Fout tijdens ophalen wkt: " + ex));
                if (tx == null || !tx.isActive()) break block12;
                tx.rollback();
            }
        }
        Geometry mergedGeom = null;
        try {
            Geometry currentGeom;
            if (currentWkt != null && !currentWkt.equals("") && (currentGeom = DataStoreUtil.createGeomFromWKTString(currentWkt)) != null && wkt != null && !wkt.equals("")) {
                Geometry newGeom = DataStoreUtil.createGeomFromWKTString(wkt);
                mergedGeom = currentGeom.union(newGeom);
            }
            if (mergedGeom != null) {
                wkt = mergedGeom.toText();
            }
        }
        catch (Exception ex) {
            log.debug((Object)"Fout tijdens mergen wkt");
        }
        if (wkt == null) {
            log.debug((Object)"Wkt string is leeg bij selecteren kaartobject.");
            return "-1";
        }
        return wkt;
    }

    public String getIdAndWktForRedliningObject(String wkt, Integer redLineGegevensbronId, String schaal, String tol, String appCode) throws Exception {
        ArrayList<Feature> features;
        if (redLineGegevensbronId == null || redLineGegevensbronId < 0) {
            return "-1";
        }
        String jsonObject = null;
        Geometry geom = DataStoreUtil.createGeomFromWKTString(wkt);
        double distance = this.getDistance(schaal, tol);
        if (distance > 0.0) {
            geom = geom.buffer(distance);
        }
        if ((features = this.doQueryRedliningObject(geom, redLineGegevensbronId, appCode)) != null && features.size() > 0) {
            Feature f = features.get(0);
            if (features.size() > 1) {
                log.debug((Object)("Meerdere redline objecten gevonden. Eerste feature gebruikt. Wkt string = " + wkt));
            }
            jsonObject = this.featureToJson(f).toString();
        }
        if (features == null || features.size() < 1 || jsonObject == null) {
            return "-1";
        }
        return jsonObject;
    }

    private JSONObject featureToJson(Feature f) throws JSONException {
        String wkt = "";
        if (f != null || f.getDefaultGeometryProperty() != null) {
            wkt = DataStoreUtil.selecteerKaartObjectWkt(f);
        }
        String id = f.getProperty("id").getValue().toString();
        String projectnaam = f.getProperty("projectnaam").getValue().toString();
        String ontwerp = f.getProperty("ontwerp").getValue().toString();
        String opmerking = null;
        if (f.getProperty("opmerking").getValue() != null) {
            opmerking = f.getProperty("opmerking").getValue().toString();
        }
        JSONObject json = new JSONObject().put("id", (Object)id).put("projectnaam", (Object)projectnaam).put("wkt", (Object)wkt).put("ontwerp", (Object)ontwerp).put("opmerking", (Object)opmerking);
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<Feature> doQueryRedliningObject(Geometry geom, Integer gbId, String appCode) throws Exception {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = null;
        DataStore ds = null;
        ArrayList<Feature> features = null;
        try {
            tx = sess.beginTransaction();
            Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)gbId);
            WebContext ctx = WebContextFactory.get();
            HttpServletRequest request = ctx.getHttpServletRequest();
            Bron b = gb.getBron(request);
            ds = b.toDatastore();
            if (b.getType().equals("wfs")) {
                ArrayList<Feature> arrayList = new ArrayList<Feature>();
                return arrayList;
            }
            List<ThemaData> thema_items = SpatialUtil.getThemaData(gb, false);
            List<String> propnames = DataStoreUtil.themaData2PropertyNames(thema_items);
            Integer maximum = ConfigKeeper.getMaxNumberOfFeatures(appCode);
            features = DataStoreUtil.getFeatures(b, gb, geom, null, propnames, maximum, true);
            tx.commit();
        }
        catch (Exception ex) {
            log.error((Object)"Fout tijdens ophalen redlining: ", (Throwable)ex);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
        return features;
    }

    private Geometry getLargestPolygonFromMultiPolygon(Geometry multipolygon) {
        if (multipolygon == null) {
            return null;
        }
        if (multipolygon.isEmpty()) {
            return null;
        }
        Polygon single = null;
        List list = new ArrayList();
        list = PolygonExtracter.getPolygons((Geometry)multipolygon);
        Iterator iter = list.iterator();
        double opp = 0.0;
        while (iter.hasNext()) {
            Polygon po = (Polygon)iter.next();
            double temp = po.getArea();
            if (!(temp > opp)) continue;
            single = po;
            opp = temp;
        }
        LineString line = single.getExteriorRing();
        if (line instanceof LinearRing) {
            return new Polygon((LinearRing)line, null, new GeometryFactory(new PrecisionModel(), 28992));
        }
        return null;
    }

    private int getNumInteriorRings(Geometry geom) {
        List list = new ArrayList();
        list = PolygonExtracter.getPolygons((Geometry)geom);
        Iterator iter = list.iterator();
        Polygon single = null;
        double opp = 0.0;
        while (iter.hasNext()) {
            Polygon po = (Polygon)iter.next();
            double temp = po.getArea();
            if (!(temp > opp)) continue;
            single = po;
            opp = temp;
        }
        return single.getNumInteriorRing();
    }

    private double getDistance(String schaal, String tol) {
        String s = schaal;
        double scale = 0.0;
        try {
            if (s != null) {
                scale = Double.parseDouble(s);
                scale = Math.round(scale * 1000000.0);
                scale /= 1000000.0;
            }
        }
        catch (NumberFormatException nfe) {
            scale = 0.0;
            log.debug((Object)"Scale is geen double dus wordt genegeerd");
        }
        String tolerance = tol;
        double clickTolerance = 5.0;
        try {
            if (tolerance != null) {
                clickTolerance = Double.parseDouble(tolerance);
            }
        }
        catch (NumberFormatException nfe) {
            clickTolerance = 5.0;
            log.debug((Object)"Tolerance is geen double dus de default wordt gebruikt: 5.0 pixels");
        }
        double distance = clickTolerance;
        if (scale > 0.0) {
            distance = scale * clickTolerance;
        }
        return distance;
    }
}

