/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.admindata;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.gis.geotools.DataStoreUtil;
import nl.b3p.gis.geotools.FilterBuilder;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.viewer.admindata.GegevensBronBean;
import nl.b3p.gis.viewer.admindata.LabelBean;
import nl.b3p.gis.viewer.admindata.RecordBean;
import nl.b3p.gis.viewer.admindata.RecordChildBean;
import nl.b3p.gis.viewer.admindata.RecordValueBean;
import nl.b3p.gis.viewer.db.Clusters;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.ThemaData;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.SpatialUtil;
import nl.b3p.wms.capabilities.ServiceProvider;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.geotools.data.DataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectAdmindata {
    private static final Log logger = LogFactory.getLog(CollectAdmindata.class);
    private static final FilterFactory2 filterFac = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    protected static final double DEFAULTTOLERANCE = 5.0;
    public static final String SEARCH = "search";
    public static final String SEARCHID = "searchId";
    public static final String SEARCHCLUSTERID = "searchClusterId";
    public static final String DEFAULT_LAYOUT = "admindata";
    private static DecimalFormat threeDBFormat = new DecimalFormat("#.##");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GegevensBronBean fillGegevensBronBean(int gegevensBronId, int themaId, String wkt, String jsonCQL, boolean collectGeom, String parentHtmlId, String appCode) {
        GegevensBronBean bean;
        block42: {
            bean = null;
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            Transaction tx = null;
            try {
                JSONObject cqlFilters = new JSONObject(jsonCQL);
                tx = sess.beginTransaction();
                Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)Integer.valueOf(gegevensBronId));
                if (gb != null) {
                    List childBronnen = sess.createQuery("from Gegevensbron where parent = :parentId order by volgordenr, naam").setInteger("parentId", gb.getId().intValue()).list();
                    bean = new GegevensBronBean();
                    bean.setId(gb.getId());
                    bean.setAdminPk(gb.getAdmin_pk());
                    bean.setParentHtmlId(parentHtmlId);
                    bean.setEditable(gb.isEditable());
                    Themas thema = null;
                    if (themaId > 0) {
                        thema = (Themas)sess.get(Themas.class, (Serializable)Integer.valueOf(themaId));
                    }
                    if (thema == null || thema.getNaam() == null || thema.getNaam().equals("")) {
                        bean.setTitle(gb.getNaam());
                    } else {
                        bean.setTitle(thema.getNaam());
                    }
                    if (thema != null) {
                        bean.setOrder(thema.getBelangnr());
                    }
                    WebContext ctx = WebContextFactory.get();
                    HttpServletRequest request = null;
                    if (ctx != null) {
                        request = ctx.getHttpServletRequest();
                    }
                    GisPrincipal user = null;
                    if (request != null) {
                        user = GisPrincipal.getGisPrincipal(request);
                    }
                    String layout = null;
                    layout = CollectAdmindata.findDataAdminLayout(thema, user, appCode);
                    if (layout == null) {
                        layout = DEFAULT_LAYOUT;
                    }
                    bean.setLayout(layout);
                    List<ThemaData> objectdata_items = SpatialUtil.getThemaData(gb, true);
                    for (ThemaData td : objectdata_items) {
                        if (!td.isBasisregel()) continue;
                        LabelBean lb = new LabelBean();
                        if (td.getId() != null) {
                            lb.setId(td.getId());
                        }
                        lb.setLabel(td.getLabel());
                        lb.setKolomBreedte(td.getKolombreedte());
                        lb.setKolomNaam(td.getKolomnaam());
                        lb.setCommando(td.getCommando());
                        int typeId = td.getDataType().getId();
                        lb.setType(RecordValueBean.getStringType(typeId));
                        lb.setEenheid(td.getEenheid());
                        bean.addLabel(lb);
                    }
                    Bron b = gb.getBron(request);
                    if (b != null) {
                        Geometry geom = null;
                        if (wkt != null) {
                            geom = DataStoreUtil.createGeomFromWKTString(wkt);
                        }
                        List<String> propnames = bean.getKolomNamenList();
                        Filter parentCqlFilter = null;
                        String cql = null;
                        if (cqlFilters.has("" + gb.getId())) {
                            cql = cqlFilters.getString("" + gb.getId());
                        }
                        if (cql != null && cql.length() > 0) {
                            parentCqlFilter = CQL.toFilter((String)cql);
                        }
                        Integer maximum = ConfigKeeper.getMaxNumberOfFeatures(appCode);
                        ArrayList<Feature> features = null;
                        features = DataStoreUtil.getFeatures(b, gb, geom, parentCqlFilter, propnames, maximum, collectGeom);
                        DataStore tempDatastore = b.toDatastore();
                        SimpleFeatureType featureType = null;
                        try {
                            featureType = DataStoreUtil.getSchema(tempDatastore, gb);
                        }
                        finally {
                            tempDatastore.dispose();
                        }
                        if (features != null && !features.isEmpty()) {
                            for (Feature f : features) {
                                RecordBean record = null;
                                record = this.getRecordBean(f, gb, bean.getLabels(), wkt);
                                if (record == null) continue;
                                if (collectGeom) {
                                    GeometryAttribute attrib = f.getDefaultGeometryProperty();
                                    if (attrib != null) {
                                        record.setShowMagicWand(true);
                                    } else if (attrib == null) {
                                        record.setShowMagicWand(false);
                                    }
                                } else if (featureType != null && featureType.getGeometryDescriptor() != null) {
                                    record.setShowMagicWand(true);
                                } else {
                                    record.setShowMagicWand(false);
                                }
                                for (Gegevensbron child : childBronnen) {
                                    String fkField = child.getAdmin_fk();
                                    if (record.getId() == null) continue;
                                    String recordId = record.getId().toString();
                                    Filter childFilter = null;
                                    ArrayList<Filter> filters = new ArrayList<Filter>();
                                    String childCql = null;
                                    if (cqlFilters.has("" + child.getId())) {
                                        childCql = cqlFilters.getString("" + child.getId());
                                    }
                                    if (childCql != null && childCql.length() > 0) {
                                        Filter childCqlFilter = CQL.toFilter((String)childCql);
                                        filters.add(childCqlFilter);
                                    }
                                    Filter attrFilter = null;
                                    if (fkField != null && recordId != null) {
                                        attrFilter = FilterBuilder.createEqualsFilter(fkField, recordId);
                                    }
                                    if (attrFilter != null) {
                                        filters.add(attrFilter);
                                    }
                                    if (filters.size() == 1) {
                                        childFilter = (Filter)filters.get(0);
                                    }
                                    if (filters.size() > 1) {
                                        childFilter = filterFac.and(filters);
                                    }
                                    SimpleFeatureImpl feature = (SimpleFeatureImpl)f;
                                    int count = 0;
                                    Object featureGeom = null;
                                    count = 1;
                                    JSONObject childCQL = new JSONObject(cqlFilters.toString());
                                    if (childCQL != null && childFilter != null) {
                                        childCQL.put("" + child.getId(), (Object)CQL.toCQL((Filter)childFilter));
                                    }
                                    if (count <= 0) continue;
                                    RecordChildBean childBean = new RecordChildBean();
                                    childBean.setId(child.getId().toString());
                                    childBean.setGegevensBronBeanId(bean.getId());
                                    childBean.setTitle(child.getNaam());
                                    childBean.setAantalRecords(count);
                                    childBean.setThemaId(new Integer(themaId).toString());
                                    childBean.setCql(childCQL.toString());
                                    childBean.setWkt(wkt);
                                    record.addChild(childBean);
                                }
                                bean.addRecord(record);
                            }
                            if (bean != null) {
                                bean.setCsvPksFromRecordBeans();
                            }
                        }
                    }
                }
                tx.commit();
            }
            catch (CQLException cqlEx) {
                logger.error((Object)"Fout tijdens filter: ", (Throwable)cqlEx);
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (NoSuchElementException nse) {
                logger.error((Object)"Verkeerd element in resultaat objectdata: ", (Throwable)nse);
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Fout tijdens ophalen objectdata: ", (Throwable)e);
                if (tx == null || !tx.isActive()) break block42;
                tx.rollback();
            }
        }
        return bean;
    }

    protected RecordBean getRecordBean(Feature f, Gegevensbron gb, List<LabelBean> label_bean_items, String wkt) throws SQLException, UnsupportedEncodingException, Exception {
        QName qName;
        RecordBean rb = new RecordBean();
        String adminPk = null;
        if (gb.getAdmin_pk() != null && (qName = DataStoreUtil.convertColumnNameToQName(gb.getAdmin_pk())) != null) {
            adminPk = qName.getLocalPart();
        }
        if (adminPk != null) {
            rb.setId(f.getProperty(adminPk).getValue());
        }
        if (label_bean_items == null) {
            return null;
        }
        String ggbId = Integer.toString(gb.getId());
        for (LabelBean lb : label_bean_items) {
            String lData;
            RecordValueBean rvb = new RecordValueBean();
            rvb.setType(lb.getType());
            rvb.setEenheid(lb.getEenheid());
            rvb.setKolomBreedte(lb.getKolomBreedte());
            String commando = lb.getCommando();
            String eenheid = lb.getEenheid();
            String kolomnaam = lb.getKolomNaam();
            if (kolomnaam != null && kolomnaam.length() > 0) {
                kolomnaam = DataStoreUtil.convertColumnNameToQName(lb.getKolomNaam()).getLocalPart();
            }
            List attributeValueList = null;
            Object attributeValue = null;
            if (kolomnaam != null && f.getProperty(kolomnaam) != null) {
                attributeValue = f.getProperty(kolomnaam).getValue();
                if (commando != null && (commando.contains(kolomnaam) || lb.getType().equals("TYPE_URL"))) {
                    attributeValueList = this.splitObject(attributeValue, ",");
                }
            }
            Object pkValue = null;
            if (adminPk != null) {
                pkValue = f.getProperty(adminPk).getValue();
            }
            ArrayList<String> resultList = new ArrayList<String>();
            String resultValue = null;
            if (lb.getType().equals("TYPE_GOOGLENAV")) {
                resultValue = "TYPE_GOOGLENAV";
                if (attributeValueList != null && attributeValueList.size() > 1) {
                    for (int i = 0; i < attributeValueList.size(); ++i) {
                        Object localValue = attributeValueList.get(i);
                        lData = "TYPE_GOOGLENAV";
                        resultList.add(lData);
                    }
                }
            } else if (lb.getType().equals("TYPE_DATA")) {
                resultValue = this.createData(attributeValue);
                if (attributeValueList != null && attributeValueList.size() > 1) {
                    for (int i = 0; i < attributeValueList.size(); ++i) {
                        Object localValue = attributeValueList.get(i);
                        lData = this.createData(localValue);
                        resultList.add(lData);
                    }
                }
            } else if (lb.getType().equals("TYPE_DATUM")) {
                resultValue = this.createDatum(attributeValue);
                if (attributeValueList != null && attributeValueList.size() > 1) {
                    for (int i = 0; i < attributeValueList.size(); ++i) {
                        Object localValue = attributeValueList.get(i);
                        lData = this.createDatum(localValue);
                        resultList.add(lData);
                    }
                }
            } else if (lb.getType().equals("TYPE_URL")) {
                resultValue = this.createUrl(kolomnaam, attributeValue, adminPk, pkValue, "themaid", ggbId, commando);
                if (attributeValueList != null && attributeValueList.size() > 1) {
                    for (int i = 0; i < attributeValueList.size(); ++i) {
                        Object localValue = attributeValueList.get(i);
                        String lUrl = this.createUrl(kolomnaam, localValue, adminPk, pkValue, "themaid", ggbId, commando);
                        resultList.add(lUrl);
                    }
                }
            } else if (lb.getType().equals("TYPE_QUERY")) {
                HashMap fhm = this.toHashMap(f);
                if (attributeValue != null) {
                    resultValue = attributeValue.toString();
                }
                if (attributeValueList != null && attributeValueList.size() > 1) {
                    for (int i = 0; i < attributeValueList.size(); ++i) {
                        Object localValue = attributeValueList.get(i);
                        String lQuery = this.createQuery(kolomnaam, localValue, commando, fhm);
                        resultList.add(lQuery);
                    }
                } else {
                    String lQuery = this.createQuery(kolomnaam, null, commando, fhm);
                    resultList.add(lQuery);
                }
            } else if (lb.getType().equals("TYPE_FUNCTION")) {
                if (lb.getCommando() != null && lb.getCommando().contains("surfaceArea")) {
                    if (kolomnaam != null && f.getProperty(kolomnaam) != null) {
                        rvb.setType("TYPE_DATA");
                        Geometry recordGeom = (Geometry)f.getProperty(kolomnaam).getValue();
                        String result = this.calcSurfaceAreaDifference(recordGeom, wkt);
                        resultValue = result != null ? result : "-";
                    }
                } else {
                    resultValue = this.createFunction(kolomnaam, attributeValue, adminPk, pkValue, ggbId, commando, eenheid);
                    if (attributeValueList != null && attributeValueList.size() > 1) {
                        for (int i = 0; i < attributeValueList.size(); ++i) {
                            Object localValue = attributeValueList.get(i);
                            String lFunction = this.createFunction(kolomnaam, localValue, adminPk, pkValue, ggbId, commando, eenheid);
                            resultList.add(lFunction);
                        }
                    }
                }
            }
            rvb.setValue(resultValue);
            rvb.setValueList(resultList);
            rb.addValue(rvb);
        }
        return rb;
    }

    private String calcSurfaceAreaDifference(Geometry geom, String wkt) {
        String result = null;
        try {
            Geometry mapPoly = DataStoreUtil.createGeomFromWKTString(wkt);
            Geometry intersection = mapPoly.intersection(geom);
            intersection.setSRID(28992);
            if (intersection != null) {
                if (intersection instanceof LineString) {
                    Double len = intersection.getLength();
                    if (len >= 1000.0) {
                        len = len / 1000.0;
                        result = threeDBFormat.format(len) + " km";
                    } else {
                        result = threeDBFormat.format(len) + " m";
                    }
                } else {
                    Double area = intersection.getArea();
                    if (area >= 1000000.0) {
                        area = area / 1000000.0;
                        result = threeDBFormat.format(area) + " km2";
                    } else {
                        result = threeDBFormat.format(area) + " m2";
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Fout tijden berekenen oppervlakte verschil:", (Throwable)ex);
        }
        return result;
    }

    private String createData(Object attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        return attributeValue.toString();
    }

    private String createDatum(Object attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (attributeValue instanceof Date) {
            Date datum = (Date)attributeValue;
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-YYYY");
            String timestamp = dateFormat.format(datum);
            return timestamp;
        }
        return attributeValue.toString();
    }

    private String createUrl(String attributeName, Object attributeValue, String adminPk, Object pkValue, String ggbIdName, String ggbId, String commando) {
        StringBuffer url = commando != null ? new StringBuffer(commando) : new StringBuffer();
        url.append(ggbIdName);
        url.append("=");
        url.append(ggbId);
        if (adminPk != null && pkValue != null) {
            url.append("&");
            url.append(adminPk);
            url.append("=");
            try {
                url.append(URLEncoder.encode(pkValue.toString().trim(), "utf-8"));
            }
            catch (UnsupportedEncodingException ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        }
        if (attributeValue != null && attributeName != null && !attributeName.equalsIgnoreCase(adminPk)) {
            url.append("&");
            url.append(attributeName);
            url.append("=");
            try {
                url.append(URLEncoder.encode(attributeValue.toString().trim(), "utf-8"));
            }
            catch (UnsupportedEncodingException ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        }
        return url.toString();
    }

    private String createQuery(String attributeName, Object attributeValue, String commando, HashMap fhm) {
        if (commando == null) {
            return null;
        }
        if (commando.contains("[") && commando.contains("]")) {
            if (attributeName != null && attributeValue != null) {
                fhm.put(attributeName, attributeValue);
            }
            String newCommando = null;
            try {
                newCommando = this.replaceValuesInString(commando, fhm);
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
            }
            return newCommando;
        }
        if (StringUtils.containsIgnoreCase((String)commando, (String)"ReportServlet")) {
            return commando;
        }
        if (attributeValue != null) {
            commando = commando + attributeValue.toString().trim();
            return commando;
        }
        return null;
    }

    private String createFunction(String attributeName, Object attributeValue, String adminPk, Object pkValue, String ggbId, String commando, String eenheid) {
        if (pkValue == null && attributeValue == null) {
            return null;
        }
        if (pkValue == null) {
            return attributeValue.toString();
        }
        StringBuilder function = new StringBuilder("");
        function.append(attributeValue);
        function.append("###").append(commando);
        function.append("(this, ");
        function.append("'").append(ggbId).append("'");
        function.append(",");
        function.append("'").append(adminPk).append("'");
        function.append(",");
        function.append("'").append(pkValue).append("'");
        function.append(",");
        function.append("'").append(attributeName).append("'");
        function.append(",");
        function.append("'").append(attributeValue).append("'");
        function.append(",");
        function.append("'").append(eenheid).append("'");
        function.append(")");
        return function.toString();
    }

    private List splitObject(Object value, String seperator) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (value == null) {
            values.add(value);
        } else if (value instanceof String) {
            String[] tokens = ((String)value).split(seperator);
            values.addAll(Arrays.asList(tokens));
        } else {
            values.add(value);
        }
        return values;
    }

    private HashMap toHashMap(Feature f) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FeatureType ft = f.getType();
        for (PropertyDescriptor pd : ft.getDescriptors()) {
            String key = pd.getName().getLocalPart();
            Object value = f.getProperty(pd.getName()).getValue();
            result.put(key, value);
        }
        return result;
    }

    private String replaceValuesInString(String string, HashMap values) throws Exception {
        if (!string.contains("[") && !string.contains("]")) {
            return string;
        }
        StringBuffer url = string != null ? new StringBuffer(string) : new StringBuffer();
        int begin = -1;
        int eind = -1;
        for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            if (c == '[') {
                if (begin == -1) {
                    begin = i;
                    continue;
                }
                logger.error((Object)("Commando \"" + string + "\" is niet correct. Er ontbreekt een ] ."));
                throw new Exception("Commando \"" + string + "\" is niet correct. Er ontbreekt een ] .");
            }
            if (c == ']') {
                eind = i;
                if (begin != -1 && eind != -1) {
                    String kolomnaam = url.substring(begin + 1, eind);
                    if (kolomnaam == null || kolomnaam.length() == 0) {
                        logger.error((Object)("Commando \"" + string + "\" is niet correct. Geen kolomnaam aanwezig tussen [ en ]."));
                        throw new Exception("Commando \"" + string + "\" is niet correct. Geen kolomnaam aanwezig tussen [ en ].");
                    }
                    Object value = values.get(kolomnaam);
                    if (value == null) {
                        value = "";
                    }
                    url.replace(begin, eind + 1, value.toString().trim());
                    begin = -1;
                    eind = -1;
                    i = 0;
                    continue;
                }
                logger.error((Object)("Commando \"" + string + "\" is niet correct. Er ontbreekt een [ ."));
                throw new Exception("Commando \"" + string + "\" is niet correct. Er ontbreekt een [ .");
            }
            if (i != url.length() - 1 || begin == -1) continue;
            logger.error((Object)("Commando \"" + string + "\" is niet correct. Er ontbreekt een ] ."));
            throw new Exception("Commando \"" + string + "\" is niet correct. Er ontbreekt een ] .");
        }
        return url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getAantalChildRecords(Gegevensbron childGb, Filter filter, Geometry geom) throws Exception {
        Bron b;
        int count = -1;
        if (childGb == null) {
            return count;
        }
        WebContext ctx = WebContextFactory.get();
        HttpServletRequest request = null;
        if (ctx != null) {
            request = ctx.getHttpServletRequest();
        }
        if ((b = childGb.getBron(request)) == null) {
            return count;
        }
        if (b.getType().equals("wfs")) {
            return 1;
        }
        DataStore ds = null;
        try {
            ds = b.toDatastore();
            Filter childGeomFilter = null;
            ArrayList<Filter> filters = new ArrayList<Filter>();
            if (filter != null) {
                filters.add(filter);
            }
            Filter geomFilter = null;
            if (geom != null) {
                geomFilter = DataStoreUtil.createIntersectFilter(childGb, ds, geom);
            }
            if (geomFilter != null) {
                filters.add(geomFilter);
            }
            if (filters.size() == 1) {
                childGeomFilter = (Filter)filters.get(0);
            }
            if (filters.size() > 1) {
                childGeomFilter = filterFac.and(filters);
            }
            ArrayList<String> propnames = new ArrayList<String>();
            if (childGb.getAdmin_fk() != null) {
                propnames.add(childGb.getAdmin_fk());
            }
            FeatureCollection fc = DataStoreUtil.getFeatureCollection(ds, childGb, childGeomFilter, propnames, null, false);
            count = fc.size();
        }
        catch (Exception ex) {
            logger.error((Object)"Fout tijdens maken DataStore voor child Gegevensbron", (Throwable)ex);
        }
        finally {
            ds.dispose();
        }
        return count;
    }

    private static String findDataAdminLayout(Themas thema, GisPrincipal user, String appCode) throws Exception {
        if (thema == null || user == null) {
            return null;
        }
        WebContext ctx = WebContextFactory.get();
        HttpServletRequest request = null;
        if (ctx != null) {
            request = ctx.getHttpServletRequest();
        }
        ConfigKeeper configKeeper = new ConfigKeeper();
        Map<String, Object> map = configKeeper.getConfigMap(appCode, true);
        String layoutAdminData = (String)map.get("layoutAdminData");
        String themaLayout = thema.getLayoutadmindata();
        layoutAdminData = themaLayout == null || themaLayout.equals("") ? (String)map.get("layoutAdminData") : themaLayout;
        return layoutAdminData;
    }

    public static List collectGegevensbronRecordChilds(HttpServletRequest request, List themas, boolean locatie) throws JSONException {
        Geometry geom = CollectAdmindata.getGeometry(request);
        String wkt = null;
        if (geom != null) {
            wkt = geom.toText();
        }
        ArrayList<RecordChildBean> beans = new ArrayList<RecordChildBean>();
        for (Themas thema : themas) {
            Gegevensbron gb;
            logger.debug((Object)("checking thema: " + thema == null ? "<null>" : thema.getNaam()));
            if (locatie && !thema.isLocatie_thema() || (gb = thema.getGegevensbron()) == null) continue;
            String gbId = thema.getGegevensbron().getId().toString();
            String themaId = thema.getId().toString();
            String themaNaam = thema.getNaam();
            Filter filter = CollectAdmindata.getExtraFilter(thema, request);
            String gbCQL = null;
            if (filter != null) {
                gbCQL = CQL.toCQL((Filter)filter);
            }
            JSONObject cqlFilters = new JSONObject();
            if (FormUtils.nullIfEmpty((String)request.getParameter("extraCriteria")) != null) {
                try {
                    cqlFilters = new JSONObject(request.getParameter("extraCriteria"));
                    String cql = null;
                    if (cqlFilters.has("" + gbId)) {
                        cql = cqlFilters.getString("" + gbId);
                    }
                    if (FormUtils.nullIfEmpty(cql) != null) {
                        gbCQL = gbCQL == null ? "" : gbCQL + " && ";
                        gbCQL = gbCQL + cql;
                    }
                }
                catch (JSONException je) {
                    cqlFilters = new JSONObject();
                    logger.error((Object)"Fout bij converteren ExtraCriteria(JSON) naar een JSONObject");
                }
            }
            cqlFilters.put("" + gbId, (Object)gbCQL);
            RecordChildBean childBean = new RecordChildBean();
            childBean.setId(gbId);
            childBean.setGegevensBronBeanId(new Integer(0));
            childBean.setTitle(themaNaam);
            childBean.setAantalRecords(1);
            childBean.setThemaId(themaId);
            childBean.setCql(cqlFilters.toString());
            childBean.setWkt(wkt);
            beans.add(childBean);
        }
        return beans;
    }

    public static Geometry getGeometry(HttpServletRequest request) {
        String geom = FormUtils.nullIfEmpty((String)request.getParameter("geom"));
        String withinObject = request.getParameter("withinObject");
        double distance = CollectAdmindata.getDistance(request);
        Geometry geometry = null;
        if (geom != null) {
            geometry = SpatialUtil.geometrieFromText(geom, 28992);
        } else {
            GeometryFactory gf = new GeometryFactory();
            double[] coords = CollectAdmindata.getCoords(request);
            if (coords == null) {
                geometry = null;
            } else if (coords.length == 2) {
                geometry = gf.createPoint(new Coordinate(coords[0], coords[1]));
            } else if (coords.length == 10) {
                Coordinate[] coordinates = new Coordinate[5];
                for (int i = 0; i < coordinates.length; ++i) {
                    coordinates[i] = new Coordinate(coords[i * 2], coords[i * 2 + 1]);
                }
                geometry = gf.createPolygon(gf.createLinearRing(coordinates), null);
            }
        }
        boolean selectWithinobject = false;
        if (withinObject != null && withinObject.equals("1")) {
            selectWithinobject = true;
        }
        if (geometry != null) {
            if (selectWithinobject) {
                if (geom.indexOf("POLY") != -1) {
                    geometry = geometry.buffer(-1.0E-4);
                }
            } else {
                geometry = geometry.buffer(distance);
            }
        }
        return geometry;
    }

    private static double[] getCoords(HttpServletRequest request) {
        double[] coords = null;
        if (request.getParameter("coords") != null && !request.getParameter("coords").equals("")) {
            String[] coordString = request.getParameter("coords").split(",");
            coords = new double[coordString.length];
            for (int i = 0; i < coordString.length; ++i) {
                coords[i] = Double.parseDouble(coordString[i]);
            }
        }
        return coords;
    }

    private static double getDistance(HttpServletRequest request) {
        String s = request.getParameter("scale");
        double scale = 0.0;
        try {
            if (s != null) {
                scale = Double.parseDouble(s);
                scale = Math.round(scale * 1000000.0);
                scale /= 1000000.0;
            }
        }
        catch (NumberFormatException nfe) {
            scale = 0.0;
            logger.debug((Object)"Scale is geen double dus wordt genegeerd");
        }
        String tolerance = request.getParameter("tolerance");
        double clickTolerance = 5.0;
        try {
            if (tolerance != null) {
                clickTolerance = Double.parseDouble(tolerance);
            }
        }
        catch (NumberFormatException nfe) {
            clickTolerance = 5.0;
            logger.debug((Object)"Tolerance is geen double dus de default wordt gebruikt: 5.0 pixels");
        }
        double distance = clickTolerance;
        if (scale > 0.0) {
            distance = scale * clickTolerance;
        }
        return distance;
    }

    public static Filter getExtraFilter(Themas t, HttpServletRequest request) {
        ArrayList<Filter> extraFilters = new ArrayList<Filter>();
        Filter sldFilter = CollectAdmindata.createSldFilter(t, request);
        if (sldFilter != null) {
            extraFilters.add(sldFilter);
        }
        String organizationcodekey = t.getOrganizationcodekey();
        String organizationcode = CollectAdmindata.getOrganizationCode(request);
        if (FormUtils.nullIfEmpty((String)organizationcodekey) != null && FormUtils.nullIfEmpty((String)organizationcode) != null) {
            Filter organizationFilter = FilterBuilder.createEqualsFilter(organizationcodekey, organizationcode);
            extraFilters.add(organizationFilter);
        }
        if (extraFilters.size() == 0) {
            return null;
        }
        if (extraFilters.size() == 1) {
            return (Filter)extraFilters.get(0);
        }
        return FilterBuilder.getFactory().and(extraFilters);
    }

    private static Filter createSldFilter(Themas t, HttpServletRequest request) {
        if (CollectAdmindata.doExtraSearchFilter(t, request)) {
            return FilterBuilder.createEqualsFilter(t.getSldattribuut(), request.getParameter(SEARCH));
        }
        return null;
    }

    private static boolean doExtraSearchFilter(Themas t, HttpServletRequest request) {
        if (FormUtils.nullIfEmpty((String)t.getSldattribuut()) != null && FormUtils.nullIfEmpty((String)request.getParameter(SEARCH)) != null) {
            int i;
            String searchId = request.getParameter(SEARCHID);
            String searchClusterId = request.getParameter(SEARCHCLUSTERID);
            if (FormUtils.nullIfEmpty((String)searchId) != null) {
                String[] searchIds = searchId.split(",");
                for (i = 0; i < searchIds.length; ++i) {
                    try {
                        if (t.getId() == Integer.parseInt(searchIds[i])) {
                            return true;
                        }
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (FormUtils.nullIfEmpty((String)searchClusterId) != null) {
                String[] clusterIds = searchClusterId.split(",");
                for (i = 0; i < clusterIds.length; ++i) {
                    try {
                        if (CollectAdmindata.isInCluster(t.getCluster(), Integer.parseInt(clusterIds[i]))) {
                            return true;
                        }
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    private static boolean isInCluster(Clusters themaCluster, int clusterId) {
        if (themaCluster == null) {
            return false;
        }
        if (themaCluster.getId() == clusterId) {
            return true;
        }
        return CollectAdmindata.isInCluster(themaCluster.getParent(), clusterId);
    }

    public static String getOrganizationCode(HttpServletRequest request) {
        GisPrincipal gp = GisPrincipal.getGisPrincipal(request);
        if (gp != null) {
            ServiceProvider sp = gp.getSp();
            if (sp != null) {
                return sp.getOrganizationCode();
            }
            logger.error((Object)("Er is geen serviceprovider aanwezig bij GisPrincipal met naam: " + gp.getName()));
            return null;
        }
        logger.debug((Object)"Er is geen GisPrincipal aanwezig.");
        return null;
    }

    public static void main(String[] args) throws CQLException {
        String cql = "aaa = null";
        Filter parentCqlFilter = CQL.toFilter((String)cql);
        System.out.println(parentCqlFilter);
    }
}

