/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.downloads;

import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import nl.b3p.commons.services.SizeLimitedOutputStream;
import nl.b3p.commons.services.StreamCopy;
import nl.b3p.gis.geotools.DataStoreUtil;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.services.DownloadServlet;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.writers.StreamingShapeWriter;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.v1_0_0.WFS_1_0_0_DataStore;
import org.geotools.data.wfs.v1_1_0.WFS_1_1_0_DataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.gml3.GML;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadThread
extends Thread {
    private static final Log log = LogFactory.getLog(DownloadThread.class);
    private static final String FORMAAT_GML = "GML";
    private static final String FORMAAT_SHP = "SHP";
    private static final int BUFFER_SIZE = 8192;
    private static final String ISO_CHARSET = "ISO-8859-1";
    private static final String UTF8_CHARSET = "UTF-8";
    private static String ZIPNAME;
    private static final String EXTENSION = ".zip";
    private static final String GML_EXTENSION = ".gml";
    public static final int STATUS_NEW = 0;
    public static final int STATUS_STARTED = 1;
    public static final int STATUS_FINISHED = 2;
    public static final int STATUS_ERROR = 3;
    private static int threadCounter;
    private String email;
    private String[] uuids;
    private String wkt;
    private String formaat;
    private Integer threadStatus = 0;
    static final Logging logging;
    private String applicationPath;
    private Bron kaartenbalieBron = null;
    private final long MAX_ZIP_FILESIZE = 0x6400000L;
    public static final int MAIL_TYPE_SUCCES = 1;
    public static final int MAIL_TYPE_TOO_LARGE = 2;
    public static final int MAIL_TYPE_ERROR = 99;
    private boolean stop = false;

    public DownloadThread(ThreadGroup tg) {
        super(tg, DownloadThread.nextThreadName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.stop) {
            this.threadStatus = 1;
            Transaction tx = null;
            try {
                String zipFileName;
                Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
                tx = sess.beginTransaction();
                String downloadPath = DownloadServlet.getDownloadPath() + File.separator;
                String folder = DownloadServlet.uniqueName("");
                String folderName = downloadPath + folder;
                File workingDir = new File(folderName);
                if (!workingDir.mkdirs()) {
                    throw new IOException("Cannot create folder: " + workingDir.getAbsolutePath());
                }
                ZIPNAME = zipFileName = folder + EXTENSION;
                String zipFile = folderName + File.separator + zipFileName;
                ArrayList<String> erroredTitles = new ArrayList<String>();
                ArrayList<String> successTitles = new ArrayList<String>();
                for (String uuid : this.uuids) {
                    boolean error = false;
                    Integer gegevensbronId = new Integer(uuid);
                    Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)gegevensbronId);
                    String title = gb.getNaam();
                    log.debug((Object)("STARTED DownloadThread voor gegevensbron: " + title));
                    try {
                        if (this.getFormaat().equals(FORMAAT_SHP)) {
                            this.writeShapesToWorkingDir(workingDir, gb);
                        }
                        if (this.getFormaat().equals(FORMAAT_GML)) {
                            this.writeGMLToWorkingDir(workingDir, title, gb);
                        }
                    }
                    catch (Exception e) {
                        error = true;
                        log.debug((Object)"Dataset opgehaald met fouten: ", (Throwable)e);
                    }
                    if (error) {
                        log.debug((Object)("Error while getting data for uuid: " + uuid));
                        erroredTitles.add(title);
                        continue;
                    }
                    successTitles.add(title);
                }
                if (this.uuids.length - erroredTitles.size() > 0) {
                    ZipOutputStream zip = null;
                    FileOutputStream fos = null;
                    SizeLimitedOutputStream limitOut = null;
                    try {
                        fos = new FileOutputStream(zipFile);
                        limitOut = new SizeLimitedOutputStream((OutputStream)fos, 0x6400000L);
                        zip = new ZipOutputStream((OutputStream)limitOut);
                        this.putDirInZip(zip, new File(workingDir.getAbsolutePath()), "");
                    }
                    catch (Exception ex) {
                        throw new Exception("Error creating zip: ", ex);
                    }
                    finally {
                        try {
                            if (zip != null) {
                                zip.close();
                            }
                            if (limitOut != null) {
                                limitOut.close();
                            }
                            if (fos != null) {
                                fos.close();
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)"Cannot close zip.", (Throwable)e);
                        }
                    }
                }
                String downloadLink = folder + File.separator + zipFileName;
                this.sendEmail(zipFile, downloadLink, erroredTitles, successTitles, 1);
                this.threadStatus = 2;
            }
            catch (Exception e) {
                this.threadStatus = 3;
                log.error((Object)"Error downloading the data: ", (Throwable)e);
                this.sendErrorEmail();
            }
            finally {
                try {
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error committing transaction, do rollback: ", (Throwable)e);
                    tx.rollback();
                }
            }
            log.debug((Object)"ENDED DownloadThread.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeShapesToWorkingDir(File workingDir, Gegevensbron gb) throws Exception {
        Bron bron = this.getCorrectBron(gb);
        if (bron != null) {
            DataStore datastore = bron.toDatastore();
            FeatureCollection fc = null;
            FeatureIterator it = null;
            StreamingShapeWriter ssw = null;
            try {
                fc = this.getFeatureCollection(datastore, gb);
                if (fc != null && fc.size() > 0) {
                    it = fc.features();
                    ssw = new StreamingShapeWriter(workingDir.getAbsolutePath() + File.separator);
                    while (it.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)it.next();
                        ssw.write(feature);
                    }
                }
            }
            catch (Exception ex) {
                log.error((Object)"Fout tijdens schrijven shape: ", (Throwable)ex);
            }
            finally {
                if (fc != null) {
                    it.close();
                }
                if (datastore != null) {
                    datastore.dispose();
                }
                if (ssw != null) {
                    ssw.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGMLToWorkingDir(File workingDir, String fileName, Gegevensbron gb) throws Exception {
        Bron bron = this.getCorrectBron(gb);
        if (bron != null) {
            DataStore datastore = bron.toDatastore();
            FeatureCollection fc = null;
            FeatureIterator it = null;
            FileOutputStream out = null;
            String gmlFile = workingDir + File.separator + fileName + GML_EXTENSION;
            try {
                if (datastore instanceof WFS_1_0_0_DataStore) {
                    int len;
                    InputStream in = this.getInputStreamForWfs(bron, gb);
                    out = new FileOutputStream(gmlFile);
                    byte[] buffer = new byte[8192];
                    while ((len = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    in.close();
                    out.flush();
                } else {
                    fc = this.getFeatureCollection(datastore, gb);
                    if (fc != null && fc.size() > 0) {
                        it = fc.features();
                        out = new FileOutputStream(gmlFile);
                        org.geotools.gml3.GMLConfiguration configuration = new org.geotools.gml3.GMLConfiguration();
                        Encoder encoder = new Encoder((Configuration)configuration);
                        encoder.encode((Object)fc, GML._FeatureCollection, (OutputStream)out);
                    }
                }
            }
            catch (Exception ex) {
                log.error((Object)"Fout tijdens schrijven gml: ", (Throwable)ex);
            }
            finally {
                if (fc != null) {
                    it.close();
                }
                if (datastore != null) {
                    datastore.dispose();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    private InputStream getInputStreamForWfs(Bron bron, Gegevensbron gb) throws MalformedURLException, IOException {
        InputStream in = null;
        String wfsUrl = bron.getUrl();
        String typeName = gb.getAdmin_tabel();
        String part = "service=WFS&version=1.0.0&request=GetFeature&typename=";
        String url = wfsUrl + part + typeName;
        URL xmlUrl = new URL(url);
        in = xmlUrl.openStream();
        return in;
    }

    private void sendErrorEmail() {
        this.sendEmail("", "", null, null, 99);
    }

    private void sendEmail(String zipFile, String zipFileName, ArrayList<String> erroredTitles, ArrayList<String> successTitles, int mailType) {
        File zip = new File(zipFile);
        try {
            Properties properties = System.getProperties();
            String smtpHost = DownloadServlet.getSmtpHost();
            properties.put("mail.smtp.host", smtpHost);
            javax.mail.Session mailSession = javax.mail.Session.getInstance((Properties)properties, null);
            mailSession.setDebug(false);
            MimeMessage msg = new MimeMessage(mailSession);
            String contactEmail = DownloadServlet.getContactEmail();
            if (contactEmail == null) {
                throw new Exception("Instelling contact e-mail is verplicht.");
            }
            InternetAddress frmAddress = new InternetAddress(contactEmail);
            msg.setFrom((Address)frmAddress);
            InternetAddress[] toAddresses = InternetAddress.parse((String)this.getEmail());
            msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
            String onderwerp = null;
            onderwerp = mailType == 1 ? "Het downloadbestand staat klaar." : (mailType == 2 ? "Het downloadbestand is te groot." : "Fout tijdens klaarzetten van het downloadbestand.");
            msg.setSubject(onderwerp);
            String file = null;
            file = mailType == 1 ? DownloadServlet.getMailDownloadSucces() : DownloadServlet.getMailDownloadError();
            Object[] params = null;
            if (mailType == 1 && zip.exists()) {
                String link = this.getApplicationPath() + DownloadServlet.getDownloadServletPath() + "?download=" + zipFileName;
                String lagenString = this.getLagenString(successTitles, erroredTitles);
                params = new Object[]{link, lagenString, contactEmail};
            } else {
                params = mailType == 2 ? new Object[]{contactEmail} : new Object[]{contactEmail};
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedInputStream in = null;
            in = new BufferedInputStream(new FileInputStream(file), 8192);
            StreamCopy.copy((InputStream)in, (OutputStream)out);
            MessageFormat textMessage = new MessageFormat(out.toString(ISO_CHARSET), Locale.ENGLISH);
            String tekst = textMessage.format(params);
            msg.setContent((Object)tekst, "text/plain");
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (AddressException ae) {
            log.error((Object)"Fout bij het opgegeven emailadres. ", (Throwable)ae);
        }
        catch (SendFailedException sfe) {
            log.error((Object)"Fout bij het verzenden van het bericht.", (Throwable)sfe);
        }
        catch (MessagingException me) {
            log.error((Object)"Fout bij het verzenden van het bericht. ", (Throwable)me);
        }
        catch (Exception e) {
            log.error((Object)"Error", (Throwable)e);
        }
    }

    private String getLagenString(ArrayList<String> successTitles, ArrayList<String> erroredTitles) {
        String laagStatus = "";
        if (successTitles.size() > 0) {
            laagStatus = "De volgende kaart(en) zijn klaar gezet (" + successTitles.size() + "): \n";
            for (String title : successTitles) {
                laagStatus = laagStatus + "- " + title + "\n";
            }
        }
        if (erroredTitles.size() > 0) {
            laagStatus = laagStatus.length() < 1 ? "De volgende kaart(en) is/zijn tijdelijk niet compleet of beschikbaar (" + erroredTitles.size() + "): \n" : laagStatus + "\nDe volgende kaart(en) is/zijn tijdelijk niet compleet of beschikbaar (" + erroredTitles.size() + "): \n";
            for (String title : erroredTitles) {
                laagStatus = laagStatus + "- " + title + "\n";
            }
        }
        return laagStatus;
    }

    private void putDirInZip(ZipOutputStream zip, File dirFile, String rootEntity) throws IOException, Exception {
        byte[] buffer = new byte[8192];
        if (rootEntity == null) {
            rootEntity = "";
        }
        if (rootEntity.length() > 0 && rootEntity.lastIndexOf(File.separator) != rootEntity.length() - 1) {
            rootEntity = rootEntity + File.separator;
        }
        if (dirFile.exists()) {
            if (dirFile.isDirectory()) {
                File[] files = dirFile.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    int len;
                    if (files[i].isDirectory()) {
                        this.putDirInZip(zip, files[i], rootEntity + files[i].getName() + File.separator);
                        continue;
                    }
                    if (files[i].getName().equalsIgnoreCase(ZIPNAME)) continue;
                    FileInputStream is = null;
                    is = new FileInputStream(files[i]);
                    zip.putNextEntry(new ZipEntry(rootEntity + files[i].getName()));
                    while ((len = ((InputStream)is).read(buffer)) > 0) {
                        zip.write(buffer, 0, len);
                    }
                    zip.closeEntry();
                    ((InputStream)is).close();
                    log.debug((Object)("Deleting " + files[i].toString()));
                    files[i].delete();
                }
            } else {
                throw new Exception("File is not a directory");
            }
        }
        zip.closeEntry();
    }

    public void stopThread() {
        this.stop = true;
    }

    private static synchronized String nextThreadName() {
        return "DownloadKaartThread-" + threadCounter++;
    }

    public Configuration getCorrectConfiguration(WFSDataStore ds, String outputFormat) {
        String version = "1.0.0";
        if (ds instanceof WFS_1_1_0_DataStore) {
            version = "1.1.0";
        }
        Object gmlconfig = version.equalsIgnoreCase("1.0.0") || outputFormat != null && (outputFormat.toLowerCase().indexOf("gml/2") >= 0 || outputFormat.equalsIgnoreCase("gml2")) ? new GMLConfiguration() : new org.geotools.gml3.GMLConfiguration();
        return gmlconfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getServiceException(File gmlFile) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        StringWriter writer = new StringWriter();
        FileInputStream fis = new FileInputStream(gmlFile);
        try {
            char[] buffer = new char[8192];
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, UTF8_CHARSET));
            int n = reader.read(buffer);
            ((Writer)writer).write(buffer, 0, n);
        }
        finally {
            fis.close();
        }
        String begin = ((Object)writer).toString();
        if (begin.indexOf("<ServiceExceptionReport") > 0 && begin.indexOf("<ServiceExceptionReport") < 1000) {
            return begin;
        }
        return null;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFormaat() {
        return this.formaat;
    }

    public void setFormaat(String formaat) {
        this.formaat = formaat;
    }

    public String[] getUuids() {
        return this.uuids;
    }

    public void setUuids(String[] uuids) {
        this.uuids = uuids;
    }

    public Integer getThreadStatus() {
        return this.threadStatus;
    }

    public String getApplicationPath() {
        return this.applicationPath;
    }

    public void setApplicationPath(String applicationPath) {
        this.applicationPath = applicationPath;
    }

    public Bron getKaartenbalieBron() {
        return this.kaartenbalieBron;
    }

    public void setKaartenbalieBron(Bron kaartenbalieBron) {
        this.kaartenbalieBron = kaartenbalieBron;
    }

    private FeatureCollection getFeatureCollection(DataStore datastore, Gegevensbron gb) throws IOException, Exception {
        FeatureCollection fc = null;
        Geometry geom = null;
        String wktString = this.getWkt();
        if (wktString != null && !wktString.equals("")) {
            geom = DataStoreUtil.createGeomFromWKTString(wktString);
        }
        Filter geomFilter = null;
        if (geom != null) {
            geomFilter = DataStoreUtil.createIntersectFilter(gb, datastore, geom);
        }
        if (datastore instanceof WFS_1_0_0_DataStore) {
            ArrayList<String> propnames = new ArrayList<String>();
            propnames.add(gb.getAdmin_pk());
            fc = DataStoreUtil.getFeatureCollection(datastore, gb, geomFilter, propnames, null, true);
        } else if (datastore instanceof WFS_1_1_0_DataStore) {
            ArrayList<String> propnames = new ArrayList<String>();
            propnames.add(gb.getAdmin_pk());
            fc = DataStoreUtil.getFeatureCollection(datastore, gb, geomFilter, propnames, null, true);
        } else {
            String typeName = gb.getAdmin_tabel();
            SimpleFeatureSource fs = datastore.getFeatureSource(typeName);
            fc = geomFilter != null ? fs.getFeatures(geomFilter) : fs.getFeatures();
        }
        return fc;
    }

    private Bron getCorrectBron(Gegevensbron gb) {
        Bron bron = gb.getBron();
        if (bron == null && gb.getAdmin_tabel() != null && !gb.getAdmin_tabel().equals("")) {
            bron = this.getKaartenbalieBron();
        }
        return bron;
    }

    public String getWkt() {
        return this.wkt;
    }

    public void setWkt(String wkt) {
        this.wkt = wkt;
    }

    static {
        threadCounter = 1;
        logging = Logging.ALL;
    }
}

