/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.ImprovedNamingStrategy;

public class HibernateUtil
extends HttpServlet {
    private static final Log log = LogFactory.getLog(HibernateUtil.class);
    private static final SessionFactory sessionFactory;
    public static String ANONIEM_ROL;
    public static String GEBRUIKERS_ROL;
    public static String THEMABEHEERDERS_ROL;
    public static String DEMOGEBRUIKERS_ROL;
    public static String BEHEERDERS_ROL;
    public static String ANONYMOUS_USER;
    private static String kburl;
    private static String internalKbUrl;
    private static boolean checkLoginKaartenbalie;
    private static String kaartenbalieCluster;
    private static boolean useKaartenbalieCluster;
    public static String kbWfsConnectieNaam;
    public static String hibernateDialect;
    private static String loginKbUrl;
    public static Boolean cacheOnDisk;
    public static String cacheOnDiskPath;

    public static String createPersonalKbUrl(String code) {
        if (code != null && code.startsWith("http://")) {
            return code;
        }
        String url = HibernateUtil.getKbUrl();
        url = url.trim();
        if (code != null && code.length() > 0) {
            String reqparam = "?";
            int pos = url.indexOf("?");
            if (pos >= 0) {
                reqparam = url.substring(pos);
                url = url.substring(0, pos);
            }
            url = url.lastIndexOf(47) == url.length() - 1 ? url + code + reqparam : url + '/' + code + reqparam;
        }
        return url;
    }

    public static String createInternalKbUrl(String code) {
        if (code != null && code.startsWith("http://")) {
            return code;
        }
        String url = HibernateUtil.getInternalKbUrl();
        if (url != null) {
            url = url.trim();
            if (code != null && code.length() > 0) {
                String reqparam = "?";
                int pos = url.indexOf("?");
                if (pos >= 0) {
                    reqparam = url.substring(pos);
                    url = url.substring(0, pos);
                }
                url = url.lastIndexOf(47) == url.length() - 1 ? url + code + reqparam : url + '/' + code + reqparam;
            }
        }
        return url;
    }

    public static String getKbUrl() {
        return kburl;
    }

    public static void setKbUrl(String aKburl) {
        kburl = aKburl;
    }

    public static boolean isCheckLoginKaartenbalie() {
        return checkLoginKaartenbalie;
    }

    public static void setCheckLoginKaartenbalie(boolean aCheckLoginKaartenbalie) {
        checkLoginKaartenbalie = aCheckLoginKaartenbalie;
    }

    public static String getKaartenbalieCluster() {
        return kaartenbalieCluster;
    }

    public static void setKaartenbalieCluster(String aKaartenbalieCluster) {
        kaartenbalieCluster = aKaartenbalieCluster;
    }

    public static boolean isUseKaartenbalieCluster() {
        return useKaartenbalieCluster;
    }

    public static void setUseKaartenbalieCluster(boolean aUseKaartenbalieCluster) {
        useKaartenbalieCluster = aUseKaartenbalieCluster;
    }

    public static String getInternalKbUrl() {
        return internalKbUrl;
    }

    public static void setInternalKbUrl(String internalKbUrl) {
        HibernateUtil.internalKbUrl = internalKbUrl;
    }

    public static String getKbLoginUrl() {
        return loginKbUrl;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            String value = config.getInitParameter("kburl");
            if (value != null && value.length() > 0) {
                kburl = value;
            }
            if ((value = config.getInitParameter("internalKbUrl")) != null && value.length() > 0) {
                internalKbUrl = value;
            }
            if ((value = config.getInitParameter("check_login_kaartenbalie")) != null && value.equalsIgnoreCase("false")) {
                checkLoginKaartenbalie = false;
            }
            if ((value = config.getInitParameter("use_kaartenbalie_cluster")) != null && value.equalsIgnoreCase("false")) {
                useKaartenbalieCluster = false;
            }
            if ((value = config.getInitParameter("anonymous_user")) != null && value.length() > 0) {
                ANONYMOUS_USER = value;
            }
            if ((value = config.getInitParameter("gebruikers_rol")) != null && value.length() > 0) {
                GEBRUIKERS_ROL = value;
            }
            if ((value = config.getInitParameter("themabeheerders_rol")) != null && value.length() > 0) {
                THEMABEHEERDERS_ROL = value;
            }
            if ((value = config.getInitParameter("loginKbUrl")) != null && value.length() > 0) {
                loginKbUrl = value;
            }
            if (config.getInitParameter("cacheOnDisk") != null) {
                cacheOnDisk = Boolean.parseBoolean(config.getInitParameter("cacheOnDisk"));
            }
            if (config.getInitParameter("cacheOnDiskPath") != null) {
                cacheOnDiskPath = config.getInitParameter("cacheOnDiskPath");
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    static {
        ANONIEM_ROL = "anoniem";
        GEBRUIKERS_ROL = "gebruiker";
        THEMABEHEERDERS_ROL = "themabeheerder";
        DEMOGEBRUIKERS_ROL = "demogebruiker";
        BEHEERDERS_ROL = "beheerder";
        ANONYMOUS_USER = "anoniem";
        kburl = null;
        internalKbUrl = null;
        checkLoginKaartenbalie = true;
        kaartenbalieCluster = "Extra";
        useKaartenbalieCluster = true;
        kbWfsConnectieNaam = "Kaartenbalie WFS";
        hibernateDialect = null;
        loginKbUrl = null;
        cacheOnDisk = false;
        cacheOnDiskPath = null;
        try {
            Configuration config = new Configuration();
            config.setNamingStrategy(ImprovedNamingStrategy.INSTANCE);
            sessionFactory = config.configure().buildSessionFactory();
            hibernateDialect = config.getProperty("dialect");
        }
        catch (Throwable ex) {
            log.error((Object)"Initial SessionFactory creation failed", ex);
            throw new ExceptionInInitializerError(ex);
        }
    }
}

