/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import nl.b3p.gis.geotools.DataStoreUtil;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.geotools.data.DataStore;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class ConfigListsUtil {
    private static final Log log = LogFactory.getLog(ConfigListsUtil.class);
    private static final StringArrayComperator stringArrayComperator = new StringArrayComperator();

    private static Bron getBron(org.hibernate.Session sess, Integer bronId) {
        WebContext ctx = WebContextFactory.get();
        HttpServletRequest request = ctx.getHttpServletRequest();
        GisPrincipal user = GisPrincipal.getGisPrincipal(request);
        return ConfigListsUtil.getBron(sess, user, bronId);
    }

    public static Bron getBron(org.hibernate.Session sess, GisPrincipal user, Integer bronId) {
        Bron b = null;
        if (bronId == null || bronId == 0) {
            b = user.getKbWfsConnectie();
        } else if (bronId > 0) {
            b = (Bron)sess.get(Bron.class, (Serializable)bronId);
        }
        return b;
    }

    public static List getPossibleFeaturesById(Integer connId) {
        String serviceUrl;
        Bron b;
        ArrayList<String> l;
        block3: {
            l = null;
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            Transaction tx = null;
            b = null;
            try {
                tx = sess.beginTransaction();
                b = ConfigListsUtil.getBron((org.hibernate.Session)sess, connId);
                l = ConfigListsUtil.getPossibleFeatures(b);
                tx.commit();
            }
            catch (Exception e) {
                log.error((Object)"Fout tijdens ophalen attributen o.b.v. id: ", (Throwable)e);
                if (tx == null || !tx.isActive()) break block3;
                tx.rollback();
            }
        }
        if (l == null && b != null && (serviceUrl = b.getUrl()) != null) {
            l = new ArrayList<String>();
            l.add("SERVICE_ERROR");
            l.add(serviceUrl);
        }
        return l;
    }

    public static List getPossibleAttributesById(Integer connId, String feature) {
        List l;
        block3: {
            l = null;
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            Transaction tx = null;
            try {
                tx = sess.beginTransaction();
                Bron b = ConfigListsUtil.getBron((org.hibernate.Session)sess, connId);
                if (b != null) {
                    l = ConfigListsUtil.getPossibleAttributes(b, feature);
                }
                tx.commit();
            }
            catch (Exception e) {
                log.error((Object)"Fout tijdens ophalen attributen: ", (Throwable)e);
                if (tx == null || !tx.isActive()) break block3;
                tx.rollback();
            }
        }
        return l;
    }

    public static Boolean isBronJDBC(Integer bronId) {
        Boolean b;
        block2: {
            b = false;
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            Transaction tx = null;
            try {
                tx = sess.beginTransaction();
                Bron bron = ConfigListsUtil.getBron((org.hibernate.Session)sess, bronId);
                b = bron.checkType("jdbc");
                tx.commit();
            }
            catch (Exception e) {
                log.error((Object)"Fout tijdens ophalen attributen: ", (Throwable)e);
                if (tx == null || !tx.isActive()) break block2;
                tx.rollback();
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getPossibleFeatures(Bron b) throws Exception {
        if (b == null) {
            return null;
        }
        ArrayList<String[]> returnValue = null;
        DataStore ds = b.toDatastore();
        try {
            QName[] features = DataStoreUtil.getTypeNames(ds);
            if (features != null) {
                returnValue = new ArrayList<String[]>();
                for (int i = 0; i < features.length; ++i) {
                    String[] s = new String[]{DataStoreUtil.convertQNameToFullname(features[i]), features[i].getLocalPart()};
                    returnValue.add(s);
                }
            }
        }
        finally {
            ds.dispose();
        }
        Collections.sort(returnValue, stringArrayComperator);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getPossibleAttributes(Bron b, String type) throws Exception {
        if (b == null || type == null) {
            return null;
        }
        ArrayList<String[]> returnValue = new ArrayList<String[]>();
        DataStore ds = b.toDatastore();
        try {
            QName nft = DataStoreUtil.convertFeatureTypeToQName(type, ds);
            SimpleFeatureType sft = DataStoreUtil.getSchema(ds, nft);
            List attributes = sft.getAttributeDescriptors();
            for (AttributeDescriptor attribute : attributes) {
                String[] s = new String[]{DataStoreUtil.convertQNameToFullname(DataStoreUtil.n2Qn(attribute.getName())), attribute.getLocalName()};
                returnValue.add(s);
            }
        }
        catch (Exception e) {
            log.error((Object)("fout bij ophalen attributen: " + e.getLocalizedMessage()));
        }
        finally {
            ds.dispose();
        }
        return returnValue;
    }

    private static class StringArrayComperator
    implements Comparator {
        private StringArrayComperator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String[] && o2 instanceof String[]) {
                String[] s1 = (String[])o1;
                String[] s2 = (String[])o2;
                for (int i = 0; i < s1.length; ++i) {
                    int compare = s1[i].compareToIgnoreCase(s2[i]);
                    if (compare == 0) continue;
                    return compare;
                }
                return s1.length - s2.length;
            }
            return 0;
        }
    }
}

