/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.utils;

import java.net.URLEncoder;
import java.text.Normalizer;
import org.apache.log4j.Logger;

public class Slugify {
    private static final Logger logger = Logger.getLogger(Slugify.class);

    public static String slugify(String input) {
        if (input == null || input.length() == 0) {
            return "";
        }
        try {
            String toReturn = Slugify.normalize(input);
            toReturn = toReturn.replaceAll("[^\\w\\s\\-]", "");
            toReturn = toReturn.replace(" ", "-");
            toReturn = toReturn.toLowerCase();
            toReturn = URLEncoder.encode(toReturn, "UTF-8");
            return toReturn;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return "";
        }
    }

    private static String normalize(String input) {
        if (input == null || input.length() == 0) {
            return "";
        }
        return Normalizer.normalize(input, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
    }
}

