/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.gis.viewer.admindata.CollectAdmindata;
import nl.b3p.gis.viewer.db.CMSMenu;
import nl.b3p.gis.viewer.db.CMSMenuItem;
import nl.b3p.gis.viewer.db.CMSPagina;
import nl.b3p.gis.viewer.db.Clusters;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.db.UserKaartlaag;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.SpatialUtil;
import nl.b3p.gis.viewer.struts.BaseHibernateAction;
import nl.b3p.wms.capabilities.Layer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseGisAction
extends BaseHibernateAction {
    private static final Log logger = LogFactory.getLog(BaseGisAction.class);
    public static final String URL_AUTH = "code";
    public static final String APP_AUTH = "appCode";
    public static final String CMS_PAGE_ID = "cmsPageId";
    protected static final double DEFAULTTOLERANCE = 5.0;
    protected static final String ACKNOWLEDGE_MESSAGES = "acknowledgeMessages";
    private static final Pattern NONLATIN = Pattern.compile("[^\\w-]");
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]");

    protected void createLists(DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        GisPrincipal gp = GisPrincipal.getGisPrincipal(request);
        String code = null;
        if (gp != null) {
            code = gp.getCode();
        }
        request.setAttribute("kburl", (Object)HibernateUtil.createPersonalKbUrl(code));
        request.setAttribute("kbcode", (Object)code);
        String organizationcode = CollectAdmindata.getOrganizationCode(request);
        if (organizationcode != null && organizationcode.length() > 0) {
            request.setAttribute("organizationcode", (Object)organizationcode);
        }
    }

    protected ArrayList getThemas(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request) {
        String themaids = request.getParameter("themaid");
        if (themaids == null || themaids.length() == 0) {
            return null;
        }
        String[] ids = themaids.split(",");
        ArrayList<Themas> themas = null;
        for (int i = 0; i < ids.length; ++i) {
            Themas t = this.getThema(ids[i], request);
            if (t == null) continue;
            if (themas == null) {
                themas = new ArrayList<Themas>();
            }
            themas.add(t);
        }
        if (themas != null && themas.size() > 0) {
            Collections.sort(themas);
        }
        return themas;
    }

    protected Themas getThema(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request) {
        String themaid = request.getParameter("themaid");
        return this.getThema(themaid, request);
    }

    protected Gegevensbron getGegevensbron(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request) {
        String bronId = request.getParameter("themaid");
        return this.getGegevensbron(bronId, request);
    }

    private Gegevensbron getGegevensbron(String bronId, HttpServletRequest request) {
        Gegevensbron gb = SpatialUtil.getGegevensbron(bronId);
        if (!HibernateUtil.isCheckLoginKaartenbalie()) {
            return gb;
        }
        GisPrincipal user = GisPrincipal.getGisPrincipal(request);
        if (user == null) {
            return null;
        }
        List layersFromRoles = user.getLayerNames(false);
        if (layersFromRoles == null) {
            return null;
        }
        return gb;
    }

    protected Themas getThema(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, boolean analysethemaid) {
        String themaid = "";
        themaid = analysethemaid ? request.getParameter("analysethemaid") : request.getParameter("themaid");
        return this.getThema(themaid, request);
    }

    private Themas getThema(String themaid, HttpServletRequest request) {
        Themas t = SpatialUtil.getThema(themaid);
        if (t == null) {
            return null;
        }
        return t;
    }

    protected List getValidThemas(boolean locatie, List ctl, HttpServletRequest request) {
        List configuredThemasList = SpatialUtil.getValidThemas(locatie);
        List layersFromRoles = null;
        GisPrincipal user = GisPrincipal.getGisPrincipal(request);
        if (user != null) {
            layersFromRoles = user.getLayerNames(false);
        }
        if (layersFromRoles == null) {
            return null;
        }
        ArrayList<String> layersFound = new ArrayList<String>();
        ArrayList<Themas> checkedThemaList = new ArrayList<Themas>();
        if (configuredThemasList != null) {
            for (Themas t : configuredThemasList) {
                if (!this.checkThemaLayers(t, layersFromRoles) && HibernateUtil.isCheckLoginKaartenbalie()) continue;
                checkedThemaList.add(t);
                layersFound.add(t.getWms_layers_real());
            }
        }
        if (!HibernateUtil.isUseKaartenbalieCluster()) {
            return checkedThemaList;
        }
        Clusters c = SpatialUtil.getDefaultCluster();
        if (c == null) {
            c = new Clusters();
            c.setNaam(HibernateUtil.getKaartenbalieCluster());
            c.setParent(null);
        }
        Iterator it = layersFromRoles.iterator();
        int tid = 100000;
        ArrayList<Themas> extraThemaList = new ArrayList<Themas>();
        while (it.hasNext()) {
            Layer l;
            String layer = (String)it.next();
            if (layersFound.contains(layer) || (l = user.getLayer(layer)) == null) continue;
            Themas t = new Themas();
            t.setNaam(l.getTitle());
            t.setId(new Integer(tid++));
            if (user.hasLegendGraphic(l)) {
                t.setWms_legendlayer_real(layer);
            }
            if ("1".equalsIgnoreCase(l.getQueryable())) {
                t.setWms_querylayers_real(layer);
            }
            t.setWms_layers_real(layer);
            t.setCluster(c);
            extraThemaList.add(t);
        }
        if (extraThemaList.size() > 0) {
            if (ctl == null) {
                ctl = new ArrayList<Clusters>();
            }
            ctl.add(c);
            for (int i = 0; i < extraThemaList.size(); ++i) {
                checkedThemaList.add((Themas)extraThemaList.get(i));
            }
        }
        return checkedThemaList;
    }

    protected List getValidUserThemas(boolean locatie, List ctl, HttpServletRequest request) {
        List configuredThemasList = SpatialUtil.getValidThemas(locatie);
        List layersFromRoles = null;
        GisPrincipal user = GisPrincipal.getGisPrincipal(request);
        if (user != null) {
            layersFromRoles = user.getLayerNames(false);
        }
        if (layersFromRoles == null) {
            return null;
        }
        List<UserKaartlaag> lagen = SpatialUtil.getUserKaartLagen(user.getCode());
        ArrayList<String> layersFound = new ArrayList<String>();
        ArrayList<Themas> checkedThemaList = new ArrayList<Themas>();
        if (configuredThemasList != null) {
            for (Themas t : configuredThemasList) {
                if (lagen != null && lagen.size() > 0) {
                    boolean isInList = false;
                    for (UserKaartlaag laag : lagen) {
                        if (laag.getThemaid() != t.getId()) continue;
                        isInList = true;
                    }
                    if (!isInList) continue;
                }
                if (!this.checkThemaLayers(t, layersFromRoles) && HibernateUtil.isCheckLoginKaartenbalie()) continue;
                checkedThemaList.add(t);
                layersFound.add(t.getWms_layers_real());
            }
        }
        if (!HibernateUtil.isUseKaartenbalieCluster()) {
            return checkedThemaList;
        }
        Clusters c = SpatialUtil.getDefaultCluster();
        if (c == null) {
            c = new Clusters();
            c.setNaam(HibernateUtil.getKaartenbalieCluster());
            c.setParent(null);
        }
        Iterator it = layersFromRoles.iterator();
        int tid = 100000;
        ArrayList<Themas> extraThemaList = new ArrayList<Themas>();
        while (it.hasNext()) {
            Layer l;
            String layer = (String)it.next();
            if (layersFound.contains(layer) || (l = user.getLayer(layer)) == null) continue;
            Themas t = new Themas();
            t.setNaam(l.getTitle());
            t.setId(new Integer(tid++));
            if (user.hasLegendGraphic(l)) {
                t.setWms_legendlayer_real(layer);
            }
            if ("1".equalsIgnoreCase(l.getQueryable())) {
                t.setWms_querylayers_real(layer);
            }
            t.setWms_layers_real(layer);
            t.setCluster(c);
            extraThemaList.add(t);
        }
        if (extraThemaList.size() > 0) {
            if (ctl == null) {
                ctl = new ArrayList<Clusters>();
            }
            ctl.add(c);
            for (int i = 0; i < extraThemaList.size(); ++i) {
                checkedThemaList.add((Themas)extraThemaList.get(i));
            }
        }
        return checkedThemaList;
    }

    protected boolean checkThemaLayers(Themas t, List acceptableLayers) {
        if (t == null || acceptableLayers == null) {
            return false;
        }
        String wmsls = t.getWms_layers_real();
        if (wmsls == null || wmsls.length() == 0) {
            return false;
        }
        String[] wmsla = wmsls.split(",");
        for (int i = 0; i < wmsla.length; ++i) {
            if (acceptableLayers.contains(wmsla[i])) continue;
            return false;
        }
        return true;
    }

    protected Themas getObjectThema(String identifier) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Themas objectThema = null;
        try {
            int id = Integer.parseInt(identifier);
            objectThema = (Themas)sess.get(Themas.class, (Serializable)new Integer(id));
        }
        catch (NumberFormatException nfe) {
            objectThema = (Themas)sess.get(Themas.class, (Serializable)((Object)identifier));
        }
        return objectThema;
    }

    protected List getTekstBlokken(Integer cmsPageId) {
        List tekstBlokken = new ArrayList();
        if (cmsPageId != null && cmsPageId > 0) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            tekstBlokken = sess.createQuery("from Tekstblok where cms_pagina = :id order by volgordenr, cdate").setParameter("id", (Object)cmsPageId).list();
        }
        return tekstBlokken;
    }

    protected static void setCMSPageFromRequest(HttpServletRequest request) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        String param = request.getParameter(CMS_PAGE_ID);
        Integer cmsPageId = null;
        if (param != null && !param.equals("")) {
            cmsPageId = new Integer(param);
        }
        if (cmsPageId != null && cmsPageId > 0) {
            CMSPagina cmsPage = (CMSPagina)sess.get(CMSPagina.class, (Serializable)cmsPageId);
            request.setAttribute(CMS_PAGE_ID, (Object)cmsPageId);
            if (cmsPage != null && cmsPage.getThema() != null && !cmsPage.getThema().equals("")) {
                request.setAttribute("theme", (Object)cmsPage.getThema());
            }
        }
    }

    protected CMSPagina getCMSPage(Integer pageID) {
        if (pageID == null || pageID < 1) {
            return null;
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        return (CMSPagina)sess.get(CMSPagina.class, (Serializable)pageID);
    }

    protected CMSMenu getCMSMenu(Integer id) {
        if (id == null || id < 1) {
            return null;
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        return (CMSMenu)sess.get(CMSMenu.class, (Serializable)id);
    }

    protected List<CMSMenuItem> getCMSMenuItems(Integer menuId) {
        List<CMSMenuItem> menuItems = new ArrayList<CMSMenuItem>();
        if (menuId == null || menuId < 1) {
            return menuItems;
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        menuItems = sess.createQuery("select item from CMSMenuItem item where item.id in (select cmsMenuItems.id from CMSMenu menu inner join menu.cmsMenuItems cmsMenuItems where menu.id = :menuId) order by item.volgordenr DESC").setParameter("menuId", (Object)menuId).list();
        return menuItems;
    }

    protected List<CMSPagina> getCMSPaginas() {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List paginas = sess.createQuery("from CMSPagina order by id").list();
        return paginas;
    }

    protected String prettifyCMSPageUrl(HttpServletRequest request, CMSPagina cmsPage) {
        String baseURL = request.getRequestURL().toString().replace(request.getRequestURI().substring(0), request.getContextPath());
        String nowhitespace = WHITESPACE.matcher(cmsPage.getTitel()).replaceAll("-");
        String normalized = Normalizer.normalize(nowhitespace, Normalizer.Form.NFD);
        String slug = NONLATIN.matcher(normalized).replaceAll("");
        String url = slug.toLowerCase(Locale.ENGLISH);
        return baseURL + "/cms/" + cmsPage.getId() + "/" + url + ".htm";
    }
}

