/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.geotools;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import nl.b3p.gis.geotools.APPSchema;
import nl.b3p.gis.geotools.MSSchema;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.ThemaData;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.SpatialUtil;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wfs.v1_0_0.FeatureSetDescription;
import org.geotools.data.wfs.v1_0_0.WFSCapabilities;
import org.geotools.data.wfs.v1_0_0.WFS_1_0_0_DataStore;
import org.geotools.data.wfs.v1_1_0.WFS_1_1_0_DataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterTransformer;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Log4JLoggerFactory;
import org.geotools.util.logging.LoggerFactory;
import org.geotools.util.logging.Logging;
import org.geotools.xml.DocumentFactory;
import org.geotools.xml.SchemaFactory;
import org.geotools.xml.schema.Schema;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Not;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Intersects;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStoreUtil {
    private static final FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    private static final Log log = LogFactory.getLog(DataStoreUtil.class);
    public static final int maxFeatures = 1000;
    public static final int MAX_COORDS_WKT = 250;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Feature> getFeatures(Bron b, Gegevensbron gb, Geometry geom, Filter extraFilter, List<String> propNames, Integer maximum, boolean collectGeom) throws IOException, Exception {
        DataStore ds = b.toDatastore();
        try {
            Filter geomFilter = DataStoreUtil.createIntersectFilter(gb, ds, geom);
            ArrayList<Filter> filters = new ArrayList<Filter>();
            if (geomFilter != null) {
                filters.add(geomFilter);
            }
            if (extraFilter != null) {
                filters.add(extraFilter);
            }
            Filter filter = null;
            if (filters.size() == 1) {
                filter = (Filter)filters.get(0);
            } else if (filters.size() > 1) {
                filter = ff.and(filters);
            }
            ArrayList<Feature> arrayList = DataStoreUtil.getFeatures(ds, gb, filter, propNames, maximum, collectGeom);
            return arrayList;
        }
        finally {
            ds.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Feature> getWfsFeaturesWithGeotools(Gegevensbron gb, Geometry geom) {
        ArrayList<Feature> features;
        block9: {
            features = new ArrayList<Feature>();
            if (gb == null || gb.getBron() == null) {
                return features;
            }
            try {
                DataStore ds = gb.getBron().toDatastore();
                QName ftName = DataStoreUtil.convertFeatureTypeToQName(gb.getAdmin_tabel(), ds);
                FeatureSource fs = null;
                FeatureIterator fi = null;
                fs = DataStoreUtil.getFeatureSource(ds, ftName);
                SimpleFeatureType featureType = (SimpleFeatureType)fs.getSchema();
                if (featureType == null) break block9;
                Filter filter = DataStoreUtil.getBboxFilter(featureType, geom);
                fi = fs.getFeatures(filter).features();
                try {
                    while (fi.hasNext()) {
                        features.add(fi.next());
                    }
                }
                finally {
                    if (fs != null) {
                        fi.close();
                    }
                }
            }
            catch (IOException ioex) {
                log.error((Object)"Fout ophalen features.", (Throwable)ioex);
            }
            catch (Exception ioex) {
                log.error((Object)"Fout omzetten datastore.", (Throwable)ioex);
            }
        }
        return features;
    }

    private static Filter getBboxFilter(SimpleFeatureType featureType, Geometry geom) {
        String geometryPropertyName = featureType.getGeometryDescriptor().getLocalName();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        CoordinateReferenceSystem targetCRS = featureType.getGeometryDescriptor().getCoordinateReferenceSystem();
        BoundingBox bbox = null;
        try {
            bbox = JTS.toEnvelope((Geometry)geom).toBounds(targetCRS);
        }
        catch (TransformException tex) {
            log.error((Object)"Fout omzetten naar bbox.", (Throwable)tex);
        }
        return ff.bbox((Expression)ff.property(geometryPropertyName), bbox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Feature> getFeatures(DataStore ds, Gegevensbron gb, Filter f, List<String> propNames, Integer maximum, boolean collectGeom) throws IOException, Exception {
        FeatureCollection fc = DataStoreUtil.getFeatureCollection(ds, gb, f, propNames, maximum, collectGeom);
        if (fc == null) {
            return null;
        }
        FeatureIterator fi = fc.features();
        ArrayList<Feature> features = new ArrayList<Feature>();
        try {
            while (fi.hasNext()) {
                features.add(fi.next());
            }
        }
        finally {
            if (fc != null) {
                fi.close();
            }
        }
        return features;
    }

    public static String reconstructPrefixedName(QName qname, DataStore ds) throws IOException {
        if (ds instanceof WFS_1_1_0_DataStore && qname.getNamespaceURI() != null && !qname.getNamespaceURI().isEmpty() && !qname.getNamespaceURI().equals("http://www.opengis.net/wfs")) {
            String[] prefixedNames = ds.getTypeNames();
            for (int i = 0; i < prefixedNames.length; ++i) {
                String[] lna = prefixedNames[i].split(":");
                String localName = lna.length == 2 ? lna[1] : prefixedNames[i];
                if (!qname.getLocalPart().equals(localName)) continue;
                return prefixedNames[i];
            }
        }
        return qname.getLocalPart();
    }

    public static FeatureCollection getFeatureCollection(DataStore ds, Gegevensbron gb, Filter f, List<String> propNames, Integer maximum, boolean collectGeom) throws IOException, Exception {
        String geomAttributeName;
        Filter filter;
        block29: {
            if (gb == null || gb.getAdmin_tabel() == null || gb.getAdmin_tabel().isEmpty()) {
                return null;
            }
            ArrayList<Filter> filters = new ArrayList<Filter>();
            if (f != null) {
                filters.add(f);
            }
            Filter adminFilter = null;
            try {
                adminFilter = DataStoreUtil.getThemaFilter(gb);
            }
            catch (CQLException cqle) {
                if (filters.isEmpty()) {
                    String msg = cqle.getLocalizedMessage();
                    throw new Exception("Error creating filter: " + msg, cqle);
                }
                log.debug((Object)"error creating filter: ", (Throwable)cqle);
            }
            if (adminFilter != null) {
                filters.add(adminFilter);
            }
            filter = null;
            if (filters.size() == 1) {
                filter = (Filter)filters.get(0);
            } else if (filters.size() > 1) {
                filter = ff.and(filters);
            } else {
                log.debug((Object)"No filter found. Using the Filter.INCLUDE (all)");
                filter = Filter.INCLUDE;
            }
            if (log.isDebugEnabled() && filter != null) {
                try {
                    FilterTransformer ft = new FilterTransformer();
                    String s = ft.transform(filter);
                    log.debug((Object)("Do query with filter: " + s));
                }
                catch (Exception e) {
                    log.debug((Object)("Cannot transform filter: " + filter.toString()));
                    log.debug((Object)("Error transform filter: " + e.getLocalizedMessage()));
                    if (e.getCause() == null) break block29;
                    log.debug((Object)("Cause Error transform filter: " + e.getCause().getLocalizedMessage()));
                }
            }
        }
        FeatureSource fs = null;
        QName ftName = DataStoreUtil.convertFeatureTypeToQName(gb.getAdmin_tabel(), ds);
        fs = DataStoreUtil.getFeatureSource(ds, ftName);
        DefaultQuery query = null;
        String prefixedName = DataStoreUtil.reconstructPrefixedName(ftName, ds);
        query = new DefaultQuery(prefixedName, filter);
        int max = maximum != null ? maximum : 1000;
        if (max > 0) {
            query.setMaxFeatures(max);
        }
        if (propNames == null) {
            propNames = new ArrayList<String>();
        }
        String adminPk = null;
        String tmpAdminPk = gb.getAdmin_pk();
        if (tmpAdminPk != null) {
            adminPk = DataStoreUtil.convertColumnNameToQName(tmpAdminPk).getLocalPart();
        }
        if (adminPk != null && adminPk.length() > 0 && !propNames.contains(adminPk)) {
            propNames.add(adminPk);
        }
        String adminFk = null;
        String tmpAdminFk = gb.getAdmin_fk();
        if (tmpAdminFk != null) {
            adminFk = DataStoreUtil.convertColumnNameToQName(tmpAdminFk).getLocalPart();
        }
        if (adminFk != null && adminFk.length() > 0 && !propNames.contains(adminFk)) {
            propNames.add(adminFk);
        }
        if (collectGeom && (geomAttributeName = DataStoreUtil.getGeometryAttributeName(ds, gb)) != null && geomAttributeName.length() > 0 && !propNames.contains(geomAttributeName)) {
            propNames.add(geomAttributeName);
        }
        for (ThemaData td : SpatialUtil.getThemaData(gb, false)) {
            if (td.getDataType() == null || td.getDataType().getId() != 3) continue;
            String commando = td.getCommando();
            while (commando != null && commando.indexOf("[") != -1 && commando.indexOf("]") != -1) {
                int endIndex;
                int beginIndex = commando.indexOf("[") + 1;
                QName propName = DataStoreUtil.convertColumnNameToQName(commando.substring(beginIndex, endIndex = commando.indexOf("]")));
                if (propName != null && !propNames.contains(propName.getLocalPart())) {
                    propNames.add(propName.getLocalPart());
                }
                if (endIndex + 1 >= commando.length() - 1) {
                    commando = "";
                    continue;
                }
                commando = commando.substring(endIndex + 1);
            }
        }
        if (propNames.size() > 0) {
            query.setPropertyNames(propNames);
        }
        FeatureCollection fc = null;
        try {
            fc = fs.getFeatures((Query)query);
        }
        catch (Exception e) {
            String message = "FeatureType: " + query.getTypeName() + "\n";
            message = message + "PropertyNames: ";
            for (int i = 0; i < propNames.size(); ++i) {
                if (i != 0) {
                    message = message + ",";
                }
                message = message + propNames.get(i);
            }
            log.error((Object)message);
            throw e;
        }
        return fc;
    }

    @Deprecated
    public static Filter createIntersectFilter(Themas t, DataStore ds, Geometry geom) throws Exception {
        String geomAttributeName = DataStoreUtil.getGeometryAttributeName(ds, t);
        if (geomAttributeName == null) {
            log.error((Object)"Thema heeft geen geometry");
            throw new Exception("Thema heeft geen geometry");
        }
        CoordinateReferenceSystem crs = DataStoreUtil.getSchema(ds, t).getGeometryDescriptor().getCoordinateReferenceSystem();
        return DataStoreUtil.createIntersectFilter(geomAttributeName, crs, ds, geom);
    }

    public static Filter createIntersectFilter(Gegevensbron gb, DataStore ds, Geometry geom) throws Exception {
        String geomAttributeName = DataStoreUtil.getGeometryAttributeName(ds, gb);
        if (geomAttributeName == null) {
            log.warn((Object)"De datastore voor deze gegevensbron heeft geen geometry.");
            return null;
        }
        CoordinateReferenceSystem crs = DataStoreUtil.getSchema(ds, gb).getGeometryDescriptor().getCoordinateReferenceSystem();
        return DataStoreUtil.createIntersectFilter(geomAttributeName, crs, ds, geom);
    }

    public static Filter createIntersectFilter(String geomAttributeName, CoordinateReferenceSystem crs, DataStore ds, Geometry geom) throws Exception {
        if (geom == null) {
            return null;
        }
        Intersects filter = ff.intersects((Expression)ff.property(geomAttributeName), (Expression)ff.literal((Object)geom));
        if (ds instanceof WFS_1_0_0_DataStore) {
            WFS_1_0_0_DataStore wfsDs = (WFS_1_0_0_DataStore)ds;
            if (!wfsDs.getCapabilities().getFilterCapabilities().fullySupports((Filter)filter)) {
                Not notFilter = ff.not((Filter)ff.disjoint((Expression)ff.property(geomAttributeName), (Expression)ff.literal((Object)geom)));
                Envelope env = geom.getEnvelopeInternal();
                ReferencedEnvelope bbox = new ReferencedEnvelope(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), crs);
                BBOX bboxFilter = ff.bbox((Expression)ff.property(geomAttributeName), (BoundingBox)bbox);
                filter = ff.and((Filter)bboxFilter, (Filter)notFilter);
            }
            if (!wfsDs.getCapabilities().getFilterCapabilities().fullySupports((Filter)filter) && !(geom instanceof Point)) {
                Envelope env = geom.getEnvelopeInternal();
                ReferencedEnvelope bbox = new ReferencedEnvelope(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), crs);
                filter = ff.bbox((Expression)ff.property(geomAttributeName), (BoundingBox)bbox);
            }
            if (!wfsDs.getCapabilities().getFilterCapabilities().supports((Filter)filter)) {
                log.debug((Object)"Intersect,disjoint and bbox filters niet ondersteund. We geven het op: Filter wordt toegepast aan de client kant (java code).");
            }
        }
        if (ds instanceof WFS_1_1_0_DataStore) {
            // empty if block
        }
        return filter;
    }

    public static Filter getThemaFilter(Themas t) throws CQLException {
        String adminQuery = t.getGegevensbron().getAdmin_query();
        if (adminQuery != null && adminQuery.length() > 0) {
            return CQL.toFilter((String)adminQuery);
        }
        return null;
    }

    public static String getGeometryAttributeName(DataStore ds, Themas t) throws Exception {
        SimpleFeatureType schema = DataStoreUtil.getSchema(ds, t);
        if (schema == null) {
            return null;
        }
        GeometryDescriptor gd = schema.getGeometryDescriptor();
        if (gd == null) {
            return null;
        }
        return gd.getName().getLocalPart();
    }

    public static SimpleFeatureType getSchema(DataStore ds, Themas t) throws Exception {
        return DataStoreUtil.getSchema(ds, new QName(t.getGegevensbron().getAdmin_tabel()));
    }

    public static SimpleFeatureType getSchema(DataStore ds, QName ftName) {
        try {
            if (ds instanceof WFS_1_1_0_DataStore && ftName.getNamespaceURI() != null && !ftName.getNamespaceURI().isEmpty() && !ftName.getNamespaceURI().equals("http://www.opengis.net/wfs")) {
                Name nn = DataStoreUtil.qN2N(ftName);
                SimpleFeatureType sft = (SimpleFeatureType)ds.getSchema(nn);
                return sft;
            }
            String ns = ftName.getLocalPart();
            SimpleFeatureType sft = ds.getSchema(ns);
            return sft;
        }
        catch (Exception e) {
            SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
            if (ftName != null) {
                sftb.setName(ftName.getLocalPart());
            }
            return sftb.buildFeatureType();
        }
    }

    public static FeatureSource getFeatureSource(DataStore ds, QName ftName) throws IOException {
        if (ds instanceof WFS_1_1_0_DataStore && ftName.getNamespaceURI() != null && !ftName.getNamespaceURI().isEmpty() && !ftName.getNamespaceURI().equals("http://www.opengis.net/wfs")) {
            Name nn = DataStoreUtil.qN2N(ftName);
            SimpleFeatureSource fs = ds.getFeatureSource(nn);
            return fs;
        }
        String ns = ftName.getLocalPart();
        SimpleFeatureSource fs = ds.getFeatureSource(ns);
        return fs;
    }

    public static boolean isFilterSupported(WFS_1_0_0_DataStore ds, Filter filter) throws IOException {
        return ds.getCapabilities().getFilterCapabilities().fullySupports(filter);
    }

    public static Filter getThemaFilter(Gegevensbron gb) throws CQLException {
        String adminQuery = gb.getAdmin_query();
        if (adminQuery != null && adminQuery.length() > 0) {
            return CQL.toFilter((String)adminQuery);
        }
        return null;
    }

    public static String getGeometryAttributeName(DataStore ds, Gegevensbron gb) throws Exception {
        SimpleFeatureType schema = DataStoreUtil.getSchema(ds, gb);
        if (schema == null) {
            return null;
        }
        GeometryDescriptor gd = schema.getGeometryDescriptor();
        if (gd == null) {
            return null;
        }
        return gd.getName().getLocalPart();
    }

    public static SimpleFeatureType getSchema(DataStore ds, Gegevensbron gb) throws Exception {
        if (gb == null || gb.getAdmin_tabel() == null || gb.getAdmin_tabel().isEmpty()) {
            return null;
        }
        return DataStoreUtil.getSchema(ds, DataStoreUtil.convertFeatureTypeToQName(gb.getAdmin_tabel(), ds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<QName> getAttributeNames(Bron b, Gegevensbron gb) throws Exception {
        if (b == null) {
            return new ArrayList<QName>();
        }
        DataStore ds = b.toDatastore();
        try {
            List<QName> list = DataStoreUtil.getAttributeNames(ds, DataStoreUtil.convertFeatureTypeToQName(gb.getAdmin_tabel(), ds));
            return list;
        }
        finally {
            ds.dispose();
        }
    }

    public static List<QName> getAttributeNames(DataStore ds, QName ftName) throws Exception {
        ArrayList<QName> attributen = new ArrayList<QName>();
        try {
            SimpleFeatureType featureType = DataStoreUtil.getSchema(ds, ftName);
            List descriptors = featureType.getAttributeDescriptors();
            for (int i = 0; i < descriptors.size(); ++i) {
                attributen.add(DataStoreUtil.n2Qn(((AttributeDescriptor)descriptors.get(i)).getName()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attributen;
    }

    public static List<String> themaData2PropertyNames(List<ThemaData> themaData) {
        ArrayList<String> propNamesList = new ArrayList<String>();
        for (int i = 0; i < themaData.size(); ++i) {
            String prp;
            if (themaData.get(i).getKolomnaam() == null || propNamesList.contains(prp = DataStoreUtil.convertColumnNameToQName(themaData.get(i).getKolomnaam()).getLocalPart())) continue;
            propNamesList.add(prp);
        }
        return propNamesList;
    }

    public static List<String> basisRegelThemaData2PropertyNames(List<ThemaData> themaData) {
        ArrayList<String> propNamesList = new ArrayList<String>();
        for (int i = 0; i < themaData.size(); ++i) {
            String prp;
            if (themaData.get(i).getKolomnaam() == null || !themaData.get(i).isBasisregel() || propNamesList.contains(prp = DataStoreUtil.convertColumnNameToQName(themaData.get(i).getKolomnaam()).getLocalPart())) continue;
            propNamesList.add(prp);
        }
        return propNamesList;
    }

    public static QName[] getTypeNames(DataStore ds) throws IOException {
        List names = ds.getNames();
        QName[] typeNames = null;
        if (names == null || names.isEmpty()) {
            String[] localNames = ds.getTypeNames();
            typeNames = new QName[localNames.length];
            for (int i = 0; i < localNames.length; ++i) {
                QName qname;
                typeNames[i] = qname = new QName(localNames[i]);
            }
        } else {
            typeNames = new QName[names.size()];
            for (int i = 0; i < names.size(); ++i) {
                QName qname;
                typeNames[i] = qname = DataStoreUtil.n2Qn((Name)names.get(i));
            }
        }
        return typeNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QName getThemaGeomName(Themas t, GisPrincipal user) throws IOException, Exception {
        Gegevensbron gb = t.getGegevensbron();
        Bron b = null;
        if (gb != null) {
            b = gb.getBron(user);
        }
        if (b == null) {
            return null;
        }
        DataStore ds = b.toDatastore();
        QName n = DataStoreUtil.convertFeatureTypeToQName(gb.getAdmin_tabel(), ds);
        if (n == null || n.getLocalPart() == null) {
            return null;
        }
        try {
            SimpleFeatureType sft = DataStoreUtil.getSchema(ds, n);
            if (sft.getGeometryDescriptor() != null) {
                QName qName = DataStoreUtil.n2Qn(sft.getGeometryDescriptor().getName());
                return qName;
            }
        }
        finally {
            ds.dispose();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QName getThemaGeomName(Gegevensbron gb, GisPrincipal user) throws IOException, Exception {
        Bron b = gb.getBron();
        if (b == null) {
            return null;
        }
        DataStore ds = b.toDatastore();
        QName n = DataStoreUtil.convertFeatureTypeToQName(gb.getAdmin_tabel(), ds);
        if (n == null || n.getLocalPart() == null) {
            return null;
        }
        try {
            SimpleFeatureType sft = DataStoreUtil.getSchema(ds, n);
            if (sft.getGeometryDescriptor() != null) {
                QName qName = DataStoreUtil.n2Qn(sft.getGeometryDescriptor().getName());
                return qName;
            }
        }
        finally {
            ds.dispose();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getThemaGeomType(Themas t, GisPrincipal user) throws IOException, Exception {
        Gegevensbron gb = t.getGegevensbron();
        Bron b = null;
        if (gb != null) {
            b = gb.getBron(user);
        }
        if (b == null) {
            return null;
        }
        DataStore ds = b.toDatastore();
        QName n = DataStoreUtil.convertFeatureTypeToQName(gb.getAdmin_tabel(), ds);
        if (n == null || n.getLocalPart() == null) {
            return null;
        }
        try {
            SimpleFeatureType sft = DataStoreUtil.getSchema(ds, n);
            if (sft.getGeometryDescriptor() != null) {
                String string = sft.getGeometryDescriptor().getType().toString();
                return string;
            }
        }
        finally {
            ds.dispose();
        }
        return null;
    }

    public static DataStore createDataStoreFromParams(Map params) throws IOException, Exception {
        return Bron.createDataStoreFromParams((Map)params);
    }

    public static Name qN2N(QName qn) {
        if (qn == null) {
            return new NameImpl("");
        }
        return new NameImpl(qn.getNamespaceURI(), qn.getLocalPart());
    }

    public static QName n2Qn(Name n) {
        if (n == null) {
            return new QName("");
        }
        return new QName(n.getNamespaceURI(), n.getLocalPart());
    }

    public static String convertQNameToFullname(QName qn) {
        String returnValue = "";
        String nsu = qn.getNamespaceURI();
        if (nsu != null && nsu.length() != 0) {
            returnValue = "{" + nsu + "}";
        }
        returnValue = returnValue + qn.getLocalPart();
        return returnValue;
    }

    public static QName convertFeatureTypeToQName(String ln, DataStore ds) throws IOException, Exception {
        if (ln == null || ln.isEmpty()) {
            throw new Exception("FeatureType name may not be null or empty");
        }
        String localName = ln;
        String nsPrefix = "";
        String nsUriString = "";
        String[] temp = ln.split("}");
        if (temp.length > 1) {
            int index2;
            localName = temp[1];
            int index1 = ln.indexOf("{");
            nsUriString = ln.substring(index1 + 1, index2 = ln.indexOf("}"));
            Schema schema = SchemaFactory.getInstance((String)nsUriString);
            nsPrefix = schema == null ? "ns" + nsUriString.hashCode() : schema.getPrefix();
        }
        QName convName = new QName(nsUriString, localName, nsPrefix);
        List names = ds.getNames();
        String[] localNames = ds.getTypeNames();
        if (names == null || names.isEmpty()) {
            for (int i = 0; i < localNames.length; ++i) {
                if (localNames[i].equals(convName.getLocalPart())) {
                    return convName;
                }
                if (!localNames[i].equalsIgnoreCase(convName.getLocalPart())) continue;
                log.debug((Object)"Ignore case for Oracle");
                return convName;
            }
        } else {
            for (Name name : names) {
                String nameUri = name.getNamespaceURI();
                if (nameUri == null) {
                    nameUri = "";
                }
                if (!convName.getNamespaceURI().equals(nameUri)) continue;
                if (convName.getLocalPart().equals(name.getLocalPart())) {
                    return DataStoreUtil.n2Qn(name);
                }
                if (!convName.getLocalPart().equalsIgnoreCase(name.getLocalPart())) continue;
                log.debug((Object)"Ignore case for Oracle");
                return DataStoreUtil.n2Qn(name);
            }
        }
        StringBuilder sb = new StringBuilder("Typename not found in datastore, ");
        sb.append("looking for typename: ");
        sb.append(ln);
        sb.append(", found typenames: ");
        for (int i = 0; i < localNames.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(localNames[i]);
        }
        sb.append("!");
        throw new Exception(sb.toString());
    }

    public static QName convertColumnNameToQName(String ln) {
        if (ln == null) {
            return null;
        }
        String localName = ln;
        String nsPrefix = "";
        String nsUriString = "";
        String[] temp = ln.split("}");
        if (temp.length > 1) {
            int index2;
            localName = temp[1];
            int index1 = ln.indexOf("{");
            nsUriString = ln.substring(index1 + 1, index2 = ln.indexOf("}"));
            Schema schema = SchemaFactory.getInstance((String)nsUriString);
            nsPrefix = schema == null ? "ns" + nsUriString.hashCode() : schema.getPrefix();
        } else {
            String[] lna = ln.split(":");
            if (lna.length > 1) {
                localName = lna[1];
                nsPrefix = lna[0];
                URI nsUri = null;
                Schema[] schemas = SchemaFactory.getSchemas((String)nsPrefix);
                if (schemas.length > 0) {
                    nsUri = schemas[0].getTargetNamespace();
                } else {
                    try {
                        nsUri = new URI("http://www.kaartenbalie.nl/" + nsPrefix);
                    }
                    catch (URISyntaxException ex) {
                        log.debug((Object)ex);
                    }
                }
                nsUriString = nsUri == null ? "" : nsUri.toString();
            }
        }
        return new QName(nsUriString, localName, nsPrefix);
    }

    public static GeometryType getGeometryType(Feature f) {
        if (f == null || f.getDefaultGeometryProperty() == null) {
            return null;
        }
        Geometry geom = (Geometry)f.getDefaultGeometryProperty().getValue();
        NameImpl name = null;
        Class binding = null;
        if (geom instanceof MultiPolygon) {
            name = new NameImpl("MULTIPOLYGON");
            binding = MultiPolygon.class;
        } else if (geom instanceof Polygon) {
            name = new NameImpl("POLYGON");
            binding = Polygon.class;
        } else if (geom instanceof MultiLineString) {
            name = new NameImpl("MULTILINESTRING");
            binding = MultiLineString.class;
        } else if (geom instanceof LineString) {
            name = new NameImpl("LINESTRING");
            binding = LineString.class;
        } else if (geom instanceof MultiPoint) {
            name = new NameImpl("MULTIPOINT");
            binding = MultiPoint.class;
        } else if (geom instanceof Point) {
            name = new NameImpl("POINT");
            binding = Point.class;
        } else {
            name = new NameImpl("GEOMETRY");
            binding = geom.getClass();
        }
        return new GeometryTypeImpl((Name)name, binding, null, true, false, null, null, null);
    }

    public static ReferencedEnvelope convertFeature2Envelop(Feature f) {
        if (f == null || f.getDefaultGeometryProperty() == null) {
            return null;
        }
        Geometry geom = (Geometry)f.getDefaultGeometryProperty().getValue();
        if (geom != null && geom.isSimple() && geom.isValid()) {
            if (!(geom instanceof Point)) {
                Envelope env = geom.getEnvelopeInternal();
                CoordinateReferenceSystem crs = f.getDefaultGeometryProperty().getDescriptor().getCoordinateReferenceSystem();
                return new ReferencedEnvelope(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), crs);
            }
            if (geom instanceof Point) {
                Envelope env = geom.getEnvelopeInternal();
                Double minX = env.getMinX() - 10.0;
                Double minY = env.getMinY() + 10.0;
                Double maxX = env.getMaxX() + 10.0;
                Double maxY = env.getMaxY() - 10.0;
                CoordinateReferenceSystem crs = f.getDefaultGeometryProperty().getDescriptor().getCoordinateReferenceSystem();
                return new ReferencedEnvelope(minX.doubleValue(), maxX.doubleValue(), minY.doubleValue(), maxY.doubleValue(), crs);
            }
        }
        return null;
    }

    public static String convertFeature2WKT(Feature f, boolean fallback) {
        if (f == null || f.getDefaultGeometryProperty() == null) {
            return null;
        }
        Geometry geom = (Geometry)f.getDefaultGeometryProperty().getValue();
        if (geom != null && geom.isSimple() && geom.isValid()) {
            if (geom.getCoordinates() != null && geom.getCoordinates().length > 250 && fallback) {
                geom = geom.getEnvelope();
            }
            WKTWriter wktw = new WKTWriter();
            return wktw.write(geom);
        }
        return null;
    }

    public static String selecteerKaartObjectWkt(Feature f) {
        if (f == null || f.getDefaultGeometryProperty() == null) {
            return null;
        }
        Geometry geom = (Geometry)f.getDefaultGeometryProperty().getValue();
        if (geom != null) {
            WKTWriter wktw = new WKTWriter();
            return wktw.write(geom);
        }
        return null;
    }

    public static Geometry createGeomFromWKTString(String wktstring) throws Exception {
        WKTReader wktreader = new WKTReader(new GeometryFactory(new PrecisionModel(), 28992));
        try {
            return wktreader.read(wktstring);
        }
        catch (ParseException ex) {
            throw new Exception(ex);
        }
    }

    public static void main(String[] args) throws URISyntaxException, IOException, Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String url = "http://localhost:8084/kaartenbalie/services/?SERVICE=WFS&VERSION=1.0.0&REQUEST=GetCapabilities";
        params.put(WFSDataStoreFactory.URL.key, url);
        params.put(WFSDataStoreFactory.TIMEOUT.key, 60000);
        params.put(WFSDataStoreFactory.USERNAME.key, "Beheerder");
        params.put(WFSDataStoreFactory.PASSWORD.key, "*****");
        DataStore ds = DataStoreFinder.getDataStore(params);
        if (ds instanceof WFS_1_0_0_DataStore) {
            WFS_1_0_0_DataStore wfs100ds = (WFS_1_0_0_DataStore)ds;
            WFSCapabilities wfscap = wfs100ds.getCapabilities();
            List fdsl = wfscap.getFeatureTypes();
            for (FeatureSetDescription fds : fdsl) {
                if (fds.getNamespace() != null) continue;
                QName qname = DataStoreUtil.convertFeatureTypeToQName(fds.getName(), ds);
                fds.setName(qname.getLocalPart());
                fds.setNamespace(new URI(qname.getNamespaceURI()));
            }
            FilterCapabilities filterCap = wfscap.getFilterCapabilities();
            filterCap.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
            boolean b = filterCap.supports(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
            wfscap.setFilterCapabilities(filterCap);
        }
        String prefixedFTName = "demowfs_rivieren_nl";
        QName ftName = DataStoreUtil.convertFeatureTypeToQName(prefixedFTName, ds);
        DefaultQuery query = null;
        SimpleFeatureType sft = null;
        FeatureSource fs = null;
        sft = DataStoreUtil.getSchema(ds, ftName);
        fs = DataStoreUtil.getFeatureSource(ds, ftName);
        String geomAttributeName = sft.getGeometryDescriptor().getLocalName();
        CoordinateReferenceSystem crs = sft.getGeometryDescriptor().getCoordinateReferenceSystem();
        ReferencedEnvelope bbox = new ReferencedEnvelope(201000.0, 380000.0, 202000.0, 381000.0, crs);
        BBOX filter = ff.bbox((Expression)ff.property(geomAttributeName), (BoundingBox)bbox);
        String prefixedName = ftName.getPrefix() + ":" + ftName.getLocalPart();
        query = new DefaultQuery(prefixedName, (Filter)filter);
        query.setNamespace(new URI(ftName.getNamespaceURI()));
        query.setMaxFeatures(3);
        ArrayList<String> propNames = new ArrayList<String>();
        propNames.add(geomAttributeName);
        query.setPropertyNames(propNames);
        FeatureCollection fc = fs.getFeatures((Query)query);
        FeatureIterator fi = fc.features();
        ArrayList<Feature> features = new ArrayList<Feature>();
        while (fi.hasNext()) {
            features.add(fi.next());
            System.out.println("feature");
        }
        boolean test2 = false;
        if (test2) {
            String wfsCapabilitiesRawData = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><WFS_Capabilities xmlns=\"http://www.opengis.net/wfs\" xmlns:app=\"http://www.deegree.org/app\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengeospatial.net/wfs/1.0.0/WFS-capabilities.xsd\" version=\"1.0.0\" updateSequence=\"0\"><Service><Name>Ruimtelijke ordeningsplannen (RO-Online WFS)</Name><Title>RO-Online: De landelijke voorziening voor digitale ruimtelijke ordeningsplannen</Title><Keywords>ruimtelijke ordening planologie bestemmingsplannen structuurvisies AMvB provinciale verordeningen wet ruimtelijke ordening besluit ruimtelijke ordening IMRO</Keywords><OnlineResource xsi:type=\"java:java.lang.String\">http://localhost:8084/kaartenbalie/services/</OnlineResource><Fees>none</Fees><AccessConstraints>NONE</AccessConstraints></Service><Capability><Request><GetFeature><ResultFormat><GML2/></ResultFormat><DCPType><HTTP><Get onlineResource=\"http://localhost:8084/kaartenbalie/services/\"/><Post onlineResource=\"http://localhost:8084/kaartenbalie/services/\"/></HTTP></DCPType></GetFeature><DescribeFeatureType><SchemaDescriptionLanguage><XMLSCHEMA/></SchemaDescriptionLanguage><DCPType><HTTP><Get onlineResource=\"http://localhost:8084/kaartenbalie/services/\"/><Post onlineResource=\"http://localhost:8084/kaartenbalie/services/\"/></HTTP></DCPType></DescribeFeatureType><GetCapabilities><DCPType><HTTP><Get onlineResource=\"http://localhost:8084/kaartenbalie/services/\"/><Post onlineResource=\"http://localhost:8084/kaartenbalie/services/\"/></HTTP></DCPType></GetCapabilities></Request></Capability><FeatureTypeList><FeatureType><Name>app:roowfs_Gebiedsaanduiding</Name><Title>app:Gebiedsaanduiding</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_ProvinciaalComplex</Name><Title>app:ProvinciaalComplex</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_ProvinciaalVerbinding</Name><Title>app:ProvinciaalVerbinding</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Structuurvisiecomplex_R</Name><Title>app:Structuurvisiecomplex_R</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Structuurvisiecomplex_P</Name><Title>app:Structuurvisiecomplex_P</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Plangebied</Name><Title>app:Plangebied</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Enkelbestemming</Name><Title>app:Enkelbestemming</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Besluitgebied_P</Name><Title>app:Besluitgebied_P</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_NationaalGebied</Name><Title>app:NationaalGebied</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Figuur</Name><Title>app:Figuur</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Besluitgebied_X</Name><Title>app:Besluitgebied_X</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Plangebied_PCP</Name><Title>app:Plangebied_PCP</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Besluitvlak_A</Name><Title>app:Besluitvlak_A</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_ProvinciaalPlangebied</Name><Title>app:ProvinciaalPlangebied</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Structuurvisiecomplex_G</Name><Title>app:Structuurvisiecomplex_G</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Dubbelbestemming</Name><Title>app:Dubbelbestemming</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Besluitgebied</Name><Title>app:Besluitgebied</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_PlangebiedDigitaalWaarmerk</Name><Title>app:PlangebiedDigitaalWaarmerk</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Besluitsubvlak_X</Name><Title>app:Besluitsubvlak_X</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Structuurvisiegebied_G</Name><Title>app:Structuurvisiegebied_G</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Bouwvlak</Name><Title>app:Bouwvlak</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Bestemmingsplangebied</Name><Title>app:Bestemmingsplangebied</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Besluitvlak_X</Name><Title>app:Besluitvlak_X</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Structuurvisiegebied_R</Name><Title>app:Structuurvisiegebied_R</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Structuurvisiegebied_P</Name><Title>app:Structuurvisiegebied_P</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Besluitsubvlak_P</Name><Title>app:Besluitsubvlak_P</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_NationaalVerbinding</Name><Title>app:NationaalVerbinding</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_OnderdelenDigitaalWaarmerk</Name><Title>app:OnderdelenDigitaalWaarmerk</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Onthoudingsgebied</Name><Title>app:Onthoudingsgebied</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Functieaanduiding</Name><Title>app:Functieaanduiding</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Structuurvisieverklaring_P</Name><Title>app:Structuurvisieverklaring_P</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Besluitvlak_P</Name><Title>app:Besluitvlak_P</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_NationaalComplex</Name><Title>app:NationaalComplex</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Maatvoering</Name><Title>app:Maatvoering</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_NationaalPlangebied</Name><Title>app:NationaalPlangebied</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Bouwaanduiding</Name><Title>app:Bouwaanduiding</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Besluitsubvlak_A</Name><Title>app:Besluitsubvlak_A</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Structuurvisieplangebied_G</Name><Title>app:Structuurvisieplangebied_G</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Lettertekenaanduiding</Name><Title>app:Lettertekenaanduiding</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Structuurvisieplangebied_R</Name><Title>app:Structuurvisieplangebied_R</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_ProvinciaalGebied</Name><Title>app:ProvinciaalGebied</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Structuurvisieplangebied_P</Name><Title>app:Structuurvisieplangebied_P</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>app:roowfs_Besluitgebied_A</Name><Title>app:Besluitgebied_A</Title><SRS>urn:ogc:def:crs:EPSG::28992</SRS><LatLongBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/><MetadataURL type=\"TC211\" format=\"XML\">http://afnemers.ruimtelijkeplannen.nl:80/afnemers/metadata.xml</MetadataURL></FeatureType><FeatureType><Name>demowfs_bebouwdekom_nl</Name><Title>bebouwdekom_nl</Title><SRS>EPSG:28992</SRS><LatLongBoundingBox minx=\"3.22989\" miny=\"50.709\" maxx=\"7.27394\" maxy=\"53.5672\"/></FeatureType><FeatureType><Name>demowfs_bebouwdekom nl</Name><Title>bebouwdekom nl</Title><SRS>EPSG:28992</SRS><LatLongBoundingBox minx=\"3.22989\" miny=\"50.709\" maxx=\"7.27394\" maxy=\"53.5672\"/></FeatureType><FeatureType><Name>demowfs_basis_nl</Name><Title>basis_nl</Title><SRS>EPSG:28992</SRS><LatLongBoundingBox minx=\"-179.156\" miny=\"-74.7705\" maxx=\"179.909\" maxy=\"2.64457\"/></FeatureType><FeatureType><Name>demowfs_autowegen_nl</Name><Title>autowegen_nl</Title><SRS>EPSG:28992</SRS><LatLongBoundingBox minx=\"-179.156\" miny=\"-74.7705\" maxx=\"179.909\" maxy=\"2.64457\"/></FeatureType><FeatureType><Name>demowfs_autowegen_elabels</Name><Title>autowegen_elabels</Title><SRS>EPSG:28992</SRS><LatLongBoundingBox minx=\"-179.156\" miny=\"-74.7705\" maxx=\"179.909\" maxy=\"2.64457\"/></FeatureType><FeatureType><Name>demowfs_rivieren_nl</Name><Title>rivieren_nl</Title><SRS>EPSG:28992</SRS><LatLongBoundingBox minx=\"-179.156\" miny=\"-74.7705\" maxx=\"179.909\" maxy=\"2.64457\"/></FeatureType><FeatureType><Name>demowfs_gemeenten_2006</Name><Title>gemeenten_2006</Title><SRS>EPSG:28992</SRS><LatLongBoundingBox minx=\"3.22989\" miny=\"50.709\" maxx=\"7.27394\" maxy=\"53.5672\"/></FeatureType><FeatureType><Name>demowfs_wijken_2006</Name><Title>wijken_2006</Title><SRS>EPSG:28992</SRS><LatLongBoundingBox minx=\"-179.156\" miny=\"-74.7705\" maxx=\"179.909\" maxy=\"2.64457\"/></FeatureType><FeatureType><Name>demowfs_buurten_2006</Name><Title>buurten_2006</Title><SRS>EPSG:28992</SRS><LatLongBoundingBox minx=\"-179.156\" miny=\"-74.7705\" maxx=\"179.909\" maxy=\"2.64457\"/></FeatureType><FeatureType><Name>demowfs_plan_lijnen</Name><Title>plan_lijnen</Title><SRS>EPSG:28992</SRS><LatLongBoundingBox minx=\"-179.156\" miny=\"-74.7705\" maxx=\"179.909\" maxy=\"2.64457\"/></FeatureType><FeatureType><Name>demowfs_plan_polygonen</Name><Title>plan_polygonen</Title><SRS>EPSG:28992</SRS><LatLongBoundingBox minx=\"-179.156\" miny=\"-74.7705\" maxx=\"179.909\" maxy=\"2.64457\"/></FeatureType></FeatureTypeList><ogc:Filter_Capabilities><ogc:Spatial_Capabilities><ogc:Spatial_Operators><ogc:BBOX/></ogc:Spatial_Operators></ogc:Spatial_Capabilities><ogc:Scalar_Capabilities><ogc:Comparison_Operators><ogc:Simple_Comparisons/><ogc:Like/><ogc:Between/><ogc:NullCheck/></ogc:Comparison_Operators></ogc:Scalar_Capabilities></ogc:Filter_Capabilities></WFS_Capabilities>";
            ByteArrayInputStream capabilitiesReader = new ByteArrayInputStream(wfsCapabilitiesRawData.getBytes("UTF-8"));
            HashMap<String, Boolean> hints = new HashMap<String, Boolean>();
            hints.put("DocumentFactory_VALIDATION_HINT", Boolean.FALSE);
            try {
                Object parsed = DocumentFactory.getInstance((InputStream)capabilitiesReader, hints, null);
            }
            catch (Exception e) {
                throw new IOException("Error parsing WFS 1.0.0 capabilities");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main2(String[] args) throws Exception {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(), 28992);
        Polygon poly = (Polygon)new WKTReader(gf).read("    POLYGON((202557 384630, 202523 384611, 202581 384507, 202637 384503, 202707 384674, 202698 384709, 202557 384630))");
        WFSDataStore wfsDatastore = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String url = "http://acceptatie.prvlimburg.nl/geoservices/wion";
            if (!url.endsWith("&") && !url.endsWith("?")) {
                url = url + (url.indexOf("?") >= 0 ? "&" : "?");
            }
            params.put(WFSDataStoreFactory.TIMEOUT.key, 30000);
            params.put(WFSDataStoreFactory.URL.key, url + "Request=GetCapabilities&Service=WFS&Version=1.0.0");
            wfsDatastore = (WFSDataStore)DataStoreFinder.getDataStore(params);
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
            String typeName = "BUIS_DUIKERS";
            String property = "msGeometry";
            Intersects filter = ff.intersects((Expression)ff.property(property), (Expression)ff.literal((Object)poly));
            System.out.println("supports:" + ((WFS_1_0_0_DataStore)wfsDatastore).getCapabilities().getFilterCapabilities().fullySupports((Filter)filter));
            DefaultQuery query = new DefaultQuery(typeName, (Filter)filter);
            query.setMaxFeatures(10);
            SimpleFeatureSource fs = wfsDatastore.getFeatureSource(typeName);
            FeatureCollection fc = fs.getFeatures((Query)query);
            int count = fc instanceof DataFeatureCollection ? ((DataFeatureCollection)fc).getCount() : fc.size();
            System.out.println("Aantal features: " + count);
        }
        finally {
            if (wfsDatastore != null) {
                wfsDatastore.dispose();
            }
        }
    }

    static {
        Logging.ALL.setLoggerFactory((LoggerFactory)Log4JLoggerFactory.getInstance());
        APPSchema appSchema = APPSchema.getInstance();
        SchemaFactory.registerSchema((URI)appSchema.getURI(), (Schema)appSchema);
        MSSchema msSchema = MSSchema.getInstance();
        SchemaFactory.registerSchema((URI)msSchema.getURI(), (Schema)msSchema);
    }
}

