/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKTReader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.gis.geotools.DataStoreUtil;
import nl.b3p.gis.geotools.FilterBuilder;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.ThemaData;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.SpatialUtil;
import nl.b3p.zoeker.configuratie.Bron;
import nl.b3p.zoeker.services.A11YResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.geotools.data.DataStore;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.opengis.feature.Feature;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;
import org.opengis.filter.Or;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class GetLocationData {
    private static final Log log = LogFactory.getLog(GetLocationData.class);

    public String getWktByThema(String themaId, String attributeName, String compareValue) {
        String wkt;
        block4: {
            wkt = "";
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            Transaction tx = null;
            tx = sess.beginTransaction();
            try {
                Integer id = -1;
                id = new Integer(themaId);
                Themas thema = (Themas)sess.get(Themas.class, (Serializable)id);
                Gegevensbron gb = thema.getGegevensbron();
                wkt = this.getWkt(gb, (org.hibernate.Session)sess, attributeName, compareValue);
                tx.commit();
            }
            catch (NumberFormatException ex) {
                log.error((Object)("Fout tijdens omzetten gegevensbronid: " + ex));
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception ex) {
                log.error((Object)("Fout tijdens ophalen wkt: " + ex));
                if (tx == null || !tx.isActive()) break block4;
                tx.rollback();
            }
        }
        return wkt;
    }

    public String getWkt(String ggbId, String attributeName, String compareValue) throws SQLException {
        String wkt;
        block4: {
            wkt = "";
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            Transaction tx = null;
            tx = sess.beginTransaction();
            try {
                Integer id = -1;
                id = new Integer(ggbId);
                Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)id);
                wkt = this.getWkt(gb, (org.hibernate.Session)sess, attributeName, compareValue);
                tx.commit();
            }
            catch (NumberFormatException ex) {
                log.error((Object)("Fout tijdens omzetten gegevensbronid: " + ex));
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception ex) {
                log.error((Object)("Fout tijdens ophalen wkt: " + ex));
                if (tx == null || !tx.isActive()) break block4;
                tx.rollback();
            }
        }
        return wkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWkt(Gegevensbron gb, org.hibernate.Session sess, String attributeName, String compareValue) throws Exception {
        DataStore ds = null;
        String wkt = null;
        try {
            GeometryDescriptor gDescr;
            WebContext ctx;
            HttpServletRequest request;
            Bron b;
            if (gb != null && (b = gb.getBron(request = (ctx = WebContextFactory.get()).getHttpServletRequest())) != null && (ds = b.toDatastore()) != null && (gDescr = DataStoreUtil.getSchema(ds, gb).getGeometryDescriptor()) != null) {
                String geometryName = gDescr.getLocalName();
                ArrayList<String> propertyNames = new ArrayList<String>();
                propertyNames.add(geometryName);
                ArrayList<Feature> list = DataStoreUtil.getFeatures(ds, gb, FilterBuilder.createEqualsFilter(attributeName, compareValue), propertyNames, 1, true);
                if (list.size() >= 1) {
                    Feature f = list.get(0);
                    wkt = DataStoreUtil.selecteerKaartObjectWkt(f);
                }
            }
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
        return wkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getArea(String elementId, String themaId, String attributeName, String compareValue, String eenheid) throws SQLException {
        HttpServletRequest request;
        Session sess = null;
        double area = 0.0;
        HttpServletRequest returnValue = new HttpServletRequest[]{elementId, "Fout (zie log)"};
        try {
            sess = HibernateUtil.getSessionFactory().getCurrentSession();
            sess.beginTransaction();
            WebContext ctx = WebContextFactory.get();
            request = ctx.getHttpServletRequest();
            Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)new Integer(themaId));
            Bron b = gb.getBron(request);
            if (b == null) {
                HttpServletRequest httpServletRequest = returnValue;
                return httpServletRequest;
            }
            DataStore ds = b.toDatastore();
            try {
                ArrayList<Feature> list = DataStoreUtil.getFeatures(ds, gb, FilterBuilder.createEqualsFilter(attributeName, compareValue), null, 1, true);
                if (list.size() >= 1) {
                    Feature f = list.get(0);
                    area = ((Geometry)f.getDefaultGeometryProperty().getValue()).getArea();
                }
            }
            finally {
                ds.dispose();
            }
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            request = returnValue;
            return request;
        }
        finally {
            sess.close();
        }
        if (eenheid != null && eenheid.equals("null")) {
            eenheid = null;
        }
        int divide = 0;
        if (eenheid != null) {
            if (eenheid.equalsIgnoreCase("km")) {
                divide = 1000000;
            } else if (eenheid.equalsIgnoreCase("hm")) {
                divide = 10000;
            }
        }
        if (area > 0.0) {
            if (divide > 0) {
                area /= (double)divide;
            }
            area *= 100.0;
            area = Math.round(area);
            area /= 100.0;
        }
        String value = "" + area;
        value = eenheid != null ? value + " " + eenheid : value + " m";
        returnValue[1] = value;
        return returnValue;
    }

    public String zendMelding(String wkt, String tekst) throws Exception {
        if (wkt == null || wkt.length() == 0 || tekst == null || tekst.length() == 0) {
            return null;
        }
        Geometry geom = DataStoreUtil.createGeomFromWKTString(wkt);
        Point p = geom.getCentroid();
        String message = "<p>Een bericht met de inhoud \"";
        message = message + tekst;
        message = message + "\" voor locatie met RD-coordinaten (";
        message = message + (int)p.getX();
        message = message + ",";
        message = message + (int)p.getY();
        message = message + ") is verzonden naar de beheerder.<p>";
        long now = new Date().getTime();
        message = message + "<p>Uw referentienummer is: \"" + Long.toString(now, 32) + "\".<p>";
        return message;
    }

    public Map getAnalyseData(String wkt, String activeThemaIds, String extraCriterium, String appCode) throws Exception {
        HashMap<String, Map> results;
        block5: {
            if (wkt == null || wkt.length() == 0 || activeThemaIds == null || activeThemaIds.length() == 0) {
                return null;
            }
            Geometry geom = DataStoreUtil.createGeomFromWKTString(wkt);
            String[] themaIds = activeThemaIds.split(",");
            if (themaIds == null || themaIds.length == 0) {
                return null;
            }
            results = new HashMap<String, Map>();
            WebContext ctx = WebContextFactory.get();
            HttpServletRequest request = ctx.getHttpServletRequest();
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            Transaction tx = null;
            try {
                tx = sess.beginTransaction();
                for (int i = 0; i < themaIds.length; ++i) {
                    Map themaAnalyseData;
                    Bron b;
                    Themas t;
                    Integer id = FormUtils.StringToInteger((String)themaIds[i].trim());
                    if (id == null || (t = (Themas)sess.get(Themas.class, (Serializable)id)) == null || (b = t.getConnectie(request)) == null || (themaAnalyseData = this.calcThemaAnalyseData(b, t, extraCriterium, geom, appCode)) == null) continue;
                    themaAnalyseData = this.formatResults(themaAnalyseData);
                    results.put(t.getNaam(), themaAnalyseData);
                }
                tx.commit();
            }
            catch (Exception e) {
                log.error((Object)("Fout tijdens analyse:" + e));
                if (tx == null || !tx.isActive()) break block5;
                tx.rollback();
            }
        }
        return results;
    }

    private double roundOneDigit(double val) {
        return (double)Math.round(10.0 * val) / 10.0;
    }

    private Map formatResults(Map results) {
        String themaName = (String)results.get("themaName") + ": ";
        results.remove("themaName");
        String eenheid = " [m2]";
        double analyseFactor = 1.0;
        if (results.get("sumPolygon") != null) {
            double sumPolygon = (Double)results.get("sumPolygon");
            sumPolygon = this.roundOneDigit(sumPolygon / analyseFactor);
            results.put("sumPolygonFormatted", "Totaal oppervlak " + themaName + Double.toString(sumPolygon) + eenheid);
            results.remove("sumPolygon");
        }
        if (results.get("maxPolygon") != null) {
            double maxPolygon = (Double)results.get("maxPolygon");
            maxPolygon = this.roundOneDigit(maxPolygon / analyseFactor);
            results.put("maxPolygonFormatted", "Grootst oppervlak " + themaName + Double.toString(maxPolygon) + eenheid);
            results.remove("maxPolygon");
        }
        if (results.get("minPolygon") != null) {
            double minPolygon = (Double)results.get("minPolygon");
            minPolygon = this.roundOneDigit(minPolygon / analyseFactor);
            results.put("minPolygonFormatted", "Kleinst oppervlak " + themaName + Double.toString(minPolygon) + eenheid);
            results.remove("minPolygon");
        }
        if (results.get("avgPolygon") != null) {
            double avgPolygon = (Double)results.get("avgPolygon");
            avgPolygon = this.roundOneDigit(avgPolygon / analyseFactor);
            results.put("avgPolygonFormatted", "Gemiddeld oppervlak " + themaName + Double.toString(avgPolygon) + eenheid);
            results.remove("avgPolygon");
        }
        eenheid = " [m]";
        analyseFactor = 1.0;
        if (results.get("sumLineString") != null) {
            double sumLineString = (Double)results.get("sumLineString");
            sumLineString = this.roundOneDigit(sumLineString / analyseFactor);
            results.put("sumLineStringFormatted", "Totale lengte " + themaName + Double.toString(sumLineString) + eenheid);
            results.remove("sumLineString");
        }
        if (results.get("maxLineString") != null) {
            double maxLineString = (Double)results.get("maxLineString");
            maxLineString = this.roundOneDigit(maxLineString / analyseFactor);
            results.put("maxLineStringFormatted", "Grootste lengte " + themaName + Double.toString(maxLineString) + eenheid);
            results.remove("maxLineString");
        }
        if (results.get("minLineString") != null) {
            double minLineString = (Double)results.get("minLineString");
            minLineString = this.roundOneDigit(minLineString / analyseFactor);
            results.put("minLineStringFormatted", "Kleinste lengte " + themaName + Double.toString(minLineString) + eenheid);
            results.remove("minLineString");
        }
        if (results.get("avgLineString") != null) {
            double avgLineString = (Double)results.get("avgLineString");
            avgLineString = this.roundOneDigit(avgLineString / analyseFactor);
            results.put("avgLineStringFormatted", "Gemiddelde lengte " + themaName + Double.toString(avgLineString) + eenheid);
            results.remove("avgLineString");
        }
        eenheid = " []";
        analyseFactor = 1.0;
        if (results.get("countPolygon") != null) {
            int countPolygon = (Integer)results.get("countPolygon");
            results.put("countPolygonFormatted", "Aantal vlakken " + themaName + Integer.toString(countPolygon) + eenheid);
            results.remove("countPolygon");
        }
        if (results.get("countLineString") != null) {
            int countLineString = (Integer)results.get("countLineString");
            results.put("countLineStringFormatted", "Aantal lijnen " + themaName + Integer.toString(countLineString) + eenheid);
            results.remove("countLineString");
        }
        if (results.get("countPoint") != null) {
            int countPoint = (Integer)results.get("countPoint");
            results.put("countPointFormatted", "Aantal punten" + themaName + Integer.toString(countPoint) + eenheid);
            results.remove("countPoint");
        }
        if (results.get("countUnknownBinding") != null) {
            int countUnknownBinding = (Integer)results.get("countUnknownBinding");
            results.put("countUnknownBindingFormatted", "Aantal onbekende objecten " + themaName + Integer.toString(countUnknownBinding) + eenheid);
            results.remove("countUnknownBinding");
        }
        return results;
    }

    private Map calcThemaAnalyseData(Bron b, Themas t, String extraCriterium, Geometry analyseGeometry, String appCode) throws Exception {
        Gegevensbron gb = t.getGegevensbron();
        Filter extraFilter = null;
        if (extraCriterium != null && extraCriterium.length() != 0) {
            List<ThemaData> thema_items = SpatialUtil.getThemaData(gb, true);
            extraFilter = GetLocationData.calculateExtraFilter(thema_items, extraCriterium);
        }
        return this.calcThemaAnalyseData(b, t, extraFilter, analyseGeometry, appCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map calcThemaAnalyseData(Bron b, Themas t, Filter extraFilter, Geometry analyseGeometry, String appCode) throws Exception {
        DataStore ds = b.toDatastore();
        try {
            Gegevensbron gb = t.getGegevensbron();
            Integer maximum = ConfigKeeper.getMaxNumberOfFeatures(appCode);
            ArrayList<Feature> features = DataStoreUtil.getFeatures(b, gb, analyseGeometry, extraFilter, null, maximum, true);
            if (features == null || features.isEmpty()) {
                Map map = null;
                return map;
            }
            GeometryType tgt = DataStoreUtil.getGeometryType((Feature)features.get(0));
            Class binding = tgt.getBinding();
            double sumPolygon = 0.0;
            double sumLineString = 0.0;
            double maxPolygon = 0.0;
            double maxLineString = 0.0;
            double minPolygon = 0.0;
            double minLineString = 0.0;
            double avgPolygon = 0.0;
            double avgLineString = 0.0;
            int countPolygon = 0;
            int countLineString = 0;
            int countPoint = 0;
            int countUnknownBinding = 0;
            for (Feature f : features) {
                Geometry geom = (Geometry)f.getDefaultGeometryProperty().getValue();
                if (geom == null) continue;
                double thisArea = geom.getArea();
                double thisLength = geom.getLength();
                int thisCount = geom.getNumGeometries();
                if (binding == Polygon.class || binding == MultiPolygon.class) {
                    if (thisArea > maxPolygon) {
                        maxPolygon = thisArea;
                    }
                    if (thisArea < minPolygon || minPolygon <= 0.0) {
                        minPolygon = thisArea;
                    }
                    sumPolygon += thisArea;
                    countPolygon += thisCount;
                    continue;
                }
                if (binding == LineString.class || binding == MultiLineString.class) {
                    if (thisLength > maxLineString) {
                        maxLineString = thisLength;
                    }
                    if (thisLength < minLineString || minLineString <= 0.0) {
                        minLineString = thisLength;
                    }
                    sumLineString += thisLength;
                    countLineString += thisCount;
                    continue;
                }
                if (binding == Point.class || binding == MultiPoint.class) {
                    countPoint += thisCount;
                    continue;
                }
                countUnknownBinding += thisCount;
            }
            if (countPolygon > 0) {
                avgPolygon = sumPolygon / (double)countPolygon;
            }
            if (countLineString > 0) {
                avgLineString = sumLineString / (double)countLineString;
            }
            HashMap<String, Object> featureResults = new HashMap<String, Object>();
            featureResults.put("themaName", t.getNaam());
            if (binding == Polygon.class || binding == MultiPolygon.class) {
                featureResults.put("sumPolygon", sumPolygon);
                featureResults.put("maxPolygon", maxPolygon);
                featureResults.put("minPolygon", minPolygon);
                featureResults.put("avgPolygon", avgPolygon);
                featureResults.put("countPolygon", countPolygon);
            } else if (binding == LineString.class || binding == MultiLineString.class) {
                featureResults.put("sumLineString", sumLineString);
                featureResults.put("maxLineString", maxLineString);
                featureResults.put("minLineString", minLineString);
                featureResults.put("avgLineString", avgLineString);
                featureResults.put("countLineString", countLineString);
            } else if (binding == Point.class || binding == MultiPoint.class) {
                featureResults.put("countPoint", countPoint);
            } else {
                featureResults.put("countUnknownBinding", countUnknownBinding);
            }
            HashMap<String, Object> hashMap = featureResults;
            return hashMap;
        }
        finally {
            ds.dispose();
        }
    }

    public static Filter calculateExtraFilter(List thema_items, String extraCriterium) {
        ArrayList<Or> andFilters = new ArrayList<Or>();
        if (thema_items != null && thema_items.size() > 0 && extraCriterium != null && extraCriterium.length() > 0) {
            extraCriterium = extraCriterium.replaceAll("\\'", "''");
            Iterator it = thema_items.iterator();
            ArrayList<Filter> filters = new ArrayList<Filter>();
            while (it.hasNext()) {
                ThemaData td = (ThemaData)it.next();
                Filter f = FilterBuilder.createLikeFilter(DataStoreUtil.convertColumnNameToQName(td.getKolomnaam()).getLocalPart(), '%' + extraCriterium + '%');
                if (f == null) continue;
                filters.add(f);
            }
            Or f = FilterBuilder.getFactory().or(filters);
            if (f != null) {
                andFilters.add(f);
            }
        }
        if (andFilters.isEmpty()) {
            return null;
        }
        if (andFilters.size() == 1) {
            return (Filter)andFilters.get(0);
        }
        return FilterBuilder.getFactory().and(andFilters);
    }

    public String[] getLatLonForRDPoint(String centerWkt, String minWkt, String maxWkt) {
        String[] llSpnParams = new String[4];
        Point centerPoint = this.convertWktToLatLonPoint(centerWkt);
        Point southWestPoint = this.convertWktToLatLonPoint(minWkt);
        Point northEastPoint = this.convertWktToLatLonPoint(maxWkt);
        double spnLat = northEastPoint.getX() - southWestPoint.getX();
        double spnLon = northEastPoint.getY() - southWestPoint.getY();
        llSpnParams[0] = Double.toString(centerPoint.getX());
        llSpnParams[1] = Double.toString(centerPoint.getY());
        llSpnParams[2] = Double.toString(spnLat);
        llSpnParams[3] = Double.toString(spnLon);
        return llSpnParams;
    }

    public String[] getLatLonForGoogleDirections(String destWkt) {
        String[] llParams = new String[4];
        Geometry startGeom = this.getStartLocation();
        if (startGeom != null) {
            Point start = this.convertWktToLatLonPoint(startGeom.toText());
            llParams[0] = Double.toString(start.getX());
            llParams[1] = Double.toString(start.getY());
        } else {
            llParams[0] = "";
            llParams[1] = "";
        }
        Point centerPoint = this.convertWktToLatLonPoint(destWkt);
        llParams[2] = Double.toString(centerPoint.getX());
        llParams[3] = Double.toString(centerPoint.getY());
        return llParams;
    }

    private Geometry getStartLocation() {
        HttpSession session;
        A11YResult a11yResult;
        Geometry startGeom = null;
        WebContext ctx = WebContextFactory.get();
        HttpServletRequest request = null;
        if (ctx != null) {
            request = ctx.getHttpServletRequest();
        }
        if ((a11yResult = (A11YResult)(session = request.getSession(true)).getAttribute("a11yResult")) != null && a11yResult.getStartWkt() != null) {
            startGeom = this.createGeomFromWkt(a11yResult.getStartWkt());
        }
        return startGeom;
    }

    private Geometry createGeomFromWkt(String wkt) {
        WKTReader wktreader = new WKTReader(new GeometryFactory(new PrecisionModel(), 28992));
        Geometry geom = null;
        try {
            geom = wktreader.read(wkt);
        }
        catch (Exception e) {
            log.error((Object)"Fout bij parsen wkt geometry", (Throwable)e);
        }
        return geom;
    }

    private Point convertWktToLatLonPoint(String wkt) {
        Point p = null;
        try {
            Geometry targetGeometry;
            CoordinateReferenceSystem targetCRS;
            CoordinateReferenceSystem sourceCRS;
            MathTransform transform;
            Geometry sourceGeometry = DataStoreUtil.createGeomFromWKTString(wkt);
            if (sourceGeometry != null && (transform = CRS.findMathTransform((CoordinateReferenceSystem)(sourceCRS = CRS.decode((String)"EPSG:28992")), (CoordinateReferenceSystem)(targetCRS = CRS.decode((String)"EPSG:4326")), (boolean)true)) != null && (targetGeometry = JTS.transform((Geometry)sourceGeometry, (MathTransform)transform)) != null) {
                targetGeometry.setSRID(4326);
                p = targetGeometry.getCentroid();
            }
        }
        catch (Exception ex) {
            log.error((Object)("Fout tijdens conversie wkt naar latlon: " + ex));
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] setAttributeValue(String elementId, String themaId, String keyName, String keyValue, String attributeName, String oldValue, String newValue) {
        String[] returnValue;
        block19: {
            returnValue = new String[2];
            Transaction transaction = null;
            try {
                returnValue[0] = elementId;
                returnValue[1] = oldValue + " (fout)";
                Integer id = FormUtils.StringToInteger((String)themaId);
                int keyValueInt = FormUtils.StringToInt((String)keyValue);
                if (id == null || keyValueInt == 0) {
                    return returnValue;
                }
                Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
                transaction = sess.beginTransaction();
                Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)id);
                if (gb == null) {
                    return returnValue;
                }
                WebContext ctx = WebContextFactory.get();
                HttpServletRequest request = ctx.getHttpServletRequest();
                Bron b = gb.getBron(request);
                if (b == null) {
                    return returnValue;
                }
                if (b.checkType("jdbc")) {
                    Connection conn = DriverManager.getConnection(b.getUrl(), b.getGebruikersnaam(), b.getWachtwoord());
                    String tableName = gb.getAdmin_tabel();
                    try {
                        String retVal = SpatialUtil.setAttributeValue(conn, tableName, keyName, keyValueInt, attributeName, newValue);
                        if (retVal != null) {
                            returnValue[1] = retVal;
                        }
                        break block19;
                    }
                    catch (SQLException ex) {
                        log.error((Object)"", (Throwable)ex);
                        break block19;
                    }
                    finally {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException ex) {
                                log.error((Object)"", (Throwable)ex);
                            }
                        }
                    }
                }
                log.error((Object)("Incorrecte bron: " + gb.getBron().getNaam()), (Throwable)new UnsupportedOperationException("Function only supports jdbc connections"));
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return returnValue;
    }

    public String[] getData(String x_input, String y_input, String[] cols, int themaId, double distance, int srid) throws SQLException {
        String[] results = new String[cols.length + 3];
        return new String[]{"Fout bij laden van data. Functie nog niet omgezet"};
    }

    public String getKaartlaagInfoTekst(Integer themaId) {
        String infoTekst;
        block4: {
            if (themaId == null || themaId < 1) {
                return null;
            }
            infoTekst = null;
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            Transaction tx = null;
            try {
                tx = sess.beginTransaction();
                Themas thema = (Themas)sess.get(Themas.class, (Serializable)themaId);
                if (thema != null) {
                    infoTekst = thema.getInfo_tekst();
                }
                tx.commit();
            }
            catch (Exception e) {
                log.error((Object)"Fout tijdens ophalen Kaartlaag info tekst: ", (Throwable)e);
                if (tx == null || !tx.isActive()) break block4;
                tx.rollback();
            }
        }
        return infoTekst;
    }
}

