/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.gis.viewer.PrintAction;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.imagetool.CombineImageSettings;
import nl.b3p.imagetool.CombineImagesHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;

public class ImageAction
extends PrintAction {
    private static final Log logFile = LogFactory.getLog(ImageAction.class);
    private static int maxResponseTime = 30000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward image(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String username = null;
        String password = null;
        GisPrincipal gp = GisPrincipal.getGisPrincipal(request);
        if (gp != null) {
            username = gp.getName();
            password = gp.getPassword();
        }
        Double minx = new Double(request.getParameter("minx"));
        Double miny = new Double(request.getParameter("miny"));
        Double maxx = new Double(request.getParameter("maxx"));
        Double maxy = new Double(request.getParameter("maxy"));
        minx = minx - 30.0;
        miny = miny - 30.0;
        maxx = maxx + 30.0;
        maxy = maxy + 30.0;
        String bbox = minx.toString() + "," + miny.toString() + "," + maxx.toString() + "," + maxy.toString();
        CombineImageSettings settings = null;
        String imageId = request.getParameter("imageId");
        if (imageId != null && request.getSession().getAttribute(imageId) != null) {
            settings = (CombineImageSettings)request.getSession().getAttribute(imageId);
            response.setContentType(settings.getMimeType());
            response.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
            String keepAlive = request.getParameter("keepAlive");
            if (keepAlive == null || keepAlive.length() == 0) {
                request.getSession().removeAttribute(imageId);
            }
        }
        if (settings == null) {
            logFile.error((Object)"No settings for image found");
            this.addAlternateMessage(mapping, request, null, "No settings for image found");
            return this.getAlternateForward(mapping, request);
        }
        settings.setHeight(Integer.valueOf(300));
        settings.setWidth(Integer.valueOf(300));
        settings.setBbox(bbox);
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
            CombineImagesHandler.combineImage((OutputStream)response.getOutputStream(), (CombineImageSettings)settings, (String)settings.getMimeType(), (int)maxResponseTime, (String)username, (String)password);
        }
        finally {
            os.close();
        }
        return null;
    }
}

