/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.OutputStream;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.combineimages.CombineImagesServlet;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.gis.viewer.print.PrintInfo;
import nl.b3p.gis.viewer.print.PrintServlet;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.struts.BaseHibernateAction;
import nl.b3p.imagetool.CombineImageSettings;
import nl.b3p.imagetool.CombineImagesHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONObject;

public class PrintAction
extends BaseHibernateAction {
    private static final Log logFile = LogFactory.getLog(PrintAction.class);
    protected static final String PRINT = "print";
    protected static final String IMAGE = "image";
    private static final String METADATA_TITLE = "Kaartexport B3P Gisviewer";
    private static final String METADATA_AUTHOR = "B3P Gisviewer";
    private static final String OUTPUT_PDF_PRINT = "PDF_PRINT";
    private static final String OUTPUT_PDF = "PDF";
    private static final String OUTPUT_RTF = "RTF";
    private static final int MAXSIZE = 2048;
    private static String logoPath = null;
    private static String extraImagePath = null;
    private static String disclaimer = null;
    private static SimpleDateFormat sdf = new SimpleDateFormat("dd-MMMM-yyyy", new Locale("NL"));
    private static float footerHeight = 25.0f;
    private static boolean addFooter = true;
    private static int maxResponseTime = 30000;
    private static Integer DEFAULT_PPI = 72;

    protected Map getActionMethodPropertiesMap() {
        HashMap<String, ExtendedMethodProperties> map = new HashMap<String, ExtendedMethodProperties>();
        ExtendedMethodProperties hibProp = new ExtendedMethodProperties(PRINT);
        hibProp.setDefaultForwardName("success");
        hibProp.setAlternateForwardName("failure");
        map.put(PRINT, hibProp);
        hibProp = new ExtendedMethodProperties(IMAGE);
        hibProp.setDefaultForwardName("success");
        hibProp.setAlternateForwardName("failure");
        map.put(IMAGE, hibProp);
        return map;
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CombineImageSettings settings = PrintAction.getCombineImageSettings(request);
        String imageId = CombineImagesServlet.uniqueName((String)"");
        request.getSession().setAttribute(imageId, (Object)settings);
        dynaForm.set("imageId", (Object)imageId);
        request.getSession().setAttribute("legendItems", (Object)settings.getLegendMap());
        Integer currentScale = this.calcCurrentScale(settings);
        dynaForm.set("scale", (Object)currentScale);
        return mapping.findForward("success");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward image(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String username = null;
        String password = null;
        GisPrincipal gp = GisPrincipal.getGisPrincipal(request);
        if (gp != null) {
            username = gp.getName();
            password = gp.getPassword();
        }
        CombineImageSettings settings = null;
        String imageId = request.getParameter("imageId");
        if (imageId != null && request.getSession().getAttribute(imageId) != null) {
            settings = (CombineImageSettings)request.getSession().getAttribute(imageId);
            response.setContentType(settings.getMimeType());
            response.setHeader("Content-Disposition", "attachment; filename=\"printvoorbeeld.png\";");
            response.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
            String keepAlive = request.getParameter("keepAlive");
            if (keepAlive == null || keepAlive.length() == 0) {
                request.getSession().removeAttribute(imageId);
            }
        }
        if (settings == null) {
            logFile.error((Object)"No settings for image found");
            this.addAlternateMessage(mapping, request, null, "No settings for image found");
            return this.getAlternateForward(mapping, request);
        }
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
            CombineImagesHandler.combineImage((OutputStream)response.getOutputStream(), (CombineImageSettings)settings, (String)settings.getMimeType(), (int)maxResponseTime, (String)username, (String)password);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
        return null;
    }

    private Integer calcCurrentScale(CombineImageSettings settings) {
        Double newMapWidth = settings.getBbox().getMaxx() - settings.getBbox().getMinx();
        Double scale = newMapWidth / ((double)settings.getWidth().intValue() * 2.8E-4);
        return scale.intValue();
    }

    private String calculateBboxForScale(CombineImageSettings settings, Integer scale) {
        Integer mapWidth = settings.getWidth();
        Integer mapHeight = settings.getHeight();
        Double newMapWidth = Math.ceil((double)scale.intValue() * ((double)mapWidth.intValue() * 2.8E-4));
        Double newMapHeight = Math.ceil((double)scale.intValue() * ((double)mapHeight.intValue() * 2.8E-4));
        double minx = settings.getBbox().getMinx();
        double miny = settings.getBbox().getMiny();
        double maxx = settings.getBbox().getMaxx();
        double maxy = settings.getBbox().getMaxy();
        double centerX = (maxx - minx) / 2.0 + minx;
        double centerY = (maxy - miny) / 2.0 + miny;
        String newMinX = Double.toString(centerX - newMapWidth / 2.0);
        String newMaxX = Double.toString(centerX + newMapWidth / 2.0);
        String newMinY = Double.toString(centerY - newMapHeight / 2.0);
        String newMaxY = Double.toString(centerY + newMapHeight / 2.0);
        return newMinX + "," + newMinY + "," + newMaxX + "," + newMaxY;
    }

    private float calcPixelSizeForResolution(Integer ppi) {
        float ratio = 1.0f / (float)ppi.intValue();
        float pixelSize = ratio * 25.4f;
        return pixelSize / 1000.0f;
    }

    private Double convertPaperFormatToInches(String format, boolean landscape) {
        Double oneMmInchUnit = 0.0394;
        if (format.equals("A0") && !landscape) {
            return 841.0 * oneMmInchUnit;
        }
        if (format.equals("A0") && landscape) {
            return 1189.0 * oneMmInchUnit;
        }
        if (format.equals("A1") && !landscape) {
            return 594.0 * oneMmInchUnit;
        }
        if (format.equals("A1") && landscape) {
            return 841.0 * oneMmInchUnit;
        }
        if (format.equals("A2") && !landscape) {
            return 420.0 * oneMmInchUnit;
        }
        if (format.equals("A2") && landscape) {
            return 594.0 * oneMmInchUnit;
        }
        if (format.equals("A3") && !landscape) {
            return 297.0 * oneMmInchUnit;
        }
        if (format.equals("A3") && landscape) {
            return 420.0 * oneMmInchUnit;
        }
        if (format.equals("A4") && !landscape) {
            return 210.0 * oneMmInchUnit;
        }
        if (format.equals("A4") && landscape) {
            return 297.0 * oneMmInchUnit;
        }
        return null;
    }

    private Integer calcNewMapWidthFromPPI(Integer ppi, Double paperWidthInInches) {
        Double w = Math.ceil((double)ppi.intValue() * paperWidthInInches);
        return w.intValue();
    }

    private Integer calcScaleForHigherPPI(Integer ppi, Integer mapWidthInMeters, Double paperWidthInInches) {
        float pixelSize = this.calcPixelSizeForResolution(ppi);
        Integer newMapWidth = this.calcNewMapWidthFromPPI(ppi, paperWidthInInches);
        Double schaal = Math.ceil((float)mapWidthInMeters.intValue() / ((float)newMapWidth.intValue() * pixelSize));
        return schaal.intValue();
    }

    public ActionForward print(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String title = FormUtils.nullIfEmpty((String)dynaForm.getString("title"));
        String imageId = FormUtils.nullIfEmpty((String)dynaForm.getString("imageId"));
        String imageSize = FormUtils.nullIfEmpty((String)dynaForm.getString("imageSize"));
        String pageSize = FormUtils.nullIfEmpty((String)dynaForm.getString("pageSize"));
        boolean landscape = Boolean.valueOf(dynaForm.getString("landscape"));
        String outputType = FormUtils.nullIfEmpty((String)dynaForm.getString("outputType"));
        String remark = FormUtils.nullIfEmpty((String)dynaForm.getString("remark"));
        Object strPPI = dynaForm.get("ppi");
        Integer PPI = DEFAULT_PPI;
        if (strPPI != null) {
            PPI = (Integer)strPPI;
        }
        Principal user = request.getUserPrincipal();
        GisPrincipal gp = (GisPrincipal)user;
        String organizationcode = gp.getSp().getOrganizationCode();
        CombineImageSettings originalSettings = (CombineImageSettings)request.getSession().getAttribute(imageId);
        CombineImageSettings settings = CombineImageSettings.fromJson((JSONObject)originalSettings.getOriginalJSON());
        settings.setLegendMap(originalSettings.getLegendMap());
        String bbox = "";
        if (settings.getBbox() != null) {
            String minx = Double.toString(settings.getBbox().getMinx());
            String miny = Double.toString(settings.getBbox().getMiny());
            String maxx = Double.toString(settings.getBbox().getMaxx());
            String maxy = Double.toString(settings.getBbox().getMaxy());
            bbox = minx + "," + miny + "," + maxx + "," + maxy;
        }
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat("d MMMMM yyyy", new Locale("NL"));
        String imageUrl = this.createImageUrl(request);
        String template = landscape && pageSize.equals("A4") ? PrintServlet.xsl_A4_Liggend : (!landscape && pageSize.equals("A4") ? PrintServlet.xsl_A4_Staand : (landscape && pageSize.equals("A3") ? PrintServlet.xsl_A3_Liggend : (!landscape && pageSize.equals("A3") ? PrintServlet.xsl_A3_Staand : (landscape && pageSize.equals("A2") ? PrintServlet.xsl_A2_Liggend : (!landscape && pageSize.equals("A2") ? PrintServlet.xsl_A2_Staand : (landscape && pageSize.equals("A1") ? PrintServlet.xsl_A1_Liggend : (!landscape && pageSize.equals("A1") ? PrintServlet.xsl_A1_Staand : (landscape && pageSize.equals("A0") ? PrintServlet.xsl_A0_Liggend : (!landscape && pageSize.equals("A0") ? PrintServlet.xsl_A0_Staand : PrintServlet.xsl_A4_Liggend)))))))));
        PrintInfo info = new PrintInfo();
        info.setTitel(title);
        info.setDatum(df.format(now));
        info.setImageUrl(imageUrl);
        info.setBbox(bbox);
        info.setOpmerking(remark);
        info.setOrganizationcode(organizationcode);
        Integer currentScale = this.calcCurrentScale(settings);
        String oldBBox = this.calculateBboxForScale(settings, currentScale);
        Integer newScale = (Integer)dynaForm.get("scale");
        if (newScale != null && newScale > 0) {
            String newBbox = this.calculateBboxForScale(settings, newScale);
            info.setBbox(newBbox);
            settings.setBbox(newBbox);
            info.setScale(newScale);
        }
        Double paperInches = this.convertPaperFormatToInches(pageSize, landscape);
        Integer newWidthPx = this.calcNewMapWidthFromPPI(PPI, paperInches);
        info.setKwaliteit(newWidthPx);
        HashMap<String, String> legendItemsMap = new HashMap<String, String>();
        String[] arr = (String[])dynaForm.get("legendItems");
        if (arr != null && arr.length > 0) {
            for (int i = 0; i < arr.length; ++i) {
                String key = arr[i];
                if (settings.getLegendMap() == null || !settings.getLegendMap().containsKey(key)) continue;
                String url = (String)settings.getLegendMap().get(key);
                legendItemsMap.put(key, url);
            }
        }
        info.setLegendItems(legendItemsMap);
        String scaleColumnOne = request.getParameter("scaleColumnOne");
        String scaleColumnTwo = request.getParameter("scaleColumnTwo");
        String scaleColumnThree = request.getParameter("scaleColumnThree");
        String titleColumnOne = request.getParameter("titleColumnOne");
        String titleColumnTwo = request.getParameter("titleColumnTwo");
        String titleColumnThree = request.getParameter("titleColumnThree");
        if (scaleColumnOne != null && scaleColumnOne.equalsIgnoreCase("on")) {
            info.setScaleColumnOne("on");
        }
        if (scaleColumnTwo != null && scaleColumnTwo.equalsIgnoreCase("on")) {
            info.setScaleColumnTwo("on");
        }
        if (scaleColumnThree != null && scaleColumnThree.equalsIgnoreCase("on")) {
            info.setScaleColumnThree("on");
        }
        if (titleColumnOne != null && titleColumnOne.equalsIgnoreCase("on")) {
            info.setTitleColumnOne("on");
        }
        if (titleColumnTwo != null && titleColumnTwo.equalsIgnoreCase("on")) {
            info.setTitleColumnTwo("on");
        }
        if (titleColumnThree != null && titleColumnThree.equalsIgnoreCase("on")) {
            info.setTitleColumnThree("on");
        }
        HashMap<String, String> legendItemsOne = new HashMap<String, String>();
        HashMap<String, String> legendItemsTwo = new HashMap<String, String>();
        HashMap<String, String> legendItemsThree = new HashMap<String, String>();
        for (Map.Entry entry : settings.getLegendMap().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String formValue = request.getParameter(key);
            Integer column = 0;
            if (formValue != null && !formValue.equals("")) {
                column = new Integer(formValue);
            }
            if (column == 1) {
                legendItemsOne.put(key, value);
            }
            if (column == 2) {
                legendItemsTwo.put(key, value);
            }
            if (column != 3) continue;
            legendItemsThree.put(key, value);
        }
        info.setColumnOneItems(legendItemsOne);
        info.setColumnTwoItems(legendItemsTwo);
        info.setColumnThreeItems(legendItemsThree);
        String mimeType = outputType != null && outputType.equals(OUTPUT_PDF) || outputType.equals(OUTPUT_PDF_PRINT) ? "application/pdf" : (outputType != null && outputType.equals(OUTPUT_RTF) ? "application/rtf" : "application/pdf");
        boolean addJavascript = false;
        if (outputType.equals(OUTPUT_PDF_PRINT)) {
            addJavascript = true;
        }
        logFile.debug((Object)("Print url: " + info.getImageUrl()));
        PrintServlet.setSettings(settings);
        PrintServlet.createOutput(info, mimeType, template, addJavascript, response);
        return null;
    }

    private String createImageUrl(HttpServletRequest request) {
        if (PrintServlet.baseImageUrl != null) {
            return PrintServlet.baseImageUrl;
        }
        String requestUrl = request.getRequestURL().toString();
        int lastIndex = requestUrl.lastIndexOf("/");
        String basePart = requestUrl.substring(0, lastIndex);
        String servletPart = "/services/PrintServlet?";
        return basePart + servletPart;
    }

    public static CombineImageSettings getCombineImageSettings(HttpServletRequest request) throws Exception {
        String mimeType;
        String jsonSettingsParam = FormUtils.nullIfEmpty((String)request.getParameter("jsonSettings"));
        String legendUrls = FormUtils.nullIfEmpty((String)request.getParameter("legendUrls"));
        JSONObject jsonSettings = new JSONObject(jsonSettingsParam);
        CombineImageSettings settings = CombineImageSettings.fromJson((JSONObject)jsonSettings);
        HashMap<String, String> legendMap = new HashMap<String, String>();
        if (legendUrls != null) {
            logFile.debug((Object)("legendUrls: " + legendUrls));
            String[] arr = legendUrls.split(";");
            for (int i = 0; i < arr.length; ++i) {
                String[] legendUrlsArr = arr[i].split("#");
                legendMap.put(legendUrlsArr[0], legendUrlsArr[1]);
            }
            settings.setLegendMap(legendMap);
        }
        if ((mimeType = FormUtils.nullIfEmpty((String)request.getParameter("FORMAT"))) != null && !mimeType.equals("")) {
            settings.setMimeType(mimeType);
        }
        return settings;
    }
}

