/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.downloads;

import java.util.ArrayList;
import java.util.List;
import nl.b3p.gis.viewer.downloads.DownloadThread;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Dispatcher
extends Thread {
    private final Log log = LogFactory.getLog(this.getClass());
    protected boolean dispatcherActive = false;
    private final List queue = new ArrayList();
    protected static int tcount = 0;
    protected long dispatcherSleepTime = 20000L;
    protected int maxAliveThreads = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCall(DownloadThread call) {
        List list = this.queue;
        synchronized (list) {
            this.queue.add(call);
            this.queue.notifyAll();
        }
    }

    public Dispatcher(boolean isDaemon, int priority, boolean autoStart) {
        this(null, isDaemon, priority, autoStart);
    }

    public Dispatcher(ThreadGroup tg, boolean isDaemon, int priority, boolean autoStart) {
        super(tg, "Dispatcher");
        this.setDaemon(isDaemon);
        this.setPriority(priority);
        this.setDispatcherActive(true);
        if (autoStart) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isDispatcherActive()) {
            List list = this.queue;
            synchronized (list) {
                while (this.queue.isEmpty() && this.isDispatcherActive()) {
                    this.dispatcherActive = false;
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException e) {
                        this.log.error((Object)"InterruptedException waiting for queue: ", (Throwable)e);
                    }
                    this.dispatcherActive = true;
                }
                ArrayList<DownloadThread> removedCalls = new ArrayList<DownloadThread>();
                DownloadThread call2 = null;
                block14: for (DownloadThread call2 : this.queue) {
                    switch (call2.getThreadStatus()) {
                        case 0: {
                            int activeTheads = this.getNumOfActiveCalls();
                            if (activeTheads >= this.getMaxAliveThreads()) continue block14;
                            call2.start();
                            continue block14;
                        }
                        case 2: {
                            if (call2.isAlive()) continue block14;
                            removedCalls.add(call2);
                            continue block14;
                        }
                        case 3: {
                            if (call2.isAlive()) continue block14;
                            removedCalls.add(call2);
                            continue block14;
                        }
                    }
                }
                if (!removedCalls.isEmpty()) {
                    for (DownloadThread call2 : removedCalls) {
                        if (call2.isAlive()) {
                            this.log.error((Object)"Running CallObject found that should be garbage collected!");
                            continue;
                        }
                        this.queue.remove(call2);
                        call2 = null;
                    }
                }
            }
            try {
                Dispatcher.sleep(this.getDispatcherSleepTime());
            }
            catch (InterruptedException ex) {
                this.log.error((Object)"Dispatcher thread interrupted: ", (Throwable)ex);
            }
        }
    }

    public int getNumOfActiveCalls() {
        ThreadGroup tg = this.getThreadGroup();
        if (tg == null) {
            return 0;
        }
        return tg.activeCount() - 1;
    }

    public boolean isDispatcherActive() {
        return this.dispatcherActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDispatcherActive(boolean dispatcherActive) {
        this.dispatcherActive = dispatcherActive;
        List list = this.queue;
        synchronized (list) {
            this.queue.notifyAll();
        }
    }

    public long getDispatcherSleepTime() {
        return this.dispatcherSleepTime;
    }

    public void setDispatcherSleepTime(long dispatcherSleepTime) {
        this.dispatcherSleepTime = dispatcherSleepTime;
    }

    public void setMaxAliveThreads(int maxAliveThreads) {
        this.maxAliveThreads = maxAliveThreads;
    }

    public int getMaxAliveThreads() {
        return this.maxAliveThreads;
    }

    public List getQueue() {
        return this.queue;
    }
}

