/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.csv.CsvOutputStream;
import nl.b3p.gis.geotools.DataStoreUtil;
import nl.b3p.gis.geotools.FilterBuilder;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.ThemaData;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.SpatialUtil;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Transaction;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.filter.Filter;

public class Data2CSV
extends HttpServlet {
    private static final Log log = LogFactory.getLog(Data2CSV.class);
    private static String HTMLTITLE = "Data naar CSV";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String appCode = request.getParameter("appCode");
        String gegevensbronId = request.getParameter("themaId");
        String objectIds = request.getParameter("objectIds");
        String seperator = request.getParameter("seperator");
        if (seperator == null || seperator.length() != 1) {
            seperator = ";";
        }
        char sep = seperator.charAt(0);
        CsvOutputStream cos = null;
        OutputStream out = null;
        Transaction tx = HibernateUtil.getSessionFactory().getCurrentSession().beginTransaction();
        try {
            Gegevensbron gb = SpatialUtil.getGegevensbron(gegevensbronId);
            String decoded = URLDecoder.decode(objectIds, "UTF-8");
            String[] ids = decoded.split(",");
            GisPrincipal user = GisPrincipal.getGisPrincipal(request);
            if (user == null) {
                this.writeErrorMessage(response, "Kan de data niet ophalen omdat u niet bent ingelogd.");
                return;
            }
            Bron b = gb.getBron(request);
            if (b == null) {
                throw new ServletException("Gegevensbron (id " + gb.getId() + ") Bron null.");
            }
            List data = null;
            String[] propertyNames = this.getThemaPropertyNames(gb);
            String[] columnLabels = this.getThemaLabelNames(gb);
            try {
                data = this.getData(b, gb, ids, propertyNames, appCode);
            }
            catch (Exception ex) {
                this.writeErrorMessage(response, ex.getMessage());
                log.error((Object)"Fout bij laden csv data.", (Throwable)ex);
                if (cos != null) {
                    cos.close();
                }
                HibernateUtil.getSessionFactory().getCurrentSession().close();
                if (out != null) {
                    out.close();
                }
                return;
            }
            response.setContentType("text/csv");
            response.setHeader("Content-disposition", "attachment; filename=\"" + gb.getNaam() + ".csv\";");
            out = response.getOutputStream();
            cos = new CsvOutputStream(new OutputStreamWriter(out), sep, false);
            cos.writeRecord(columnLabels);
            for (int i = 0; i < data.size(); ++i) {
                String[] row = (String[])data.get(i);
                cos.writeRecord(row);
            }
        }
        finally {
            if (cos != null) {
                cos.close();
            }
            HibernateUtil.getSessionFactory().getCurrentSession().close();
            if (out != null) {
                out.close();
            }
        }
    }

    public String[] getThemaPropertyNames(Gegevensbron gb) {
        Set themadata = gb.getThemaData();
        Iterator it = themadata.iterator();
        ArrayList<String> columns = new ArrayList<String>();
        while (it.hasNext()) {
            ThemaData td = (ThemaData)it.next();
            if (td.getKolomnaam() == null || columns.contains(td.getKolomnaam()) || td.getKolomnaam().equalsIgnoreCase("the_geom") || td.getKolomnaam().equalsIgnoreCase("geometry")) continue;
            columns.add(td.getKolomnaam());
        }
        String[] s = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            s[i] = (String)columns.get(i);
        }
        return s;
    }

    public String[] getThemaLabelNames(Gegevensbron gb) {
        Set themadata = gb.getThemaData();
        Iterator it = themadata.iterator();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> labels = new ArrayList<String>();
        while (it.hasNext()) {
            ThemaData td = (ThemaData)it.next();
            if (td.getKolomnaam() == null || columns.contains(td.getKolomnaam()) || td.getKolomnaam().equalsIgnoreCase("the_geom") || td.getKolomnaam().equalsIgnoreCase("geometry")) continue;
            columns.add(td.getKolomnaam());
            if (td.getLabel() != null) {
                labels.add(td.getLabel());
                continue;
            }
            labels.add(td.getKolomnaam());
        }
        String[] s = new String[labels.size()];
        for (int i = 0; i < labels.size(); ++i) {
            s[i] = (String)labels.get(i);
        }
        return s;
    }

    public List getData(Bron b, Gegevensbron gb, String[] pks, String[] propertyNames, String appCode) throws IOException, Exception {
        Filter filter = FilterBuilder.createOrEqualsFilter(DataStoreUtil.convertColumnNameToQName(gb.getAdmin_pk()).getLocalPart(), pks);
        List<ThemaData> items = SpatialUtil.getThemaData(gb, false);
        List<String> propnames = DataStoreUtil.themaData2PropertyNames(items);
        Integer maximum = ConfigKeeper.getMaxNumberOfFeatures(appCode);
        ArrayList<Feature> features = DataStoreUtil.getFeatures(b, gb, null, filter, propnames, maximum, false);
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (int i = 0; i < features.size(); ++i) {
            Feature f = features.get(i);
            String[] row = new String[propertyNames.length];
            for (int p = 0; p < propertyNames.length; ++p) {
                Property property = f.getProperty(propertyNames[p]);
                row[p] = property != null && property.getValue() != null && property.getValue().toString() != null ? property.getValue().toString().trim() : "";
            }
            result.add(row);
        }
        return result;
    }

    protected void writeErrorMessage(HttpServletResponse response, String message) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter pw = response.getWriter();
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title>" + HTMLTITLE + "</title>");
        pw.println("<script type=\"text/javascript\"> if(window.parent && (typeof window.parent.showCsvError == 'function')) { window.parent.showCsvError(); } </script>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<h1>Fout</h1>");
        pw.println("<h3>" + message + "</h3>");
        pw.println("</body>");
        pw.println("</html>");
    }

    private boolean themaAllowed(Themas t, GisPrincipal user) {
        List layersFromRoles = user.getLayerNames(false);
        if (layersFromRoles == null) {
            return false;
        }
        if (t.getWms_layers_real() == null) {
            return false;
        }
        String[] themaLayers = t.getWms_layers_real().split(",");
        for (int i = 0; i < themaLayers.length; ++i) {
            if (layersFromRoles.contains(themaLayers[i])) continue;
            return false;
        }
        return true;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

