/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import nl.b3p.commons.security.XmlSecurityDatabase;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.services.HttpClientConfigured;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.wms.capabilities.ServiceProvider;
import nl.b3p.wms.capabilities.WMSCapabilitiesReader;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.securityfilter.filter.SecurityRequestWrapper;
import org.securityfilter.realm.ExternalAuthenticatedRealm;
import org.securityfilter.realm.FlexibleRealmInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GisSecurityRealm
implements FlexibleRealmInterface,
ExternalAuthenticatedRealm {
    private static final Log log = LogFactory.getLog(GisSecurityRealm.class);
    private static final String FORM_USERNAME = "j_username";
    private static final String FORM_PASSWORD = "j_password";
    private static final String FORM_CODE = "j_code";
    private static final String CAPABILITIES_QUERYSTRING = "REQUEST=GetCapabilities&VERSION=1.1.1&SERVICE=WMS";
    protected static Map<String, ServiceProvider> perUserNameSPCache = new HashMap<String, ServiceProvider>();

    public Principal authenticate(SecurityRequestWrapper request) {
        String username = FormUtils.nullIfEmpty((String)request.getParameter(FORM_USERNAME));
        String password = FormUtils.nullIfEmpty((String)request.getParameter(FORM_PASSWORD));
        String code = FormUtils.nullIfEmpty((String)request.getParameter(FORM_CODE));
        HttpSession session = request.getSession();
        session.setAttribute("loginForm", (Object)true);
        return GisSecurityRealm.authenticate(username, password, code, request);
    }

    public Principal getAuthenticatedPrincipal(String username, String password) {
        return this.authenticate(username, password);
    }

    public boolean isUserInRole(Principal principal, String rolename) {
        if (principal == null) {
            return false;
        }
        boolean inRole = ((GisPrincipal)principal).isInRole(rolename);
        if (!inRole) {
            inRole = XmlSecurityDatabase.isUserInRole((String)principal.getName(), (String)rolename);
        }
        return inRole;
    }

    public static String createCapabilitiesURL(String code) {
        String url = HibernateUtil.createPersonalKbUrl(code);
        if (url.indexOf(63) == -1) {
            url = url + "?";
        }
        url = url.indexOf(63) == url.length() - 1 ? url + CAPABILITIES_QUERYSTRING : (url.lastIndexOf(38) == url.length() - 1 ? url + CAPABILITIES_QUERYSTRING : url + "&REQUEST=GetCapabilities&VERSION=1.1.1&SERVICE=WMS");
        log.debug((Object)("Using external kb url: " + url));
        return url;
    }

    public static String createInternalCapabilitiesURL(String code) {
        String url = HibernateUtil.createInternalKbUrl(code);
        if (url == null || url.equals("")) {
            url = HibernateUtil.createPersonalKbUrl(code);
        }
        if (url.indexOf(63) == -1) {
            url = url + "?";
        }
        url = url.indexOf(63) == url.length() - 1 ? url + CAPABILITIES_QUERYSTRING : (url.lastIndexOf(38) == url.length() - 1 ? url + CAPABILITIES_QUERYSTRING : url + "&REQUEST=GetCapabilities&VERSION=1.1.1&SERVICE=WMS");
        log.debug((Object)("Using internal kb url: " + url));
        return url;
    }

    protected static GisPrincipal authenticateFake(String username) {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add(HibernateUtil.GEBRUIKERS_ROL);
        roles.add(HibernateUtil.THEMABEHEERDERS_ROL);
        return new GisPrincipal(username, roles);
    }

    public static GisPrincipal authenticateHttp(String location, String username, String password, String code, SecurityRequestWrapper request) {
        boolean isConfig;
        log.debug((Object)"Start authenticateHttp()");
        WMSCapabilitiesReader wmscr = new WMSCapabilitiesReader();
        ServiceProvider sp = null;
        String key = "";
        if (username == null && code != null) {
            key = code;
        } else if (username != null && username.equals("anoniem")) {
            key = code;
        } else if (code == null && username != null) {
            key = username;
        } else if (username != null && password != null) {
            key = username;
        }
        boolean bl = isConfig = location == null ? false : location.contains("_VIEWER_CONFIG=true");
        if (key == null || key.isEmpty()) {
            return null;
        }
        if (isConfig) {
            key = key + "_VIEWER_CONFIG";
        }
        String ip = null;
        if (request != null && (ip = request.getRemoteAddr()) == null) {
            ip = request.getLocalAddr();
        }
        log.debug((Object)("Username: " + username + ", Password: ****, Code: " + code + ", Key: " + key + ", Ip: " + ip));
        if (username != null && code == null || code.isEmpty() || code.equals("") || code.equalsIgnoreCase("null")) {
            log.debug((Object)"Checking login with kaartenbalie!");
            boolean canLogin = GisSecurityRealm.canLoginKaartenbalie(username, password, ip);
            if (!canLogin) {
                log.error((Object)("Gebruiker " + username + " is ongeldig. IP-adres: " + ip));
                return null;
            }
        }
        try {
            Boolean cacheOnDisk = HibernateUtil.cacheOnDisk;
            if (cacheOnDisk != null && cacheOnDisk.booleanValue() && GisSecurityRealm.isCachedOnDisk(key)) {
                sp = GisSecurityRealm.readCacheFromDisk(key);
                log.debug((Object)("User from DISK cache " + sp.getUserName() + " using key " + key));
            }
            if (cacheOnDisk == null || !cacheOnDisk.booleanValue() && GisSecurityRealm.isInSPCache(key)) {
                sp = GisSecurityRealm.getFromSPCache(key);
                log.debug((Object)("User from MEM cache " + sp.getUserName() + " using key " + key));
            } else if (sp == null) {
                sp = wmscr.getProvider(location, username, password, ip);
                if (username != null && password != null && password.length() > 0) {
                    sp.setPassword(password);
                }
                if (cacheOnDisk != null && cacheOnDisk.booleanValue()) {
                    GisSecurityRealm.writeCacheToDisk(key, sp);
                    log.debug((Object)("Login new in DISK cache for user " + sp.getUserName() + " using key " + key));
                } else {
                    GisSecurityRealm.putInSPCache(key, sp);
                    log.debug((Object)("Login new in MEM for user " + sp.getUserName() + " using key " + key));
                }
            }
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error reading GetCapabilities ", (Throwable)ex);
            } else {
                log.error((Object)("Error reading GetCapabilities: " + ex.getLocalizedMessage()));
            }
            return null;
        }
        if (sp == null) {
            log.error((Object)"No ServiceProvider found, denying login!");
            return null;
        }
        if (sp.getPersonalCode() != null) {
            code = sp.getPersonalCode();
        }
        if (sp.getUserName() != null) {
            username = sp.getUserName();
        }
        if (username == null || username.length() < 1) {
            username = HibernateUtil.ANONYMOUS_USER;
        }
        log.debug((Object)("Login for user: " + username));
        return new GisPrincipal(username, password, code, sp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canLoginKaartenbalie(String username, String password, String ip) {
        String loginKbUrl = HibernateUtil.getKbLoginUrl();
        String kbUrl = HibernateUtil.getKbUrl();
        if (loginKbUrl == null && kbUrl != null && kbUrl.contains("/services")) {
            loginKbUrl = kbUrl;
            loginKbUrl = loginKbUrl.replaceAll("/services", "/login");
        }
        if (loginKbUrl == null || username == null || password == null || loginKbUrl.isEmpty() || username.isEmpty() || password.isEmpty()) {
            return false;
        }
        B3PCredentials cred = new B3PCredentials();
        cred.setUserName(username);
        cred.setPassword(password);
        cred.setUrl(loginKbUrl);
        cred.setPreemptive(true);
        HttpClientConfigured hcc = new HttpClientConfigured(cred);
        log.debug((Object)("method url: " + loginKbUrl));
        HttpGet request = new HttpGet(loginKbUrl);
        request.addHeader("X-Forwarded-For", ip);
        HttpResponse response = null;
        try {
            response = hcc.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            log.debug((Object)("Status code: " + statusCode));
            if (statusCode != 200) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException ex) {
            log.debug((Object)"Exception False: ", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            hcc.close(response);
            hcc.close();
        }
        return true;
    }

    private static boolean isExpired(Date expireDate) {
        Date now = new Date();
        return expireDate != null && expireDate.before(now);
    }

    public Principal authenticate(String username, String password) {
        return GisSecurityRealm.authenticate(username, password, null);
    }

    public static Principal authenticate(String username, String password, String code) {
        if (!HibernateUtil.isCheckLoginKaartenbalie()) {
            return GisSecurityRealm.authenticateFake(username);
        }
        String url = GisSecurityRealm.createInternalCapabilitiesURL(code);
        return GisSecurityRealm.authenticateHttp(url, username, password, code, null);
    }

    public static Principal authenticate(String username, String password, String code, SecurityRequestWrapper request) {
        if (!HibernateUtil.isCheckLoginKaartenbalie()) {
            return GisSecurityRealm.authenticateFake(username);
        }
        String url = GisSecurityRealm.createInternalCapabilitiesURL(code);
        return GisSecurityRealm.authenticateHttp(url, username, password, code, request);
    }

    public Principal getAuthenticatedPrincipal(String username) {
        return null;
    }

    public static synchronized boolean isInSPCache(String userName) {
        if (Bron.isCacheExpired()) {
            GisSecurityRealm.flushSPCache();
            return false;
        }
        return perUserNameSPCache.containsKey(userName);
    }

    public static synchronized void putInSPCache(String userName, ServiceProvider sp) {
        perUserNameSPCache.put(userName, sp);
    }

    public static synchronized ServiceProvider getFromSPCache(String userName) {
        return perUserNameSPCache.get(userName);
    }

    private static boolean isCachedOnDisk(String key) {
        if (key == null || key.isEmpty()) {
            return false;
        }
        String cacheOnDiskPath = HibernateUtil.cacheOnDiskPath;
        String fileName = cacheOnDiskPath + key + ".xml";
        File f = new File(fileName);
        return f.exists() && !f.isDirectory();
    }

    private static boolean isCachePathValid() {
        String cacheOnDiskPath = HibernateUtil.cacheOnDiskPath;
        File f = new File(cacheOnDiskPath);
        return f.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCacheToDisk(String key, ServiceProvider sp) {
        if (key == null || sp == null || key.isEmpty() || !GisSecurityRealm.isCachePathValid()) {
            return;
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("WMT_MS_Capabilities");
        doc.appendChild(rootElement);
        Element spElem = sp.toElement(doc, rootElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
        String cacheOnDiskPath = HibernateUtil.cacheOnDiskPath;
        String fileName = cacheOnDiskPath + key + ".xml";
        DOMSource source = new DOMSource(doc);
        FileOutputStream fop = null;
        try {
            File file = new File(fileName);
            fop = new FileOutputStream(file);
            if (!file.exists()) {
                file.createNewFile();
            }
            StreamResult result = new StreamResult(fop);
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            log.error((Object)"Error writing cache to disk: ", (Throwable)ex);
        }
        finally {
            try {
                if (fop != null) {
                    fop.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error closing stream for cache to disk: ", (Throwable)e);
            }
        }
    }

    private static ServiceProvider readCacheFromDisk(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        String cacheOnDiskPath = HibernateUtil.cacheOnDiskPath;
        String fileName = cacheOnDiskPath + key + ".xml";
        File file = new File(fileName);
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(FileUtils.readFileToByteArray((File)file));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        WMSCapabilitiesReader wmsReader = new WMSCapabilitiesReader();
        ServiceProvider serviceProvider = wmsReader.getProvider(in);
        return serviceProvider;
    }

    public static synchronized void flushSPCache() {
        boolean cacheOnDisk = HibernateUtil.cacheOnDisk;
        if (cacheOnDisk) {
            try {
                String dir = HibernateUtil.cacheOnDiskPath;
                File directory = new File(dir);
                FileUtils.cleanDirectory((File)directory);
            }
            catch (IOException ex) {
                log.error((Object)"Fout tijdens verwijderen disk cache.", (Throwable)ex);
            }
            log.debug((Object)"Cache on DISK WMS leeggemaakt.");
        } else {
            perUserNameSPCache.clear();
            log.debug((Object)"Cache in MEMORY WMS leeggemaakt.");
        }
    }
}

