/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.gis.viewer.db.UserLayer;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.ogc.sld.SldWriter;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.Style;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserLayerSldServlet
extends HttpServlet {
    private final String MIME_XML = "text/xml";
    private static final Log log = LogFactory.getLog(UserLayerSldServlet.class);

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug((Object)"UserLayerSldServlet processRequest.");
        String ids = request.getParameter("layerids");
        if (ids != null || !ids.equals("")) {
            String[] layerids = ids.split(",");
            List<Style> styles = this.getKbStyles(layerids);
            try {
                SldWriter sldWriter = new SldWriter();
                sldWriter.addNamedLayers(sldWriter.createNamedLayersWithKBStyles(styles));
                String body = sldWriter.createSLD();
                this.createSld(body, response);
            }
            catch (SAXParseException sax) {
                log.error((Object)("SLD is ongeldig voor layerids: " + ids));
                this.writeErrorMessage(response, "SLD is ongeldig.");
            }
            catch (Exception ex) {
                log.error((Object)"Fout tijdens maken user sld: ", (Throwable)ex);
                this.writeErrorMessage(response, "Fout tijdens maken user sld.");
            }
        } else {
            this.writeErrorMessage(response, "Geen geldig layerid meegegeven.");
        }
    }

    private List<Style> getKbStyles(String[] layerids) {
        ArrayList<Style> styles;
        block3: {
            styles = new ArrayList<Style>();
            Session sess = null;
            Transaction tx = null;
            try {
                sess = HibernateUtil.getSessionFactory().getCurrentSession();
                tx = sess.beginTransaction();
                for (int i = 0; i < layerids.length; ++i) {
                    UserLayer layer = (UserLayer)sess.get(UserLayer.class, (Serializable)new Integer(layerids[i]));
                    if (layer == null || layer.getSld_part() == null) continue;
                    String part = layer.getSld_part();
                    Style style = new Style();
                    style.setName(layer.getName());
                    style.setSldPart(part);
                    Layer l = new Layer();
                    l.setName(layer.getName());
                    style.setLayer(l);
                    styles.add(style);
                }
                tx.commit();
            }
            catch (Exception ex) {
                log.error((Object)"Fout tijdens maken user sld: ", (Throwable)ex);
                if (tx == null || !tx.isActive()) break block3;
                tx.rollback();
            }
        }
        return styles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSld(String body, HttpServletResponse response) {
        PrintWriter out = null;
        try {
            out = response.getWriter();
            response.setContentType("text/xml");
            out.write(body);
        }
        catch (Exception ex) {
            log.error((Object)"Fout tijdens maken user sld: ", (Throwable)ex);
        }
        finally {
            out.close();
        }
    }

    private void writeErrorMessage(HttpServletResponse response, String message) {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = null;
        try {
            out = response.getWriter();
            out.println("<html>");
            out.println("<head>");
            out.println("<title>User Layer SLD Servlet Error</title>");
            out.println("</head>");
            out.println("<body>");
            out.println("" + message + "");
            out.println("</body>");
            out.println("</html>");
            out.close();
        }
        catch (IOException ex) {
            log.error((Object)ex);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }
}

