/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.geotools;

import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.filter.FilterTransformer;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class FilterBuilder {
    private static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());

    public static Filter createEqualsFilter(String key, String value) {
        Literal e;
        try {
            int iid = Integer.parseInt(value);
            e = ff.literal(iid);
        }
        catch (NumberFormatException nfe) {
            e = ff.literal((Object)value);
        }
        return ff.equals((Expression)ff.property(key), (Expression)e);
    }

    public static FilterFactory2 getFactory() {
        return ff;
    }

    public static Filter createOrEqualsFilter(String key, String[] pks) {
        ArrayList<PropertyIsEqualTo> filters = new ArrayList<PropertyIsEqualTo>();
        PropertyName pn = ff.property(key);
        for (int i = 0; i < pks.length; ++i) {
            filters.add(ff.equals((Expression)pn, (Expression)ff.literal((Object)pks[i])));
        }
        if (filters.size() == 1) {
            return (Filter)filters.get(0);
        }
        if (filters.size() > 1) {
            return ff.or(filters);
        }
        return null;
    }

    public static Filter createLikeFilter(String key, String extraCriterium) {
        return ff.like((Expression)ff.property(key), extraCriterium);
    }

    public static void main(String[] args) throws TransformerException {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        ReferencedEnvelope bbox = new ReferencedEnvelope(195580.0, 466937.0, 196403.0, 467760.0, null);
        Filter filter = null;
        FilterTransformer ft = new FilterTransformer();
        try {
            String s = ft.transform(filter);
            System.out.println(s);
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
    }
}

