/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.gis.viewer.BaseGisAction;
import nl.b3p.gis.viewer.db.CMSMenuItem;
import nl.b3p.gis.viewer.db.CMSPagina;
import nl.b3p.gis.viewer.services.GisPrincipal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.RedirectingActionForward;
import org.apache.struts.validator.DynaValidatorForm;
import org.securityfilter.filter.SavedRequest;
import org.securityfilter.filter.SecurityFilter;

public class CMSAction
extends BaseGisAction {
    private static final Log logger = LogFactory.getLog(CMSAction.class);
    private static final String CMS = "cms";
    private static final String CMS_STYLE = "cmsstyle";

    protected Map getActionMethodPropertiesMap() {
        HashMap<String, ExtendedMethodProperties> map = new HashMap<String, ExtendedMethodProperties>();
        ExtendedMethodProperties hibProp = new ExtendedMethodProperties(CMS);
        hibProp.setDefaultForwardName(CMS);
        hibProp.setAlternateForwardName("failure");
        map.put(CMS, hibProp);
        hibProp = new ExtendedMethodProperties(CMS_STYLE);
        hibProp.setDefaultForwardName(CMS_STYLE);
        hibProp.setAlternateForwardName("failure");
        map.put(CMS_STYLE, hibProp);
        return map;
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        GisPrincipal user;
        Integer cmsPageId = this.getCMSPageId(request);
        CMSPagina cmsPage = this.getCMSPage(cmsPageId);
        if (cmsPage == null) {
            return new RedirectingActionForward("/http_404.do");
        }
        if (cmsPage.getLoginRequired().booleanValue() && (user = GisPrincipal.getGisPrincipal(request)) == null) {
            String url = this.prettifyCMSPageUrl(request, cmsPage);
            HttpSession session = request.getSession();
            session.setAttribute(SecurityFilter.SAVED_REQUEST_URL, (Object)url);
            session.setAttribute(SecurityFilter.SAVED_REQUEST, (Object)new SavedRequest(request));
            return new RedirectingActionForward("/login.do");
        }
        this.populateCMSPage(request, cmsPageId);
        if (cmsPageId != null && cmsPageId > 0) {
            this.populateTekstblok(request, cmsPageId);
        }
        return mapping.findForward("success");
    }

    public ActionForward cmsstyle(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer cmsPageId = this.getCMSPageId(request);
        if (cmsPageId != null && cmsPageId > 0) {
            this.populateTekstblok(request, cmsPageId);
        }
        return mapping.findForward("success");
    }

    private Integer getCMSPageId(HttpServletRequest request) {
        Integer cmsPageId = null;
        String param = null;
        try {
            param = request.getParameter("id");
            if (param != null && !param.isEmpty()) {
                cmsPageId = Integer.parseInt(param);
            } else {
                param = request.getParameter("cmsPageId");
                if (param != null && !param.isEmpty()) {
                    cmsPageId = new Integer(param);
                }
            }
        }
        catch (NumberFormatException nfe) {
            logger.info((Object)("Trying to get invalid CMS page with id: " + param));
        }
        return cmsPageId;
    }

    private void populateTekstblok(HttpServletRequest request, Integer cmsPageId) {
        List tekstBlokken = this.getTekstBlokken(cmsPageId);
        request.setAttribute("tekstBlokken", (Object)tekstBlokken);
    }

    private void populateCMSPage(HttpServletRequest request, Integer pageID) {
        CMSPagina cmsPage = null;
        if (pageID != null && pageID > 0 && (cmsPage = this.getCMSPage(pageID)) != null) {
            request.setAttribute("cmsPage", (Object)cmsPage);
            if (cmsPage.getThema() == null || cmsPage.getThema().equals("")) {
                request.setAttribute("theme", (Object)"");
            } else {
                request.setAttribute("theme", (Object)cmsPage.getThema());
            }
            if (cmsPage.getCmsMenu() != null) {
                List<CMSMenuItem> items = this.getCMSMenuItems(cmsPage.getCmsMenu());
                request.setAttribute("cmsMenuItems", items);
            }
        }
        if (cmsPage == null) {
            request.setAttribute("theme", (Object)"");
        } else if (cmsPage.getShowPlainAndMapButton().booleanValue()) {
            request.setAttribute("showPlainAndMapButton", (Object)true);
        }
    }
}

