/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.html.HtmlWriter;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.rtf.RtfWriter2;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.services.HttpClientConfigured;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.imagetool.CombineImageSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class CreateMapPDF
extends HttpServlet {
    private static final int RTIMEOUT = 20000;
    private static final Log log = LogFactory.getLog(CreateMapPDF.class);
    private static final String METADATA_TITLE = "Kaartexport B3P Gisviewer";
    private static final String METADATA_AUTHOR = "B3P Gisviewer";
    private static final String OUTPUT_PDF_PRINT = "PDF_PRINT";
    private static final String OUTPUT_PDF = "PDF";
    private static final String OUTPUT_RTF = "RTF";
    private static final int MAXSIZE = 2048;
    private static String logoPath = null;
    private static String extraImagePath = null;
    private static String disclaimer = null;
    private static SimpleDateFormat sdf = null;
    private static float footerHeight = 25.0f;
    private static boolean addFooter = true;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        String title = FormUtils.nullIfEmpty((String)request.getParameter("title"));
        String remark = FormUtils.nullIfEmpty((String)request.getParameter("remark"));
        CombineImageSettings settings = null;
        String imageSource = null;
        String imageId = FormUtils.nullIfEmpty((String)request.getParameter("imageId"));
        if (imageId != null && request.getSession().getAttribute(imageId) != null) {
            settings = (CombineImageSettings)request.getSession().getAttribute(imageId);
            String servletUrl = request.getRequestURL().toString();
            String servletName = this.getServletName();
            String servletPath = request.getServletPath();
            servletUrl = servletUrl.substring(0, servletUrl.length() - servletPath.length()) + "/CreateImage";
            imageSource = servletUrl + "?imageId=" + imageId;
        }
        String pageSize = FormUtils.nullIfEmpty((String)request.getParameter("pageSize"));
        boolean landscape = Boolean.valueOf(request.getParameter("landscape"));
        String outputType = OUTPUT_PDF;
        if (FormUtils.nullIfEmpty((String)request.getParameter("outputType")) != null) {
            outputType = FormUtils.nullIfEmpty((String)request.getParameter("outputType"));
        }
        int imageSize = 0;
        if (FormUtils.nullIfEmpty((String)request.getParameter("imageSize")) != null) {
            try {
                imageSize = Integer.parseInt(FormUtils.nullIfEmpty((String)request.getParameter("imageSize")));
            }
            catch (NumberFormatException nfe) {
                imageSize = 0;
            }
        }
        if (imageId == null || imageId.length() == 0) {
            throw new ServletException("Geen kaart om te plaatsen in de pdf.");
        }
        Document doc = null;
        try {
            PdfWriter dw = null;
            doc = this.createDocument(pageSize, landscape);
            String filename = title;
            if (filename == null) {
                filename = "kaartexport";
            }
            if (outputType.equalsIgnoreCase(OUTPUT_PDF) || outputType.equalsIgnoreCase(OUTPUT_PDF_PRINT)) {
                dw = PdfWriter.getInstance((Document)doc, (OutputStream)response.getOutputStream());
                response.setContentType("application/pdf");
                filename = filename + ".pdf";
            } else if (outputType.equalsIgnoreCase(OUTPUT_RTF)) {
                dw = RtfWriter2.getInstance((Document)doc, (OutputStream)response.getOutputStream());
                response.setContentType("application/rtf");
                filename = filename + ".rtf";
            } else {
                dw = HtmlWriter.getInstance((Document)doc, (OutputStream)response.getOutputStream());
                response.setContentType("text/html");
                filename = filename + ".html";
            }
            response.setHeader("Content-Disposition", "inline; filename=\"" + filename + "\";");
            doc.open();
            this.setDocumentMetadata(doc);
            if (title != null) {
                Paragraph titleParagraph = new Paragraph(title);
                titleParagraph.setAlignment(1);
                doc.add((Element)titleParagraph);
            }
            int width = 0;
            int height = 0;
            if (imageSize == 0) {
                imageSize = 2048;
            }
            float factor = 0.0f;
            factor = width >= height ? new Float(imageSize).floatValue() / (float)width : new Float(imageSize).floatValue() / (float)height;
            width = new Double(Math.floor((float)width * factor)).intValue();
            height = new Double(Math.floor((float)height * factor)).intValue();
            float imageWidth = doc.getPageSize().getWidth() - doc.leftMargin() - doc.rightMargin();
            float imageHeight = doc.getPageSize().getHeight() - doc.topMargin() - doc.bottomMargin();
            try {
                Image map = this.getImage(imageSource, request);
                map.setAlignment(1);
                int resize = 75;
                if (landscape && remark != null) {
                    imageHeight -= (float)resize;
                    imageWidth -= (float)Math.round((float)resize * factor);
                }
                if (landscape && addFooter) {
                    imageHeight -= (float)resize;
                    imageWidth -= (float)Math.round((float)resize * factor);
                }
                if (landscape && title != null) {
                    imageHeight -= (float)resize;
                    imageWidth -= (float)Math.round((float)resize * factor);
                }
                map.scaleToFit(imageWidth, imageHeight);
                doc.add((Element)map);
            }
            catch (Exception ex) {
                log.error((Object)"Kan kaart image niet toevoegen.", (Throwable)ex);
                doc.add((Element)new Phrase("Kan kaart image niet toevoegen."));
            }
            if (addFooter) {
                Element footer = this.createfooter(doc, outputType);
                if (footer instanceof PdfPTable) {
                    PdfPTable table = (PdfPTable)footer;
                    table.setTotalWidth(new float[]{80.0f, imageWidth - 107.0f, 25.0f});
                    table.setLockedWidth(true);
                    doc.add((Element)table);
                } else {
                    doc.add(footer);
                }
            }
            if (remark != null) {
                doc.add((Element)new Phrase(remark));
            }
            if (dw instanceof PdfWriter && outputType.equalsIgnoreCase(OUTPUT_PDF_PRINT)) {
                PdfWriter dwpdf = dw;
                dwpdf.addJavaScript("this.print({bSilent:true,bShrinkToFit:true});");
            }
        }
        catch (DocumentException de) {
            log.error((Object)"Fout bij het maken van een document. Reden: ", (Throwable)de);
            throw new ServletException((Throwable)de);
        }
        finally {
            doc.close();
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            if (config.getInitParameter("logoPath") != null) {
                logoPath = this.getServletContext().getRealPath(config.getInitParameter("logoPath"));
            }
            if (config.getInitParameter("extraImagePath") != null) {
                extraImagePath = this.getServletContext().getRealPath(config.getInitParameter("extraImagePath"));
            }
            if (config.getInitParameter("disclaimer") != null) {
                disclaimer = config.getInitParameter("disclaimer");
            }
            if (config.getInitParameter("addFooter") != null) {
                addFooter = "true".equalsIgnoreCase(config.getInitParameter("addFooter"));
            }
            sdf = new SimpleDateFormat("dd-MMMM-yyyy", new Locale("NL"));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public Document createDocument(String pageSize, boolean landscape) {
        Rectangle ps = PageSize.A4;
        if (pageSize != null) {
            ps = PageSize.getRectangle((String)pageSize);
        }
        Document doc = null;
        doc = landscape ? new Document(ps.rotate()) : new Document(ps);
        return doc;
    }

    private Element createfooter(Document doc, String outputType) {
        Image logo = null;
        Image extraImage = null;
        if (logoPath != null) {
            try {
                logo = Image.getInstance((String)logoPath);
            }
            catch (Exception e) {
                log.error((Object)"Fout bij ophalen export logo: ", (Throwable)e);
            }
        }
        if (extraImagePath != null) {
            try {
                extraImage = Image.getInstance((String)extraImagePath);
            }
            catch (Exception e) {
                log.error((Object)"Fout bij ophalen van de noord pijl: ", (Throwable)e);
            }
        }
        if (outputType.equalsIgnoreCase(OUTPUT_PDF)) {
            PdfPTable mainTable = new PdfPTable(3);
            if (logo != null) {
                PdfPCell logoCell = new PdfPCell();
                logoCell.setFixedHeight(footerHeight);
                logoCell.setImage(logo);
                mainTable.addCell(logoCell);
            }
            Font font = new Font(2, 8.0f, 1);
            PdfPTable nestedTable = new PdfPTable(1);
            PdfPCell dateCell = new PdfPCell(new Phrase(sdf.format(new Date()), font));
            dateCell.setHorizontalAlignment(1);
            nestedTable.addCell(dateCell);
            if (disclaimer != null) {
                PdfPCell disc = new PdfPCell(new Phrase(disclaimer, font));
                disc.setHorizontalAlignment(1);
                nestedTable.addCell(disc);
            }
            PdfPCell cell = new PdfPCell(nestedTable);
            cell.setBorder(0);
            mainTable.addCell(cell);
            if (extraImage != null) {
                PdfPCell extraCell = new PdfPCell();
                extraCell.setFixedHeight(footerHeight);
                extraCell.setImage(extraImage);
                mainTable.addCell(extraCell);
            }
            return mainTable;
        }
        if (logo != null) {
            return logo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getImage(String mapUrl, HttpServletRequest request) throws IOException, Exception {
        GisPrincipal gp = GisPrincipal.getGisPrincipal(request);
        B3PCredentials credentials = new B3PCredentials();
        if (gp != null) {
            credentials.setUserName(gp.getName());
            credentials.setPassword(gp.getPassword());
        }
        credentials.setUrl(mapUrl);
        credentials.setPreemptive(true);
        HttpClientConfigured hcc = new HttpClientConfigured(credentials);
        HttpGet httpget = new HttpGet(mapUrl);
        HttpResponse response = hcc.execute((HttpUriRequest)httpget);
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            if (statusCode != 200) {
                log.error((Object)("Host: " + mapUrl + " error: " + response.getStatusLine().getReasonPhrase()));
                throw new Exception("Host: " + mapUrl + " error: " + response.getStatusLine().getReasonPhrase());
            }
            byte[] ba = EntityUtils.toString((HttpEntity)entity).getBytes();
            Image image = Image.getInstance((byte[])ba);
            return image;
        }
        finally {
            hcc.close(response);
            hcc.close();
        }
    }

    private void setDocumentMetadata(Document doc) {
        doc.addTitle(METADATA_TITLE);
        doc.addAuthor(METADATA_AUTHOR);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

