/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class GetBlobServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(GetBlobServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException {
        String gbId = request.getParameter("gbId");
        String recordId = request.getParameter("recordId");
        String columnName = request.getParameter("columnName");
        String mimeType = request.getParameter("mimeType");
        if (gbId != null && recordId != null && columnName != null && mimeType != null) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            Transaction tx = null;
            Connection conn = null;
            try {
                String primaryKey;
                String adminTabel;
                Integer id;
                Object obj;
                tx = sess.beginTransaction();
                Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)new Integer(gbId));
                conn = this.getConnection(gb.getBron());
                if (gb == null || conn == null) {
                    this.writeMessage(response, "Fout tijdens verbinden.");
                }
                if ((obj = this.getBlob(id = new Integer(recordId), columnName, adminTabel = gb.getAdmin_tabel(), primaryKey = gb.getAdmin_pk(), conn)) != null && mimeType != null && !mimeType.contains("html")) {
                    byte[] arr = this.convertObjectToByteArray(obj);
                    this.createBinary(response, arr, mimeType, columnName);
                } else if (obj != null && mimeType != null && mimeType.contains("html")) {
                    this.createHtml(response, obj);
                } else {
                    this.writeMessage(response, "Geen document gevonden.");
                }
                tx.commit();
                DbUtils.close((Connection)conn);
                return;
            }
            catch (Exception e) {
                log.error((Object)"Fout tijdens ophalen blob: ", (Throwable)e);
                this.writeMessage(response, "Fout tijdens ophalen blob.");
                if (!tx.isActive()) return;
                tx.rollback();
                return;
            }
            finally {
                DbUtils.close(conn);
            }
        } else {
            this.writeMessage(response, "Verplichte parameters ontbreken.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] convertObjectToByteArray(Object obj) throws IOException {
        byte[] arr = null;
        if (obj instanceof Blob) {
            try {
                Blob b = (Blob)obj;
                arr = b.getBytes(1L, (int)b.length());
            }
            catch (Exception ex) {
                log.error((Object)"Fout bij omzetten naar blob");
            }
            return arr;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream objOut = null;
        try {
            objOut = new ObjectOutputStream(bos);
            objOut.writeObject(obj);
            arr = bos.toByteArray();
        }
        finally {
            if (objOut != null) {
                objOut.close();
            }
            bos.close();
        }
        return arr;
    }

    private void createBinary(HttpServletResponse response, byte[] arr, String mimeType, String column) throws SQLException, IOException {
        ServletOutputStream out = response.getOutputStream();
        response.setContentType(mimeType);
        response.setContentLength(arr.length);
        response.setHeader("Content-disposition", "inline; filename=\"" + column + "\"");
        out.write(arr);
        out.flush();
    }

    private void createHtml(HttpServletResponse response, Object file) throws SQLException, IOException {
        if (file == null) {
            this.writeMessage(response, "Fout tijdens maken output html.");
            return;
        }
        PrintWriter out = response.getWriter();
        response.setContentType("text/html");
        if (file instanceof String) {
            out.println(file.toString());
        } else {
            Clob clob = (Clob)file;
            int len = (int)clob.length();
            out.println(clob.getSubString(1L, len));
        }
        out.flush();
    }

    public Object getBlob(Integer recordId, String column, String table, String pk, Connection conn) {
        if (conn == null || recordId < 1) {
            return null;
        }
        String sql = "select " + column + " from " + table + " where " + pk + " = ?";
        try {
            return new QueryRunner().query(conn, sql, (ResultSetHandler)new ResultSetHandler<Object>(){

                public Object handle(ResultSet rs) throws SQLException {
                    Blob obj = null;
                    while (rs.next()) {
                        obj = rs.getBlob(1);
                    }
                    return obj;
                }
            }, new Object[]{recordId});
        }
        catch (SQLException sqlEx) {
            log.error((Object)"Fout tijdens sql voor ophalen blob: ", (Throwable)sqlEx);
            return null;
        }
    }

    private Connection getConnection(Bron b) {
        if (b != null) {
            try {
                Object conn = null;
                Properties connectionProps = new Properties();
                connectionProps.put("user", b.getGebruikersnaam());
                connectionProps.put("password", b.getWachtwoord());
                Class.forName("oracle.jdbc.driver.OracleDriver");
                String url = this.replaceSchema(b.getUrl());
                return DriverManager.getConnection(url, connectionProps);
            }
            catch (Exception ex) {
                log.error((Object)"Fout bij maken connectie: ", (Throwable)ex);
            }
        }
        return null;
    }

    private String replaceSchema(String url) {
        if (url != null) {
            int idxLast = url.lastIndexOf(":");
            int idxLastDot = url.lastIndexOf(".");
            if (idxLastDot > idxLast) {
                url = url.substring(0, idxLastDot);
            }
        }
        return url;
    }

    private void writeMessage(HttpServletResponse response, String message) {
        response.setContentType("text/html;charset=UTF-8");
        try {
            PrintWriter out = response.getWriter();
            out.println("<html>");
            out.println("<head>");
            out.println("<title>Ophalen Document</title>");
            out.println("</head>");
            out.println("<body>");
            out.println("" + message + "");
            out.println("</body>");
            out.println("</html>");
            out.close();
        }
        catch (IOException ex) {
            log.error((Object)ex);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (SQLException ex) {
            log.error((Object)"Servlet error: ", (Throwable)ex);
        }
    }
}

