/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.gis.geotools.DataStoreUtil;
import nl.b3p.gis.geotools.FilterBuilder;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.ThemaData;
import nl.b3p.gis.viewer.print.PrintServlet;
import nl.b3p.gis.viewer.report.ReportInfo;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.SpatialUtil;
import nl.b3p.imagetool.CombineImageSettings;
import nl.b3p.imagetool.CombineImagesHandler;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.json.JSONObject;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.filter.Filter;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(ReportServlet.class);
    private static String xsl_report = null;
    private static String PK_ONLY = "only pk no basisregel";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.checkRequestParams(request);
            String appCode = request.getParameter("appCode");
            String gegevensbronId = request.getParameter("gbId");
            String recordId = request.getParameter("recordId");
            String reportType = request.getParameter("reportType");
            String pk = request.getParameter("pk");
            CombineImageSettings settings = null;
            settings = this.getCombineImageSettings(request);
            settings.setWidth(Integer.valueOf(500));
            settings.setHeight(Integer.valueOf(375));
            Date now = new Date();
            SimpleDateFormat df = new SimpleDateFormat("d MMMMM yyyy", new Locale("NL"));
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            Transaction t = null;
            try {
                t = sess.beginTransaction();
                GisPrincipal user = GisPrincipal.getGisPrincipal(request);
                if (user == null) {
                    throw new Exception("Kan de data niet ophalen omdat u niet bent ingelogd.");
                }
                Gegevensbron gb = SpatialUtil.getGegevensbron(gegevensbronId);
                if (pk != null && !pk.isEmpty()) {
                    recordId = pk;
                }
                ReportInfo info = new ReportInfo();
                ReportInfo.Bron startBron = this.createReportBron(gb, recordId, false, settings, info, appCode);
                if (reportType == null || reportType.isEmpty()) {
                    info.setTitel("Rapport");
                } else {
                    info.setTitel(reportType);
                }
                info.setDatum(df.format(now));
                info.setBron(startBron);
                if (log.isDebugEnabled()) {
                    ReportServlet.createXmlOutput(info);
                }
                ReportServlet.createPdfOutput(info, xsl_report, response);
                t.commit();
            }
            finally {
                if (sess.isOpen()) {
                    sess.close();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            this.writeErrorMessage(response, e.getMessage());
        }
    }

    private String createImageUrl(String wkt, CombineImageSettings settings) {
        Geometry geom = null;
        try {
            geom = DataStoreUtil.createGeomFromWKTString(wkt);
        }
        catch (Exception ex) {
            log.error((Object)"Fout tijdens knutselen geometrie: ", (Throwable)ex);
        }
        Envelope bbox = geom.getEnvelopeInternal();
        double[] dbbox = new double[4];
        double bufferSize = 50.0;
        dbbox[0] = bbox.getMinX() - bufferSize;
        dbbox[1] = bbox.getMinY() - bufferSize;
        dbbox[2] = bbox.getMaxX() + bufferSize;
        dbbox[3] = bbox.getMaxY() + bufferSize;
        settings.setBbox(dbbox);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String imageUrl = null;
        BASE64Encoder enc = new BASE64Encoder();
        try {
            CombineImagesHandler.combineImage((OutputStream)baos, (CombineImageSettings)settings);
            byte[] imageBytes = baos.toByteArray();
            imageUrl = enc.encode(imageBytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageUrl;
    }

    private ReportInfo.Bron createReportBron(Gegevensbron gb, String recordId, boolean isChild, CombineImageSettings settings, ReportInfo info, String appCode) throws Exception {
        Map<String, String> dataColumns;
        if (gb == null) {
            throw new Exception("Geen gegevensbron gevonden");
        }
        ReportInfo.Bron.LAYOUT table_type = ReportInfo.Bron.LAYOUT.FLAT_TABLE;
        if (isChild) {
            table_type = ReportInfo.Bron.LAYOUT.SIMPLE_TABLE;
        }
        if ((dataColumns = this.getObjectDataColumns(gb)) == null || dataColumns.isEmpty()) {
            throw new Exception("Geen kolommen gevonden voor gegevensbron: " + gb.getNaam());
        }
        String pkColumn = gb.getAdmin_pk();
        String wkt = null;
        if (table_type.equals((Object)ReportInfo.Bron.LAYOUT.FLAT_TABLE)) {
            wkt = this.getWktForImageUrl(gb.getBron(), gb, recordId, appCode);
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.addAll(dataColumns.keySet());
        List<Map> data = this.getData(gb.getBron(), gb, recordId, columnNames, isChild, appCode);
        ArrayList<String> basisregelColumnNames = new ArrayList<String>();
        for (String cn : dataColumns.keySet()) {
            if (dataColumns.get(cn).equals(PK_ONLY)) continue;
            basisregelColumnNames.add(cn);
        }
        ReportInfo.Bron bron = new ReportInfo.Bron();
        bron.setTitel(gb.getNaam());
        bron.setLayout(table_type);
        String imageUrl = null;
        for (Map row : data) {
            String pkValue = (String)row.get(pkColumn);
            if (settings != null && table_type.equals((Object)ReportInfo.Bron.LAYOUT.FLAT_TABLE) && wkt != null) {
                imageUrl = this.createImageUrl(wkt, settings);
            }
            ReportInfo.Record record = new ReportInfo.Record();
            record.setId(pkValue);
            if (imageUrl != null && !imageUrl.isEmpty()) {
                info.setImage_url(imageUrl);
            }
            String[] values = new String[basisregelColumnNames.size()];
            for (int i = 0; i < basisregelColumnNames.size(); ++i) {
                values[i] = (String)row.get(basisregelColumnNames.get(i));
            }
            record.setValues(values);
            bron.addRecord(record);
            ArrayList<ReportInfo.Bron> subBronnen = null;
            Set children = gb.getChildren();
            ArrayList childList = new ArrayList(children);
            if (childList.size() > 0) {
                Collections.sort(childList);
            }
            for (Gegevensbron child : childList) {
                Gegevensbron gbChild = child;
                ReportInfo.Bron childBron = this.createReportBron(gbChild, pkValue, true, null, null, appCode);
                if (childBron == null || childBron.getRecords() == null || childBron.getRecords().size() < 1) continue;
                if (subBronnen == null) {
                    subBronnen = new ArrayList<ReportInfo.Bron>();
                }
                subBronnen.add(childBron);
            }
            if (subBronnen == null || subBronnen.size() <= 0) continue;
            for (ReportInfo.Bron childSubbron : subBronnen) {
                record.addBron(childSubbron);
            }
        }
        String[] labelNames = new String[basisregelColumnNames.size()];
        for (int i = 0; i < basisregelColumnNames.size(); ++i) {
            labelNames[i] = dataColumns.get(basisregelColumnNames.get(i));
        }
        bron.setLabels(labelNames);
        return bron;
    }

    public Map<String, String> getObjectDataColumns(Gegevensbron gb) {
        Set themadata = gb.getThemaData();
        if (themadata == null || themadata.isEmpty()) {
            return null;
        }
        ArrayList tdList = new ArrayList();
        tdList.addAll(themadata);
        Collections.sort(tdList);
        Iterator it = tdList.iterator();
        LinkedHashMap<String, String> dataColumns = new LinkedHashMap<String, String>();
        while (it.hasNext()) {
            ThemaData td = (ThemaData)it.next();
            if (td.getKolomnaam() == null) continue;
            if (!dataColumns.containsKey(td.getKolomnaam()) && td.getKolomnaam().equalsIgnoreCase(gb.getAdmin_pk())) {
                dataColumns.put(td.getKolomnaam(), PK_ONLY);
            }
            if (!td.isBasisregel()) continue;
            dataColumns.put(td.getKolomnaam(), td.getLabel());
        }
        return dataColumns;
    }

    public List<Map> getData(Bron b, Gegevensbron gb, String recordId, List<String> propertyNames, boolean isChild, String appCode) throws IOException, Exception {
        String column = null;
        column = !isChild ? gb.getAdmin_pk() : gb.getAdmin_fk();
        Filter filter = FilterBuilder.createOrEqualsFilter(DataStoreUtil.convertColumnNameToQName(column).getLocalPart(), new String[]{recordId});
        Integer maximum = ConfigKeeper.getMaxNumberOfFeatures(appCode);
        ArrayList<Feature> features = DataStoreUtil.getFeatures(b, gb, null, filter, propertyNames, maximum, false);
        ArrayList<Map> result = new ArrayList<Map>();
        for (int i = 0; i < features.size(); ++i) {
            Feature f = (Feature)features.get(i);
            HashMap<String, String> row = new HashMap<String, String>();
            for (int p = 0; p < propertyNames.size(); ++p) {
                Property property = f.getProperty(propertyNames.get(p));
                if (property != null && property.getValue() != null && property.getValue().toString() != null) {
                    row.put(propertyNames.get(p), property.getValue().toString().trim());
                    continue;
                }
                row.put(propertyNames.get(p), "-");
            }
            result.add(row);
        }
        return result;
    }

    private String getWktForImageUrl(Bron b, Gegevensbron gb, String recordId, String appCode) throws Exception {
        String wkt = null;
        String column = gb.getAdmin_pk();
        Filter filter = FilterBuilder.createOrEqualsFilter(DataStoreUtil.convertColumnNameToQName(column).getLocalPart(), new String[]{recordId});
        List<ThemaData> items = SpatialUtil.getThemaData(gb, false);
        List<String> propnames = DataStoreUtil.themaData2PropertyNames(items);
        Integer maximum = ConfigKeeper.getMaxNumberOfFeatures(appCode);
        ArrayList<Feature> features = DataStoreUtil.getFeatures(b, gb, null, filter, propnames, maximum, true);
        for (int i = 0; i < features.size(); ++i) {
            Feature f = features.get(i);
            SimpleFeatureImpl feature = (SimpleFeatureImpl)f;
            Geometry geom = (Geometry)feature.getDefaultGeometry();
            if (geom == null) continue;
            wkt = geom.toText();
        }
        return wkt;
    }

    public static void createXmlOutput(ReportInfo object) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ReportInfo.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter sw = new StringWriter();
        jaxbMarshaller.marshal((Object)object, (Writer)sw);
        log.debug((Object)("xml data for report:" + sw.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPdfOutput(ReportInfo info, String template, HttpServletResponse response) throws Exception {
        File xslFile = new File(template);
        String path = new File(xslFile.getParent()).toURI().toString();
        FopFactory fopFactory = FopFactory.newInstance();
        fopFactory.setBaseURL(path);
        fopFactory.getFontManager().setFontBaseURL(PrintServlet.fontPath);
        fopFactory.setUserConfig(new File(PrintServlet.fopConfig));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            foUserAgent.setCreator("Gisviewer webapplicatie");
            foUserAgent.setProducer("B3Partners");
            Date now = new Date();
            foUserAgent.setCreationDate(now);
            foUserAgent.setTitle("Rapport A");
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)out);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ReportInfo.class});
            JAXBSource src = new JAXBSource(jc, (Object)info);
            StreamSource xsltSrc = new StreamSource(xslFile);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(xsltSrc);
            if (transformer == null) {
                log.error((Object)"Fout tijdens inlezen xsl bestand.");
                return;
            }
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            if (transformer != null) {
                transformer.transform((Source)src, res);
            }
            response.setContentType("application/pdf");
            response.setContentLength(out.size());
            SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy", new Locale("NL"));
            String date = df.format(now);
            String fileName = "Rapport_" + date + ".pdf";
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.getOutputStream().write(out.toByteArray());
            response.getOutputStream().flush();
        }
        finally {
            out.close();
        }
    }

    private void writeErrorMessage(HttpServletResponse response, String message) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter pw = response.getWriter();
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title>Report message</title>");
        pw.println("<script type=\"text/javascript\"> if(window.parent && (typeof window.parent.showCsvError == 'function')) { window.parent.showCsvError(); } </script>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<h1>Fout</h1>");
        pw.println("<h3>" + message + "</h3>");
        pw.println("</body>");
        pw.println("</html>");
    }

    private void checkRequestParams(HttpServletRequest request) throws Exception {
        String gegevensbronId = request.getParameter("gbId");
        String recordId = request.getParameter("recordId");
        String reportType = request.getParameter("reportType");
        if (gegevensbronId == null || gegevensbronId.isEmpty() || recordId == null || recordId.isEmpty() || reportType == null || reportType.isEmpty()) {
            throw new Exception("Ongeldige rapport parameters.");
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            if (config.getInitParameter("xsl_report") != null) {
                xsl_report = this.getServletContext().getRealPath(config.getInitParameter("xsl_report"));
            }
            PrintServlet.fopConfig = this.getServletContext().getRealPath("/WEB-INF/xsl/fop.xml");
            PrintServlet.fontPath = this.getServletContext().getRealPath("/WEB-INF/xsl/fonts");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private CombineImageSettings getCombineImageSettings(HttpServletRequest request) throws Exception {
        String mimeType;
        String jsonSettingsParam = FormUtils.nullIfEmpty((String)request.getParameter("jsonSettings"));
        String legendUrls = FormUtils.nullIfEmpty((String)request.getParameter("legendUrls"));
        JSONObject jsonSettings = new JSONObject(jsonSettingsParam);
        CombineImageSettings settings = CombineImageSettings.fromJson((JSONObject)jsonSettings);
        HashMap<String, String> legendMap = new HashMap<String, String>();
        if (legendUrls != null) {
            log.debug((Object)("legendUrls: " + legendUrls));
            String[] arr = legendUrls.split(";");
            for (int i = 0; i < arr.length; ++i) {
                String[] legendUrlsArr = arr[i].split("#");
                legendMap.put(legendUrlsArr[0], legendUrlsArr[1]);
            }
            settings.setLegendMap(legendMap);
        }
        if ((mimeType = FormUtils.nullIfEmpty((String)request.getParameter("FORMAT"))) != null && !mimeType.equals("")) {
            settings.setMimeType(mimeType);
        }
        return settings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Objectdata 2 Report Servlet";
    }
}

