/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.utils.KaartSelectieUtil;
import nl.b3p.gis.viewer.BaseGisAction;
import nl.b3p.gis.viewer.db.Applicatie;
import nl.b3p.gis.viewer.db.CMSPagina;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.zoeker.configuratie.ResultaatAttribuut;
import nl.b3p.zoeker.configuratie.ZoekAttribuut;
import nl.b3p.zoeker.configuratie.ZoekConfiguratie;
import nl.b3p.zoeker.services.A11YResult;
import nl.b3p.zoeker.services.ZoekResultaat;
import nl.b3p.zoeker.services.ZoekResultaatAttribuut;
import nl.b3p.zoeker.services.Zoeker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class A11YViewerAction
extends BaseGisAction {
    protected static final String LIST = "list";
    protected static final String SEARCH = "search";
    protected static final String START_LOCATIE = "startLocation";
    protected static final String RESULTS = "results";
    private Zoeker zoeker;
    private static int MAX_SEARCH_RESULTS = 1000;
    private static final int MAX_PAGE_LIMIT = 25;
    private static final Log logger = LogFactory.getLog(A11YViewerAction.class);

    protected Map getActionMethodPropertiesMap() {
        HashMap<String, ExtendedMethodProperties> map = new HashMap<String, ExtendedMethodProperties>();
        ExtendedMethodProperties hibProp = new ExtendedMethodProperties(LIST);
        hibProp.setDefaultForwardName(LIST);
        hibProp.setAlternateForwardName("failure");
        map.put(LIST, hibProp);
        hibProp = new ExtendedMethodProperties(SEARCH);
        hibProp.setDefaultForwardName(SEARCH);
        hibProp.setAlternateForwardName("failure");
        map.put(SEARCH, hibProp);
        hibProp = new ExtendedMethodProperties(RESULTS);
        hibProp.setDefaultForwardName(RESULTS);
        hibProp.setAlternateForwardName("failure");
        map.put(RESULTS, hibProp);
        hibProp = new ExtendedMethodProperties(START_LOCATIE);
        hibProp.setDefaultForwardName(START_LOCATIE);
        hibProp.setAlternateForwardName("failure");
        map.put(START_LOCATIE, hibProp);
        return map;
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.zoeker = new Zoeker();
        this.addCMSParams(request);
        this.createLists(dynaForm, request);
        return mapping.findForward(LIST);
    }

    private void setBreadCrumb(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        A11YResult a11yResult = (A11YResult)session.getAttribute("a11yResult");
        if (a11yResult != null) {
            request.setAttribute("a11yResultMap", (Object)a11yResult.getResultMap());
        }
    }

    public ActionForward search(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addCMSParams(request);
        this.setBreadCrumb(request);
        this.showZoekVelden(dynaForm, request);
        return mapping.findForward(SEARCH);
    }

    public ActionForward results(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addCMSParams(request);
        this.showZoekResults(dynaForm, request);
        return mapping.findForward(RESULTS);
    }

    public ActionForward startLocation(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String appCode = request.getParameter("appCode");
        request.setAttribute("appCode", (Object)appCode);
        A11YResult a11yResult = this.createA11YResult(request);
        if (a11yResult != null) {
            HttpSession session = request.getSession(true);
            session.setAttribute("a11yResult", (Object)a11yResult);
        }
        return mapping.findForward(START_LOCATIE);
    }

    private A11YResult createA11YResult(HttpServletRequest request) {
        A11YResult result = new A11YResult();
        Enumeration attrs = request.getParameterNames();
        while (attrs.hasMoreElements()) {
            String key = (String)attrs.nextElement();
            String value = request.getParameter(key);
            if (key.equalsIgnoreCase("startGeom")) {
                result.setStartWkt(value);
            }
            if (key.equalsIgnoreCase("nextStep")) {
                result.setHasNextStep(Boolean.valueOf(true));
            }
            if (key.equalsIgnoreCase("appCode")) {
                result.setAppCode(value);
            }
            if (key.equalsIgnoreCase("searchConfigId") && !value.equals("")) {
                result.setSearchConfigId(new Integer(value));
            }
            if (!(key.equalsIgnoreCase("startGeom") || key.equalsIgnoreCase("nextStep") || key.equalsIgnoreCase("appCode") || key.equalsIgnoreCase("searchConfigId") || key.equalsIgnoreCase(START_LOCATIE))) {
                result.addResult(key, value);
            }
            logger.debug((Object)("REQUEST PARAM: " + key + "=" + value));
        }
        return result;
    }

    @Override
    protected void createLists(DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        Integer maxResults;
        super.createLists(dynaForm, request);
        String appCode = request.getParameter("appCode");
        Applicatie app = null;
        if (appCode != null && appCode.length() > 0) {
            app = KaartSelectieUtil.getApplicatie(appCode);
        }
        if (app == null) {
            app = KaartSelectieUtil.getDefaultApplicatie();
        }
        if (app == null) {
            return;
        }
        appCode = app.getCode();
        request.setAttribute("appCode", (Object)appCode);
        ConfigKeeper configKeeper = new ConfigKeeper();
        Map<String, Object> map = configKeeper.getConfigMap(appCode, true);
        String zoekConfigIds = (String)map.get("zoekConfigIds");
        if (zoekConfigIds != null && !zoekConfigIds.isEmpty()) {
            zoekConfigIds = zoekConfigIds.replace("\"", "");
            String[] ids = zoekConfigIds.split(",");
            List<ZoekConfiguratie> zcs = this.getZoekConfigs(ids);
            request.setAttribute("zoekConfigs", zcs);
        }
        if ((maxResults = (Integer)map.get("maxResults")) != null && maxResults > 0) {
            MAX_SEARCH_RESULTS = new Integer(maxResults);
        }
    }

    private void addCMSParams(HttpServletRequest request) {
        String cmsPageId = request.getParameter("cmsPageId");
        CMSPagina cmsPage = null;
        if (cmsPageId != null && !cmsPageId.isEmpty()) {
            request.setAttribute("cmsPageId", (Object)cmsPageId);
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            cmsPage = (CMSPagina)sess.get(CMSPagina.class, (Serializable)new Integer(cmsPageId));
        }
        if (cmsPage != null) {
            if (cmsPage.getThema() != null) {
                request.setAttribute("theme", (Object)cmsPage.getThema());
            }
            if (cmsPage.getSefUrl() != null) {
                request.setAttribute("sefUrl", (Object)cmsPage.getSefUrl());
            }
        }
    }

    private List<ZoekConfiguratie> getZoekConfigs(String[] zoekerIds) {
        ArrayList<ZoekConfiguratie> zcs = new ArrayList<ZoekConfiguratie>();
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List results = sess.createQuery("from ZoekConfiguratie order by naam").list();
        for (ZoekConfiguratie zc : results) {
            for (String id : zoekerIds) {
                if (id == null || id.equals("") || zc.getId() != Integer.parseInt(id) || (zc.getForUsageIn() == null || !zc.getForUsageIn().equals("viewer_webr")) && !zc.getForUsageIn().equals("webr")) continue;
                zcs.add(zc);
            }
        }
        return zcs;
    }

    private void showZoekVelden(DynaValidatorForm dynaForm, HttpServletRequest request) {
        String appCode = request.getParameter("appCode");
        String searchConfigId = request.getParameter("searchConfigId");
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ZoekConfiguratie zc = (ZoekConfiguratie)sess.get(ZoekConfiguratie.class, (Serializable)new Integer(searchConfigId));
        Set zoekVelden = zc.getZoekVelden();
        request.setAttribute("zoekVelden", (Object)zoekVelden);
        HashMap<String, List> results = new HashMap<String, List>();
        for (ZoekAttribuut attr : zoekVelden) {
            if (attr.getInputtype() != 1) continue;
            List zr = this.zoeker.zoekMetConfiguratie(attr.getInputzoekconfiguratie(), new String[]{"*"}, Integer.valueOf(MAX_SEARCH_RESULTS), new ArrayList());
            results.put(attr.getLabel(), zr);
        }
        Map params = this.createInputParamsMap(zoekVelden, request);
        request.setAttribute("params", (Object)params);
        request.setAttribute("dropdownResults", results);
        request.setAttribute("appCode", (Object)appCode);
        request.setAttribute("searchConfigId", (Object)searchConfigId);
        request.setAttribute("searchName", (Object)zc.getNaam());
    }

    private void showZoekResults(DynaValidatorForm dynaForm, HttpServletRequest request) {
        HttpSession session;
        A11YResult a11yResult;
        String appCode = request.getParameter("appCode");
        String searchConfigId = request.getParameter("searchConfigId");
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ZoekConfiguratie zc = (ZoekConfiguratie)sess.get(ZoekConfiguratie.class, (Serializable)new Integer(searchConfigId));
        String[] searchStrings = this.createZoekStringForZoeker(zc.getZoekVelden(), request);
        Integer startIndex = request.getParameter("startIndex") != null ? new Integer(request.getParameter("startIndex")) : Integer.valueOf(0);
        Integer limit = request.getParameter("limit") != null ? new Integer(request.getParameter("limit")) : Integer.valueOf(25);
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (limit < 0) {
            limit = 0;
        }
        if (limit > 25) {
            limit = 25;
        }
        List results = new ArrayList();
        if (this.zoeker == null) {
            this.zoeker = new Zoeker();
        }
        results = (a11yResult = (A11YResult)(session = request.getSession(true)).getAttribute("a11yResult")) != null ? this.zoeker.zoekMetConfiguratie(zc, searchStrings, Integer.valueOf(MAX_SEARCH_RESULTS), new ArrayList(), true, startIndex.intValue(), limit.intValue(), a11yResult) : this.zoeker.zoekMetConfiguratie(zc, searchStrings, Integer.valueOf(MAX_SEARCH_RESULTS), new ArrayList(), true, startIndex.intValue(), limit.intValue());
        if (a11yResult != null) {
            request.setAttribute("a11yResultMap", (Object)a11yResult.getResultMap());
        }
        request.setAttribute("searchConfigId", (Object)searchConfigId);
        if (zc.getParentZoekConfiguratie() != null) {
            request.setAttribute("nextStep", (Object)true);
            request.setAttribute("nextSearchConfigId", (Object)zc.getParentZoekConfiguratie().getId());
        } else {
            request.setAttribute("nextStep", (Object)false);
        }
        if (results != null && results.size() > 0) {
            ZoekResultaat r = (ZoekResultaat)results.get(0);
            request.setAttribute("count", (Object)r.getCount());
            boolean startLocation = false;
            if (r != null) {
                if (r.getCount() < limit) {
                    limit = r.getCount();
                }
                for (ZoekResultaatAttribuut attr : r.getAttributen()) {
                    if (attr.getType() != 33) continue;
                    startLocation = true;
                }
            }
            request.setAttribute(START_LOCATIE, (Object)startLocation);
        } else {
            request.setAttribute("count", (Object)0);
        }
        request.setAttribute("startIndex", (Object)startIndex);
        request.setAttribute("limit", (Object)limit);
        request.setAttribute(RESULTS, results);
        request.setAttribute("appCode", (Object)appCode);
        request.setAttribute("searchName", (Object)zc.getNaam());
        Map params = this.createResultParamsMap(zc.getResultaatVelden(), zc.getZoekVelden(), request);
        request.setAttribute("params", (Object)params);
        Map searchparams = this.createSearchStringMapForResult(zc.getZoekVelden(), request);
        request.setAttribute("searchparams", (Object)searchparams);
    }

    private Map createResultParamsMap(Set<ResultaatAttribuut> velden, Set<ZoekAttribuut> zoekVelden, HttpServletRequest request) {
        String value;
        String[] waardes;
        String param;
        HashMap<String, String> resultParams = new HashMap<String, String>();
        Map params = request.getParameterMap();
        for (ResultaatAttribuut resultaatAttribuut : velden) {
            for (Map.Entry pairs : params.entrySet()) {
                param = (String)pairs.getKey();
                if (!param.equalsIgnoreCase(resultaatAttribuut.getLabel()) && !param.equalsIgnoreCase(resultaatAttribuut.getNaam()) && !param.equalsIgnoreCase(resultaatAttribuut.getAttribuutnaam())) continue;
                waardes = (String[])pairs.getValue();
                value = waardes[0];
                resultParams.put(param, value);
            }
        }
        for (ZoekAttribuut zoekAttribuut : zoekVelden) {
            for (Map.Entry pairs : params.entrySet()) {
                param = (String)pairs.getKey();
                if (!param.equalsIgnoreCase(zoekAttribuut.getLabel()) && !param.equalsIgnoreCase(zoekAttribuut.getNaam()) && !param.equalsIgnoreCase(zoekAttribuut.getAttribuutnaam())) continue;
                waardes = (String[])pairs.getValue();
                value = waardes[0];
                if (resultParams.containsKey(param)) continue;
                resultParams.put(param, value);
            }
        }
        return resultParams;
    }

    private Map createSearchStringMapForResult(Set<ZoekAttribuut> zoekVelden, HttpServletRequest request) {
        HashMap<String, String> values = new HashMap<String, String>();
        Map params = request.getParameterMap();
        for (ZoekAttribuut attribuut : zoekVelden) {
            for (Map.Entry pairs : params.entrySet()) {
                String[] waardes;
                String value;
                String param = (String)pairs.getKey();
                if (!param.equalsIgnoreCase(attribuut.getLabel()) && !param.equalsIgnoreCase(attribuut.getNaam()) || (value = (waardes = (String[])pairs.getValue())[0]).contains("POLYGON") || value.contains("POINT") || value.contains("LINE")) continue;
                values.put(attribuut.getLabel(), value);
            }
        }
        return values;
    }

    private String[] createZoekStringForZoeker(Set<ZoekAttribuut> zoekVelden, HttpServletRequest request) {
        ArrayList<String> values = new ArrayList<String>();
        Map params = request.getParameterMap();
        for (ZoekAttribuut attribuut : zoekVelden) {
            Boolean lijktOp = false;
            if (attribuut.getType() == 0) {
                lijktOp = true;
            }
            for (Map.Entry pairs : params.entrySet()) {
                String param = (String)pairs.getKey();
                if (!param.equalsIgnoreCase(attribuut.getLabel()) && !param.equalsIgnoreCase(attribuut.getNaam())) continue;
                String[] waardes = (String[])pairs.getValue();
                String value = waardes[0];
                Integer getal = null;
                try {
                    getal = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (lijktOp.booleanValue() && !value.equals("") && getal == null) {
                    values.add("%" + value + "%");
                    continue;
                }
                values.add(value);
            }
        }
        return values.toArray(new String[0]);
    }

    private Map createInputParamsMap(Set<ZoekAttribuut> zoekVelden, HttpServletRequest request) {
        HashMap<String, String> searchParams = new HashMap<String, String>();
        Map params = request.getParameterMap();
        for (ZoekAttribuut attribuut : zoekVelden) {
            Boolean lijktOp = false;
            if (attribuut.getType() == 0) {
                lijktOp = true;
            }
            for (Map.Entry pairs : params.entrySet()) {
                String param = (String)pairs.getKey();
                if (!param.equalsIgnoreCase(attribuut.getLabel()) && !param.equalsIgnoreCase(attribuut.getNaam())) continue;
                String[] waardes = (String[])pairs.getValue();
                String value = waardes[0];
                Integer getal = null;
                try {
                    getal = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                searchParams.put(attribuut.getLabel(), value);
            }
        }
        return searchParams;
    }
}

