/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.b3p.gis.viewer.UploadedPoints;
import nl.b3p.imagetool.CombineImageSettings;
import nl.b3p.imagetool.CombineImageWkt;
import nl.b3p.imagetool.CombineImagesHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadedPointsWmsServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(UploadedPointsWmsServlet.class);
    public static final String UPLOAD_MAP_NAME = "uploadedPoints";
    private final String IMAGE_MIME_TYPE = "image/png";
    private static UploadedPoints points = null;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String req = request.getParameter("REQUEST");
        HttpSession session = request.getSession();
        if (session.getAttribute(UPLOAD_MAP_NAME) != null) {
            points = (UploadedPoints)session.getAttribute(UPLOAD_MAP_NAME);
        }
        if (req != null && req.equalsIgnoreCase("GetMap")) {
            String bbox = request.getParameter("BBOX");
            String width = request.getParameter("WIDTH");
            String height = request.getParameter("HEIGHT");
            CombineImageSettings settings = new CombineImageSettings();
            try {
                settings.setBbox(bbox);
                settings.setWidth(new Integer(width));
                settings.setHeight(new Integer(height));
                settings.setMimeType("image/png");
            }
            catch (Exception e) {
                throw new ServletException("Cannot make combineImageSettings: ", (Throwable)e);
            }
            ArrayList<CombineImageWkt> wkts = new ArrayList<CombineImageWkt>();
            if (points != null && points.getPoints() != null && points.getPoints().size() > 0) {
                for (Map.Entry pairs : points.getPoints().entrySet()) {
                    String label = (String)pairs.getKey();
                    String wkt = (String)pairs.getValue();
                    CombineImageWkt ciWkt = new CombineImageWkt(wkt);
                    ciWkt.setLabel(label);
                    ciWkt.setColor(Color.MAGENTA);
                    wkts.add(ciWkt);
                }
            }
            settings.setWktGeoms(wkts);
            try {
                CombineImagesHandler.combineImage((OutputStream)response.getOutputStream(), (CombineImageSettings)settings);
            }
            catch (Exception ex) {
                log.error((Object)"Fout tijdens maken tijdelijke punten: ", (Throwable)ex);
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

