/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.gis.viewer.downloads.Dispatcher;
import nl.b3p.gis.viewer.downloads.DownloadThread;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DispatcherServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(DispatcherServlet.class);
    private static ArrayList threads = new ArrayList();
    private static ArrayList finishedThreads = new ArrayList();
    private static int maxThreadLog = 300;
    private static int refreshRate = 10;
    private static int dispatcherSleepTime = 10000;
    private static int maxAliveThreads = 10;
    private static Dispatcher dispatcher = null;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            if (config.getInitParameter("maxThreadLog") != null) {
                maxThreadLog = Integer.parseInt(config.getInitParameter("maxThreadLog"));
            }
            if (config.getInitParameter("refreshRate") != null) {
                refreshRate = Integer.parseInt(config.getInitParameter("refreshRate"));
            }
            if (config.getInitParameter("dispatcherSleepTime") != null) {
                dispatcherSleepTime = Integer.parseInt(config.getInitParameter("dispatcherSleepTime"));
            }
            if (config.getInitParameter("maxAliveThreads") != null) {
                maxAliveThreads = Integer.parseInt(config.getInitParameter("dispatcherSleepTime"));
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        int priority = Thread.currentThread().getPriority();
        ThreadGroup tg = new ThreadGroup("DispatcherThreads");
        dispatcher = new Dispatcher(tg, false, priority, true);
        dispatcher.setDispatcherSleepTime(dispatcherSleepTime);
        dispatcher.setMaxAliveThreads(maxAliveThreads);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    public void destroy() {
        log.debug((Object)"DESTROY DispatcherServlet.");
        DownloadThread thread2 = null;
        List queue = dispatcher.getQueue();
        for (DownloadThread thread2 : queue) {
            if (!thread2.isAlive()) continue;
            thread2.stopThread();
        }
        dispatcher.setDispatcherActive(false);
        super.destroy();
    }

    public static Dispatcher getDispatcher() {
        return dispatcher;
    }
}

