/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.b3p.gis.utils.ConfigListsUtil;
import nl.b3p.gis.utils.KaartSelectieUtil;
import nl.b3p.gis.viewer.db.Applicatie;
import nl.b3p.gis.viewer.services.GisSecurityRealm;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.Roles;
import nl.b3p.wms.capabilities.ServiceProvider;
import nl.b3p.wms.capabilities.Style;
import nl.b3p.wms.capabilities.StyleDomainResource;
import nl.b3p.zoeker.configuratie.Bron;
import nl.b3p.zoeker.services.A11YResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.securityfilter.filter.SecurityRequestWrapper;

public class GisPrincipal
implements Principal {
    private static final Log log = LogFactory.getLog(GisPrincipal.class);
    private String name;
    private String password;
    private String code;
    private Set roles;
    private ServiceProvider sp;
    private Bron kbWfsConnectie;
    private List kbWfsFeatures;

    public GisPrincipal(String name, List roles) {
        this.name = name;
        this.roles = new HashSet();
        this.roles.addAll(roles);
    }

    public GisPrincipal(String name, String password, String code, ServiceProvider sp) {
        this.name = name;
        this.password = password;
        this.code = code;
        this.sp = sp;
        this.kbWfsConnectie = new Bron();
        this.kbWfsConnectie.setUrl(HibernateUtil.createPersonalKbUrl(code));
        this.kbWfsConnectie.setNaam(HibernateUtil.kbWfsConnectieNaam);
        this.kbWfsConnectie.setGebruikersnaam(name);
        this.kbWfsConnectie.setWachtwoord(password);
        if (sp == null) {
            return;
        }
        this.roles = new HashSet();
        Set sproles = sp.getAllRoles();
        if (sproles == null || sproles.isEmpty()) {
            return;
        }
        for (Roles role : sproles) {
            String sprole = role.getRole();
            if (sprole == null || sprole.length() <= 0) continue;
            this.roles.add(sprole);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public final boolean isInRole(String role) {
        return this.roles.contains(role);
    }

    public Set getRoles() {
        return this.roles;
    }

    public String toString() {
        return "GisPrincipal[name=" + this.name + "]";
    }

    public ServiceProvider getSp() {
        return this.sp;
    }

    public void setSp(ServiceProvider sp) {
        this.sp = sp;
    }

    public List getLayerNames(boolean legendGraphicOnly) {
        if (this.sp == null) {
            return null;
        }
        Set layers = this.sp.getAllLayers();
        if (layers == null || layers.isEmpty()) {
            return null;
        }
        ArrayList<String> allLayers = new ArrayList<String>();
        for (Layer layer : layers) {
            String name = layer.getName();
            if (name == null || name.length() <= 0 || (!legendGraphicOnly || !this.hasLegendGraphic(layer)) && legendGraphicOnly) continue;
            allLayers.add(name);
        }
        if (allLayers != null) {
            Collections.sort(allLayers);
        }
        return allLayers;
    }

    public List getLayers(boolean legendGraphicOnly, boolean nameOnly) {
        if (this.sp == null) {
            return null;
        }
        Set layers = this.sp.getAllLayers();
        if (layers == null || layers.isEmpty()) {
            return null;
        }
        ArrayList<Layer> allLayers = new ArrayList<Layer>();
        for (Layer layer : layers) {
            if ((!legendGraphicOnly || !this.hasLegendGraphic(layer)) && legendGraphicOnly || (!nameOnly || layer.getName() == null) && nameOnly) continue;
            allLayers.add(layer);
        }
        Collections.sort(allLayers);
        return allLayers;
    }

    public boolean hasLegendGraphic(Layer l) {
        return this.getLegendGraphicUrl(l, null) != null;
    }

    public String getLegendGraphicUrl(Layer l, String styleName) {
        if (l == null) {
            return null;
        }
        Set styles = l.getStyles();
        if (styles == null || styles.isEmpty()) {
            return null;
        }
        Iterator it = styles.iterator();
        String legendUrl = null;
        while (it.hasNext()) {
            Style style = (Style)it.next();
            Set ldrs = style.getDomainResource();
            if (ldrs == null || ldrs.isEmpty()) continue;
            for (StyleDomainResource sdr : ldrs) {
                if (!"LegendURL".equalsIgnoreCase(sdr.getDomain())) continue;
                legendUrl = sdr.getUrl();
                if (!(styleName == null ? style.getName().equalsIgnoreCase("default") : style.getName().equalsIgnoreCase(styleName))) continue;
                return legendUrl;
            }
        }
        return legendUrl;
    }

    public Layer getLayer(String layerName) {
        if (this.sp == null) {
            return null;
        }
        Set layers = this.sp.getAllLayers();
        if (layers == null || layers.isEmpty()) {
            return null;
        }
        for (Layer layer : layers) {
            String name = layer.getName();
            if (name == null || name.length() == 0 || !name.equalsIgnoreCase(layerName)) continue;
            return layer;
        }
        return null;
    }

    public String getLayerTitle(String layerName) {
        Layer layer = this.getLayer(layerName);
        if (layer == null) {
            return null;
        }
        return layer.getTitle();
    }

    public boolean acceptWfsFeatureType(String ftn) {
        List wfsfs = this.getKbWfsFeatures();
        if (wfsfs == null) {
            return false;
        }
        for (int i = 0; i < wfsfs.size(); ++i) {
            String[] fna = (String[])wfsfs.get(i);
            if (fna == null || fna[1] == null || !fna[1].equals(ftn)) continue;
            return true;
        }
        return false;
    }

    public static GisPrincipal getGisPrincipal(HttpServletRequest request) {
        return GisPrincipal.getGisPrincipal(request, false);
    }

    public static GisPrincipal getGisPrincipal(HttpServletRequest request, HttpServletResponse response) {
        return GisPrincipal.getGisPrincipal(request, false);
    }

    public static GisPrincipal getGisPrincipal(HttpServletRequest request, boolean flushCache) {
        HttpSession session = request.getSession();
        Principal user = request.getUserPrincipal();
        if (!(user instanceof GisPrincipal) || !(request instanceof SecurityRequestWrapper)) {
            return null;
        }
        String gpCode = null;
        String gpUsername = HibernateUtil.ANONYMOUS_USER;
        String gpPassword = null;
        GisPrincipal gp = (GisPrincipal)user;
        if (gp != null) {
            gpCode = gp.getCode();
            gpUsername = gp.getName();
            gpPassword = gp.getPassword();
        }
        String appCode = request.getParameter("appCode");
        Applicatie app = null;
        if (appCode != null && appCode.length() > 0) {
            app = KaartSelectieUtil.getApplicatie(appCode);
        }
        if (gp != null && app != null && app.getGebruikersCode() != null && !app.getGebruikersCode().equals(gp.getCode())) {
            A11YResult a11yResult = (A11YResult)session.getAttribute("a11yResult");
            session.invalidate();
            gp = null;
            gpCode = app.getGebruikersCode();
            gpUsername = HibernateUtil.ANONYMOUS_USER;
            gpPassword = null;
            SecurityRequestWrapper srw = (SecurityRequestWrapper)request;
            gp = (GisPrincipal)GisSecurityRealm.authenticate(gpUsername, gpPassword, gpCode);
            srw.setUserPrincipal((Principal)gp);
            if (a11yResult != null) {
                HttpSession newSession = request.getSession(true);
                newSession.setAttribute("a11yResult", (Object)a11yResult);
            }
            log.debug((Object)"Gebruikerscode verschilt. Automatisch ingelogd met nieuwe gebruiker.");
        }
        if (app != null && app.getGebruikersCode() == null) {
            SecurityRequestWrapper srw = (SecurityRequestWrapper)request;
            gp = (GisPrincipal)GisSecurityRealm.authenticate(gpUsername, gpPassword, gpCode);
            srw.setUserPrincipal((Principal)gp);
            log.debug((Object)"Applicatie zonder gebruikerscode. Nu ingelogd via formulier.");
        }
        return gp;
    }

    public Bron getKbWfsConnectie() {
        return this.kbWfsConnectie;
    }

    public void setKbWfsConnectie(Bron kbWfsConnectie) {
        this.kbWfsConnectie = kbWfsConnectie;
    }

    public List getKbWfsFeatures() {
        if (this.kbWfsFeatures == null) {
            try {
                this.kbWfsFeatures = ConfigListsUtil.getPossibleFeatures(this.kbWfsConnectie);
            }
            catch (Exception ex) {
                log.info((Object)("Cannot collect Kaartenbalie WFS features, cause: " + ex.getLocalizedMessage()));
                log.debug((Object)"Cannot collect Kaartenbalie WFS features, stacktrace: ", (Throwable)ex);
                this.kbWfsFeatures = new ArrayList();
            }
        }
        return this.kbWfsFeatures;
    }

    public void setKbWfsFeatures(List kbWfsFeatures) {
        this.kbWfsFeatures = kbWfsFeatures;
    }
}

