/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.b3p.gis.viewer.db.Clusters;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.ThemaData;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.db.UserKaartgroep;
import nl.b3p.gis.viewer.db.UserKaartlaag;
import nl.b3p.gis.viewer.db.UserLayer;
import nl.b3p.gis.viewer.db.UserService;
import nl.b3p.gis.viewer.services.HibernateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpatialUtil {
    private static final Log log = LogFactory.getLog(SpatialUtil.class);
    public static final String MULTIPOINT = "multipoint";
    public static final String MULTILINESTRING = "multilinestring";
    public static final String MULTIPOLYGON = "multipolygon";
    public static final List VALID_GEOMS = Arrays.asList("multipoint", "multilinestring", "multipolygon");

    public static List getValidClusters() {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        String hquery = "FROM Clusters WHERE default_cluster = false ";
        hquery = hquery + "ORDER BY belangnr, naam DESC";
        Query q = sess.createQuery(hquery);
        return q.list();
    }

    public static List getClusters() {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        String hquery = "FROM Clusters ";
        hquery = hquery + "ORDER BY belangnr, naam DESC";
        Query q = sess.createQuery(hquery);
        return q.list();
    }

    public static Clusters getDefaultCluster() {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        String hquery = "FROM Clusters WHERE default_cluster = true ";
        Query q = sess.createQuery(hquery = hquery + "ORDER BY belangnr, naam DESC");
        List cl = q.list();
        if (cl != null && cl.size() > 0) {
            return (Clusters)cl.get(0);
        }
        return null;
    }

    public static Themas getThema(String themaid) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        if (themaid == null || themaid.length() == 0) {
            return null;
        }
        Integer id = new Integer(themaid);
        Themas t = (Themas)sess.get(Themas.class, (Serializable)id);
        return t;
    }

    public static Gegevensbron getGegevensbron(String gbId) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        if (gbId == null || gbId.length() == 0) {
            return null;
        }
        Integer id = new Integer(gbId);
        Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)id);
        return gb;
    }

    public static List getValidThemas(boolean locatie) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        String hquery = "FROM Themas t LEFT JOIN FETCH t.gegevensbron ";
        hquery = hquery + "ORDER BY t.belangnr, t.naam DESC";
        Query q = sess.createQuery(hquery);
        return q.list();
    }

    public static List<ThemaData> getThemaData(Gegevensbron gb, boolean basisregel) {
        if (gb == null) {
            return new ArrayList<ThemaData>();
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        String query = "from ThemaData td where gegevensbron = :gb ";
        if (basisregel) {
            query = query + "and td.basisregel = :br ";
        }
        query = query + " order by td.dataorder, td.label";
        Query q = sess.createQuery(query);
        q.setInteger("gb", gb.getId().intValue());
        if (basisregel) {
            q.setBoolean("br", basisregel);
        }
        List themadata = q.list();
        return themadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setAttributeValue(Connection conn, String tableName, String keyName, int keyValue, String attributeName, String newValue) throws SQLException {
        if (conn == null) {
            return null;
        }
        StringBuilder sq = new StringBuilder();
        sq.append("update \"");
        sq.append(tableName);
        sq.append("\" set \"");
        sq.append(attributeName);
        sq.append("\" = ? where \"");
        sq.append(keyName);
        sq.append("\" = ? ;");
        boolean orgAutoCommit = conn.getAutoCommit();
        conn.setAutoCommit(false);
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(sq.toString());
            statement.setString(1, newValue);
            statement.setInt(2, keyValue);
            int r = statement.executeUpdate();
            if (r != 1) {
                throw new SQLException("update affects not just one row, but '" + r + "' rows!");
            }
            conn.commit();
        }
        catch (SQLException ex) {
            if (conn != null) {
                conn.rollback();
            }
            log.error((Object)"rollback, reason: ", (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ex) {
                    log.error((Object)"", (Throwable)ex);
                }
            }
        }
        conn.setAutoCommit(orgAutoCommit);
        return newValue;
    }

    public static Geometry geometrieFromText(String wktgeom, int srid) {
        WKTReader wktreader = new WKTReader(new GeometryFactory(new PrecisionModel(), srid));
        try {
            Geometry geom = wktreader.read(wktgeom);
            return geom;
        }
        catch (ParseException p) {
            log.error((Object)("Can't create geomtry from wkt: " + wktgeom), (Throwable)p);
            return null;
        }
    }

    public static List<UserKaartgroep> getUserKaartGroepen(String code) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List groepen = sess.createQuery("from UserKaartgroep where code = :code").setParameter("code", (Object)code).list();
        return groepen;
    }

    public static List<UserKaartlaag> getUserKaartLagen(String code) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List lagen = sess.createQuery("from UserKaartlaag where code = :code").setParameter("code", (Object)code).list();
        return lagen;
    }

    public static List<UserService> getUserServices(String code) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List services = sess.createQuery("from UserService where code = :code").setParameter("code", (Object)code).list();
        return services;
    }

    public static List<UserService> getValidUserServices(String code) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ArrayList<UserService> validServices = new ArrayList<UserService>();
        List services = sess.createQuery("from UserService where code = :code order by groupname").setParameter("code", (Object)code).list();
        for (UserService service : services) {
            List layers = sess.createQuery("from UserLayer where serviceid = :ser and show = :show").setParameter("ser", (Object)service).setParameter("show", (Object)true).list();
            if (layers == null || layers.size() <= 0) continue;
            validServices.add(service);
        }
        return validServices;
    }

    public static List<UserLayer> getValidUserLayers(UserService service) {
        ArrayList<UserLayer> validUserLayers = new ArrayList<UserLayer>();
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List layers = sess.createQuery("from UserLayer where serviceid = :service and show = :show order by name, title, id").setParameter("service", (Object)service).setParameter("show", (Object)true).list();
        for (UserLayer layer : layers) {
            if (layer.getParent() == null || validUserLayers.contains(layer.getParent())) continue;
            validUserLayers.add(layer.getParent());
        }
        layers.addAll(validUserLayers);
        return layers;
    }
}

