/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.downloads;

import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import nl.b3p.commons.services.SizeLimitedOutputStream;
import nl.b3p.commons.services.StreamCopy;
import nl.b3p.gis.geotools.DataStoreUtil;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.ThemaData;
import nl.b3p.gis.viewer.services.DownloadServlet;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.writers.StreamingShapeWriter;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.wfs.v1_0_0.WFS_1_0_0_DataStore;
import org.geotools.data.wfs.v1_1_0.WFS_1_1_0_DataStore;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadThread
extends Thread {
    private static final Log log = LogFactory.getLog(DownloadThread.class);
    private static final String FORMAAT_GML = "GML";
    private static final String FORMAAT_SHP = "SHP";
    private static final int BUFFER_SIZE = 8192;
    private static final String ISO_CHARSET = "ISO-8859-1";
    private static final String UTF8_CHARSET = "UTF-8";
    private static String ZIPNAME;
    private static final String EXTENSION = ".zip";
    private static final String GML_EXTENSION = ".gml";
    public static final int STATUS_NEW = 0;
    public static final int STATUS_STARTED = 1;
    public static final int STATUS_FINISHED = 2;
    public static final int STATUS_ERROR = 3;
    private static int threadCounter;
    private String email;
    private String[] uuids;
    private String wkt;
    private String formaat;
    private Integer threadStatus = 0;
    static final Logging logging;
    private String applicationPath;
    private Bron kaartenbalieBron = null;
    private final long MAX_ZIP_FILESIZE = 0x6400000L;
    public static final int MAIL_TYPE_SUCCES = 1;
    public static final int MAIL_TYPE_ERROR = 99;
    private boolean stop = false;

    public DownloadThread(ThreadGroup tg) {
        super(tg, DownloadThread.nextThreadName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.stop) {
            this.threadStatus = 1;
            Transaction tx = null;
            try {
                String zipFileName;
                Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
                tx = sess.beginTransaction();
                String downloadPath = DownloadServlet.getDownloadPath() + File.separator;
                String folder = DownloadServlet.uniqueName("");
                String folderName = downloadPath + folder;
                File workingDir = new File(folderName);
                if (!workingDir.mkdirs()) {
                    log.debug((Object)("Cannot create folder: " + workingDir.getAbsolutePath()));
                    throw new IOException("Er kan geen downloadmap worden aangemaakt!");
                }
                ZIPNAME = zipFileName = folder + EXTENSION;
                String zipFile = folderName + File.separator + zipFileName;
                ArrayList<String> erroredTitles = new ArrayList<String>();
                ArrayList<String> successTitles = new ArrayList<String>();
                for (String uuid : this.uuids) {
                    Integer gegevensbronId = new Integer(uuid);
                    Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)gegevensbronId);
                    String title = gb.getNaam();
                    log.debug((Object)("STARTED DownloadThread voor gegevensbron: " + title));
                    try {
                        if (this.getFormaat().equals(FORMAAT_SHP)) {
                            this.writeShapesToWorkingDir(workingDir, gb);
                        } else if (this.getFormaat().equals(FORMAAT_GML)) {
                            this.writeGMLToWorkingDir(workingDir, title, gb);
                        }
                        successTitles.add(title);
                    }
                    catch (Exception e) {
                        log.debug((Object)("Dataset met uuid (" + uuid + ") opgehaald met fouten: "), (Throwable)e);
                        erroredTitles.add(title);
                    }
                }
                if (this.uuids.length - erroredTitles.size() > 0) {
                    ZipOutputStream zip = null;
                    FileOutputStream fos = null;
                    SizeLimitedOutputStream limitOut = null;
                    try {
                        fos = new FileOutputStream(zipFile);
                        limitOut = new SizeLimitedOutputStream((OutputStream)fos, 0x6400000L);
                        zip = new ZipOutputStream((OutputStream)limitOut);
                        this.putDirInZip(zip, new File(workingDir.getAbsolutePath()), "");
                    }
                    finally {
                        if (zip != null) {
                            zip.close();
                        }
                        if (limitOut != null) {
                            limitOut.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                }
                String downloadLink = folder + File.separator + zipFileName;
                this.sendEmail(zipFile, downloadLink, erroredTitles, successTitles, null, 1);
                this.threadStatus = 2;
            }
            catch (Exception e) {
                log.error((Object)"Error downloading the data: ", (Throwable)e);
                ArrayList<String> extraMessages = new ArrayList<String>();
                extraMessages.add("Het downloadbestand kon worden aangemaakt, oorzaak: " + e.getLocalizedMessage());
                this.sendEmail("", "", null, null, extraMessages, 99);
                this.threadStatus = 3;
            }
            finally {
                try {
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error committing transaction, do rollback: ", (Throwable)e);
                    tx.rollback();
                }
            }
            log.debug((Object)"ENDED DownloadThread.");
        }
    }

    private boolean cleanupFeatureNeeded(SimpleFeature feature, Gegevensbron gb) {
        if (feature == null) {
            return false;
        }
        List attributeDescriptors = feature.getFeatureType().getAttributeDescriptors();
        Set themadata = gb.getThemaData();
        boolean allFound = true;
        for (AttributeDescriptor attributeDescriptor : attributeDescriptors) {
            boolean found = false;
            for (ThemaData td : themadata) {
                if (!attributeDescriptor.getLocalName().equalsIgnoreCase(td.getKolomnaam())) continue;
                found = true;
                break;
            }
            if (found) continue;
            allFound = false;
            break;
        }
        return !allFound;
    }

    private SimpleFeature cleanupFeature(SimpleFeature feature, Gegevensbron gb) {
        GeometryDescriptor gd;
        if (feature == null) {
            return feature;
        }
        Map ud = feature.getUserData();
        SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
        featureTypeBuilder.init(feature.getFeatureType());
        List oldAttributeDescriptors = feature.getFeatureType().getAttributeDescriptors();
        ArrayList attributeDescriptors = new ArrayList(oldAttributeDescriptors);
        List attributes = feature.getAttributes();
        Set themadata = gb.getThemaData();
        for (int i = 0; !(i >= attributeDescriptors.size() || (gd = feature.getFeatureType().getGeometryDescriptor()) != null && ((AttributeDescriptor)attributeDescriptors.get(i)).getLocalName().equalsIgnoreCase(gd.getLocalName())); ++i) {
            int attributeID = i;
            for (ThemaData td : themadata) {
                if (!((AttributeDescriptor)attributeDescriptors.get(i)).getLocalName().equalsIgnoreCase(td.getKolomnaam())) continue;
                attributeID = -1;
                break;
            }
            if (attributeID < 0) continue;
            attributeDescriptors.remove(attributeID);
            attributes.remove(attributeID);
        }
        featureTypeBuilder.setAttributes(attributeDescriptors);
        SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(featureTypeBuilder.buildFeatureType());
        feature = simpleFeatureBuilder.buildFeature(feature.getID(), attributes.toArray(new Object[attributes.size()]));
        feature.getUserData().putAll(ud);
        return feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeShapesToWorkingDir(File workingDir, Gegevensbron gb) throws Exception {
        Bron bron = this.getCorrectBron(gb);
        if (bron != null) {
            DataStore datastore = bron.toDatastore();
            FeatureIterator it = null;
            StreamingShapeWriter ssw = null;
            try {
                FeatureCollection fc = this.getFeatureCollection(datastore, gb);
                if (fc != null && fc.size() > 0) {
                    it = fc.features();
                    ssw = new StreamingShapeWriter(workingDir.getAbsolutePath() + File.separator);
                    boolean firstFeature = true;
                    boolean cleanupNeeded = false;
                    while (it.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)it.next();
                        if (firstFeature) {
                            cleanupNeeded = this.cleanupFeatureNeeded(feature, gb);
                            firstFeature = false;
                        }
                        if (cleanupNeeded) {
                            feature = this.cleanupFeature(feature, gb);
                        }
                        ssw.write(feature);
                    }
                }
            }
            finally {
                if (it != null) {
                    it.close();
                }
                if (datastore != null) {
                    datastore.dispose();
                }
                if (ssw != null) {
                    ssw.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGMLToWorkingDir(File workingDir, String fileName, Gegevensbron gb) throws Exception {
        Bron bron = this.getCorrectBron(gb);
        if (bron != null) {
            DataStore datastore = bron.toDatastore();
            FeatureIterator it = null;
            FileOutputStream out = null;
            String gmlFile = workingDir + File.separator + fileName + GML_EXTENSION;
            try {
                FeatureCollection fc = this.getFeatureCollection(datastore, gb);
                if (fc != null && fc.size() > 0) {
                    DefaultFeatureCollection outputFeatureCollection = new DefaultFeatureCollection();
                    out = new FileOutputStream(gmlFile);
                    GMLConfiguration configuration = new GMLConfiguration();
                    Encoder encoder = new Encoder((Configuration)configuration);
                    it = fc.features();
                    boolean cleanupNeeded = false;
                    SimpleFeature firstFeature = null;
                    if (it.hasNext()) {
                        firstFeature = (SimpleFeature)it.next();
                        cleanupNeeded = this.cleanupFeatureNeeded(firstFeature, gb);
                    }
                    if (cleanupNeeded) {
                        outputFeatureCollection.add(firstFeature);
                        while (it.hasNext()) {
                            SimpleFeature feature = (SimpleFeature)it.next();
                            feature = this.cleanupFeature(feature, gb);
                            outputFeatureCollection.add(feature);
                        }
                        encoder.encode((Object)outputFeatureCollection, GML._FeatureCollection, (OutputStream)out);
                    } else {
                        encoder.encode((Object)fc, GML._FeatureCollection, (OutputStream)out);
                    }
                }
            }
            finally {
                if (it != null) {
                    it.close();
                }
                if (datastore != null) {
                    datastore.dispose();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    private void sendEmail(String zipFile, String zipFileName, ArrayList<String> erroredTitles, ArrayList<String> successTitles, ArrayList<String> extraMessages, int mailType) {
        File zip = new File(zipFile);
        try {
            Properties properties = System.getProperties();
            String smtpHost = DownloadServlet.getSmtpHost();
            properties.put("mail.smtp.host", smtpHost);
            javax.mail.Session mailSession = javax.mail.Session.getInstance((Properties)properties, null);
            mailSession.setDebug(false);
            MimeMessage msg = new MimeMessage(mailSession);
            String contactEmail = DownloadServlet.getContactEmail();
            if (contactEmail == null) {
                throw new Exception("Instelling contact e-mail is verplicht.");
            }
            InternetAddress frmAddress = new InternetAddress(contactEmail);
            msg.setFrom((Address)frmAddress);
            InternetAddress[] toAddresses = InternetAddress.parse((String)this.getEmail());
            msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
            String onderwerp = null;
            String file = null;
            Object[] params = null;
            String remarks = this.createRemarks(successTitles, erroredTitles, extraMessages);
            String link = this.getApplicationPath() + DownloadServlet.getDownloadServletPath() + "?download=" + zipFileName;
            if (mailType == 1 && zip.exists()) {
                onderwerp = "Het downloadbestand staat klaar.";
                file = DownloadServlet.getMailDownloadSucces();
                params = new Object[]{link, remarks, contactEmail};
            } else {
                onderwerp = "Fout tijdens klaarzetten van het downloadbestand.";
                file = DownloadServlet.getMailDownloadError();
                params = new Object[]{contactEmail, remarks};
            }
            msg.setSubject(onderwerp);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedInputStream in = null;
            in = new BufferedInputStream(new FileInputStream(file), 8192);
            StreamCopy.copy((InputStream)in, (OutputStream)out);
            MessageFormat textMessage = new MessageFormat(out.toString(ISO_CHARSET), Locale.ENGLISH);
            String tekst = textMessage.format(params);
            msg.setContent((Object)tekst, "text/plain");
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            log.error((Object)"Error", (Throwable)e);
        }
    }

    private String createRemarks(ArrayList<String> successTitles, ArrayList<String> erroredTitles, ArrayList<String> extraMessages) {
        String laagStatus = "";
        if (successTitles != null && successTitles.size() > 0) {
            laagStatus = laagStatus + "\nDe volgende kaart(en) zijn klaar gezet (" + successTitles.size() + "): \n";
            for (String title : successTitles) {
                laagStatus = laagStatus + "- " + title + "\n";
            }
        }
        if (erroredTitles != null && erroredTitles.size() > 0) {
            laagStatus = laagStatus + "\nDe volgende kaart(en) is/zijn tijdelijk niet (volledig) beschikbaar (" + erroredTitles.size() + "): \n";
            for (String title : erroredTitles) {
                laagStatus = laagStatus + "- " + title + "\n";
            }
        }
        if (extraMessages != null && extraMessages.size() > 0) {
            laagStatus = laagStatus + "\nHiernaast zijn de volgende berichten beschikbaar (" + extraMessages.size() + "): \n";
            for (String message : extraMessages) {
                laagStatus = laagStatus + "- " + message + "\n";
            }
        }
        return laagStatus;
    }

    private void putDirInZip(ZipOutputStream zip, File dirFile, String rootEntity) throws IOException, Exception {
        byte[] buffer = new byte[8192];
        if (rootEntity == null) {
            rootEntity = "";
        }
        if (rootEntity.length() > 0 && rootEntity.lastIndexOf(File.separator) != rootEntity.length() - 1) {
            rootEntity = rootEntity + File.separator;
        }
        if (dirFile.exists()) {
            if (dirFile.isDirectory()) {
                File[] files = dirFile.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    int len;
                    if (files[i].isDirectory()) {
                        this.putDirInZip(zip, files[i], rootEntity + files[i].getName() + File.separator);
                        continue;
                    }
                    if (files[i].getName().equalsIgnoreCase(ZIPNAME)) continue;
                    FileInputStream is = null;
                    is = new FileInputStream(files[i]);
                    zip.putNextEntry(new ZipEntry(rootEntity + files[i].getName()));
                    while ((len = ((InputStream)is).read(buffer)) > 0) {
                        zip.write(buffer, 0, len);
                    }
                    zip.closeEntry();
                    ((InputStream)is).close();
                    log.debug((Object)("Deleting " + files[i].toString()));
                    files[i].delete();
                }
            } else {
                throw new Exception("File is not a directory");
            }
        }
        zip.closeEntry();
    }

    public void stopThread() {
        this.stop = true;
    }

    private static synchronized String nextThreadName() {
        return "DownloadKaartThread-" + threadCounter++;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFormaat() {
        return this.formaat;
    }

    public void setFormaat(String formaat) {
        this.formaat = formaat;
    }

    public String[] getUuids() {
        return this.uuids;
    }

    public void setUuids(String[] uuids) {
        this.uuids = uuids;
    }

    public Integer getThreadStatus() {
        return this.threadStatus;
    }

    public String getApplicationPath() {
        return this.applicationPath;
    }

    public void setApplicationPath(String applicationPath) {
        this.applicationPath = applicationPath;
    }

    public Bron getKaartenbalieBron() {
        return this.kaartenbalieBron;
    }

    public void setKaartenbalieBron(Bron kaartenbalieBron) {
        this.kaartenbalieBron = kaartenbalieBron;
    }

    private FeatureCollection getFeatureCollection(DataStore datastore, Gegevensbron gb) throws IOException, Exception {
        FeatureCollection fc = null;
        Geometry geom = null;
        String wktString = this.getWkt();
        if (wktString != null && !wktString.equals("")) {
            geom = DataStoreUtil.createGeomFromWKTString(wktString);
        }
        Filter geomFilter = null;
        if (geom != null) {
            geomFilter = DataStoreUtil.createIntersectFilter(gb, datastore, geom);
        }
        if (datastore instanceof WFS_1_0_0_DataStore) {
            ArrayList<String> propnames = new ArrayList<String>();
            propnames.add(gb.getAdmin_pk());
            fc = DataStoreUtil.getFeatureCollection(datastore, gb, geomFilter, propnames, null, true);
        } else if (datastore instanceof WFS_1_1_0_DataStore) {
            ArrayList<String> propnames = new ArrayList<String>();
            propnames.add(gb.getAdmin_pk());
            fc = DataStoreUtil.getFeatureCollection(datastore, gb, geomFilter, propnames, null, true);
        } else {
            String typeName = gb.getAdmin_tabel();
            SimpleFeatureSource fs = datastore.getFeatureSource(typeName);
            fc = geomFilter != null ? fs.getFeatures(geomFilter) : fs.getFeatures();
        }
        return fc;
    }

    private Bron getCorrectBron(Gegevensbron gb) {
        Bron bron = gb.getBron();
        if (bron == null && gb.getAdmin_tabel() != null && !gb.getAdmin_tabel().equals("")) {
            bron = this.getKaartenbalieBron();
        }
        return bron;
    }

    public String getWkt() {
        return this.wkt;
    }

    public void setWkt(String wkt) {
        this.wkt = wkt;
    }

    static {
        threadCounter = 1;
        logging = Logging.ALL;
    }
}

