/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.gis.viewer.downloads.RemoveFilesWithDelayThread;
import nl.b3p.gis.viewer.downloads.RemoveOldDownloads;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(DownloadServlet.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    private static HashMap<String, RemoveFilesWithDelayThread> removeThreads = new HashMap();
    private static Random rg = null;
    private static String downloadPath = null;
    private static String smtpHost = null;
    private static String contactEmail = null;
    private static String emailSuffix = null;
    private static String downloadServletPath = "/services/DownloadServlet";
    private static String mailDownloadSucces = null;
    private static String mailDownloadError = null;
    private static final int runTaskEverySeconds = 86400;
    private static final int folderAliveSeconds = 86400;
    private static String mailKaartselectie = null;
    private Timer timer = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            if (config.getInitParameter("downloadPath") != null) {
                downloadPath = config.getInitParameter("downloadPath");
            }
            if (config.getInitParameter("smtpHost") != null) {
                smtpHost = config.getInitParameter("smtpHost");
            }
            if (config.getInitParameter("contactEmail") != null) {
                contactEmail = config.getInitParameter("contactEmail");
            }
            if (config.getInitParameter("emailSuffix") != null) {
                emailSuffix = config.getInitParameter("emailSuffix");
            }
            mailDownloadSucces = this.getServletContext().getRealPath("/WEB-INF/txt/mail-download-succes.txt");
            mailDownloadError = this.getServletContext().getRealPath("/WEB-INF/txt/mail-download-error.txt");
            mailKaartselectie = this.getServletContext().getRealPath("/WEB-INF/txt/mail-kaartselectie.txt");
            long delay = 86400000L;
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new RemoveOldDownloads(downloadPath, 86400), 0L, delay);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug((Object)"DownloadServlet processRequest.");
        String downloadPath = DownloadServlet.getDownloadPath() + File.separator;
        String downloadCode = downloadPath + request.getParameter("download");
        if (downloadCode != null) {
            if (removeThreads.get(downloadCode) != null) {
                removeThreads.get(downloadCode).stopThread();
                removeThreads.remove(downloadCode);
            }
            try {
                File zipfile = new File(downloadCode);
                if (zipfile.exists()) {
                    int len;
                    byte[] buffer = new byte[8192];
                    FileInputStream fis = new FileInputStream(downloadCode);
                    response.setContentType("application/zip");
                    response.setHeader("Content-disposition", "attachment; filename=\"" + zipfile.getName() + "\";");
                    response.setContentLength((int)zipfile.length());
                    ServletOutputStream os = response.getOutputStream();
                    while ((len = fis.read(buffer)) > 0) {
                        os.write(buffer, 0, len);
                    }
                    fis.close();
                    os.flush();
                    RemoveFilesWithDelayThread removeThread = new RemoveFilesWithDelayThread(downloadCode, zipfile.getParentFile(), 3600000L, removeThreads);
                    removeThreads.put(downloadCode, removeThread);
                    removeThread.start();
                } else {
                    this.writeErrorMessage(response, "De door u opgevraagde download is verlopen, mogelijk komt dit doordat u de download reeds heeft opgehaald.");
                }
            }
            catch (IOException ioe) {
                log.error((Object)"", (Throwable)ioe);
            }
            catch (Exception e) {
                log.error((Object)"Error committing transaction, do rollback: ", (Throwable)e);
            }
        }
    }

    public void destroy() {
        log.debug((Object)"DESTROY DownloadServlet.");
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (removeThreads != null && removeThreads.size() > 0) {
            Collection<RemoveFilesWithDelayThread> threads = removeThreads.values();
            for (RemoveFilesWithDelayThread thread : threads) {
                if (!thread.isAlive()) continue;
                thread.stopThread();
            }
        }
        super.destroy();
    }

    private void writeErrorMessage(HttpServletResponse response, String message) {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = null;
        try {
            out = response.getWriter();
            out.println("<html>");
            out.println("<head>");
            out.println("<title>Download Kaart</title>");
            out.println("</head>");
            out.println("<body>");
            out.println("" + message + "");
            out.println("</body>");
            out.println("</html>");
            out.close();
        }
        catch (IOException ex) {
            log.error((Object)ex);
        }
    }

    public static String uniqueName(String extension) {
        long now = new Date().getTime();
        String val1 = Long.toString(now, 36).toUpperCase();
        if (rg == null) {
            rg = new Random();
        }
        long rnum = rg.nextInt(1000);
        String val2 = Long.toString(rnum, 36).toUpperCase();
        String thePath = "";
        return val1 + val2 + extension;
    }

    public static String getDownloadPath() {
        return downloadPath;
    }

    public static String getContactEmail() {
        return contactEmail;
    }

    public static String getSmtpHost() {
        return smtpHost;
    }

    public static String getDownloadServletPath() {
        return downloadServletPath;
    }

    public static String getMailDownloadSucces() {
        return mailDownloadSucces;
    }

    public static String getMailDownloadError() {
        return mailDownloadError;
    }

    public static String getMailKaartselectie() {
        return mailKaartselectie;
    }

    public static void setMailKaartselectie(String mailKaartselectie) {
        DownloadServlet.mailKaartselectie = mailKaartselectie;
    }

    public static String getEmailSuffix() {
        return emailSuffix;
    }

    public static void setEmailSuffix(String emailSuffix) {
        DownloadServlet.emailSuffix = emailSuffix;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

