/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.b3p.gis.utils.KaartSelectieUtil;
import nl.b3p.gis.viewer.db.Applicatie;
import nl.b3p.gis.viewer.db.Configuratie;
import nl.b3p.gis.viewer.db.CyclomediaAccount;
import nl.b3p.gis.viewer.services.HibernateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigKeeper {
    private static final Log log = LogFactory.getLog(ConfigKeeper.class);
    public static final String MAX_RESULTS = "maxResults";

    private Collection<Configuratie> getConfig(String setting) {
        if (setting == null || setting.length() == 0) {
            return null;
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List results = sess.createQuery("from Configuratie where setting = :setting ORDER BY id").setParameter("setting", (Object)setting).list();
        return results;
    }

    public Configuratie getConfiguratie(String property, String setting) {
        if (property == null || property.length() == 0 || setting == null || setting.length() == 0) {
            return null;
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List results = sess.createQuery("from Configuratie where property = :prop AND setting = :setting").setParameter("prop", (Object)property).setParameter("setting", (Object)setting).list();
        Configuratie configuratie = null;
        if (results.size() == 1) {
            configuratie = (Configuratie)results.get(0);
        }
        if (results.size() < 1) {
            configuratie = new Configuratie();
            configuratie.setProperty(property);
            configuratie.setSetting(setting);
        }
        return configuratie;
    }

    public Map<String, Object> getConfigMap(String setting, boolean fetchDefault) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        HashMap<String, Object> dbconfig = new HashMap<String, Object>();
        Collection<Configuratie> configs = this.getConfig(setting);
        if ((configs == null || configs.isEmpty()) && fetchDefault) {
            Applicatie app = KaartSelectieUtil.getDefaultApplicatie();
            if (app != null) {
                configs = this.getConfig(app.getCode());
            }
            if ((configs == null || configs.isEmpty()) && ((configs = this.getConfig("default")) == null || configs.isEmpty())) {
                ConfigKeeper.createStandardApplicationConfiguration("default");
                configs = this.getConfig("default");
            }
        }
        if (configs == null || configs.isEmpty()) {
            return null;
        }
        for (Configuratie config : configs) {
            String propval;
            String property = config.getProperty();
            String propvalObject = propval = config.getPropval();
            String type = config.getType();
            if (type != null && type.length() > 0 && propval != null) {
                Class<?> typeClass = Class.forName(type);
                Constructor<?> typeConstructor = typeClass.getConstructor(String.class);
                propvalObject = typeConstructor.newInstance(propval);
            }
            dbconfig.put(property, propvalObject);
        }
        return dbconfig;
    }

    public static void createStandardApplicationConfiguration(String appCode) {
        Configuratie cfg = null;
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        cfg = new Configuratie();
        cfg.setProperty("useCookies");
        cfg.setPropval("false");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("multipleActiveThemas");
        cfg.setPropval("true");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("dataframepopupHandle");
        cfg.setPropval("null");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("showLeftPanel");
        cfg.setPropval("false");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("autoRedirect");
        cfg.setPropval("2");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Integer");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("useSortableFunction");
        cfg.setPropval("false");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("layerDelay");
        cfg.setPropval("5000");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Integer");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("refreshDelay");
        cfg.setPropval("1000");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Integer");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("minBboxZoeken");
        cfg.setPropval("1000");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Integer");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("zoekConfigIds");
        cfg.setPropval("\"-1\"");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("zoekenAutoIdentify");
        cfg.setPropval("true");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty(MAX_RESULTS);
        cfg.setPropval("500");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Integer");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("defaultSearchRadius");
        cfg.setPropval("10000");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Integer");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("usePopup");
        cfg.setPropval("false");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("useDivPopup");
        cfg.setPropval("false");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("usePanelControls");
        cfg.setPropval("true");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("expandAll");
        cfg.setPropval("true");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("tolerance");
        cfg.setPropval("4");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Integer");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("useInheritCheckbox");
        cfg.setPropval("false");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("showLegendInTree");
        cfg.setPropval("true");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("useMouseOverTabs");
        cfg.setPropval("false");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("layoutAdminData");
        cfg.setPropval("admindata1");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("tabs");
        cfg.setPropval("\"themas\",\"legenda\"");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("planSelectieIds");
        cfg.setPropval("-1");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("showRedliningTools");
        cfg.setPropval("true");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("showBufferTool");
        cfg.setPropval("true");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("showSelectBulkTool");
        cfg.setPropval("true");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("showNeedleTool");
        cfg.setPropval("false");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("showPrintTool");
        cfg.setPropval("true");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("showLayerSelectionTool");
        cfg.setPropval("false");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("layerGrouping");
        cfg.setPropval("lg_cluster");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("popupWidth");
        cfg.setPropval("90%");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("popupHeight");
        cfg.setPropval("20%");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("popupLeft");
        cfg.setPropval("5%");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("popupTop");
        cfg.setPropval("75%");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("defaultdataframehoogte");
        cfg.setPropval("150");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("viewerType");
        cfg.setPropval("openlayers");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("viewerTemplate");
        cfg.setPropval("standalone");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("objectInfoType");
        cfg.setPropval("popup");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("treeOrder");
        cfg.setPropval("volgorde");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("tabWidth");
        cfg.setPropval("288");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Integer");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("tabWidthLeft");
        cfg.setPropval("288");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Integer");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("bagMaxBouwjaar");
        cfg.setPropval("" + Calendar.getInstance().get(1));
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Integer");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("bagMinBouwjaar");
        cfg.setPropval("1000");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Integer");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("bagMaxOpp");
        cfg.setPropval("16000");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Integer");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("bagMinOpp");
        cfg.setPropval("0");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Integer");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("bagOppAttr");
        cfg.setPropval("OPPERVLAKTE");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("bagBouwjaarAttr");
        cfg.setPropval("BOUWJAAR");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("bagGebruiksfunctieAttr");
        cfg.setPropval("GEBRUIKSFUNCTIE");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("bagGeomAttr");
        cfg.setPropval("the_geom");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("useUserWmsDropdown");
        cfg.setPropval("true");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("datasetDownload");
        cfg.setPropval("false");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("showServiceUrl");
        cfg.setPropval("false");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("activeTab");
        cfg.setPropval("themas");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("transSliderTab");
        cfg.setPropval("legenda");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        String tileRes = "3440.64,1720.32,860.16,430.08,215.04,107.52,53.76,26.88,13.44,6.72,3.36,1.68,0.84,0.42,0.21,0.105";
        cfg = new Configuratie();
        cfg.setProperty("tilingResolutions");
        cfg.setPropval(tileRes);
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("showInfoTab");
        cfg.setPropval("off");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("homeUrl");
        cfg.setPropval(null);
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("helpUrl");
        cfg.setPropval(null);
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("showGoogleMapsIcon");
        cfg.setPropval("false");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("showBookmarkIcon");
        cfg.setPropval("false");
        cfg.setSetting(appCode);
        cfg.setType("java.lang.Boolean");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("contactUrl");
        cfg.setPropval(null);
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        cfg = new Configuratie();
        cfg.setProperty("logoutUrl");
        cfg.setPropval(null);
        cfg.setSetting(appCode);
        cfg.setType("java.lang.String");
        sess.save((Object)cfg);
        sess.flush();
    }

    public CyclomediaAccount getCyclomediaAccount(String appCode) {
        CyclomediaAccount account = null;
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List results = sess.createQuery("from CyclomediaAccount where app_code = :appcode").setParameter("appcode", (Object)appCode).setMaxResults(1).list();
        if (results != null && results.size() == 1) {
            return (CyclomediaAccount)results.get(0);
        }
        return account;
    }

    public static Integer getMaxNumberOfFeatures(String appCode) {
        Applicatie app;
        Integer maximum = null;
        ConfigKeeper keeper = new ConfigKeeper();
        Configuratie cfg = keeper.getConfiguratie(MAX_RESULTS, appCode);
        if (cfg == null && (app = KaartSelectieUtil.getDefaultApplicatie()) != null && (cfg = keeper.getConfiguratie(MAX_RESULTS, appCode = app.getCode())) == null && (cfg = keeper.getConfiguratie(MAX_RESULTS, "default")) == null) {
            ConfigKeeper.createStandardApplicationConfiguration("default");
            cfg = keeper.getConfiguratie(MAX_RESULTS, "default");
        }
        if (cfg != null && cfg.getType().contains("Integer")) {
            maximum = new Integer(cfg.getPropval());
        }
        return maximum;
    }
}

