/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.utils;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.viewer.db.Applicatie;
import nl.b3p.gis.viewer.db.Clusters;
import nl.b3p.gis.viewer.db.Configuratie;
import nl.b3p.gis.viewer.db.CyclomediaAccount;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.db.UserKaartgroep;
import nl.b3p.gis.viewer.db.UserKaartlaag;
import nl.b3p.gis.viewer.db.UserLayer;
import nl.b3p.gis.viewer.db.UserLayerStyle;
import nl.b3p.gis.viewer.db.UserService;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.SpatialUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.StyleImpl;
import org.hibernate.classic.Session;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KaartSelectieUtil {
    private static final Log log = LogFactory.getLog(KaartSelectieUtil.class);

    public static void populateKaartSelectieForm(String appCode, HttpServletRequest request) throws JSONException, Exception {
        KaartSelectieUtil.setKaartlagenTree(request, appCode);
        KaartSelectieUtil.setUserServiceTrees(request, appCode);
    }

    public static String[] addDefaultOnValues(String[] defaults, String[] current) {
        ArrayList<String> col2 = new ArrayList<String>();
        col2.addAll(Arrays.asList(current));
        for (int j = 0; j < defaults.length; ++j) {
            if (col2.contains(defaults[j])) continue;
            col2.add(defaults[j]);
        }
        return col2.toArray(new String[0]);
    }

    public static void removeExistingUserKaartgroepAndUserKaartlagen(String code) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List groepen = sess.createQuery("from UserKaartgroep where code = :code").setParameter("code", (Object)code).list();
        List lagen = sess.createQuery("from UserKaartlaag where code = :code").setParameter("code", (Object)code).list();
        for (UserKaartgroep groep : groepen) {
            sess.delete((Object)groep);
        }
        for (UserKaartlaag laag : lagen) {
            sess.delete((Object)laag);
        }
    }

    public static void removeExistingConfigKeeperSettings(String appCode) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List configItems = sess.createQuery("from Configuratie where setting = :code").setParameter("code", (Object)appCode).list();
        for (Configuratie item : configItems) {
            sess.delete((Object)item);
        }
    }

    public static void resetExistingUserLayers(String code) {
        List<UserService> services = KaartSelectieUtil.getUserServices(code);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        for (UserService service : services) {
            Set userLayers = service.getUser_layers();
            for (UserLayer layer : userLayers) {
                layer.setDefault_on(null);
                layer.setShow(null);
                sess.merge((Object)layer);
            }
        }
    }

    public static void saveKaartGroepen(String appCode, String[] kaartgroepenAan, String[] kaartgroepenDefaultAan) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        for (int i = 0; i < kaartgroepenAan.length; ++i) {
            Integer clusterId = new Integer(kaartgroepenAan[i]);
            boolean defaultOn = KaartSelectieUtil.isKaartGroepDefaultOn(kaartgroepenDefaultAan, clusterId);
            UserKaartgroep groep = KaartSelectieUtil.getUserKaartGroep(appCode, clusterId);
            if (groep != null) {
                groep.setDefault_on(defaultOn);
                sess.merge((Object)groep);
                continue;
            }
            UserKaartgroep newGroep = new UserKaartgroep(appCode, clusterId, defaultOn);
            sess.save((Object)newGroep);
        }
    }

    public static void saveKaartlagen(String appCode, String[] kaartlagenAan, String[] kaartlagenDefaultAan) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        for (int j = 0; j < kaartlagenAan.length; ++j) {
            Integer themaId = new Integer(kaartlagenAan[j]);
            boolean defaultOn = KaartSelectieUtil.isKaartlaagDefaultOn(kaartlagenDefaultAan, themaId);
            UserKaartlaag laag = KaartSelectieUtil.getUserKaartlaag(appCode, themaId);
            if (laag != null) {
                laag.setDefault_on(defaultOn);
                sess.merge((Object)laag);
                continue;
            }
            UserKaartlaag newLaag = new UserKaartlaag(appCode, themaId, defaultOn);
            sess.save((Object)newLaag);
        }
    }

    public static void saveServiceLayers(String[] layersAan, String[] layersDefaultAan) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        for (int k = 0; k < layersAan.length; ++k) {
            Integer id = new Integer(layersAan[k]);
            boolean defaultOn = KaartSelectieUtil.isKaartlaagDefaultOn(layersDefaultAan, id);
            UserLayer userLayer = (UserLayer)sess.get(UserLayer.class, (Serializable)id);
            if (userLayer == null) continue;
            userLayer.setDefault_on(defaultOn);
            userLayer.setShow(true);
            sess.merge((Object)userLayer);
        }
    }

    public static void saveUserLayerStyles(String[] useLayerStyles) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        for (int m = 0; m < useLayerStyles.length; ++m) {
            String[] useStyle = useLayerStyles[m].split("@");
            Integer layerId = new Integer(useStyle[0]);
            String styleName = useStyle[1];
            if (layerId <= 0 || styleName == null) continue;
            UserLayer ul = (UserLayer)sess.get(UserLayer.class, (Serializable)layerId);
            if (styleName.equals("default")) {
                ul.setUse_style(null);
            } else {
                ul.setUse_style(styleName);
            }
            sess.merge((Object)ul);
        }
    }

    public static void saveUserLayerSldParts(String[] userLayerIds, String[] useLayerSldParts) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        for (int n = 0; n < useLayerSldParts.length; ++n) {
            String sldPart = useLayerSldParts[n];
            Integer layerId = new Integer(userLayerIds[n]);
            if (sldPart == null || layerId <= 0) continue;
            UserLayer ul = (UserLayer)sess.get(UserLayer.class, (Serializable)layerId);
            if (sldPart.equals("")) {
                ul.setSld_part(null);
            } else {
                ul.setSld_part(sldPart);
            }
            sess.merge((Object)ul);
        }
    }

    public static Applicatie getNewApplicatie() {
        Applicatie app = null;
        app = new Applicatie();
        String appCode = null;
        try {
            appCode = Applicatie.createApplicatieCode();
        }
        catch (Exception ex) {
            log.error((Object)"Fout tijdens maken Applicatie code:", (Throwable)ex);
        }
        app.setCode(appCode);
        app.setRead_only(true);
        app.setUser_copy(false);
        app.setDefault_app(false);
        app.setVersie(1);
        app.setDatum_gebruikt(new Date());
        return app;
    }

    public static Applicatie getApplicatie(String appCode) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Applicatie app = null;
        List applicaties = sess.createQuery("from Applicatie where code = :appcode").setParameter("appcode", (Object)appCode).setMaxResults(1).list();
        if (applicaties != null && applicaties.size() == 1) {
            return (Applicatie)applicaties.get(0);
        }
        log.error((Object)("Applicatie not found or more then 1 found. Appcode: " + appCode));
        return app;
    }

    public static Applicatie getDefaultApplicatie() {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Applicatie app = null;
        List applicaties = sess.createQuery("from Applicatie where default_app = :value").setParameter("value", (Object)true).setMaxResults(1).list();
        if (applicaties != null && applicaties.size() == 1) {
            return (Applicatie)applicaties.get(0);
        }
        return app;
    }

    private static void setKaartlagenTree(HttpServletRequest request, String appCode) throws JSONException, Exception {
        List ctl = SpatialUtil.getValidClusters();
        HibernateUtil.setUseKaartenbalieCluster(false);
        List themalist = KaartSelectieUtil.getValidThemas(false, ctl, request);
        Map rootClusterMap = KaartSelectieUtil.getClusterMap(themalist, ctl, null);
        GisPrincipal user = GisPrincipal.getGisPrincipal(request);
        JSONObject treeObject = null;
        if (user != null && (treeObject = KaartSelectieUtil.createJasonObject(rootClusterMap, user, appCode)) != null) {
            request.setAttribute("tree", (Object)treeObject);
        }
    }

    private static void setUserServiceTrees(HttpServletRequest request, String appCode) throws JSONException, Exception {
        ArrayList<JSONObject> servicesTrees = new ArrayList<JSONObject>();
        List<UserService> services = KaartSelectieUtil.getUserServices(appCode);
        for (UserService service : services) {
            JSONObject tree = KaartSelectieUtil.createUserServiceTree(service);
            servicesTrees.add(tree);
        }
        request.setAttribute("servicesTrees", servicesTrees);
    }

    private static JSONObject createUserServiceTree(UserService service) throws JSONException, Exception {
        JSONObject root = new JSONObject();
        root.put("id", (Object)"0");
        root.put("title", (Object)service.getGroupname());
        root.put("name", (Object)service.getGroupname());
        root.put("serviceid", (Object)service.getId());
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List ctl = sess.createQuery("from UserLayer where serviceid = :service order by name, title, id").setParameter("service", (Object)service).list();
        Map rootLayerMap = KaartSelectieUtil.getUserLayersMap(ctl, null);
        List lMaps = (List)rootLayerMap.get("sublayers");
        root.put("children", (Object)KaartSelectieUtil.getSubLayers(lMaps, null));
        return root;
    }

    private static Map getUserLayersMap(List layerList, UserLayer root) throws JSONException, Exception {
        if (layerList == null) {
            return null;
        }
        ArrayList<Map> subLayers = null;
        for (UserLayer la : layerList) {
            Map lMap;
            if (root != la.getParent() || (lMap = KaartSelectieUtil.getUserLayersMap(layerList, la)) == null || lMap.isEmpty()) continue;
            if (subLayers == null) {
                subLayers = new ArrayList<Map>();
            }
            subLayers.add(lMap);
        }
        HashMap<String, Object> lNode = new HashMap<String, Object>();
        lNode.put("sublayers", subLayers);
        lNode.put("userlayer", root);
        return lNode;
    }

    private static JSONArray getSubLayers(List subLayers, JSONArray layersArray) throws JSONException {
        if (subLayers == null) {
            return layersArray;
        }
        for (Map lMap : subLayers) {
            List subsubMaps;
            UserLayer layer = (UserLayer)lMap.get("userlayer");
            JSONObject jsonLayer = new JSONObject();
            jsonLayer.put("id", layer.getId().intValue());
            jsonLayer.put("serviceid", layer.getServiceid().getId().intValue());
            jsonLayer.put("title", (Object)layer.getTitle());
            jsonLayer.put("name", (Object)layer.getName());
            jsonLayer.put("queryable", (Object)layer.getQueryable());
            jsonLayer.put("scalehintmin", (Object)layer.getScalehint_min());
            jsonLayer.put("scalehintmax", (Object)layer.getScalehint_max());
            jsonLayer.put("use_style", (Object)layer.getUse_style());
            jsonLayer.put("sld_part", (Object)layer.getSld_part());
            jsonLayer.put("show", (Object)layer.getShow());
            jsonLayer.put("default_on", (Object)layer.getDefault_on());
            JSONArray styles = KaartSelectieUtil.getLayerStyles(layer);
            if (styles != null && styles.length() > 0) {
                jsonLayer.put("styles", (Object)styles);
            }
            if ((subsubMaps = (List)lMap.get("sublayers")) != null && !subsubMaps.isEmpty()) {
                JSONArray childrenArray = new JSONArray();
                childrenArray = KaartSelectieUtil.getSubLayers(subsubMaps, childrenArray);
                jsonLayer.put("children", (Object)childrenArray);
            }
            if (layersArray == null) {
                layersArray = new JSONArray();
            }
            layersArray.put((Object)jsonLayer);
        }
        return layersArray;
    }

    private static JSONArray getLayerStyles(UserLayer layer) throws JSONException {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List styles = sess.createQuery("from UserLayerStyle where layerid = :layer").setParameter("layer", (Object)layer).list();
        JSONArray arr = new JSONArray();
        for (UserLayerStyle uls : styles) {
            arr.put((Object)uls.getName());
        }
        return arr;
    }

    private static Map getClusterMap(List themalist, List clusterlist, Clusters rootCluster) throws JSONException, Exception {
        if (themalist == null || clusterlist == null) {
            return null;
        }
        List childrenList = KaartSelectieUtil.getThemaList(themalist, rootCluster);
        ArrayList<Map> subclusters = null;
        for (Clusters cluster : clusterlist) {
            Map clusterMap;
            if (rootCluster != cluster.getParent() || (clusterMap = KaartSelectieUtil.getClusterMap(themalist, clusterlist, cluster)) == null || clusterMap.isEmpty()) continue;
            if (subclusters == null) {
                subclusters = new ArrayList<Map>();
            }
            subclusters.add(clusterMap);
        }
        if ((childrenList == null || childrenList.isEmpty()) && (subclusters == null || subclusters.isEmpty())) {
            return null;
        }
        HashMap<String, Object> clusterNode = new HashMap<String, Object>();
        clusterNode.put("subclusters", subclusters);
        clusterNode.put("children", childrenList);
        clusterNode.put("cluster", rootCluster);
        return clusterNode;
    }

    private static List getThemaList(List themalist, Clusters rootCluster) throws JSONException, Exception {
        if (themalist == null) {
            return null;
        }
        ArrayList<Themas> children = null;
        for (Themas thema : themalist) {
            if (thema.getCluster() != rootCluster) continue;
            if (children == null) {
                children = new ArrayList<Themas>();
            }
            children.add(thema);
        }
        return children;
    }

    private static JSONObject createJasonObject(Map rootClusterMap, GisPrincipal user, String appCode) throws JSONException {
        JSONObject root = new JSONObject().put("id", (Object)"root").put("type", (Object)"root").put("title", (Object)"root");
        if (rootClusterMap == null || rootClusterMap.isEmpty()) {
            return root;
        }
        List clusterMaps = (List)rootClusterMap.get("subclusters");
        if (clusterMaps == null || clusterMaps.isEmpty()) {
            return root;
        }
        List<UserKaartgroep> groepen = KaartSelectieUtil.getUserKaartGroepen(appCode);
        List<UserKaartlaag> lagen = KaartSelectieUtil.getUserKaartLagen(appCode);
        root.put("children", (Object)KaartSelectieUtil.getSubClusters(clusterMaps, null, user, 0, groepen, lagen));
        return root;
    }

    private static JSONArray getSubClusters(List subclusterMaps, JSONArray clusterArray, GisPrincipal user, int order, List<UserKaartgroep> groepen, List<UserKaartlaag> lagen) throws JSONException {
        if (subclusterMaps == null) {
            return clusterArray;
        }
        for (Map clMap : subclusterMaps) {
            Clusters cluster = (Clusters)clMap.get("cluster");
            JSONObject jsonCluster = new JSONObject();
            if (cluster.getId() != null) {
                jsonCluster.put("id", cluster.getId().intValue());
            }
            jsonCluster.put("type", (Object)"child");
            String titel = cluster.getNaam();
            if (titel == null || titel.equals("")) {
                titel = "(geen naam opgegeven)";
            }
            jsonCluster.put("title", (Object)titel);
            jsonCluster.put("cluster", true);
            if (cluster.isExclusive_childs()) {
                jsonCluster.put("exclusive_childs", true);
            } else {
                jsonCluster.put("exclusive_childs", false);
            }
            KaartSelectieUtil.setExtraClusterProperties(jsonCluster, cluster);
            jsonCluster.put("visible", true);
            if (cluster.getMetadatalink() != null) {
                String metadatalink = cluster.getMetadatalink();
                metadatalink = metadatalink.replaceAll("%id%", "" + cluster.getId());
                jsonCluster.put("metadatalink", (Object)metadatalink);
            } else {
                jsonCluster.put("metadatalink", (Object)"#");
            }
            jsonCluster.put("groepSelected", false);
            jsonCluster.put("groupDefaultOn", false);
            for (UserKaartgroep kaartGroep : groepen) {
                if (cluster.getId().intValue() != kaartGroep.getClusterid().intValue()) continue;
                jsonCluster.put("groepSelected", true);
                if (!kaartGroep.getDefault_on().booleanValue()) continue;
                jsonCluster.put("groupDefaultOn", true);
            }
            List childrenList = (List)clMap.get("children");
            JSONArray childrenArray = new JSONArray();
            order = KaartSelectieUtil.getChildren(childrenArray, childrenList, user, order, lagen);
            List subsubclusterMaps = (List)clMap.get("subclusters");
            childrenArray = KaartSelectieUtil.getSubClusters(subsubclusterMaps, childrenArray, user, order, groepen, lagen);
            jsonCluster.put("children", (Object)childrenArray);
            if (clusterArray == null) {
                clusterArray = new JSONArray();
            }
            clusterArray.put((Object)jsonCluster);
        }
        return clusterArray;
    }

    private static int getChildren(JSONArray childrenArray, List children, GisPrincipal user, int order, List<UserKaartlaag> lagen) throws JSONException {
        if (children == null || childrenArray == null) {
            return order;
        }
        for (Themas th : children) {
            Integer themaId = th.getId();
            String ttitel = th.getNaam();
            if (ttitel == null || ttitel.equals("")) {
                ttitel = "(geen naam opgegeven)";
            }
            JSONObject jsonCluster = new JSONObject().put("id", (Object)themaId).put("type", (Object)"child").put("title", (Object)ttitel).put("cluster", false);
            jsonCluster.put("order", ++order);
            if (th.getOrganizationcodekey() != null && th.getOrganizationcodekey().length() > 0) {
                jsonCluster.put("organizationcodekey", (Object)th.getOrganizationcodekey().toUpperCase());
            } else {
                jsonCluster.put("organizationcodekey", (Object)"");
            }
            if (th.getMaptipstring() != null) {
                jsonCluster.put("maptipfield", (Object)th.getMaptipstring());
            }
            jsonCluster.put("visible", (Object)"on");
            jsonCluster.put("analyse", (Object)"off");
            if (th.isAnalyse_thema()) {
                jsonCluster.put("highlight", (Object)"on");
            } else {
                jsonCluster.put("highlight", (Object)"off");
            }
            jsonCluster.put("kaartSelected", false);
            jsonCluster.put("kaartDefaultOn", false);
            for (UserKaartlaag kaartlaag : lagen) {
                if (th.getId().intValue() != kaartlaag.getThemaid().intValue()) continue;
                jsonCluster.put("kaartSelected", true);
                if (!kaartlaag.getDefault_on().booleanValue()) continue;
                jsonCluster.put("kaartDefaultOn", true);
            }
            Clusters cluster = th.getCluster();
            if (cluster.getId() != null) {
                jsonCluster.put("clusterid", (Object)("c" + cluster.getId()));
            }
            KaartSelectieUtil.setExtraClusterProperties(jsonCluster, cluster);
            nl.b3p.wms.capabilities.Layer layer = null;
            if (th.getWms_layers_real() != null) {
                jsonCluster.put("wmslayers", (Object)th.getWms_layers_real());
                if (th.getWms_querylayers_real() != null) {
                    jsonCluster.put("wmsquerylayers", (Object)th.getWms_querylayers_real());
                }
                if (th.getWms_legendlayer_real() != null) {
                    jsonCluster.put("legendurl", (Object)user.getLegendGraphicUrl(user.getLayer(th.getWms_legendlayer_real()), th.getStyle()));
                }
                layer = user.getLayer(th.getWms_layers_real());
            } else {
                jsonCluster.put("wmslayers", (Object)th.getWms_layers());
                if (th.getWms_querylayers() != null) {
                    jsonCluster.put("wmsquerylayers", (Object)th.getWms_querylayers());
                }
                if (th.getWms_legendlayer() != null) {
                    jsonCluster.put("legendurl", (Object)user.getLegendGraphicUrl(user.getLayer(th.getWms_legendlayer()), th.getStyle()));
                }
                layer = user.getLayer(th.getWms_layers());
            }
            if (layer != null) {
                DecimalFormat formatter = new DecimalFormat("#.#####");
                double shmax = -1.0;
                try {
                    shmax = Double.parseDouble(layer.getScaleHintMax());
                }
                catch (NumberFormatException nfe) {
                    log.debug((Object)("max scale hint not valid: " + layer.getScaleHintMax()));
                }
                if (shmax > 0.0) {
                    jsonCluster.put("scalehintmax", (Object)formatter.format(shmax));
                }
                double shmin = -1.0;
                try {
                    shmin = Double.parseDouble(layer.getScaleHintMin());
                }
                catch (NumberFormatException nfe) {
                    log.debug((Object)("min scale hint not valid: " + layer.getScaleHintMin()));
                }
                if (shmin > 0.0) {
                    jsonCluster.put("scalehintmin", (Object)formatter.format(shmin));
                }
            }
            if (th.getMetadata_link() != null) {
                String metadatalink = th.getMetadata_link();
                metadatalink = metadatalink.replaceAll("%id%", "" + themaId);
                jsonCluster.put("metadatalink", (Object)metadatalink);
            } else {
                jsonCluster.put("metadatalink", (Object)"#");
            }
            childrenArray.put((Object)jsonCluster);
        }
        return order;
    }

    private static void setExtraClusterProperties(JSONObject jsonCluster, Clusters cluster) throws JSONException {
        if (cluster.isDefault_cluster()) {
            jsonCluster.put("default_cluster", true);
        } else {
            jsonCluster.put("default_cluster", false);
        }
        if (cluster.isHide_legend()) {
            jsonCluster.put("hide_legend", true);
        } else {
            jsonCluster.put("hide_legend", false);
        }
        if (cluster.isHide_tree()) {
            jsonCluster.put("hide_tree", true);
        } else {
            jsonCluster.put("hide_tree", false);
        }
        if (cluster.isBackground_cluster()) {
            jsonCluster.put("background", true);
        } else {
            jsonCluster.put("background", false);
        }
        if (cluster.isExtra_level()) {
            jsonCluster.put("extra_level", true);
        } else {
            jsonCluster.put("extra_level", false);
        }
        if (cluster.isCallable()) {
            jsonCluster.put("callable", true);
        } else {
            jsonCluster.put("callable", false);
        }
    }

    private static List getValidThemas(boolean locatie, List ctl, HttpServletRequest request) {
        List configuredThemasList = SpatialUtil.getValidThemas(locatie);
        List layersFromRoles = null;
        GisPrincipal user = GisPrincipal.getGisPrincipal(request);
        if (user != null) {
            layersFromRoles = user.getLayerNames(false);
        }
        if (layersFromRoles == null) {
            return null;
        }
        ArrayList<String> layersFound = new ArrayList<String>();
        ArrayList<Themas> checkedThemaList = new ArrayList<Themas>();
        if (configuredThemasList != null) {
            for (Themas t : configuredThemasList) {
                if (!KaartSelectieUtil.checkThemaLayers(t, layersFromRoles) && HibernateUtil.isCheckLoginKaartenbalie()) continue;
                checkedThemaList.add(t);
                layersFound.add(t.getWms_layers_real());
            }
        }
        if (!HibernateUtil.isUseKaartenbalieCluster()) {
            return checkedThemaList;
        }
        Clusters c = SpatialUtil.getDefaultCluster();
        if (c == null) {
            c = new Clusters();
            c.setNaam(HibernateUtil.getKaartenbalieCluster());
            c.setParent(null);
        }
        Iterator it = layersFromRoles.iterator();
        int tid = 100000;
        ArrayList<Themas> extraThemaList = new ArrayList<Themas>();
        while (it.hasNext()) {
            nl.b3p.wms.capabilities.Layer l;
            String layer = (String)it.next();
            if (layersFound.contains(layer) || (l = user.getLayer(layer)) == null) continue;
            Themas t = new Themas();
            t.setNaam(l.getTitle());
            t.setId(new Integer(tid++));
            if (user.hasLegendGraphic(l)) {
                t.setWms_legendlayer_real(layer);
            }
            if ("1".equalsIgnoreCase(l.getQueryable())) {
                t.setWms_querylayers_real(layer);
            }
            t.setWms_layers_real(layer);
            t.setCluster(c);
            extraThemaList.add(t);
        }
        if (extraThemaList.size() > 0) {
            if (ctl == null) {
                ctl = new ArrayList<Clusters>();
            }
            ctl.add(c);
            for (int i = 0; i < extraThemaList.size(); ++i) {
                checkedThemaList.add((Themas)extraThemaList.get(i));
            }
        }
        return checkedThemaList;
    }

    private static boolean checkThemaLayers(Themas t, List acceptableLayers) {
        if (t == null || acceptableLayers == null) {
            return false;
        }
        String wmsls = t.getWms_layers_real();
        if (wmsls == null || wmsls.length() == 0) {
            return false;
        }
        String[] wmsla = wmsls.split(",");
        for (int i = 0; i < wmsla.length; ++i) {
            if (acceptableLayers.contains(wmsla[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isKaartGroepDefaultOn(String[] kaartgroepenDefaultAan, Integer clusterId) {
        boolean defaultOn = false;
        for (int i = 0; i < kaartgroepenDefaultAan.length; ++i) {
            Integer defaultOnId = new Integer(kaartgroepenDefaultAan[i]);
            if (defaultOnId.intValue() != clusterId.intValue()) continue;
            defaultOn = true;
            break;
        }
        return defaultOn;
    }

    private static boolean isKaartlaagDefaultOn(String[] kaartlagenDefaultAan, Integer themaId) {
        boolean defaultOn = false;
        for (int i = 0; i < kaartlagenDefaultAan.length; ++i) {
            Integer defaultOnId = new Integer(kaartlagenDefaultAan[i]);
            if (defaultOnId.intValue() != themaId.intValue()) continue;
            defaultOn = true;
            break;
        }
        return defaultOn;
    }

    private static UserKaartgroep getUserKaartGroep(String code, Integer clusterId) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List groepen = sess.createQuery("from UserKaartgroep where code = :code and clusterid = :clusterid").setParameter("code", (Object)code).setParameter("clusterid", (Object)clusterId).setMaxResults(1).list();
        if (groepen != null && groepen.size() == 1) {
            return (UserKaartgroep)groepen.get(0);
        }
        return null;
    }

    private static UserKaartlaag getUserKaartlaag(String code, Integer themaId) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List groepen = sess.createQuery("from UserKaartlaag where code = :code and themaid = :themaid").setParameter("code", (Object)code).setParameter("themaid", (Object)themaId).setMaxResults(1).list();
        if (groepen != null && groepen.size() == 1) {
            return (UserKaartlaag)groepen.get(0);
        }
        return null;
    }

    private static List<UserKaartlaag> getUserKaartLagen(String code) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List lagen = sess.createQuery("from UserKaartlaag where code = :code").setParameter("code", (Object)code).list();
        return lagen;
    }

    private static List<UserKaartgroep> getUserKaartGroepen(String code) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List groepen = sess.createQuery("from UserKaartgroep where code = :code").setParameter("code", (Object)code).list();
        return groepen;
    }

    private static List<UserService> getUserServices(String code) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List services = sess.createQuery("from UserService where code = :code").setParameter("code", (Object)code).list();
        return services;
    }

    public static void removeExistingUserServices(String appCode) {
        List<UserService> services = KaartSelectieUtil.getUserServices(appCode);
        for (UserService service : services) {
            KaartSelectieUtil.removeService(service.getId());
        }
    }

    public static void removeService(Integer serviceId) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        UserService service = (UserService)sess.get(UserService.class, (Serializable)serviceId);
        sess.delete((Object)service);
    }

    public static void removeCyclomediaAccount(String appCode) {
        ConfigKeeper keeper = new ConfigKeeper();
        CyclomediaAccount cycloeAccount = keeper.getCyclomediaAccount(appCode);
        if (cycloeAccount != null) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            sess.delete((Object)cycloeAccount);
        }
    }

    public static List<Layer> getParentLayers(Layer[] layers) {
        ArrayList<Layer> parents = new ArrayList<Layer>();
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i].getChildren().length <= 0 && layers[i].getParent() != null) continue;
            parents.add(layers[i]);
        }
        return parents;
    }

    public static UserLayer createUserLayers(UserService us, Layer layer, UserLayer parent) {
        String layerTitle = layer.getTitle();
        String layerName = layer.getName();
        boolean queryable = layer.isQueryable();
        double scaleMin = layer.getScaleDenominatorMin();
        double scaleMax = layer.getScaleDenominatorMax();
        UserLayer ul = new UserLayer();
        ul.setServiceid(us);
        if (layerName != null && !layerName.equals("")) {
            ul.setName(layerName);
        }
        if (layerTitle != null && !layerTitle.equals("")) {
            ul.setTitle(layerTitle);
        }
        ul.setQueryable(queryable);
        if (scaleMin > 0.0) {
            ul.setScalehint_min(Double.toString(scaleMin));
        }
        if (scaleMax > 0.0) {
            ul.setScalehint_max(Double.toString(scaleMax));
        }
        List styles = layer.getStyles();
        for (StyleImpl style : styles) {
            String styleName = style.getName();
            if (styleName == null || styleName.equals("")) continue;
            UserLayerStyle uls = new UserLayerStyle(ul, styleName);
            ul.addStyle(uls);
        }
        if (parent != null) {
            ul.setParent(parent);
        }
        Layer[] childs = layer.getChildren();
        for (int i = 0; i < childs.length; ++i) {
            UserLayer child = KaartSelectieUtil.createUserLayers(us, childs[i], ul);
            us.addLayer(child);
        }
        return ul;
    }

    public static boolean userAlreadyHasThisService(String code, String url) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List services = sess.createQuery("from UserService where code = :code and url = :url").setParameter("code", (Object)code).setParameter("url", (Object)url).setMaxResults(1).list();
        return services != null && services.size() == 1;
    }

    public static Applicatie copyApplicatie(Applicatie sourceApp, boolean readOnly, boolean userCopy) {
        Applicatie app = new Applicatie();
        String newCode = null;
        try {
            newCode = Applicatie.createApplicatieCode();
        }
        catch (Exception ex) {
            log.error((Object)"Fout tijdens maken Applicatie code:", (Throwable)ex);
        }
        Integer versie = null;
        versie = sourceApp.getVersie() != null && userCopy ? Integer.valueOf(sourceApp.getVersie() + 1) : (sourceApp.getVersie() != null && !userCopy ? sourceApp.getVersie() : Integer.valueOf(1));
        app.setEmail(sourceApp.getEmail());
        app.setNaam(sourceApp.getNaam());
        app.setCode(newCode);
        app.setGebruikersCode(sourceApp.getGebruikersCode());
        app.setParent(null);
        app.setDatum_gebruikt(new Date());
        app.setRead_only(readOnly);
        app.setUser_copy(userCopy);
        app.setVersie(versie);
        app.setDefault_app(false);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        sess.save((Object)app);
        sess.flush();
        KaartSelectieUtil.copyConfigKeeperSettings(sourceApp.getCode(), newCode);
        KaartSelectieUtil.copyUserKaartgroepen(sourceApp.getCode(), newCode);
        KaartSelectieUtil.copyUserKaartlagen(sourceApp.getCode(), newCode);
        KaartSelectieUtil.copyCyclomediaAccount(sourceApp.getCode(), newCode);
        return app;
    }

    private static void copyConfigKeeperSettings(String oldCode, String newCode) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List configItems = sess.createQuery("from Configuratie where setting = :appcode").setParameter("appcode", (Object)oldCode).list();
        for (Configuratie item : configItems) {
            Configuratie clone = (Configuratie)item.clone();
            clone.setSetting(newCode);
            sess.save((Object)clone);
            sess.flush();
        }
    }

    private static void copyUserKaartgroepen(String oldCode, String newCode) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List groepen = sess.createQuery("from UserKaartgroep where code = :appcode").setParameter("appcode", (Object)oldCode).list();
        for (UserKaartgroep groep : groepen) {
            UserKaartgroep clone = (UserKaartgroep)groep.clone();
            clone.setCode(newCode);
            sess.save((Object)clone);
            sess.flush();
        }
    }

    private static void copyCyclomediaAccount(String oldCode, String newCode) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List groepen = sess.createQuery("from CyclomediaAccount where app_code = :appcode").setParameter("appcode", (Object)oldCode).list();
        for (CyclomediaAccount groep : groepen) {
            CyclomediaAccount clone = (CyclomediaAccount)groep.clone();
            clone.setAppCode(newCode);
            sess.save((Object)clone);
            sess.flush();
        }
    }

    private static void copyUserKaartlagen(String oldCode, String newCode) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List lagen = sess.createQuery("from UserKaartlaag where code = :appcode").setParameter("appcode", (Object)oldCode).list();
        for (UserKaartlaag laag : lagen) {
            UserKaartlaag clone = (UserKaartlaag)laag.clone();
            clone.setCode(newCode);
            sess.save((Object)clone);
            sess.flush();
        }
    }
}

