/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.utils.KaartSelectieUtil;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.db.Applicatie;
import nl.b3p.gis.viewer.db.CyclomediaAccount;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;

public class CyclomediaAction
extends ViewerCrudAction {
    private static final Log log = LogFactory.getLog(CyclomediaAction.class);
    private final String CERT_TYPE = "PKCS12";
    private final String KEY_FORMAT = "PKCS#8";
    private final String SIG_ALGORITHM = "SHA1withRSA";
    private final String URL_ENCODING = "utf-8";

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String imageId = request.getParameter("imageId");
        Applicatie app = null;
        HttpSession session = request.getSession(true);
        String appCode = (String)session.getAttribute("appCode");
        if (appCode != null && appCode.length() > 0) {
            app = KaartSelectieUtil.getApplicatie(appCode);
        }
        if (app == null) {
            app = KaartSelectieUtil.getDefaultApplicatie();
        }
        ConfigKeeper keeper = new ConfigKeeper();
        CyclomediaAccount cycloAccount = keeper.getCyclomediaAccount(app.getCode());
        if (imageId != null && !imageId.equals("") && cycloAccount != null) {
            String apiKey = cycloAccount.getApiKey();
            if (apiKey == null || apiKey.equals("")) {
                apiKey = "K3MRqDUdej4JGvohGfM5e78xaTUxmbYBqL0tSHsNWnwdWPoxizYBmjIBGHAhS3U1";
            }
            String accountId = cycloAccount.getAccountId();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            String date = df.format(new Date());
            String token = "X" + accountId + "&" + imageId + "&" + date + "Z";
            String privateBase64Key = cycloAccount.getPrivateBase64Key();
            if (privateBase64Key == null || privateBase64Key.equals("")) {
                log.error((Object)"Kon private key voor aanmaken TID niet ophalen!");
            }
            String tid = this.getTIDFromBase64EncodedString(privateBase64Key, token);
            request.setAttribute("apiKey", (Object)apiKey);
            request.setAttribute("imageId", (Object)imageId);
            request.setAttribute("tid", (Object)tid);
            StringBuilder sb = new StringBuilder("Cyclomedia globespotter aanroep: ");
            sb.append("\ntoken (X + accountId + & + imageId + & + datum + Z): ");
            sb.append(token);
            sb.append("\ntid: ");
            sb.append(tid);
            sb.append("\n");
            log.debug((Object)sb.toString());
        }
        return mapping.findForward("success");
    }

    private byte[] sign(PrivateKey privateKey, String token) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature instance = Signature.getInstance("SHA1withRSA");
        instance.initSign(privateKey);
        instance.update(token.getBytes());
        byte[] signature = instance.sign();
        return signature;
    }

    private String getTIDFromBase64EncodedString(String base64Encoded, String token) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        String tid = null;
        Base64 encoder = new Base64();
        byte[] tempBytes = encoder.decode(base64Encoded.getBytes());
        KeyFactory rsaKeyFac = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(tempBytes);
        RSAPrivateKey privKey = (RSAPrivateKey)rsaKeyFac.generatePrivate(encodedKeySpec);
        byte[] signature = this.sign(privKey, token);
        String base64 = new String(encoder.encode(signature));
        tid = URLEncoder.encode(token + "&" + base64, "utf-8");
        return tid;
    }
}

