/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.b3p.gis.viewer.BaseGisAction;
import nl.b3p.gis.viewer.UploadedPoints;
import nl.b3p.gis.viewer.ViewerCrudAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.validator.DynaValidatorForm;

public class UploadTempPointsAction
extends ViewerCrudAction {
    private static final Log logger = LogFactory.getLog(UploadTempPointsAction.class);

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        dynaForm.initialize(mapping);
        BaseGisAction.setCMSPageFromRequest(request);
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward list(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BaseGisAction.setCMSPageFromRequest(request);
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BaseGisAction.setCMSPageFromRequest(request);
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            this.addMessages(request, (ActionMessages)errors);
            return this.getAlternateForward(mapping, request);
        }
        FormFile tempFormFile = (FormFile)dynaForm.get("uploadFile");
        String csvSeparatorChar = dynaForm.getString("csvSeparatorChar");
        if (csvSeparatorChar == null || csvSeparatorChar.equals("")) {
            csvSeparatorChar = ";";
        }
        if (tempFormFile != null && !tempFormFile.getFileName().equals("")) {
            String path = this.getServlet().getServletContext().getRealPath("") + File.separatorChar + tempFormFile.getFileName();
            File serverFile = new File(path);
            serverFile.deleteOnExit();
            FileOutputStream outputStream = new FileOutputStream(serverFile);
            outputStream.write(tempFormFile.getFileData());
            UploadedPoints points = this.readCsv(path, csvSeparatorChar);
            if (points.getPoints() != null && points.getPoints().size() > 0) {
                HttpSession session = request.getSession();
                session.setAttribute("uploadedPoints", (Object)points);
            }
            tempFormFile.destroy();
        }
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    private UploadedPoints readCsv(String fileName, String csvSeparatorChar) throws FileNotFoundException, IOException {
        UploadedPoints points = new UploadedPoints();
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        Object strLine = null;
        StringTokenizer st = null;
        int lineNumber = 0;
        int tokenNumber = 0;
        while ((fileName = br.readLine()) != null) {
            ++lineNumber;
            st = new StringTokenizer(fileName, "@");
            while (st.hasMoreTokens()) {
                String[] arr;
                ++tokenNumber;
                String line = st.nextToken();
                if (lineNumber <= 1 || (arr = line.split(csvSeparatorChar)) == null || arr.length != 3) continue;
                String x = arr[0];
                String y = arr[1];
                String label = arr[2];
                points.addPoint(label, "POINT(" + x + " " + y + ")");
            }
            tokenNumber = 0;
        }
        return points;
    }
}

