/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.struts.CrudAction;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.wms.capabilities.ServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.JDBCException;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class ViewerCrudAction
extends CrudAction {
    private static Log log = LogFactory.getLog(ViewerCrudAction.class);
    protected static final String ACKNOWLEDGE_MESSAGES = "acknowledgeMessages";

    protected ActionForward getUnspecifiedAlternateForward(ActionMapping mapping, HttpServletRequest request) {
        return mapping.findForward("failure");
    }

    protected String getOrganizationCode(HttpServletRequest request) {
        GisPrincipal gp = GisPrincipal.getGisPrincipal(request);
        if (gp != null) {
            ServiceProvider sp = gp.getSp();
            if (sp != null) {
                return sp.getOrganizationCode();
            }
            log.error((Object)("Er is geen serviceprovider aanwezig bij GisPrincipal met naam: " + gp.getName()));
            return null;
        }
        log.debug((Object)"Er is geen GisPrincipal aanwezig.");
        return null;
    }

    protected void createLists(DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        String organizationcode = this.getOrganizationCode(request);
        if (organizationcode != null && organizationcode.length() > 0) {
            request.setAttribute("organizationcodekey", (Object)organizationcode);
            request.setAttribute("organizationcode", (Object)organizationcode);
        }
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = sess.getTransaction();
        tx.begin();
        ActionForward forward = null;
        String msg = null;
        try {
            forward = super.execute(mapping, form, request, response);
            tx.commit();
            return forward;
        }
        catch (Exception e) {
            tx.rollback();
            log.error((Object)"Exception occured, rollback", (Throwable)e);
            MessageResources messages = this.getResources(request);
            if (e instanceof JDBCException) {
                msg = e.toString();
                SQLException sqle = ((JDBCException)e).getSQLException();
                msg = msg + ": " + sqle;
                SQLException nextSqlE = sqle.getNextException();
                if (nextSqlE != null) {
                    msg = msg + ": " + nextSqlE;
                }
            } else if (e instanceof SQLException) {
                msg = e.toString();
                SQLException nextSqlE = ((SQLException)e).getNextException();
                if (nextSqlE != null) {
                    msg = msg + ": " + nextSqlE;
                }
            } else {
                msg = e.toString();
            }
            this.addAlternateMessage(mapping, request, null, msg);
            sess = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = sess.getTransaction();
            tx.begin();
            try {
                this.prepareMethod((DynaValidatorForm)form, request, "list", "edit");
                tx.commit();
            }
            catch (Exception e2) {
                tx.rollback();
                log.error((Object)"Exception occured in second session, rollback", (Throwable)e2);
                this.addAlternateMessage(mapping, request, null, e2.toString());
            }
            return this.getAlternateForward(mapping, request);
        }
    }
}

