/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.ThemaData;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.jdbc.JDBCDataStore;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;

public class EditFeature {
    private static final Log log = LogFactory.getLog(EditFeature.class);
    private static final String SUCCESS_PARAM = "success";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFeatureType(Integer gegevensBronId) throws JSONException {
        JSONObject json = new JSONObject();
        json.put(SUCCESS_PARAM, false);
        DataStore ds = null;
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = null;
        try {
            tx = sess.beginTransaction();
            Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)gegevensBronId);
            Bron b = gb.getBron();
            ds = b.toDatastore();
            SimpleFeatureType type = ds.getSchema(gb.getAdmin_tabel());
            Set themadata = gb.getThemaData();
            ArrayList<ThemaData> editables = new ArrayList<ThemaData>();
            ArrayList<ThemaData> readonlyAttributes = new ArrayList<ThemaData>();
            for (ThemaData themaData : themadata) {
                if (themaData.isEditable().booleanValue()) {
                    editables.add(themaData);
                    continue;
                }
                if (!themaData.isBasisregel() || themaData.getDataType().getNaam().equals("Javascript functie")) continue;
                readonlyAttributes.add(themaData);
            }
            JSONObject feat = new JSONObject();
            feat.put("featurename", (Object)gb.getNaam());
            feat.put("gegevensbronId", (Object)gb.getId());
            JSONArray vals = new JSONArray();
            for (ThemaData themaData : editables) {
                JSONObject obj = themaData.toJSON();
                AttributeDescriptor attr = type.getDescriptor(themaData.getKolomnaam());
                if (attr != null) {
                    String name = attr.getType().getBinding().getName();
                    name = name.substring(name.lastIndexOf(".") + 1);
                    obj.put("type", (Object)name);
                } else {
                    obj.put("type", (Object)"String");
                }
                vals.put((Object)obj);
            }
            feat.put("values", (Object)vals);
            JSONArray readOnlyAttrs = new JSONArray();
            for (ThemaData themaData : readonlyAttributes) {
                JSONObject obj = themaData.toJSON();
                readOnlyAttrs.put((Object)obj);
            }
            feat.put("readonly", (Object)readOnlyAttrs);
            if (gb.isGeometryeditable()) {
                GeometryDescriptor gp = type.getGeometryDescriptor();
                feat.put("geom_attribute", (Object)gp.getName().toString());
                feat.put("geom_type", (Object)this.getGeomType(gp.getType().getBinding()));
            }
            json.put("featuretype", (Object)feat);
            tx.commit();
            json.put(SUCCESS_PARAM, true);
        }
        catch (Exception ex) {
            log.error((Object)"Exception while getting the features in EditFeature.java:", (Throwable)ex);
            json.put("message", (Object)ex.getMessage());
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
        return json.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFeatureByWkt(String gegevensBronId, String wkt, Double distance) throws JSONException {
        JSONObject json = new JSONObject();
        json.put(SUCCESS_PARAM, false);
        DataStore ds = null;
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = null;
        try {
            tx = sess.beginTransaction();
            Integer gbIntId = Integer.valueOf(gegevensBronId);
            Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)gbIntId);
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            Bron b = gb.getBron();
            ds = b.toDatastore();
            SimpleFeatureType ft = ds.getSchema(gb.getAdmin_tabel());
            GeometryDescriptor gd = ft.getGeometryDescriptor();
            WKTReader reader = new WKTReader();
            Geometry g = reader.read(wkt);
            g = g.buffer(distance.doubleValue());
            Intersects filter = ff.intersects((Expression)ff.property(gd.getLocalName()), (Expression)ff.literal((Object)g));
            json = this.getEditableFeatureAttributes((Filter)filter, gb);
            tx.commit();
            json.put(SUCCESS_PARAM, true);
        }
        catch (Exception ex) {
            log.error((Object)"Exception while getting the features in EditFeature.java:", (Throwable)ex);
            json.put("message", (Object)ex.getMessage());
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
        return json.toString();
    }

    public String getFeature(String fid, String gegevensBronId) throws JSONException {
        JSONObject json = new JSONObject();
        json.put(SUCCESS_PARAM, false);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = null;
        try {
            tx = sess.beginTransaction();
            Integer gbIntId = Integer.valueOf(gegevensBronId);
            Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)gbIntId);
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            PropertyIsEqualTo filter = ff.equals((Expression)ff.property(gb.getAdmin_pk()), (Expression)ff.literal((Object)fid));
            json = this.getEditableFeatureAttributes((Filter)filter, gb);
            tx.commit();
            json.put(SUCCESS_PARAM, true);
        }
        catch (Exception ex) {
            log.error((Object)"Exception while getting the features in EditFeature.java:", (Throwable)ex);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            json.put("message", (Object)ex.getMessage());
        }
        return json.toString();
    }

    private JSONObject getEditableFeatureAttributes(Filter filter, Gegevensbron gb) throws Exception, JSONException {
        JSONObject json = new JSONObject();
        SimpleFeatureSource fs = null;
        FeatureCollection fc = null;
        DataStore ds = null;
        FeatureIterator featureIt = null;
        try {
            Bron b = gb.getBron();
            ds = b.toDatastore();
            if (!(ds instanceof JDBCDataStore)) {
                throw new Exception("DataStore not of type JDBCDataStore.");
            }
            Set themadata = gb.getThemaData();
            ArrayList<ThemaData> editables = new ArrayList<ThemaData>();
            ArrayList<ThemaData> readonlyAttributes = new ArrayList<ThemaData>();
            for (ThemaData themaData : themadata) {
                if (themaData.isEditable().booleanValue()) {
                    editables.add(themaData);
                    continue;
                }
                if (!themaData.isBasisregel() || themaData.getDataType().getNaam().equals("Javascript functie")) continue;
                readonlyAttributes.add(themaData);
            }
            fs = ds.getFeatureSource(gb.getAdmin_tabel());
            fc = fs.getFeatures(filter);
            ArrayList<Point> multiPoints = new ArrayList<Point>();
            ArrayList<LineString> multiLines = new ArrayList<LineString>();
            featureIt = fc.features();
            JSONArray features = new JSONArray();
            while (featureIt.hasNext()) {
                JSONObject obj;
                JSONObject feat = new JSONObject();
                SimpleFeature sf = (SimpleFeature)featureIt.next();
                feat.put("featurename", (Object)gb.getNaam());
                feat.put("gegevensbronId", (Object)gb.getId());
                JSONArray vals = new JSONArray();
                for (ThemaData themaData : editables) {
                    Object attr = sf.getAttribute(themaData.getKolomnaam());
                    obj = themaData.toJSON();
                    String datatype = obj.get("datatype").toString();
                    if (datatype.equalsIgnoreCase("datum")) {
                        if (attr instanceof Date) {
                            Date datum = (Date)attr;
                            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-YYYY");
                            String timestamp = dateFormat.format(datum);
                            obj.put("value", (Object)timestamp);
                        } else {
                            obj.put("value", attr);
                        }
                    } else {
                        obj.put("value", attr);
                    }
                    if (attr != null) {
                        obj.put("type", (Object)attr.getClass().getSimpleName());
                    } else {
                        obj.put("type", (Object)"String");
                    }
                    vals.put((Object)obj);
                }
                feat.put("values", (Object)vals);
                JSONArray readOnlyAttrs = new JSONArray();
                for (ThemaData themaData : readonlyAttributes) {
                    obj = themaData.toJSON();
                    if (themaData.getKolomnaam() != null) {
                        Object attr = sf.getAttribute(themaData.getKolomnaam());
                        obj.put("value", attr);
                    }
                    readOnlyAttrs.put((Object)obj);
                }
                feat.put("readonly", (Object)readOnlyAttrs);
                Object fid = sf.getAttribute(gb.getAdmin_pk());
                if (fid == null) {
                    throw new Exception("Geen identifier gevonden voor feature");
                }
                feat.put("fid", fid);
                if (gb.isGeometryeditable()) {
                    GeometryAttribute gp = sf.getDefaultGeometryProperty();
                    Geometry geom = (Geometry)gp.getValue();
                    feat.put("geom_attribute", (Object)gp.getName().toString());
                    if (geom instanceof MultiPoint) {
                        for (int i = 0; i < geom.getNumGeometries(); ++i) {
                            Point p = (Point)geom.getGeometryN(i);
                            multiPoints.add(p);
                        }
                    } else if (geom instanceof MultiLineString) {
                        for (int i = 0; i < geom.getNumGeometries(); ++i) {
                            LineString l = (LineString)geom.getGeometryN(i);
                            multiLines.add(l);
                        }
                    } else {
                        feat.put("geom", (Object)geom.toText());
                    }
                    feat.put("geom_type", (Object)this.getGeomType(gp.getType().getBinding()));
                }
                if (multiPoints != null && multiPoints.size() > 0) {
                    for (Point p : multiPoints) {
                        feat.put("geom", (Object)p.toText());
                        features.put((Object)feat);
                    }
                    continue;
                }
                if (multiLines != null && multiLines.size() > 0) {
                    for (LineString l : multiLines) {
                        feat.put("geom", (Object)l.toText());
                        features.put((Object)feat);
                    }
                    continue;
                }
                features.put((Object)feat);
            }
            json.put("features", (Object)features);
        }
        catch (IOException ex) {
            log.error((Object)"Fout bij ophalen attribuutinfo: ", (Throwable)ex);
            throw ex;
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
            featureIt.close();
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean editFeature(String json) throws JSONException {
        JSONObject feat = new JSONObject(json);
        String fid = feat.getString("fid");
        Integer gbId = feat.getInt("gegevensbronId");
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = null;
        DefaultTransaction transaction = new DefaultTransaction("edit");
        DataStore ds = null;
        try {
            tx = sess.beginTransaction();
            Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)gbId);
            Set themadata = gb.getThemaData();
            Bron b = gb.getBron();
            ds = b.toDatastore();
            if (!(ds instanceof JDBCDataStore)) {
                throw new Exception("DataStore not of type JDBCDataStore, exiting");
            }
            FeatureStore fs = (FeatureStore)ds.getFeatureSource(gb.getAdmin_tabel());
            fs.setTransaction((org.geotools.data.Transaction)transaction);
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            PropertyIsEqualTo filter = ff.equals((Expression)ff.property(gb.getAdmin_pk()), (Expression)ff.literal((Object)fid));
            JSONObject attributes = feat.getJSONObject("columns");
            JSONArray names = attributes.names();
            ArrayList<Object> values = new ArrayList<Object>();
            ArrayList<AttributeDescriptor> columns = new ArrayList<AttributeDescriptor>();
            if (names != null) {
                String mode;
                AttributeDescriptor ad;
                for (int i = 0; i < names.length(); ++i) {
                    String column = (String)names.get(i);
                    Object value = attributes.get(column);
                    AttributeDescriptor ad2 = (AttributeDescriptor)fs.getSchema().getDescriptor(column);
                    for (ThemaData themaData : themadata) {
                        String naamKolom = themaData.getKolomnaam();
                        if (naamKolom == null || !naamKolom.equalsIgnoreCase(column) || !themaData.getDataType().getNaam().equalsIgnoreCase("datum")) continue;
                        try {
                            String[] datum = value.toString().split("-");
                            String timestamp = datum[2] + "-" + datum[1] + "-" + datum[0];
                            value = timestamp + " 00:00:00";
                        }
                        catch (Exception datum) {}
                    }
                    if (ad2 == null) continue;
                    columns.add(ad2);
                    values.add(value);
                }
                Geometry g = null;
                if (feat.has("geometry_attribute") && feat.get("geometry_attribute") != null && feat.has("geom") && feat.get("geom") != null && gb.isGeometryeditable()) {
                    GeometryFactory factory;
                    int num;
                    Object geom_attr = feat.get("geometry_attribute");
                    Object geom = feat.get("geom");
                    WKTReader reader = new WKTReader();
                    g = reader.read((String)geom);
                    ad = (AttributeDescriptor)fs.getSchema().getDescriptor((String)geom_attr);
                    if (ad.getType().getBinding() == MultiPoint.class && (num = g.getNumGeometries()) == 1) {
                        factory = JTSFactoryFinder.getGeometryFactory(null);
                        Point[] points = new Point[]{(Point)g};
                        g = factory.createMultiPoint(points);
                    }
                    if (ad.getType().getBinding() == MultiLineString.class && (num = g.getNumGeometries()) == 1) {
                        factory = JTSFactoryFinder.getGeometryFactory(null);
                        LineString[] lines = new LineString[]{(LineString)g};
                        g = factory.createMultiLineString(lines);
                    }
                    values.add(g);
                    columns.add(ad);
                }
                if ((mode = feat.getString("mode")).equals("edit")) {
                    fs.modifyFeatures(columns.toArray(new AttributeDescriptor[columns.size()]), values.toArray(new Object[values.size()]), (Filter)filter);
                } else if (mode.equals("new")) {
                    SimpleFeature f = DataUtilities.template((SimpleFeatureType)((SimpleFeatureType)fs.getSchema()));
                    for (int i = 0; i < columns.size(); ++i) {
                        ad = (AttributeDescriptor)columns.get(i);
                        Object v = values.get(i);
                        f.setAttribute(ad.getName(), v);
                    }
                    if (g != null) {
                        f.setDefaultGeometry(g);
                    }
                    fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)f));
                }
            }
            tx.commit();
            transaction.commit();
        }
        catch (Exception ex) {
            log.error((Object)"Exception while getting the features in EditFeature.java:", (Throwable)ex);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            try {
                transaction.rollback();
            }
            catch (IOException e) {
                log.error((Object)"Can't rollback geotools transaction:", (Throwable)e);
                Boolean b = false;
                return b;
            }
            Boolean bl = false;
            return bl;
        }
        finally {
            try {
                transaction.close();
                ds.dispose();
            }
            catch (IOException ex) {
                log.error((Object)"Can't close geotools transaction:", (Throwable)ex);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean removeFeature(String json) throws JSONException {
        JSONObject feat = new JSONObject(json);
        String fid = Integer.toString(feat.getInt("fid"));
        Integer gbId = feat.getInt("gegevensbronId");
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = null;
        DefaultTransaction transaction = new DefaultTransaction("edit");
        DataStore ds = null;
        try {
            tx = sess.beginTransaction();
            Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)gbId);
            Bron b = gb.getBron();
            ds = b.toDatastore();
            if (!(ds instanceof JDBCDataStore)) {
                throw new Exception("DataStore not of type JDBCDataStore, exiting");
            }
            FeatureStore fs = (FeatureStore)ds.getFeatureSource(gb.getAdmin_tabel());
            fs.setTransaction((org.geotools.data.Transaction)transaction);
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            PropertyIsEqualTo filter = ff.equals((Expression)ff.property(gb.getAdmin_pk()), (Expression)ff.literal((Object)fid));
            fs.removeFeatures((Filter)filter);
            tx.commit();
            transaction.commit();
        }
        catch (Exception ex) {
            log.error((Object)"Exception while getting the features in EditFeature.java:", (Throwable)ex);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            try {
                transaction.rollback();
            }
            catch (IOException e) {
                log.error((Object)"Can't rollback geotools transaction:", (Throwable)e);
                Boolean fs = false;
                return fs;
            }
            Boolean bl = false;
            return bl;
        }
        finally {
            try {
                transaction.close();
                ds.dispose();
            }
            catch (IOException ex) {
                log.error((Object)"Can't close geotools transaction:", (Throwable)ex);
            }
        }
        return true;
    }

    private String getGeomType(Class clazz) {
        String type = "";
        if (MultiPolygon.class == clazz || Polygon.class == clazz) {
            type = "Polygon";
        } else if (MultiPoint.class == clazz || Point.class == clazz) {
            type = "Point";
        } else if (MultiLineString.class == clazz || LineString.class == clazz) {
            type = "LineString";
        }
        return type;
    }
}

