/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.lang.reflect.Method;
import nl.b3p.gis.viewer.services.HibernateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.AjaxFilterChain;
import org.directwebremoting.annotations.GlobalFilter;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

@GlobalFilter
public class DwrTransactionFilter
implements AjaxFilter {
    private static final Log log = LogFactory.getLog(DwrTransactionFilter.class);

    public Object doFilter(Object obj, Method method, Object[] params, AjaxFilterChain chain) throws Exception {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction t = null;
        try {
            t = sess.beginTransaction();
            Object ret = chain.doFilter(obj, method, params);
            if (t != null && t.isActive()) {
                t.commit();
            }
            Object object = ret;
            return object;
        }
        catch (Exception e) {
            log.error((Object)("Exception occured during DWR call" + (t.isActive() ? ", rolling back transaction" : " - no transaction active")), (Throwable)e);
            if (t.isActive()) {
                try {
                    t.rollback();
                }
                catch (Exception e2) {
                    log.error((Object)"Exception rolling back transaction", (Throwable)e2);
                }
            }
            throw e;
        }
        finally {
            if (sess.isOpen()) {
                sess.close();
            }
        }
    }
}

