/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.gis.viewer.ConfigThemaAction;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.db.Clusters;
import nl.b3p.gis.viewer.services.HibernateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.classic.Session;

public class ConfigClusterAction
extends ViewerCrudAction {
    private static final Log log = LogFactory.getLog(ConfigThemaAction.class);
    protected static final String HASTHEMAS_ERROR_KEY = "error.hasthemas";
    protected static final String HASCHILDCLUSTER_ERROR_KEY = "error.haschildcluster";

    protected Clusters getCluster(DynaValidatorForm form, boolean createNew) {
        Integer id = FormUtils.StringToInteger((String)form.getString("clusterID"));
        Clusters c = null;
        if (id == null && createNew) {
            c = new Clusters();
        } else if (id != null) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            c = (Clusters)sess.get(Clusters.class, (Serializable)id);
        }
        return c;
    }

    protected Clusters getFirstCluster() {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List cs = sess.createQuery("from Clusters order by naam").setMaxResults(1).list();
        if (cs != null && cs.size() > 0) {
            return (Clusters)cs.get(0);
        }
        return null;
    }

    protected void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
        super.createLists(form, request);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        request.setAttribute("allClusters", (Object)sess.createQuery("from Clusters order by naam").list());
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Clusters c = this.getCluster(dynaForm, false);
        if (c == null) {
            c = this.getFirstCluster();
        }
        this.populateClustersForm(c, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward edit(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Clusters c = this.getCluster(dynaForm, false);
        if (c == null) {
            c = this.getFirstCluster();
        }
        this.populateClustersForm(c, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            this.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        Clusters c = this.getCluster(dynaForm, true);
        if (c == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        this.populateClustersObject(dynaForm, c, request);
        sess.saveOrUpdate((Object)c);
        sess.flush();
        sess.refresh((Object)c);
        this.populateClustersForm(c, dynaForm, request);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Clusters c = this.getCluster(dynaForm, false);
        if (c == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        int themaSize = c.getThemas().size();
        int childrenSize = c.getChildren().size();
        if (themaSize > 0) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, HASTHEMAS_ERROR_KEY);
            return this.getAlternateForward(mapping, request);
        }
        if (childrenSize > 0) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, HASCHILDCLUSTER_ERROR_KEY);
            return this.getAlternateForward(mapping, request);
        }
        sess.delete((Object)c);
        sess.flush();
        dynaForm.initialize(mapping);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    private void populateClustersForm(Clusters c, DynaValidatorForm dynaForm, HttpServletRequest request) {
        if (c == null) {
            return;
        }
        dynaForm.set("clusterID", (Object)Integer.toString(c.getId()));
        dynaForm.set("naam", (Object)c.getNaam());
        dynaForm.set("omschrijving", (Object)c.getOmschrijving());
        dynaForm.set("belangnr", (Object)FormUtils.IntToString((int)c.getBelangnr()));
        dynaForm.set("metadatalink", (Object)c.getMetadatalink());
        dynaForm.set("default_cluster", (Object)new Boolean(c.isDefault_cluster()));
        dynaForm.set("hide_legend", (Object)new Boolean(c.isHide_legend()));
        dynaForm.set("hide_tree", (Object)new Boolean(c.isHide_tree()));
        dynaForm.set("background_cluster", (Object)new Boolean(c.isBackground_cluster()));
        dynaForm.set("extra_level", (Object)new Boolean(c.isExtra_level()));
        dynaForm.set("callable", (Object)new Boolean(c.isCallable()));
        dynaForm.set("default_visible", (Object)new Boolean(c.isDefault_visible()));
        String val = "";
        if (c.getParent() != null) {
            val = Integer.toString(c.getParent().getId());
        }
        dynaForm.set("parentID", (Object)val);
    }

    private void populateClustersObject(DynaValidatorForm dynaForm, Clusters c, HttpServletRequest request) {
        c.setNaam(FormUtils.nullIfEmpty((String)dynaForm.getString("naam")));
        c.setOmschrijving(FormUtils.nullIfEmpty((String)dynaForm.getString("omschrijving")));
        if (dynaForm.getString("belangnr") != null && dynaForm.getString("belangnr").length() > 0) {
            c.setBelangnr(Integer.parseInt(dynaForm.getString("belangnr")));
        }
        c.setMetadatalink(FormUtils.nullIfEmpty((String)dynaForm.getString("metadatalink")));
        Boolean b = (Boolean)dynaForm.get("default_cluster");
        c.setDefault_cluster(b == null ? false : b);
        b = (Boolean)dynaForm.get("hide_legend");
        c.setHide_legend(b == null ? false : b);
        b = (Boolean)dynaForm.get("hide_tree");
        c.setHide_tree(b == null ? false : b);
        b = (Boolean)dynaForm.get("background_cluster");
        c.setBackground_cluster(b == null ? false : b);
        b = (Boolean)dynaForm.get("extra_level");
        c.setExtra_level(b == null ? false : b);
        b = (Boolean)dynaForm.get("callable");
        c.setCallable(b == null ? false : b);
        b = (Boolean)dynaForm.get("default_visible");
        c.setDefault_visible(b == null ? false : b);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        String parentID = FormUtils.nullIfEmpty((String)dynaForm.getString("parentID"));
        if (parentID != null) {
            int mId = 0;
            try {
                mId = Integer.parseInt(dynaForm.getString("parentID"));
            }
            catch (NumberFormatException ex) {
                log.error((Object)"Illegal parent id", (Throwable)ex);
            }
            Clusters m = (Clusters)sess.get(Clusters.class, (Serializable)new Integer(mId));
            c.setParent(m);
        } else {
            c.setParent(null);
        }
    }
}

