/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.zoeker.configuratie.Bron;
import nl.b3p.zoeker.configuratie.ZoekConfiguratie;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.DynaValidatorForm;
import org.geotools.data.DataStore;
import org.hibernate.classic.Session;

public class ConfigConnectieAction
extends ViewerCrudAction {
    private static final Log logger = LogFactory.getLog(ConfigConnectieAction.class);
    protected static final String FK_PARENTBRON_ERROR_KEY = "error.fk.parentbron";
    protected static final String FK_GEGEVENSBRON_ERROR_KEY = "error.fk.gegevensbron";

    protected Bron getConnectie(DynaValidatorForm form, boolean createNew) {
        Integer id = FormUtils.StringToInteger((String)form.getString("bronId"));
        Bron c = null;
        if (id == null && createNew) {
            c = new Bron();
        } else if (id != null) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            c = (Bron)sess.get(Bron.class, (Serializable)id);
        }
        return c;
    }

    protected Bron getFirstConnectie() {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List cs = sess.createQuery("from Bron order by naam").setMaxResults(1).list();
        if (cs != null && cs.size() > 0) {
            return (Bron)cs.get(0);
        }
        return null;
    }

    protected void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
        super.createLists(form, request);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List alleBronnen = sess.createQuery("from Bron order by naam").list();
        request.setAttribute("allConnecties", (Object)alleBronnen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkValidBron(Bron b, HttpServletRequest request) {
        ArrayList<Integer> validBronIds = new ArrayList<Integer>();
        DataStore ds = null;
        try {
            String[] typeNames;
            ds = b.toDatastore();
            if (ds != null && (typeNames = ds.getTypeNames()) != null && typeNames.length > 0) {
                validBronIds.add(b.getId());
            }
        }
        catch (SocketTimeoutException stoex) {
            logger.error((Object)("Socket Timeout for bron url: " + b.getUrl()));
        }
        catch (FileNotFoundException ex) {
            logger.debug((Object)("Kon tijdens bewerken van bron " + b.getNaam() + " de GetCapabilities niet ophalen."));
        }
        catch (Exception e) {
            logger.error((Object)("Exception for bron: " + b.getId() + " URL: " + b.getUrl()), (Throwable)e);
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
        request.setAttribute("validBronIds", validBronIds);
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Bron c = this.getConnectie(dynaForm, false);
        if (c == null) {
            c = this.getFirstConnectie();
        }
        this.populateConnectieForm(c, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward edit(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Bron c = this.getConnectie(dynaForm, false);
        if (c == null) {
            c = this.getFirstConnectie();
        }
        this.populateConnectieForm(c, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            this.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        Bron c = this.getConnectie(dynaForm, true);
        if (c == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        this.populateConnectieObject(dynaForm, c, request);
        sess.saveOrUpdate((Object)c);
        sess.flush();
        sess.refresh((Object)c);
        this.populateConnectieForm(c, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = null;
        Bron c = null;
        try {
            sess = HibernateUtil.getSessionFactory().getCurrentSession();
            c = this.getConnectie(dynaForm, false);
            if (c == null) {
                this.prepareMethod(dynaForm, request, "edit", "list");
                this.addAlternateMessage(mapping, request, "error.notfound");
                return this.getAlternateForward(mapping, request);
            }
            List zoekConfigs = sess.createQuery("from ZoekConfiguratie where  parentbron = :bron").setParameter("bron", (Object)c).list();
            if (zoekConfigs != null && zoekConfigs.size() > 0) {
                Iterator iter = zoekConfigs.iterator();
                String zcNamen = "";
                while (iter.hasNext()) {
                    ZoekConfiguratie zc = (ZoekConfiguratie)iter.next();
                    if (zc.getNaam() != null) {
                        if (zcNamen.length() < 1) {
                            zcNamen = zcNamen + zc.getNaam();
                            continue;
                        }
                        zcNamen = zcNamen + ", " + zc.getNaam();
                        continue;
                    }
                    if (zcNamen.length() < 1) {
                        zcNamen = zcNamen + zc.getFeatureType();
                        continue;
                    }
                    zcNamen = zcNamen + ", " + zc.getFeatureType();
                }
                logger.error((Object)("Kon bron " + c.getNaam() + " niet verwijderen. Er is nog een" + " zoekconfiguratie aan gekoppeld."));
                MessageResources msg = this.getResources(request);
                Locale locale = this.getLocale(request);
                String melding = msg.getMessage(locale, FK_PARENTBRON_ERROR_KEY, (Object)zcNamen);
                this.prepareMethod(dynaForm, request, "edit", "list");
                this.addAlternateMessage(mapping, request, null, melding);
                return this.getAlternateForward(mapping, request);
            }
            List gegevensbronen = sess.createQuery("from Gegevensbron where bron = :bron").setParameter("bron", (Object)c).list();
            if (gegevensbronen != null && gegevensbronen.size() > 0) {
                Iterator iter = gegevensbronen.iterator();
                String gbNamen = "";
                while (iter.hasNext()) {
                    Gegevensbron gb = (Gegevensbron)iter.next();
                    if (gb.getNaam() == null) continue;
                    if (gbNamen.length() < 1) {
                        gbNamen = gbNamen + gb.getNaam();
                        continue;
                    }
                    gbNamen = gbNamen + ", " + gb.getNaam();
                }
                logger.error((Object)("Kon bron " + c.getNaam() + " niet verwijderen. Er is nog een" + " gegevensbron aan gekoppeld."));
                MessageResources msg = this.getResources(request);
                Locale locale = this.getLocale(request);
                String melding = msg.getMessage(locale, FK_GEGEVENSBRON_ERROR_KEY, (Object)gbNamen);
                this.prepareMethod(dynaForm, request, "edit", "list");
                this.addAlternateMessage(mapping, request, null, melding);
                return this.getAlternateForward(mapping, request);
            }
            sess.delete((Object)c);
            sess.flush();
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.exception");
            return this.getAlternateForward(mapping, request);
        }
        Bron bron = this.getFirstConnectie();
        if (bron != null) {
            this.populateConnectieForm(bron, dynaForm, request);
        } else {
            dynaForm.initialize(mapping);
        }
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    private void populateConnectieForm(Bron c, DynaValidatorForm dynaForm, HttpServletRequest request) {
        if (c == null) {
            return;
        }
        dynaForm.set("bronId", (Object)Integer.toString(c.getId()));
        dynaForm.set("naam", (Object)c.getNaam());
        dynaForm.set("url", (Object)c.getUrl());
        dynaForm.set("gebruikersnaam", (Object)c.getGebruikersnaam());
        dynaForm.set("wachtwoord", (Object)c.getWachtwoord());
        if (c.getVolgorde() != null) {
            dynaForm.set("volgorde", (Object)c.getVolgorde().toString());
        }
    }

    private void populateConnectieObject(DynaValidatorForm dynaForm, Bron c, HttpServletRequest request) {
        if (FormUtils.nullIfEmpty((String)dynaForm.getString("bronId")) != null) {
            c.setId(new Integer(dynaForm.getString("bronId")));
        }
        c.setNaam(FormUtils.nullIfEmpty((String)dynaForm.getString("naam")));
        c.setUrl(FormUtils.nullIfEmpty((String)dynaForm.getString("url")));
        c.setGebruikersnaam(FormUtils.nullIfEmpty((String)dynaForm.getString("gebruikersnaam")));
        String wachtwoord = FormUtils.nullIfEmpty((String)dynaForm.getString("wachtwoord"));
        c.setWachtwoord(wachtwoord);
        if (FormUtils.nullIfEmpty((String)dynaForm.getString("volgorde")) != null) {
            c.setVolgorde(new Integer(dynaForm.getString("volgorde")));
        }
    }
}

