/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.zoekconfiguratie;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.gis.viewer.ConfigZoekConfiguratieAction;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.db.ZoekconfiguratieThemas;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.zoekconfiguratie.ZoekConfiguratieListUtil;
import nl.b3p.zoeker.configuratie.Bron;
import nl.b3p.zoeker.configuratie.ResultaatAttribuut;
import nl.b3p.zoeker.configuratie.ZoekAttribuut;
import nl.b3p.zoeker.configuratie.ZoekConfiguratie;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardZoekConfiguratieAction
extends ViewerCrudAction {
    private static final Log log = LogFactory.getLog(ConfigZoekConfiguratieAction.class);
    private static final String BRONID = "bronId";
    private static final String FEATURETYPE = "featureType";
    private static final String PARENTZOEKCONFIGURATIE = "parentZoekConfiguratie";
    private static final String ZOEKCONFIGURATIEID = "zoekConfiguratieId";
    public static final String STEP1 = "step1";
    public static final String STEP2 = "step2";
    public static final String STEP3 = "step3";
    public static final String STEP4 = "step4";
    public static final String STEP5 = "step5";
    public static final String SAVESTEP5 = "saveStep5";
    public static final String WIZARDDONE = "wizardDone";
    protected static final String ERROR_ZOEKVELD_RELATION = "error.zoekveld.relation";

    protected Map getActionMethodPropertiesMap() {
        Map map = super.getActionMethodPropertiesMap();
        ExtendedMethodProperties crudProp = new ExtendedMethodProperties(STEP1);
        crudProp.setDefaultForwardName(STEP1);
        crudProp.setAlternateForwardName("failure");
        map.put(STEP1, crudProp);
        crudProp = new ExtendedMethodProperties(STEP2);
        crudProp.setDefaultForwardName(STEP2);
        crudProp.setAlternateForwardName("failure");
        map.put(STEP2, crudProp);
        crudProp = new ExtendedMethodProperties(STEP3);
        crudProp.setDefaultForwardName(STEP3);
        crudProp.setAlternateForwardName("failure");
        map.put(STEP3, crudProp);
        crudProp = new ExtendedMethodProperties(STEP5);
        crudProp.setDefaultForwardName(STEP5);
        crudProp.setAlternateForwardName("failure");
        map.put(STEP5, crudProp);
        crudProp = new ExtendedMethodProperties(SAVESTEP5);
        crudProp.setDefaultForwardName(SAVESTEP5);
        crudProp.setAlternateForwardName("failure");
        map.put(SAVESTEP5, crudProp);
        crudProp = new ExtendedMethodProperties(WIZARDDONE);
        crudProp.setDefaultForwardName(WIZARDDONE);
        crudProp.setAlternateForwardName("failure");
        map.put(WIZARDDONE, crudProp);
        return map;
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List bronnen = sess.createCriteria(Bron.class).list();
        request.setAttribute("bronnen", (Object)bronnen);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (FormUtils.nullIfEmpty((String)request.getParameter(ZOEKCONFIGURATIEID)) != null) {
            Integer id = new Integer(request.getParameter(ZOEKCONFIGURATIEID));
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            Object zc = sess.get(ZoekConfiguratie.class, (Serializable)id);
            if (zc != null) {
                int size;
                List themas;
                List velden;
                ZoekConfiguratie zoekConfiguratie = (ZoekConfiguratie)zc;
                String message = "";
                List parents = sess.createQuery("from ZoekConfiguratie z where z.parentZoekConfiguratie=:zc").setParameter("zc", zc).list();
                if (parents != null && parents.size() > 0) {
                    message = message + "De zoekconfiguratie(s) ";
                    for (ZoekConfiguratie zoekConfig : parents) {
                        message = message + " : " + zoekConfig.getNaam();
                    }
                    message = message + ", hebben de " + zoekConfiguratie.getNaam() + " zoeker nog als vervolgzoeker ingesteld. ";
                }
                if ((velden = sess.createQuery("from ZoekAttribuut zv where zv.zoekConfiguratie != :zcId1 AND zv.inputzoekconfiguratie = :zcId2").setParameter("zcId1", zc).setParameter("zcId2", zc).list()) != null && velden.size() > 0) {
                    message = message + "In de zoekconfiguratie(s) ";
                    for (ZoekAttribuut za : velden) {
                        message = message + " : " + za.getZoekConfiguratie().getNaam();
                    }
                    message = message + ", wordt de " + zoekConfiguratie.getNaam() + " zoeker nog als input voor een zoekveld gebruikt.";
                }
                if ((themas = sess.createQuery("from ZoekconfiguratieThemas where zoekconfiguratie = :zoeker").setParameter("zoeker", (Object)zoekConfiguratie).list()) != null && themas.size() > 0) {
                    message = message + "In de zoekconfiguratie " + zoekConfiguratie.getNaam() + ", worden de kaartlagen ";
                    for (ZoekconfiguratieThemas zt : themas) {
                        message = message + " : " + zt.getThema().getNaam();
                    }
                    message = message + " nog gekoppeld aan de zoekingang.";
                }
                if ((size = parents.size() + velden.size() + themas.size()) > 0) {
                    this.addAlternateMessage(mapping, request, ERROR_ZOEKVELD_RELATION, message);
                    return this.step2(mapping, dynaForm, request, response);
                }
                sess.delete(zc);
                sess.flush();
            } else {
                this.addAlternateMessage(mapping, request, "error.exception", "Kan opgegeven zoekconfiguratie niet vinden.");
            }
        }
        return mapping.findForward(WIZARDDONE);
    }

    public ActionForward step1(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (FormUtils.nullIfEmpty((String)request.getParameter(BRONID)) == null) {
            return this.step2(mapping, dynaForm, request, response);
        }
        if ("new".equalsIgnoreCase(request.getParameter(BRONID))) {
            ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("wizardCreateBron"));
            return redirect;
        }
        Bron bron = this.getAndSetBron(request);
        String[] types = ZoekConfiguratieListUtil.getTypeNames(bron, true);
        request.setAttribute("featureTypes", (Object)types);
        return mapping.findForward(STEP2);
    }

    public ActionForward step2(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ZoekConfiguratie zc = this.getAndSetZoekConfiguratie(request);
        Bron bron = null;
        String featureType = null;
        if (zc != null) {
            request.setAttribute(ZOEKCONFIGURATIEID, (Object)zc.getId());
            bron = zc.getBron();
            if (zc.getBron() != null) {
                request.setAttribute(BRONID, (Object)bron.getId());
            }
            request.setAttribute("naam", (Object)zc.getNaam());
            if (zc.getParentZoekConfiguratie() != null) {
                request.setAttribute(PARENTZOEKCONFIGURATIE, (Object)zc.getParentZoekConfiguratie().getId());
            }
            if (!zc.isResultListDynamic()) {
                request.setAttribute("usecaching", (Object)"1");
            }
            request.setAttribute("omschrijving", (Object)zc.getOmschrijving());
            request.setAttribute("selectedUsage", (Object)zc.getForUsageIn());
            featureType = zc.getFeatureType();
        } else {
            bron = this.getAndSetBron(request);
            if (bron != null) {
                featureType = FormUtils.nullIfEmpty((String)request.getParameter(FEATURETYPE));
            }
            request.setAttribute("selectedUsage", (Object)"viewer_webr");
        }
        HashMap<String, String> forUsageMap = new HashMap<String, String>();
        forUsageMap.put("viewer_webr", "Viewer en webrichtlijnen");
        forUsageMap.put("viewer", "Alleen viewer");
        forUsageMap.put("webr", "Alleen webrichtlijnen");
        request.setAttribute("forUsageMap", forUsageMap);
        request.setAttribute(FEATURETYPE, (Object)featureType);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        String queryString = "from ZoekConfiguratie z LEFT JOIN FETCH z.parentZoekConfiguratie LEFT JOIN FETCH z.parentBron";
        if (zc != null) {
            queryString = queryString + " where z.id != " + zc.getId();
        }
        List zoekconfiguraties = sess.createQuery(queryString).list();
        request.setAttribute("zoekConfiguraties", (Object)zoekconfiguraties);
        return mapping.findForward(STEP3);
    }

    public ActionForward step3(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ZoekConfiguratie zc = this.getAndSetZoekConfiguratie(request);
        Bron bron = null;
        String featureType = null;
        String naam = null;
        if (zc != null) {
            bron = zc.getBron();
            featureType = zc.getFeatureType();
            naam = zc.getNaam() == null || zc.getNaam().equals("") ? FormUtils.nullIfEmpty((String)request.getParameter("naam")) : zc.getNaam();
        } else {
            bron = this.getAndSetBron(request);
            if (bron != null) {
                featureType = FormUtils.nullIfEmpty((String)request.getParameter(FEATURETYPE));
            }
            naam = FormUtils.nullIfEmpty((String)request.getParameter("naam"));
        }
        if (bron != null && featureType == null) {
            this.addAlternateMessage(mapping, request, "error.exception", "De zoekingang heeft geen tabel/feature. Selecteer een tabel/feature.");
            return this.step1(mapping, dynaForm, request, response);
        }
        if (naam == null) {
            this.addAlternateMessage(mapping, request, "error.exception", "Geef een naam op voor deze zoekingang.");
            return this.step2(mapping, dynaForm, request, response);
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        if (zc == null) {
            zc = new ZoekConfiguratie();
        }
        if (FormUtils.StringToInteger((String)request.getParameter(PARENTZOEKCONFIGURATIE)) != null) {
            Integer parentId = FormUtils.StringToInteger((String)request.getParameter(PARENTZOEKCONFIGURATIE));
            ZoekConfiguratie parent = (ZoekConfiguratie)sess.get(ZoekConfiguratie.class, (Serializable)parentId);
            zc.setParentZoekConfiguratie(parent);
        } else if (request.getParameter(PARENTZOEKCONFIGURATIE) != null) {
            zc.setParentZoekConfiguratie(null);
        }
        if (FormUtils.nullIfEmpty((String)request.getParameter("naam")) != null) {
            zc.setNaam(request.getParameter("naam"));
        }
        zc.setParentBron(bron);
        zc.setFeatureType(featureType);
        String useCaching = FormUtils.nullIfEmpty((String)request.getParameter("usecaching"));
        if (useCaching != null) {
            zc.setResultListDynamic(false);
            request.setAttribute("usecaching", (Object)"1");
        } else {
            zc.setResultListDynamic(true);
        }
        if (request.getParameter("omschrijving") != null) {
            zc.setOmschrijving(request.getParameter("omschrijving"));
        }
        if (request.getParameter("forUsageIn") != null) {
            zc.setForUsageIn(request.getParameter("forUsageIn"));
        }
        sess.save((Object)zc);
        sess.flush();
        request.setAttribute(ZOEKCONFIGURATIEID, (Object)zc.getId());
        request.setAttribute("zoekVelden", (Object)zc.getZoekVelden());
        request.setAttribute("resultaatVelden", (Object)zc.getResultaatVelden());
        request.setAttribute("tips", this.createTips(zc));
        if (zc.getParentZoekConfiguratie() != null) {
            // empty if block
        }
        return mapping.findForward(STEP4);
    }

    private Set<ZoekAttribuut> getParentZoekvelden(ZoekConfiguratie parent) {
        List zoekConfigs;
        Set<Object> zoekVelden = new HashSet<ZoekAttribuut>();
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        String queryString = "from ZoekConfiguratie z LEFT JOIN FETCH z.zoekVelden LEFT JOIN FETCH z.parentBron";
        if (parent != null) {
            queryString = queryString + " where z.id != " + parent.getId();
        }
        if ((zoekConfigs = sess.createQuery(queryString).list()) != null && zoekConfigs.size() == 1) {
            zoekVelden = ((ZoekConfiguratie)zoekConfigs.get(0)).getZoekVelden();
        }
        return zoekVelden;
    }

    public ActionForward step5(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ZoekConfiguratie zc = this.getAndSetZoekConfiguratie(request);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List l = sess.createQuery("from Themas").list();
        List zoekconfigThemas = sess.createQuery("from ZoekconfiguratieThemas WHERE zoekconfiguratie = :id").setParameter("id", (Object)zc).list();
        ArrayList<String> layersAan = new ArrayList<String>();
        ArrayList<String> layerNamesOn = new ArrayList<String>();
        for (ZoekconfiguratieThemas zoekconfiguratieThema : zoekconfigThemas) {
            layersAan.add(zoekconfiguratieThema.getThema().getId().toString());
            layerNamesOn.add(zoekconfiguratieThema.getThema().getNaam());
        }
        request.setAttribute("themas", (Object)l);
        request.setAttribute("layerNamesOn", layerNamesOn);
        dynaForm.set("layersAan", (Object)layersAan.toArray(new String[layersAan.size()]));
        return mapping.findForward(STEP5);
    }

    public ActionForward saveStep5(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ZoekConfiguratie zc = this.getAndSetZoekConfiguratie(request);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List zoekconfigThemas = sess.createQuery("from ZoekconfiguratieThemas WHERE zoekconfiguratie = :id").setParameter("id", (Object)zc).list();
        for (ZoekconfiguratieThemas zoekconfigThema : zoekconfigThemas) {
            sess.delete((Object)zoekconfigThema);
        }
        sess.flush();
        String[] layersAan = dynaForm.getStrings("layersAan");
        for (int i = 0; i < layersAan.length; ++i) {
            String thema = layersAan[i];
            Themas t = (Themas)sess.get(Themas.class, (Serializable)new Integer(thema));
            ZoekconfiguratieThemas zt = new ZoekconfiguratieThemas();
            zt.setThema(t);
            zt.setZoekconfiguratie(zc);
            sess.save((Object)zt);
        }
        sess.flush();
        return mapping.findForward(WIZARDDONE);
    }

    private Bron getAndSetBron(HttpServletRequest request) {
        Bron bron = this.getBron(request);
        if (bron == null) {
            return null;
        }
        request.setAttribute(BRONID, (Object)bron.getId());
        return bron;
    }

    private Bron getBron(HttpServletRequest request) {
        if (FormUtils.nullIfEmpty((String)request.getParameter(BRONID)) == null) {
            return null;
        }
        if (request.getParameter(BRONID).equalsIgnoreCase("geenbron")) {
            return null;
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Bron b = (Bron)sess.get(Bron.class, (Serializable)new Integer(request.getParameter(BRONID)));
        return b;
    }

    private ZoekConfiguratie getAndSetZoekConfiguratie(HttpServletRequest request) {
        Integer zid = FormUtils.StringToInteger((String)request.getParameter(ZOEKCONFIGURATIEID));
        if (zid == null) {
            return null;
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ZoekConfiguratie zc = (ZoekConfiguratie)sess.get(ZoekConfiguratie.class, (Serializable)zid);
        if (zc != null) {
            request.setAttribute(ZOEKCONFIGURATIEID, (Object)zc.getId());
        }
        return zc;
    }

    private ArrayList<String> createTips(ZoekConfiguratie zc) {
        boolean geometryExists;
        Iterator it;
        if (zc == null) {
            return null;
        }
        ArrayList<String> tips = new ArrayList<String>();
        if (zc.getZoekVelden() == null || zc.getZoekVelden().size() == 0) {
            tips.add("wizardzoekconfiguratie.tip.geenzoekvelden");
        }
        if (zc.getResultaatVelden() == null || zc.getResultaatVelden().size() == 0) {
            tips.add("wizardzoekconfiguratie.tip.geenresultaatvelden");
        }
        if (zc.getZoekVelden() != null && zc.getZoekVelden().size() == 0) {
            it = zc.getZoekVelden().iterator();
            geometryExists = false;
            boolean geometryDependentExists = false;
            while (it.hasNext()) {
                ZoekAttribuut za = (ZoekAttribuut)it.next();
                if (3 == za.getType()) {
                    geometryExists = true;
                    continue;
                }
                if (100 != za.getType()) continue;
                geometryDependentExists = true;
            }
            if (geometryDependentExists && !geometryExists) {
                tips.add("wizardzoekconfiguratie.tip.geengeometriezoek");
            }
        }
        if (zc.getResultaatVelden() != null && zc.getResultaatVelden().size() > 0) {
            it = zc.getResultaatVelden().iterator();
            geometryExists = false;
            boolean toonExists = false;
            while (it.hasNext()) {
                ResultaatAttribuut ra = (ResultaatAttribuut)it.next();
                if (3 == ra.getType()) {
                    geometryExists = true;
                    continue;
                }
                if (2 != ra.getType() && -1 != ra.getType()) continue;
                toonExists = true;
            }
            if (!geometryExists) {
                tips.add("wizardzoekconfiguratie.tip.geengeometrieresultaat");
            }
            if (!toonExists) {
                tips.add("wizardzoekconfiguratie.tip.geentoonresultaat");
            }
        }
        return tips;
    }
}

