/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.zoekconfiguratie;

import java.io.Serializable;
import java.util.Arrays;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.zoeker.configuratie.Bron;
import nl.b3p.zoeker.configuratie.ResultaatAttribuut;
import nl.b3p.zoeker.configuratie.ZoekAttribuut;
import nl.b3p.zoeker.services.Zoeker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.hibernate.classic.Session;

public class ZoekConfiguratieListUtil {
    private static final Log log = LogFactory.getLog(ZoekConfiguratieListUtil.class);

    public static String[] getTypeNames(Bron bron, Boolean sort) throws Exception {
        if (bron == null) {
            throw new Exception("Bron kan niet worden gevonden");
        }
        DataStore ds = null;
        Object[] types = null;
        try {
            ds = Zoeker.getDataStore((Bron)bron);
            if (ds != null) {
                types = ds.getTypeNames();
            }
            if (types != null && types.length > 0) {
                Arrays.sort(types);
            }
        }
        catch (Exception ex) {
            throw new Exception("Kan geen verbinding maken met bron");
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
        return types;
    }

    public static String[] getTypeNamesById(Integer bronId) throws Exception {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Bron bron = (Bron)sess.get(Bron.class, (Serializable)bronId);
        return ZoekConfiguratieListUtil.getTypeNames(bron, true);
    }

    public static void removeZoekAttribuut(Integer id) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ZoekAttribuut za = (ZoekAttribuut)sess.get(ZoekAttribuut.class, (Serializable)id);
        za.getZoekConfiguratie().getZoekVelden().remove(za);
        sess.delete((Object)za);
    }

    public static void removeResultaatAttribuut(Integer id) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ResultaatAttribuut ra = (ResultaatAttribuut)sess.get(ResultaatAttribuut.class, (Serializable)id);
        ra.getZoekConfiguratie().getResultaatVelden().remove(ra);
        sess.delete((Object)ra);
    }
}

