/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.db.CMSMenuItem;
import nl.b3p.gis.viewer.services.HibernateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.classic.Session;

public class ConfigCMSMenuItemAction
extends ViewerCrudAction {
    private static final Log logger = LogFactory.getLog(ConfigCMSMenuItemAction.class);

    private CMSMenuItem getCMSMenuItem(DynaValidatorForm form, boolean createNew) {
        Session sess;
        CMSMenuItem cmsMenuItem;
        if (createNew) {
            return new CMSMenuItem();
        }
        Integer id = (Integer)form.get("cmsMenuItemID");
        if (id != null && id > 0 && (cmsMenuItem = (CMSMenuItem)(sess = HibernateUtil.getSessionFactory().getCurrentSession()).get(CMSMenuItem.class, (Serializable)id)) != null) {
            return cmsMenuItem;
        }
        return null;
    }

    private CMSMenuItem getFirstCMSMenuItem() {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List lijst = sess.createQuery("from CMSMenuItem order by cdate").setMaxResults(1).list();
        if (lijst != null && lijst.size() == 1) {
            return (CMSMenuItem)lijst.get(0);
        }
        return null;
    }

    protected void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List cmsMenuItems = sess.createQuery("from CMSMenuItem order by cdate").list();
        request.setAttribute("cmsMenuItems", (Object)cmsMenuItems);
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CMSMenuItem cmsMenuItem = this.getCMSMenuItem(dynaForm, false);
        if (cmsMenuItem == null) {
            cmsMenuItem = this.getFirstCMSMenuItem();
        }
        this.populateCMSMenuItemForm(cmsMenuItem, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward edit(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CMSMenuItem cmsMenuItem = this.getCMSMenuItem(dynaForm, false);
        if (cmsMenuItem == null) {
            cmsMenuItem = this.getFirstCMSMenuItem();
        }
        this.populateCMSMenuItemForm(cmsMenuItem, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            this.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        CMSMenuItem cmsMenuItem = this.getCMSMenuItem(dynaForm, true);
        if (cmsMenuItem == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        this.populateCMSMenuItemObject(dynaForm, cmsMenuItem, request);
        sess.saveOrUpdate((Object)cmsMenuItem);
        sess.flush();
        this.populateCMSMenuItemForm(cmsMenuItem, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = null;
        CMSMenuItem cmsMenuItem = null;
        try {
            sess = HibernateUtil.getSessionFactory().getCurrentSession();
            cmsMenuItem = this.getCMSMenuItem(dynaForm, false);
            if (cmsMenuItem == null) {
                this.prepareMethod(dynaForm, request, "list", "edit");
                this.addAlternateMessage(mapping, request, "error.notfound");
                return this.getAlternateForward(mapping, request);
            }
            this.deleteFromMenuItemJoinTable(cmsMenuItem.getId());
            sess.delete((Object)cmsMenuItem);
            sess.flush();
        }
        catch (Exception ex) {
            logger.error((Object)("Fout tijdens verwijderen van cms menu " + cmsMenuItem.getTitel()), (Throwable)ex);
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.exception");
            return this.getAlternateForward(mapping, request);
        }
        CMSMenuItem menuItem = this.getFirstCMSMenuItem();
        if (menuItem != null) {
            this.populateCMSMenuItemForm(menuItem, dynaForm, request);
        } else {
            dynaForm.initialize(mapping);
        }
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    private void deleteFromMenuItemJoinTable(Integer id) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        sess.createSQLQuery("delete from cms_menu_menuitem where cms_menuitem_id = :id").setParameter("id", (Object)id).executeUpdate();
    }

    private void populateCMSMenuItemForm(CMSMenuItem cmsMenuItem, DynaValidatorForm dynaForm, HttpServletRequest request) {
        if (cmsMenuItem == null) {
            return;
        }
        dynaForm.set("cmsMenuItemID", (Object)cmsMenuItem.getId());
        dynaForm.set("titel", (Object)cmsMenuItem.getTitel());
        dynaForm.set("url", (Object)cmsMenuItem.getUrl());
        dynaForm.set("icon", (Object)cmsMenuItem.getIcon());
        dynaForm.set("volgordenr", (Object)cmsMenuItem.getVolgordenr());
    }

    private void populateCMSMenuItemObject(DynaValidatorForm dynaForm, CMSMenuItem cmsMenuItem, HttpServletRequest request) {
        Integer id = (Integer)dynaForm.get("cmsMenuItemID");
        if (id != null && id != 0) {
            cmsMenuItem.setId(id);
        }
        cmsMenuItem.setTitel(FormUtils.nullIfEmpty((String)dynaForm.getString("titel")));
        cmsMenuItem.setUrl(FormUtils.nullIfEmpty((String)dynaForm.getString("url")));
        cmsMenuItem.setIcon(FormUtils.nullIfEmpty((String)dynaForm.getString("icon")));
        cmsMenuItem.setVolgordenr((Integer)dynaForm.get("volgordenr"));
        cmsMenuItem.setCdate(new Date());
    }
}

