/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.gis.geotools.DataStoreUtil;
import nl.b3p.gis.viewer.ConfigThemaAction;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.db.DataTypen;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.ThemaData;
import nl.b3p.gis.viewer.db.WaardeTypen;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.SpatialUtil;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.Query;
import org.hibernate.classic.Session;

public class ConfigThemaDataAction
extends ViewerCrudAction {
    private static final Log logger = LogFactory.getLog(ConfigThemaAction.class);
    protected static final String CHANGE = "change";
    protected static final String CREATEALLTHEMADATA = "createAllThemaData";
    protected static final String UPDATEBASISREGELS = "updateBasisregels";
    private int DEFAULTBASISCOLUMNS = 0;

    protected Map getActionMethodPropertiesMap() {
        Map map = super.getActionMethodPropertiesMap();
        ExtendedMethodProperties crudProp = null;
        crudProp = new ExtendedMethodProperties(CHANGE);
        crudProp.setDefaultForwardName("success");
        map.put(CHANGE, crudProp);
        crudProp = new ExtendedMethodProperties(CREATEALLTHEMADATA);
        crudProp.setDefaultForwardName("success");
        map.put(CREATEALLTHEMADATA, crudProp);
        crudProp = new ExtendedMethodProperties(UPDATEBASISREGELS);
        crudProp.setDefaultForwardName("success");
        map.put(UPDATEBASISREGELS, crudProp);
        return map;
    }

    protected ThemaData getThemaData(DynaValidatorForm form, boolean createNew) {
        Integer id = FormUtils.StringToInteger((String)form.getString("themaDataID"));
        ThemaData td = null;
        if (id == null && createNew) {
            td = new ThemaData();
        } else if (id != null) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            td = (ThemaData)sess.get(ThemaData.class, (Serializable)id);
        }
        return td;
    }

    protected ThemaData getFirstThemaData(Gegevensbron gb) {
        if (gb == null) {
            return null;
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Query q = sess.createQuery("from ThemaData where gegevensbron = :gb order by dataorder, label");
        List cs = q.setParameter("gb", (Object)gb).setMaxResults(1).list();
        if (cs != null && cs.size() > 0) {
            return (ThemaData)cs.get(0);
        }
        ThemaData td = new ThemaData();
        td.setGegevensbron(gb);
        return td;
    }

    protected Gegevensbron getGegevensbron(DynaValidatorForm form, boolean createNew) {
        Integer id = FormUtils.StringToInteger((String)form.getString("gegevensbronID"));
        Gegevensbron gb = null;
        if (id == null && createNew) {
            gb = new Gegevensbron();
        } else if (id != null) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)id);
        }
        return gb;
    }

    protected Gegevensbron getFirstGegevensbron() {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List cs = sess.createQuery("from Gegevensbron order by naam").setMaxResults(1).list();
        if (cs != null && cs.size() > 0) {
            return (Gegevensbron)cs.get(0);
        }
        return null;
    }

    protected void createLists(DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        Gegevensbron gb;
        super.createLists(dynaForm, request);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        request.setAttribute("listThemas", (Object)sess.createQuery("from Gegevensbron order by LOWER(naam) asc").list());
        request.setAttribute("listWaardeTypen", (Object)sess.createQuery("from WaardeTypen order by naam").list());
        request.setAttribute("listDataTypen", (Object)sess.createQuery("from DataTypen order by naam").list());
        ThemaData td = this.getThemaData(dynaForm, false);
        if (td == null) {
            gb = this.getGegevensbron(dynaForm, false);
            if (gb == null) {
                gb = this.getFirstGegevensbron();
            }
        } else {
            gb = td.getGegevensbron();
        }
        if (gb == null) {
            return;
        }
        List bestaandeObjecten = SpatialUtil.getThemaData((Gegevensbron)gb, (boolean)false);
        request.setAttribute("listThemaData", (Object)bestaandeObjecten);
        request.setAttribute("gegevensbron", (Object)gb);
        Bron b = gb.getBron(request);
        List attributes = new ArrayList();
        try {
            attributes = DataStoreUtil.getAttributeNames((Bron)b, (Gegevensbron)gb);
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)"Socket time out error while getting attributes.");
        }
        ArrayList<String> listAdminTableColumns = new ArrayList<String>();
        for (QName attributeName : attributes) {
            listAdminTableColumns.add(attributeName.getLocalPart());
        }
        request.setAttribute("listAdminTableColumns", listAdminTableColumns);
        if (gb.getBron() != null) {
            request.setAttribute("connectieType", (Object)gb.getBron().getType());
        } else {
            request.setAttribute("connectieType", (Object)"unknown");
        }
        ArrayList<Integer> basisregels = new ArrayList<Integer>();
        ArrayList<Integer> editables = new ArrayList<Integer>();
        HashMap<String, Integer> volgordeVelden = new HashMap<String, Integer>();
        HashMap<String, String> labelVelden = new HashMap<String, String>();
        StringBuilder uglyThemaData = new StringBuilder();
        for (ThemaData tdi : bestaandeObjecten) {
            if (tdi.isBasisregel()) {
                basisregels.add(tdi.getId());
            }
            if (tdi.isEditable().booleanValue()) {
                editables.add(tdi.getId());
            }
            boolean bestaatNog = false;
            if (tdi.getKolomnaam() == null) {
                bestaatNog = true;
            } else {
                QName dbkolom = DataStoreUtil.convertColumnNameToQName((String)tdi.getKolomnaam());
                for (QName attributeName : attributes) {
                    if (attributeName.getLocalPart().compareTo(dbkolom.getLocalPart()) != 0) continue;
                    bestaatNog = true;
                    break;
                }
            }
            if (bestaatNog) {
                String commando = null;
                if (tdi.getDataType().getId() == 3 && tdi.getCommando() != null && tdi.getCommando().indexOf("[") >= 0) {
                    commando = tdi.getCommando();
                }
                if (commando != null) {
                    for (QName attribute : attributes) {
                        if (commando.indexOf("[" + attribute.getLocalPart() + "]") != -1) {
                            commando = commando.replaceAll("\\[" + attribute + "\\]", "");
                        }
                        if (commando.indexOf("[") != -1) continue;
                        break;
                    }
                    if (commando != null && commando.indexOf("[") >= 0) {
                        bestaatNog = false;
                    }
                }
            } else {
                uglyThemaData.append("[");
                uglyThemaData.append(tdi.getId() + ":KOLOMNAAM");
                uglyThemaData.append("]");
            }
            if (!bestaatNog) {
                uglyThemaData.append("[");
                uglyThemaData.append(tdi.getId() + ":COMMANDO");
                uglyThemaData.append("]");
            }
            if (tdi.getDataorder() != null) {
                volgordeVelden.put(tdi.getId().toString(), tdi.getDataorder());
            }
            if (tdi.getLabel() == null) continue;
            labelVelden.put(tdi.getId().toString(), tdi.getLabel());
        }
        dynaForm.set("volgordeVelden", volgordeVelden);
        dynaForm.set("labelVelden", labelVelden);
        request.setAttribute("listUglyThemaData", (Object)uglyThemaData);
        dynaForm.set("basisregels", (Object)basisregels.toArray(new Integer[basisregels.size()]));
        dynaForm.set("editables", (Object)editables.toArray(new Integer[editables.size()]));
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemaData td = this.getThemaData(dynaForm, false);
        if (td == null) {
            Gegevensbron gb = this.getGegevensbron(dynaForm, false);
            if (gb == null) {
                gb = this.getFirstGegevensbron();
            }
            td = this.getFirstThemaData(gb);
        }
        this.populateThemaDataForm(td, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward change(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Gegevensbron gb = this.getGegevensbron(dynaForm, false);
        if (gb == null) {
            gb = this.getFirstGegevensbron();
        }
        ThemaData td = this.getFirstThemaData(gb);
        this.populateThemaDataForm(td, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward create(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Gegevensbron gb = this.getGegevensbron(dynaForm, false);
        if (gb == null) {
            gb = this.getFirstGegevensbron();
        }
        dynaForm.initialize(mapping);
        String val = "";
        if (gb != null) {
            val = Integer.toString(gb.getId());
        }
        dynaForm.set("gegevensbronID", (Object)val);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward edit(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemaData td;
        Gegevensbron gb = this.getGegevensbron(dynaForm, false);
        if (gb == null) {
            gb = this.getFirstGegevensbron();
        }
        if ((td = this.getThemaData(dynaForm, false)) == null) {
            td = this.getFirstThemaData(gb);
        }
        this.populateThemaDataForm(td, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            this.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        ThemaData t = this.getThemaData(dynaForm, true);
        if (t == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        this.populateThemaDataObject(dynaForm, t, request);
        sess.saveOrUpdate((Object)t);
        sess.flush();
        sess.refresh((Object)t);
        this.populateThemaDataForm(t, dynaForm, request);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward updateBasisregels(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer[] basisregels = (Integer[])dynaForm.get("basisregels");
        Gegevensbron gb = this.getGegevensbron(dynaForm, false);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List bestaandeObjecten = SpatialUtil.getThemaData((Gegevensbron)gb, (boolean)false);
        for (ThemaData td : bestaandeObjecten) {
            boolean isBasis = false;
            for (Integer bs : basisregels) {
                if (bs == null || bs.compareTo(td.getId()) != 0) continue;
                isBasis = true;
                break;
            }
            if (isBasis) {
                td.setBasisregel(true);
            } else {
                td.setBasisregel(false);
            }
            sess.saveOrUpdate((Object)td);
            sess.flush();
        }
        this.saveVolgordeVelden(dynaForm);
        this.saveLabelVelden(dynaForm);
        return this.unspecified(mapping, dynaForm, request, response);
    }

    private void saveVolgordeVelden(DynaValidatorForm dynaForm) {
        HashMap volgordeVelden = (HashMap)dynaForm.get("volgordeVelden");
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        for (Map.Entry pairs : volgordeVelden.entrySet()) {
            ThemaData td;
            Integer key = null;
            Integer volgorde = null;
            try {
                key = new Integer((String)pairs.getKey());
                volgorde = new Integer((String)pairs.getValue());
            }
            catch (NumberFormatException nfe) {
                logger.debug((Object)"Fout tijdens omzetten volgorde waardes van objectdata veld.");
            }
            if (key == null || key <= 0 || volgorde == null || (td = (ThemaData)sess.get(ThemaData.class, (Serializable)key)) == null) continue;
            if (volgorde < 0) {
                td.setDataorder(null);
            } else if (volgorde >= 0) {
                td.setDataorder(new Integer(volgorde));
            }
            sess.saveOrUpdate((Object)td);
        }
        sess.flush();
    }

    private void saveLabelVelden(DynaValidatorForm dynaForm) {
        HashMap labelVelden = (HashMap)dynaForm.get("labelVelden");
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        for (Map.Entry pairs : labelVelden.entrySet()) {
            ThemaData td;
            Integer key = null;
            String label = (String)pairs.getValue();
            try {
                key = new Integer((String)pairs.getKey());
            }
            catch (NumberFormatException nfe) {
                logger.debug((Object)"Fout tijdens omzetten volgorde waardes van objectdata veld.");
            }
            if (key == null || key <= 0 || label == null || (td = (ThemaData)sess.get(ThemaData.class, (Serializable)key)) == null) continue;
            if (label.equals("")) {
                td.setLabel(null);
            } else if (!label.equals("")) {
                td.setLabel(label);
            }
            sess.saveOrUpdate((Object)td);
        }
        sess.flush();
    }

    public ActionForward createAllThemaData(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Gegevensbron gb = this.getGegevensbron(dynaForm, false);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Bron b = gb.getBron(request);
        List attributes = new ArrayList();
        try {
            attributes = DataStoreUtil.getAttributeNames((Bron)b, (Gegevensbron)gb);
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)"Socket time out error while getting attributes.");
        }
        if (attributes == null || attributes.size() < 1) {
            return this.unspecified(mapping, dynaForm, request, response);
        }
        GisPrincipal user = GisPrincipal.getGisPrincipal((HttpServletRequest)request);
        QName geomName = null;
        try {
            geomName = DataStoreUtil.getThemaGeomName((Gegevensbron)gb, (GisPrincipal)user);
        }
        catch (Exception ex) {
            logger.debug((Object)"", (Throwable)ex);
        }
        String geomPropname = "";
        if (geomName != null && geomName.getLocalPart() != null) {
            geomPropname = geomName.getLocalPart();
        }
        List bestaandeObjecten = SpatialUtil.getThemaData((Gegevensbron)gb, (boolean)false);
        for (QName attributeName : attributes) {
            if (attributeName == null || attributeName.getLocalPart().compareTo(geomPropname) == 0) continue;
            boolean bestaatAl = false;
            for (ThemaData td : bestaandeObjecten) {
                if (td.getKolomnaam() == null) continue;
                QName dbkolomName = DataStoreUtil.convertColumnNameToQName((String)td.getKolomnaam());
                if (attributeName.getLocalPart().compareTo(dbkolomName.getLocalPart()) != 0) continue;
                bestaatAl = true;
                break;
            }
            if (bestaatAl) continue;
            ThemaData td = new ThemaData();
            td.setBasisregel(false);
            td.setDataType((DataTypen)sess.get(DataTypen.class, (Serializable)Integer.valueOf(1)));
            String netteNaam = attributeName.getLocalPart();
            if (netteNaam.indexOf("{") >= 0 && netteNaam.indexOf("}") >= 0) {
                netteNaam = netteNaam.substring(netteNaam.indexOf("}") + 1);
            }
            td.setLabel(netteNaam);
            td.setKolomnaam(attributeName.getLocalPart());
            td.setGegevensbron(gb);
            td.setDefaultValues("");
            td.setEditable(Boolean.valueOf(false));
            td.setWaardeType((WaardeTypen)sess.get(WaardeTypen.class, (Serializable)Integer.valueOf(1)));
            sess.saveOrUpdate((Object)td);
        }
        boolean extraVeldBestaatAl = false;
        boolean erIsEenBasisRegel = false;
        for (ThemaData td : bestaandeObjecten) {
            if (td.isBasisregel()) {
                erIsEenBasisRegel = true;
            }
            if (td.getCommando() != null && td.getCommando().toLowerCase().startsWith("viewerdata.do?aanvullendeinfo=t")) {
                extraVeldBestaatAl = true;
            }
            if (td.getKolomnaam() == null) continue;
            QName dbkolom = DataStoreUtil.convertColumnNameToQName((String)td.getKolomnaam());
            boolean bestaatNog = false;
            for (QName attributeName : attributes) {
                if (attributeName.getLocalPart().compareTo(dbkolom.getLocalPart()) != 0) continue;
                bestaatNog = true;
                break;
            }
            if (bestaatNog) continue;
            Gegevensbron tgb = td.getGegevensbron();
            tgb.getThemaData().remove(td);
            sess.delete((Object)td);
            sess.flush();
        }
        if (attributes.size() > this.DEFAULTBASISCOLUMNS && !extraVeldBestaatAl) {
            ThemaData td = this.createDefaultExtraThemaData(gb);
            sess.saveOrUpdate((Object)td);
        }
        return this.unspecified(mapping, dynaForm, request, response);
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ThemaData td = this.getThemaData(dynaForm, false);
        if (td == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        Gegevensbron gb = td.getGegevensbron();
        gb.getThemaData().remove(td);
        sess.delete((Object)td);
        sess.flush();
        td = this.getFirstThemaData(gb);
        dynaForm.initialize(mapping);
        this.populateThemaDataForm(td, dynaForm, request);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    private void populateThemaDataForm(ThemaData td, DynaValidatorForm dynaForm, HttpServletRequest request) {
        if (td == null) {
            return;
        }
        if (td.getId() != null) {
            dynaForm.set("themaDataID", (Object)Integer.toString(td.getId()));
        } else {
            dynaForm.set("themaDataID", (Object)"");
        }
        dynaForm.set("label", (Object)td.getLabel());
        dynaForm.set("eenheid", (Object)td.getEenheid());
        dynaForm.set("omschrijving", (Object)td.getOmschrijving());
        String val = "";
        if (td.getGegevensbron() != null) {
            val = Integer.toString(td.getGegevensbron().getId());
        }
        dynaForm.set("gegevensbronID", (Object)val);
        dynaForm.set("basisregel", (Object)td.isBasisregel());
        dynaForm.set("editable", (Object)td.isEditable());
        dynaForm.set("defaultValues", (Object)td.getDefaultValues());
        dynaForm.set("voorbeelden", (Object)td.getVoorbeelden());
        dynaForm.set("kolombreedte", (Object)FormUtils.IntToString((int)td.getKolombreedte()));
        val = "";
        if (td.getWaardeType() != null) {
            val = Integer.toString(td.getWaardeType().getId());
        }
        dynaForm.set("waardeTypeID", (Object)val);
        val = "1";
        if (td.getDataType() != null) {
            val = Integer.toString(td.getDataType().getId());
        }
        dynaForm.set("dataTypeID", (Object)val);
        dynaForm.set("commando", (Object)td.getCommando());
        dynaForm.set("kolomnaam", (Object)td.getKolomnaam());
        if (td.getDataorder() != null) {
            dynaForm.set("dataorder", (Object)FormUtils.IntToString((int)td.getDataorder()));
        }
    }

    private void populateThemaDataObject(DynaValidatorForm dynaForm, ThemaData td, HttpServletRequest request) {
        Boolean b = (Boolean)dynaForm.get("basisregel");
        td.setBasisregel(b == null ? false : b);
        td.setCommando(FormUtils.nullIfEmpty((String)dynaForm.getString("commando")));
        if (dynaForm.getString("dataorder") != null && dynaForm.getString("dataorder").length() > 0) {
            td.setDataorder(Integer.valueOf(Integer.parseInt(dynaForm.getString("dataorder"))));
        } else {
            td.setDataorder(null);
        }
        td.setEenheid(FormUtils.nullIfEmpty((String)dynaForm.getString("eenheid")));
        td.setKolombreedte(FormUtils.StringToInt((String)dynaForm.getString("kolombreedte")));
        td.setKolomnaam(FormUtils.nullIfEmpty((String)dynaForm.getString("kolomnaam")));
        td.setLabel(FormUtils.nullIfEmpty((String)dynaForm.getString("label")));
        td.setOmschrijving(FormUtils.nullIfEmpty((String)dynaForm.getString("omschrijving")));
        td.setVoorbeelden(FormUtils.nullIfEmpty((String)dynaForm.getString("voorbeelden")));
        Boolean editable = (Boolean)dynaForm.get("editable");
        td.setEditable(Boolean.valueOf(editable == null ? false : editable));
        String defaultValues = FormUtils.nullIfEmpty((String)dynaForm.getString("defaultValues"));
        if (defaultValues != null) {
            Object[] entries = defaultValues.split(",");
            for (int i = 0; i < entries.length; ++i) {
                entries[i] = ((String)entries[i]).trim();
            }
            defaultValues = StringUtils.join((Object[])entries, (String)",");
        }
        td.setDefaultValues(defaultValues);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        int tId = 0;
        int dId = 0;
        boolean wId = false;
        try {
            tId = Integer.parseInt(dynaForm.getString("gegevensbronID"));
        }
        catch (NumberFormatException ex) {
            logger.error((Object)"Illegal gegevensbronID", (Throwable)ex);
        }
        try {
            dId = Integer.parseInt(dynaForm.getString("dataTypeID"));
        }
        catch (NumberFormatException ex) {
            logger.error((Object)"Illegal dataTypeID", (Throwable)ex);
        }
        Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)new Integer(tId));
        td.setGegevensbron(gb);
        DataTypen d = (DataTypen)sess.get(DataTypen.class, (Serializable)new Integer(dId));
        td.setDataType(d);
    }

    protected ThemaData createDefaultExtraThemaData(Gegevensbron gb) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ThemaData td = new ThemaData();
        td.setLabel("Extra");
        td.setBasisregel(false);
        td.setEditable(Boolean.valueOf(false));
        td.setDefaultValues(null);
        td.setKolombreedte(50);
        td.setWaardeType((WaardeTypen)sess.get(WaardeTypen.class, (Serializable)Integer.valueOf(1)));
        td.setDataType((DataTypen)sess.get(DataTypen.class, (Serializable)Integer.valueOf(2)));
        td.setCommando("viewerdata.do?aanvullendeinfo=t&");
        td.setGegevensbron(gb);
        return td;
    }
}

