/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.db.CMSPagina;
import nl.b3p.gis.viewer.services.HibernateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.classic.Session;

public class ConfigCMSPaginaAction
extends ViewerCrudAction {
    private static final Log logger = LogFactory.getLog(ConfigCMSPaginaAction.class);

    private CMSPagina getCMSPagina(DynaValidatorForm form, boolean createNew) {
        Session sess;
        CMSPagina cmsPag;
        if (createNew) {
            return new CMSPagina();
        }
        Integer id = (Integer)form.get("cmsPaginaID");
        if (id != null && id > 0 && (cmsPag = (CMSPagina)(sess = HibernateUtil.getSessionFactory().getCurrentSession()).get(CMSPagina.class, (Serializable)id)) != null) {
            return cmsPag;
        }
        return null;
    }

    private CMSPagina getFirstCMSPagina() {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List lijst = sess.createQuery("from CMSPagina order by cdate").setMaxResults(1).list();
        if (lijst != null && lijst.size() == 1) {
            return (CMSPagina)lijst.get(0);
        }
        return null;
    }

    protected void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List cmsPaginas = sess.createQuery("from CMSPagina order by cdate").list();
        request.setAttribute("cmsPaginas", (Object)cmsPaginas);
        List cmsMenus = sess.createQuery("from CMSMenu order by titel").list();
        request.setAttribute("cmsMenus", (Object)cmsMenus);
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CMSPagina cmsPag = this.getCMSPagina(dynaForm, false);
        if (cmsPag == null) {
            cmsPag = this.getFirstCMSPagina();
        }
        this.populateCMSPaginaForm(cmsPag, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward edit(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CMSPagina cmsPag = this.getCMSPagina(dynaForm, false);
        if (cmsPag == null) {
            cmsPag = this.getFirstCMSPagina();
        }
        this.populateCMSPaginaForm(cmsPag, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            this.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        CMSPagina cmsPag = this.getCMSPagina(dynaForm, true);
        if (cmsPag == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        this.populateCMSPaginaObject(dynaForm, cmsPag, request);
        sess.saveOrUpdate((Object)cmsPag);
        sess.flush();
        sess.refresh((Object)cmsPag);
        this.populateCMSPaginaForm(cmsPag, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = null;
        CMSPagina cmsPag = null;
        try {
            sess = HibernateUtil.getSessionFactory().getCurrentSession();
            cmsPag = this.getCMSPagina(dynaForm, false);
            if (cmsPag == null) {
                this.prepareMethod(dynaForm, request, "list", "edit");
                this.addAlternateMessage(mapping, request, "error.notfound");
                return this.getAlternateForward(mapping, request);
            }
            sess.delete((Object)cmsPag);
            sess.flush();
        }
        catch (Exception ex) {
            logger.error((Object)("Fout tijdens verwijderen van cms pagina " + cmsPag.getTitel()), (Throwable)ex);
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.exception");
            return this.getAlternateForward(mapping, request);
        }
        CMSPagina pag = this.getFirstCMSPagina();
        if (pag != null) {
            this.populateCMSPaginaForm(pag, dynaForm, request);
        } else {
            dynaForm.initialize(mapping);
        }
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    private void populateCMSPaginaForm(CMSPagina cmsPag, DynaValidatorForm dynaForm, HttpServletRequest request) {
        if (cmsPag == null) {
            return;
        }
        dynaForm.set("cmsPaginaID", (Object)cmsPag.getId());
        dynaForm.set("titel", (Object)cmsPag.getTitel());
        dynaForm.set("tekst", (Object)cmsPag.getTekst());
        dynaForm.set("thema", (Object)cmsPag.getThema());
        dynaForm.set("showPlainAndMapButton", (Object)cmsPag.getShowPlainAndMapButton());
        dynaForm.set("cmsMenu", (Object)cmsPag.getCmsMenu());
        dynaForm.set("loginRequired", (Object)cmsPag.getLoginRequired());
    }

    private void populateCMSPaginaObject(DynaValidatorForm dynaForm, CMSPagina cmsPag, HttpServletRequest request) {
        Integer id = (Integer)dynaForm.get("cmsPaginaID");
        if (id != null && id != 0) {
            cmsPag.setId(id);
        }
        cmsPag.setTitel(FormUtils.nullIfEmpty((String)dynaForm.getString("titel")));
        cmsPag.setTekst(FormUtils.nullIfEmpty((String)dynaForm.getString("tekst")));
        cmsPag.setThema(FormUtils.nullIfEmpty((String)dynaForm.getString("thema")));
        Boolean showPlainAndMapButton = (Boolean)dynaForm.get("showPlainAndMapButton");
        if (showPlainAndMapButton != null && showPlainAndMapButton.booleanValue()) {
            cmsPag.setShowPlainAndMapButton(Boolean.valueOf(true));
        } else {
            cmsPag.setShowPlainAndMapButton(Boolean.valueOf(false));
        }
        cmsPag.setCdate(new Date());
        Integer cmsMenu = (Integer)dynaForm.get("cmsMenu");
        if (cmsMenu != null && cmsMenu > 0) {
            cmsPag.setCmsMenu(cmsMenu);
        } else {
            cmsPag.setCmsMenu(null);
        }
        Boolean loginRequired = (Boolean)dynaForm.get("loginRequired");
        if (loginRequired != null && loginRequired.booleanValue()) {
            cmsPag.setLoginRequired(Boolean.valueOf(true));
        } else {
            cmsPag.setLoginRequired(Boolean.valueOf(false));
        }
    }
}

