/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.utils.KaartSelectieUtil;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.db.Applicatie;
import nl.b3p.gis.viewer.db.CyclomediaAccount;
import nl.b3p.gis.viewer.services.HibernateUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.classic.Session;
import org.json.JSONException;
import sun.security.rsa.RSAPrivateCrtKeyImpl;

public class ConfigCyclomediaAction
extends ViewerCrudAction {
    private static final Log logger = LogFactory.getLog(ConfigCyclomediaAction.class);
    private final String CERT_TYPE = "PKCS12";
    private final String KEY_FORMAT = "PKCS#8";
    private final String SIG_ALGORITHM = "SHA1withRSA";
    private final String URL_ENCODING = "utf-8";

    protected Map getActionMethodPropertiesMap() {
        Map map = super.getActionMethodPropertiesMap();
        ExtendedMethodProperties crudProp = null;
        crudProp = new ExtendedMethodProperties("save");
        crudProp.setDefaultForwardName("success");
        crudProp.setDefaultMessageKey("message.savecyclomedia.success");
        crudProp.setAlternateForwardName("failure");
        crudProp.setAlternateMessageKey("message.savecyclomedia.failed");
        map.put("save", crudProp);
        return map;
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String appCode = request.getParameter("appcode");
        ConfigKeeper configKeeper = new ConfigKeeper();
        Map map = configKeeper.getConfigMap(appCode, true);
        this.populateForm(dynaForm, request, map, appCode);
        this.populateForApplicatieHeader(request, appCode);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    protected void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
    }

    private void populateForApplicatieHeader(HttpServletRequest request, String appCode) {
        Applicatie app = KaartSelectieUtil.getApplicatie((String)appCode);
        if (app != null) {
            request.setAttribute("header_appnaam", (Object)app.getNaam());
        }
    }

    public void populateForm(DynaValidatorForm dynaForm, HttpServletRequest request, Map map, String appCode) {
        ConfigKeeper keeper = new ConfigKeeper();
        CyclomediaAccount cycloAccount = keeper.getCyclomediaAccount(appCode);
        if (cycloAccount != null) {
            dynaForm.set("cfg_cyclo_apikey", (Object)cycloAccount.getApiKey());
            dynaForm.set("cfg_cyclo_accountid", (Object)cycloAccount.getAccountId());
            dynaForm.set("cfg_cyclo_wachtwoord", (Object)cycloAccount.getWachtwoord());
        }
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String appCode = (String)dynaForm.get("appcode");
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        this.saveCyclomediaAccount(appCode, dynaForm, request);
        this.populateForApplicatieHeader(request, appCode);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    private void saveCyclomediaAccount(String appCode, DynaValidatorForm dynaForm, HttpServletRequest request) throws JSONException, Exception {
        ConfigKeeper keeper;
        CyclomediaAccount cycloAccount;
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        String apiKey = dynaForm.getString("cfg_cyclo_apikey");
        String accountId = dynaForm.getString("cfg_cyclo_accountid");
        String wachtwoord = dynaForm.getString("cfg_cyclo_wachtwoord");
        String privateBase64Key = dynaForm.getString("cfg_cyclo_privatebase64key");
        FormFile tempFormFile = (FormFile)dynaForm.get("cfg_cyclo_keybestand");
        if (apiKey != null && apiKey.equals("")) {
            apiKey = null;
        }
        if (accountId != null && accountId.equals("")) {
            accountId = null;
        }
        if (wachtwoord != null && wachtwoord.equals("")) {
            wachtwoord = null;
        }
        if (privateBase64Key != null && privateBase64Key.equals("")) {
            privateBase64Key = null;
        }
        if (privateBase64Key == null && tempFormFile != null && !tempFormFile.getFileName().equals("")) {
            try {
                privateBase64Key = this.getBase64EncodedPrivateKeyFromPfxUpload(tempFormFile, wachtwoord);
            }
            catch (IOException iox) {
                logger.error((Object)("Fout tijdens openen " + tempFormFile.getFileName() + " bestand. Wachtwoord verkeerd ?"));
            }
        }
        if ((cycloAccount = (keeper = new ConfigKeeper()).getCyclomediaAccount(appCode)) == null) {
            cycloAccount = new CyclomediaAccount();
            cycloAccount.setApiKey(apiKey);
            cycloAccount.setAccountId(accountId);
            cycloAccount.setWachtwoord(wachtwoord);
            cycloAccount.setPrivateBase64Key(privateBase64Key);
            cycloAccount.setAppCode(appCode);
            sess.save((Object)cycloAccount);
        } else {
            if (apiKey != null && !apiKey.equals(cycloAccount.getApiKey())) {
                cycloAccount.setApiKey(apiKey);
            }
            if (accountId != null && !accountId.equals(cycloAccount.getAccountId())) {
                cycloAccount.setAccountId(accountId);
            }
            if (wachtwoord != null && !wachtwoord.equals(cycloAccount.getWachtwoord())) {
                cycloAccount.setWachtwoord(wachtwoord);
            }
            if (privateBase64Key != null && !privateBase64Key.equals(cycloAccount.getPrivateBase64Key())) {
                cycloAccount.setPrivateBase64Key(privateBase64Key);
            }
            sess.update((Object)cycloAccount);
        }
    }

    private String getBase64EncodedPrivateKeyFromPfxUpload(FormFile formFile, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        String base64 = null;
        Key privateKey = null;
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(new BufferedInputStream(formFile.getInputStream()), password.toCharArray());
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Key key = ks.getKey(alias, password.toCharArray());
            String keyFormat = key.getFormat();
            if (!(key instanceof RSAPrivateCrtKeyImpl) || !keyFormat.equals("PKCS#8")) continue;
            privateKey = (PrivateKey)key;
        }
        if (privateKey != null) {
            Base64 encoder = new Base64();
            base64 = new String(encoder.encode(privateKey.getEncoded()));
        }
        return base64;
    }
}

