/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.gis.geotools.DataStoreUtil;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.utils.KaartSelectieUtil;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.db.Applicatie;
import nl.b3p.gis.viewer.db.Configuratie;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.db.UserLayer;
import nl.b3p.gis.viewer.db.UserService;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.SldServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.WMSUtils;
import org.geotools.data.wms.WebMapServer;
import org.hibernate.classic.Session;
import org.json.JSONException;

public class ConfigKeeperAction
extends ViewerCrudAction {
    private static final Log logger = LogFactory.getLog(ConfigKeeperAction.class);
    private static final String[] CONFIGKEEPER_TABS = new String[]{"leeg", "themas", "legenda", "zoeken", "analyse", "planselectie", "meldingen", "redlining", "bag", "wkt", "transparantie", "tekenen", "uploadpoints", "layerinfo", "externeinformatie"};
    private static final String[] LABELS_VOOR_TABS = new String[]{"-Kies een tabblad-", "Kaarten", "Legenda", "Zoeken", "Analyse", "Plannen", "Meldingen", "Redlining", "BAG", "WKT", "Transparantie", "Tekenen", "Upload tijdelijke punten", "Laag informatie", "Externe informatie ophalen"};
    private static final String[] CONFIGKEEPER_SLIDER_TABS = new String[]{"leeg", "themas", "legenda", "zoeken"};
    private static final String[] LABELS_VOOR_SLIDER_TABS = new String[]{"-Kies een tabblad-", "Kaarten", "Legenda", "Zoeken"};
    protected static final String RESET_INSTELLINGEN = "resetInstellingen";
    protected static final String SAVE_WMS_SERVICE = "saveWMSService";
    protected static final String DELETE_WMS_SERVICES = "deleteWMSServices";
    protected static final String ERROR_SAVE_WMS = "error.save.wms";
    protected static final String ERROR_DUPLICATE_WMS = "error.duplicate.wms";

    protected Map getActionMethodPropertiesMap() {
        Map map = super.getActionMethodPropertiesMap();
        ExtendedMethodProperties crudProp = null;
        crudProp = new ExtendedMethodProperties("save");
        crudProp.setDefaultForwardName("success");
        crudProp.setDefaultMessageKey("message.saveinstellingen.success");
        crudProp.setAlternateForwardName("failure");
        crudProp.setAlternateMessageKey("message.saveinstellingen.failed");
        map.put("save", crudProp);
        crudProp = new ExtendedMethodProperties(RESET_INSTELLINGEN);
        crudProp.setDefaultForwardName("success");
        crudProp.setDefaultMessageKey("message.resetappsettings.success");
        crudProp.setAlternateForwardName("failure");
        crudProp.setAlternateMessageKey("message.resetappsettings.failed");
        map.put(RESET_INSTELLINGEN, crudProp);
        crudProp = new ExtendedMethodProperties(SAVE_WMS_SERVICE);
        crudProp.setDefaultForwardName("success");
        crudProp.setDefaultMessageKey("message.userwms.success");
        crudProp.setAlternateForwardName("failure");
        crudProp.setAlternateMessageKey("message.userwms.failed");
        map.put(SAVE_WMS_SERVICE, crudProp);
        crudProp = new ExtendedMethodProperties(DELETE_WMS_SERVICES);
        crudProp.setDefaultForwardName("success");
        crudProp.setDefaultMessageKey("message.userwms.delete.success");
        crudProp.setAlternateForwardName("failure");
        crudProp.setAlternateMessageKey("message.userwms.delete.failed");
        map.put(DELETE_WMS_SERVICES, crudProp);
        return map;
    }

    public ActionForward resetInstellingen(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        String appCode = dynaForm.getString("appcode");
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        sess.createQuery("delete from Configuratie where setting = :appcode)").setParameter("appcode", (Object)appCode).executeUpdate();
        sess.flush();
        KaartSelectieUtil.removeExistingUserKaartgroepAndUserKaartlagen((String)appCode);
        KaartSelectieUtil.resetExistingUserLayers((String)appCode);
        KaartSelectieUtil.populateKaartSelectieForm((String)appCode, (HttpServletRequest)request);
        ConfigKeeper configKeeper = new ConfigKeeper();
        Map map = configKeeper.getConfigMap(appCode, true);
        this.populateForm(dynaForm, request, map, appCode);
        this.populateForApplicatieHeader(request, appCode);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String appCode = request.getParameter("appcode");
        KaartSelectieUtil.populateKaartSelectieForm((String)appCode, (HttpServletRequest)request);
        ConfigKeeper configKeeper = new ConfigKeeper();
        Map map = configKeeper.getConfigMap(appCode, true);
        this.populateForm(dynaForm, request, map, appCode);
        this.populateForApplicatieHeader(request, appCode);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward deleteWMSServices(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] servicesAan = (String[])dynaForm.get("servicesAan");
        String appCode = (String)dynaForm.get("appcode");
        for (int i = 0; i < servicesAan.length; ++i) {
            Integer serviceId = new Integer(servicesAan[i]);
            KaartSelectieUtil.removeService((Integer)serviceId);
        }
        KaartSelectieUtil.populateKaartSelectieForm((String)appCode, (HttpServletRequest)request);
        ConfigKeeper configKeeper = new ConfigKeeper();
        Map map = configKeeper.getConfigMap(appCode, true);
        this.populateForm(dynaForm, request, map, appCode);
        this.populateForApplicatieHeader(request, appCode);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward saveWMSService(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String groupName = (String)dynaForm.get("groupName");
        String serviceUrl = (String)dynaForm.get("serviceUrl");
        String sldUrl = (String)dynaForm.get("sldUrl");
        boolean error = false;
        String appCode = (String)dynaForm.get("appcode");
        if (KaartSelectieUtil.userAlreadyHasThisService((String)appCode, (String)serviceUrl)) {
            KaartSelectieUtil.populateKaartSelectieForm((String)appCode, (HttpServletRequest)request);
            this.addMessage(request, ERROR_DUPLICATE_WMS, serviceUrl);
            error = true;
        }
        URI uri = new URI(serviceUrl);
        Layer[] layers = null;
        try {
            WebMapServer wms = new WebMapServer(uri.toURL(), 30000);
            layers = WMSUtils.getNamedLayers((WMSCapabilities)wms.getCapabilities());
        }
        catch (Exception ex) {
            logger.error((Object)"Fout tijdens opslaan WMS. ", (Throwable)ex);
            KaartSelectieUtil.populateKaartSelectieForm((String)appCode, (HttpServletRequest)request);
            this.addMessage(request, ERROR_SAVE_WMS, uri.toString());
            error = true;
        }
        if (!error) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            UserService us = new UserService(appCode, serviceUrl, groupName);
            List parents = KaartSelectieUtil.getParentLayers((Layer[])layers);
            for (Layer layer : parents) {
                UserLayer ul = KaartSelectieUtil.createUserLayers((UserService)us, (Layer)layer, null);
                us.addLayer(ul);
            }
            if (parents.size() < 1) {
                for (int i = 0; i < layers.length; ++i) {
                    UserLayer ul = KaartSelectieUtil.createUserLayers((UserService)us, (Layer)layers[i], null);
                    us.addLayer(ul);
                }
            }
            sess.save((Object)us);
        }
        KaartSelectieUtil.populateKaartSelectieForm((String)appCode, (HttpServletRequest)request);
        ConfigKeeper configKeeper = new ConfigKeeper();
        Map map = configKeeper.getConfigMap(appCode, true);
        this.populateForm(dynaForm, request, map, appCode);
        this.populateForApplicatieHeader(request, appCode);
        this.prepareMethod(dynaForm, request, "edit", "list");
        if (!error) {
            this.addDefaultMessage(mapping, request, "acknowledgeMessages");
            return mapping.findForward("success");
        }
        return this.getAlternateForward(mapping, request);
    }

    protected void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
        request.setAttribute("tabValues", (Object)CONFIGKEEPER_TABS);
        request.setAttribute("tabLabels", (Object)LABELS_VOOR_TABS);
        request.setAttribute("tabSliderValues", (Object)CONFIGKEEPER_SLIDER_TABS);
        request.setAttribute("tabSliderLabels", (Object)LABELS_VOOR_SLIDER_TABS);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List zoekconfigs = sess.createQuery("from ZoekConfiguratie order by naam").list();
        request.setAttribute("zoekConfigs", (Object)zoekconfigs);
        List meldingGegevensbronnen = sess.createQuery("from Gegevensbron order by naam").list();
        request.setAttribute("meldingGegevensbronnen", (Object)meldingGegevensbronnen);
        List redliningKaartlagen = sess.createQuery("from Themas order by naam").list();
        request.setAttribute("redliningKaartlagen", (Object)redliningKaartlagen);
        List tekenGegevensbronnen = sess.createQuery("from Gegevensbron order by naam").list();
        ArrayList<Gegevensbron> tempGb = new ArrayList<Gegevensbron>();
        for (Gegevensbron gegevensbron : tekenGegevensbronnen) {
            if (gegevensbron.getBron() == null || !gegevensbron.getBron().checkType("jdbc")) continue;
            tempGb.add(gegevensbron);
        }
        request.setAttribute("tekenGegevensbronnen", tempGb);
        this.fillTekenTabFilterKaartlagenDropdown(request, (org.hibernate.Session)sess);
        this.fillTekenTabFilterSLD(request, (org.hibernate.Session)sess, form);
    }

    private void fillTekenTabFilterKaartlagenDropdown(HttpServletRequest request, org.hibernate.Session sess) throws Exception {
        String appCode = request.getParameter("appcode");
        Gegevensbron gekozenGb = this.getTekenTabGekozenGegevensbron(appCode, sess);
        if (gekozenGb != null) {
            List lagen = sess.createQuery("from Themas where gegevensbron = :gb order by naam").setParameter("gb", (Object)gekozenGb).list();
            request.setAttribute("tekenKaartlagen", (Object)lagen);
        }
    }

    private void fillTekenTabFilterSLD(HttpServletRequest request, org.hibernate.Session sess, DynaValidatorForm form) throws Exception {
        String appCode = request.getParameter("appcode");
        Themas laag = this.getTekenTabGekozenKaartlaag(appCode, sess);
        if (laag != null) {
            String featureType = laag.getWms_layers_real();
            if (featureType == null || featureType.length() == 0) {
                logger.debug((Object)"Kaartlaag heeft geen featuretype");
            }
            featureType = featureType.substring(featureType.indexOf("_") + 1);
            String geometryType = null;
            try {
                geometryType = this.getGeomtryType(laag, request);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String currentSldValue = this.getTekenTabFilterSLDValue(appCode);
            if (geometryType != null && currentSldValue == null || currentSldValue.equals("")) {
                logger.debug((Object)("teken kaartlaag geom type: " + geometryType));
                if (geometryType.toLowerCase().indexOf("polygon") >= 0) {
                    form.set("cfg_tekenFilterSld", (Object)SldServlet.getDefaultPolygonStyle());
                } else if (geometryType.toLowerCase().indexOf("line") >= 0) {
                    form.set("cfg_tekenFilterSld", (Object)SldServlet.getDefaultLineStyle());
                } else if (geometryType.toLowerCase().indexOf("point") >= 0) {
                    form.set("cfg_tekenFilterSld", (Object)SldServlet.getDefaultPointStyle());
                } else {
                    form.set("cfg_tekenFilterSld", (Object)SldServlet.getDefaultPolygonStyle());
                }
            }
        }
    }

    private String getGeomtryType(Themas t, HttpServletRequest request) throws Exception {
        GisPrincipal user = GisPrincipal.getGisPrincipal((HttpServletRequest)request);
        String geometryType = DataStoreUtil.getThemaGeomType((Themas)t, (GisPrincipal)user);
        return geometryType;
    }

    private String getTekenTabFilterSLDValue(String appCode) throws Exception {
        ConfigKeeper configKeeper = new ConfigKeeper();
        Map map = configKeeper.getConfigMap(appCode, true);
        String sldPart = (String)map.get("tekenFilterSld");
        return sldPart;
    }

    private Gegevensbron getTekenTabGekozenGegevensbron(String appCode, org.hibernate.Session sess) throws Exception {
        ConfigKeeper configKeeper = new ConfigKeeper();
        Map map = configKeeper.getConfigMap(appCode, true);
        Gegevensbron gekozenGegevensbron = null;
        Integer gbId = (Integer)map.get("tekenGegevensbron");
        if (gbId != null && gbId > 0) {
            gekozenGegevensbron = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)gbId);
        }
        return gekozenGegevensbron;
    }

    private Themas getTekenTabGekozenKaartlaag(String appCode, org.hibernate.Session sess) throws Exception {
        ConfigKeeper configKeeper = new ConfigKeeper();
        Map map = configKeeper.getConfigMap(appCode, true);
        Themas gekozenKaartlaag = null;
        Integer tekenlaag = (Integer)map.get("tekenKaartlaagId");
        Integer externelaag = (Integer)map.get("externelaagid");
        if (tekenlaag != null && tekenlaag > 0) {
            gekozenKaartlaag = (Themas)sess.get(Themas.class, (Serializable)tekenlaag);
        } else if (externelaag != null && externelaag > 0) {
            gekozenKaartlaag = (Themas)sess.get(Themas.class, (Serializable)externelaag);
        }
        return gekozenKaartlaag;
    }

    private void populateForApplicatieHeader(HttpServletRequest request, String appCode) {
        Applicatie app = KaartSelectieUtil.getApplicatie((String)appCode);
        if (app != null) {
            request.setAttribute("header_appnaam", (Object)app.getNaam());
        }
    }

    public void populateForm(DynaValidatorForm dynaForm, HttpServletRequest request, Map map, String appCode) {
        Boolean useCookies = (Boolean)map.get("useCookies");
        Boolean usePopup = (Boolean)map.get("usePopup");
        Boolean useDivPopup = (Boolean)map.get("useDivPopup");
        Boolean usePanelControls = (Boolean)map.get("usePanelControls");
        Integer autoRedirect = (Integer)map.get("autoRedirect");
        Integer tolerance = (Integer)map.get("tolerance");
        Integer refreshDelay = (Integer)map.get("refreshDelay");
        String planSelectieIds = (String)map.get("planSelectieIds");
        Integer minBboxZoeken = (Integer)map.get("minBboxZoeken");
        Integer maxResults = (Integer)map.get("maxResults");
        Integer defaultSearchRadius = (Integer)map.get("defaultSearchRadius");
        Boolean expandAll = (Boolean)map.get("expandAll");
        Boolean multipleActiveThemas = (Boolean)map.get("multipleActiveThemas");
        Boolean useInheritCheckbox = (Boolean)map.get("useInheritCheckbox");
        Boolean showLegendInTree = (Boolean)map.get("showLegendInTree");
        Boolean useMouseOverTabs = (Boolean)map.get("useMouseOverTabs");
        String layoutAdminData = (String)map.get("layoutAdminData");
        Boolean showRedliningTools = (Boolean)map.get("showRedliningTools");
        Boolean showBufferTool = (Boolean)map.get("showBufferTool");
        Boolean showSelectBulkTool = (Boolean)map.get("showSelectBulkTool");
        Boolean showNeedleTool = (Boolean)map.get("showNeedleTool");
        Boolean showPrintTool = (Boolean)map.get("showPrintTool");
        Boolean showLayerSelectionTool = (Boolean)map.get("showLayerSelectionTool");
        Boolean showGPSTool = (Boolean)map.get("showGPSTool");
        Boolean edit = (Boolean)map.get("showEditTool");
        String gpsBuffer = (String)map.get("gpsBuffer");
        Boolean showXYTool = (Boolean)map.get("showXYTool");
        Boolean useUserWmsDropdown = (Boolean)map.get("useUserWmsDropdown");
        Boolean datasetDownload = (Boolean)map.get("datasetDownload");
        Boolean showServiceUrl = (Boolean)map.get("showServiceUrl");
        Boolean useOwnCyclomedia = (Boolean)map.get("useOwnCyclomedia");
        String ownCyclomediaUrl = (String)map.get("ownCyclomediaUrl");
        String layerGrouping = (String)map.get("layerGrouping");
        String popupWidth = (String)map.get("popupWidth");
        String popupHeight = (String)map.get("popupHeight");
        String popupLeft = (String)map.get("popupLeft");
        String popupTop = (String)map.get("popupTop");
        String defaultdataframehoogte = (String)map.get("defaultdataframehoogte");
        String viewerType = (String)map.get("viewerType");
        String viewerTemplate = (String)map.get("viewerTemplate");
        String objectInfoType = (String)map.get("objectInfoType");
        String treeOrder = (String)map.get("treeOrder");
        Integer tabWidth = (Integer)map.get("tabWidth");
        Integer tabWidthLeft = (Integer)map.get("tabWidthLeft");
        String extent = (String)map.get("extent");
        String fullextent = (String)map.get("fullextent");
        String activeTab = (String)map.get("activeTab");
        String transSliderTab = (String)map.get("transSliderTab");
        String tilingResolutions = (String)map.get("tilingResolutions");
        String showInfoTab = (String)map.get("showInfoTab");
        String homeUrl = (String)map.get("homeUrl");
        String helpUrl = (String)map.get("helpUrl");
        Boolean showGoogleMapsIcon = (Boolean)map.get("showGoogleMapsIcon");
        Boolean showBookmarkIcon = (Boolean)map.get("showBookmarkIcon");
        String contactUrl = (String)map.get("contactUrl");
        String logoutUrl = (String)map.get("logoutUrl");
        String tekenFilterColumn = (String)map.get("tekenFilterColumn");
        String tekenFilterSld = (String)map.get("tekenFilterSld");
        this.fillZoekConfigBox(dynaForm, request, map);
        this.fillPlanSelectieBox(dynaForm, request, planSelectieIds);
        this.fillMeldingenBox(dynaForm, request, map);
        dynaForm.set("cfg_useCookies", (Object)useCookies);
        dynaForm.set("cfg_autoRedirect", (Object)autoRedirect);
        dynaForm.set("cfg_tolerance", (Object)tolerance);
        dynaForm.set("cfg_refreshDelay", (Object)refreshDelay);
        dynaForm.set("cfg_minBboxZoeken", (Object)minBboxZoeken);
        dynaForm.set("cfg_maxResults", (Object)maxResults);
        dynaForm.set("cfg_defaultSearchRadius", (Object)defaultSearchRadius);
        dynaForm.set("cfg_expandAll", (Object)expandAll);
        dynaForm.set("cfg_multipleActiveThemas", (Object)multipleActiveThemas);
        dynaForm.set("cfg_useInheritCheckbox", (Object)useInheritCheckbox);
        dynaForm.set("cfg_showLegendInTree", (Object)showLegendInTree);
        dynaForm.set("cfg_useMouseOverTabs", (Object)useMouseOverTabs);
        dynaForm.set("cfg_layoutAdminData", (Object)layoutAdminData);
        dynaForm.set("cfg_showRedliningTools", (Object)showRedliningTools);
        dynaForm.set("cfg_showBufferTool", (Object)showBufferTool);
        dynaForm.set("cfg_showSelectBulkTool", (Object)showSelectBulkTool);
        dynaForm.set("cfg_showNeedleTool", (Object)showNeedleTool);
        dynaForm.set("cfg_showPrintTool", (Object)showPrintTool);
        dynaForm.set("cfg_showLayerSelectionTool", (Object)showLayerSelectionTool);
        dynaForm.set("cfg_showGPSTool", (Object)showGPSTool);
        dynaForm.set("cfg_showEditTool", (Object)edit);
        dynaForm.set("cfg_GPSBuffer", (Object)gpsBuffer);
        dynaForm.set("cfg_showXYTool", (Object)showXYTool);
        dynaForm.set("cfg_useOwnCyclomedia", (Object)useOwnCyclomedia);
        dynaForm.set("cfg_ownCyclomediaUrl", (Object)ownCyclomediaUrl);
        dynaForm.set("cfg_layerGrouping", (Object)layerGrouping);
        dynaForm.set("cfg_popupWidth", (Object)popupWidth);
        dynaForm.set("cfg_popupHeight", (Object)popupHeight);
        dynaForm.set("cfg_popupLeft", (Object)popupLeft);
        dynaForm.set("cfg_popupTop", (Object)popupTop);
        dynaForm.set("cfg_defaultdataframehoogte", (Object)defaultdataframehoogte);
        dynaForm.set("cfg_viewerType", (Object)viewerType);
        dynaForm.set("cfg_viewerTemplate", (Object)viewerTemplate);
        dynaForm.set("cfg_objectInfoType", (Object)objectInfoType);
        dynaForm.set("cfg_treeOrder", (Object)treeOrder);
        dynaForm.set("cfg_tabWidth", (Object)tabWidth);
        dynaForm.set("cfg_tabWidthLeft", (Object)tabWidthLeft);
        dynaForm.set("cfg_activeTab", (Object)activeTab);
        dynaForm.set("cfg_transSliderTab", (Object)transSliderTab);
        dynaForm.set("cfg_extent", (Object)extent);
        dynaForm.set("cfg_fullextent", (Object)fullextent);
        dynaForm.set("appcode", (Object)appCode);
        this.fillTabbladenConfig(dynaForm, map);
        dynaForm.set("cfg_redlininggegevensbron", (Object)((Integer)map.get("redliningGegevensbron")));
        dynaForm.set("cfg_redliningkaartlaagid", (Object)((Integer)map.get("redliningkaartlaagid")));
        dynaForm.set("cfg_tekenGegevensbron", (Object)((Integer)map.get("tekenGegevensbron")));
        dynaForm.set("cfg_tekenTekstBoven", (Object)((String)map.get("tekenTekstBoven")));
        dynaForm.set("cfg_tekenTekstOnder", (Object)((String)map.get("tekenTekstOnder")));
        dynaForm.set("cfg_tekenTitel", (Object)((String)map.get("tekenTitel")));
        dynaForm.set("cfg_tekenPlaatje", (Object)((String)map.get("tekenPlaatje")));
        if (map.get("bagkaartlaagid") != null) {
            dynaForm.set("cfg_bagkaartlaagid", (Object)((Integer)map.get("bagkaartlaagid")));
        }
        if (map.get("bagMaxBouwjaar") != null) {
            dynaForm.set("cfg_bagmaxbouwjaar", (Object)((Integer)map.get("bagMaxBouwjaar")));
        }
        if (map.get("bagMinBouwjaar") != null) {
            dynaForm.set("cfg_bagminbouwjaar", (Object)((Integer)map.get("bagMinBouwjaar")));
        }
        if (map.get("bagMaxOpp") != null) {
            dynaForm.set("cfg_bagmaxopp", (Object)((Integer)map.get("bagMaxOpp")));
        }
        if (map.get("bagMinOpp") != null) {
            dynaForm.set("cfg_bagminopp", (Object)((Integer)map.get("bagMinOpp")));
        }
        if (map.get("bagOppAttr") != null) {
            dynaForm.set("cfg_bagOppAttr", (Object)((String)map.get("bagOppAttr")));
        }
        if (map.get("bagBouwjaarAttr") != null) {
            dynaForm.set("cfg_bagBouwjaarAttr", (Object)((String)map.get("bagBouwjaarAttr")));
        }
        if (map.get("bagGebruiksfunctieAttr") != null) {
            dynaForm.set("cfg_bagGebruiksfunctieAttr", (Object)((String)map.get("bagGebruiksfunctieAttr")));
        }
        if (map.get("bagGeomAttr") != null) {
            dynaForm.set("cfg_bagGeomAttr", (Object)((String)map.get("bagGeomAttr")));
        }
        dynaForm.set("cfg_useUserWmsDropdown", (Object)useUserWmsDropdown);
        dynaForm.set("cfg_datasetDownload", (Object)datasetDownload);
        dynaForm.set("cfg_tilingResolutions", (Object)tilingResolutions);
        dynaForm.set("cfg_showServiceUrl", (Object)showServiceUrl);
        dynaForm.set("cfg_showInfoTab", (Object)showInfoTab);
        dynaForm.set("cfg_homeUrl", (Object)homeUrl);
        dynaForm.set("cfg_helpUrl", (Object)helpUrl);
        dynaForm.set("cfg_showGoogleMapsIcon", (Object)showGoogleMapsIcon);
        dynaForm.set("cfg_showBookmarkIcon", (Object)showBookmarkIcon);
        dynaForm.set("cfg_contactUrl", (Object)contactUrl);
        dynaForm.set("cfg_logoutUrl", (Object)logoutUrl);
        dynaForm.set("cfg_tekenKaartlaagId", (Object)((Integer)map.get("tekenKaartlaagId")));
        dynaForm.set("cfg_tekenFilterColumn", (Object)tekenFilterColumn);
        dynaForm.set("cfg_tekenFilterSld", (Object)tekenFilterSld);
        dynaForm.set("cfg_highlightFilterSld", (Object)tekenFilterSld);
        if (map.get("externelaagid") != null) {
            dynaForm.set("cfg_externelaagid", (Object)((Integer)map.get("externelaagid")));
        }
        if (map.get("externeWegvakidAttr") != null) {
            dynaForm.set("cfg_externeWegvakidAttr", (Object)((String)map.get("externeWegvakidAttr")));
        }
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String appCode = (String)dynaForm.get("appcode");
        if (!this.isTokenValid(request)) {
            KaartSelectieUtil.populateKaartSelectieForm((String)appCode, (HttpServletRequest)request);
            this.populateForApplicatieHeader(request, appCode);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        this.saveKaartSelectie(appCode, dynaForm, request);
        this.populateObject(dynaForm, appCode);
        KaartSelectieUtil.populateKaartSelectieForm((String)appCode, (HttpServletRequest)request);
        this.populateForApplicatieHeader(request, appCode);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    private void saveKaartSelectie(String appCode, DynaValidatorForm dynaForm, HttpServletRequest request) throws JSONException, Exception {
        String[] kaartgroepenAan = (String[])dynaForm.get("kaartgroepenAan");
        String[] kaartlagenAan = (String[])dynaForm.get("kaartlagenAan");
        String[] kaartgroepenDefaultAan = (String[])dynaForm.get("kaartgroepenDefaultAan");
        String[] kaartlagenDefaultAan = (String[])dynaForm.get("kaartlagenDefaultAan");
        String[] layersAan = (String[])dynaForm.get("layersAan");
        String[] layersDefaultAan = (String[])dynaForm.get("layersDefaultAan");
        String[] useLayerStyles = (String[])dynaForm.get("useLayerStyles");
        String[] userLayerIds = (String[])dynaForm.get("userLayerIds");
        String[] useLayerSldParts = (String[])dynaForm.get("useLayerSldParts");
        kaartgroepenAan = KaartSelectieUtil.addDefaultOnValues((String[])kaartgroepenDefaultAan, (String[])kaartgroepenAan);
        kaartlagenAan = KaartSelectieUtil.addDefaultOnValues((String[])kaartlagenDefaultAan, (String[])kaartlagenAan);
        layersAan = KaartSelectieUtil.addDefaultOnValues((String[])layersDefaultAan, (String[])layersAan);
        KaartSelectieUtil.removeExistingUserKaartgroepAndUserKaartlagen((String)appCode);
        KaartSelectieUtil.resetExistingUserLayers((String)appCode);
        KaartSelectieUtil.saveKaartGroepen((String)appCode, (String[])kaartgroepenAan, (String[])kaartgroepenDefaultAan);
        KaartSelectieUtil.saveKaartlagen((String)appCode, (String[])kaartlagenAan, (String[])kaartlagenDefaultAan);
        KaartSelectieUtil.saveServiceLayers((String[])layersAan, (String[])layersDefaultAan);
        KaartSelectieUtil.saveUserLayerStyles((String[])useLayerStyles);
        KaartSelectieUtil.saveUserLayerSldParts((String[])userLayerIds, (String[])useLayerSldParts);
    }

    public void populateObject(DynaValidatorForm dynaForm, String appCode) {
        ConfigKeeper configKeeper = new ConfigKeeper();
        Configuratie c = null;
        this.writeTabbladenConfig(dynaForm, appCode);
        c = configKeeper.getConfiguratie("useCookies", appCode);
        this.writeBoolean(dynaForm, "cfg_useCookies", c);
        c = configKeeper.getConfiguratie("autoRedirect", appCode);
        this.writeInteger(dynaForm, "cfg_autoRedirect", c);
        c = configKeeper.getConfiguratie("tolerance", appCode);
        this.writeInteger(dynaForm, "cfg_tolerance", c);
        c = configKeeper.getConfiguratie("refreshDelay", appCode);
        this.writeInteger(dynaForm, "cfg_refreshDelay", c);
        c = configKeeper.getConfiguratie("minBboxZoeken", appCode);
        this.writeInteger(dynaForm, "cfg_minBboxZoeken", c);
        c = configKeeper.getConfiguratie("maxResults", appCode);
        this.writeInteger(dynaForm, "cfg_maxResults", c);
        c = configKeeper.getConfiguratie("defaultSearchRadius", appCode);
        this.writeInteger(dynaForm, "cfg_defaultSearchRadius", c);
        c = configKeeper.getConfiguratie("expandAll", appCode);
        this.writeBoolean(dynaForm, "cfg_expandAll", c);
        c = configKeeper.getConfiguratie("multipleActiveThemas", appCode);
        this.writeBoolean(dynaForm, "cfg_multipleActiveThemas", c);
        c = configKeeper.getConfiguratie("useInheritCheckbox", appCode);
        this.writeBoolean(dynaForm, "cfg_useInheritCheckbox", c);
        c = configKeeper.getConfiguratie("showLegendInTree", appCode);
        this.writeBoolean(dynaForm, "cfg_showLegendInTree", c);
        c = configKeeper.getConfiguratie("useMouseOverTabs", appCode);
        this.writeBoolean(dynaForm, "cfg_useMouseOverTabs", c);
        c = configKeeper.getConfiguratie("layoutAdminData", appCode);
        this.writeString(dynaForm, "cfg_layoutAdminData", c);
        c = configKeeper.getConfiguratie("showRedliningTools", appCode);
        this.writeBoolean(dynaForm, "cfg_showRedliningTools", c);
        c = configKeeper.getConfiguratie("showBufferTool", appCode);
        this.writeBoolean(dynaForm, "cfg_showBufferTool", c);
        c = configKeeper.getConfiguratie("showSelectBulkTool", appCode);
        this.writeBoolean(dynaForm, "cfg_showSelectBulkTool", c);
        c = configKeeper.getConfiguratie("showNeedleTool", appCode);
        this.writeBoolean(dynaForm, "cfg_showNeedleTool", c);
        c = configKeeper.getConfiguratie("showPrintTool", appCode);
        this.writeBoolean(dynaForm, "cfg_showPrintTool", c);
        c = configKeeper.getConfiguratie("showLayerSelectionTool", appCode);
        this.writeBoolean(dynaForm, "cfg_showLayerSelectionTool", c);
        c = configKeeper.getConfiguratie("showGPSTool", appCode);
        this.writeBoolean(dynaForm, "cfg_showGPSTool", c);
        c = configKeeper.getConfiguratie("showEditTool", appCode);
        this.writeBoolean(dynaForm, "cfg_showEditTool", c);
        c = configKeeper.getConfiguratie("gpsBuffer", appCode);
        this.writeString(dynaForm, "cfg_GPSBuffer", c);
        c = configKeeper.getConfiguratie("showXYTool", appCode);
        this.writeBoolean(dynaForm, "cfg_showXYTool", c);
        c = configKeeper.getConfiguratie("layerGrouping", appCode);
        this.writeString(dynaForm, "cfg_layerGrouping", c);
        c = configKeeper.getConfiguratie("popupWidth", appCode);
        this.writeString(dynaForm, "cfg_popupWidth", c);
        c = configKeeper.getConfiguratie("popupHeight", appCode);
        this.writeString(dynaForm, "cfg_popupHeight", c);
        c = configKeeper.getConfiguratie("popupLeft", appCode);
        this.writeString(dynaForm, "cfg_popupLeft", c);
        c = configKeeper.getConfiguratie("popupTop", appCode);
        this.writeString(dynaForm, "cfg_popupTop", c);
        c = configKeeper.getConfiguratie("defaultdataframehoogte", appCode);
        this.writeString(dynaForm, "cfg_defaultdataframehoogte", c);
        c = configKeeper.getConfiguratie("viewerType", appCode);
        this.writeString(dynaForm, "cfg_viewerType", c);
        c = configKeeper.getConfiguratie("viewerTemplate", appCode);
        this.writeString(dynaForm, "cfg_viewerTemplate", c);
        c = configKeeper.getConfiguratie("objectInfoType", appCode);
        this.writeString(dynaForm, "cfg_objectInfoType", c);
        c = configKeeper.getConfiguratie("treeOrder", appCode);
        this.writeString(dynaForm, "cfg_treeOrder", c);
        c = configKeeper.getConfiguratie("tabWidth", appCode);
        this.writeInteger(dynaForm, "cfg_tabWidth", c);
        c = configKeeper.getConfiguratie("tabWidthLeft", appCode);
        this.writeInteger(dynaForm, "cfg_tabWidthLeft", c);
        c = configKeeper.getConfiguratie("activeTab", appCode);
        this.writeString(dynaForm, "cfg_activeTab", c);
        c = configKeeper.getConfiguratie("transSliderTab", appCode);
        this.writeString(dynaForm, "cfg_transSliderTab", c);
        c = configKeeper.getConfiguratie("extent", appCode);
        this.writeString(dynaForm, "cfg_extent", c);
        c = configKeeper.getConfiguratie("fullextent", appCode);
        this.writeString(dynaForm, "cfg_fullextent", c);
        c = configKeeper.getConfiguratie("useOwnCyclomedia", appCode);
        this.writeBoolean(dynaForm, "cfg_useOwnCyclomedia", c);
        c = configKeeper.getConfiguratie("ownCyclomediaUrl", appCode);
        this.writeString(dynaForm, "cfg_ownCyclomediaUrl", c);
        this.writeZoekenConfig(dynaForm, appCode);
        this.writePlanSelectieIdConfig(dynaForm, appCode);
        this.writeMeldingConfig(dynaForm, appCode);
        c = configKeeper.getConfiguratie("redliningGegevensbron", appCode);
        this.writeInteger(dynaForm, "cfg_redlininggegevensbron", c);
        c = configKeeper.getConfiguratie("redliningkaartlaagid", appCode);
        this.writeInteger(dynaForm, "cfg_redliningkaartlaagid", c);
        c = configKeeper.getConfiguratie("tekenGegevensbron", appCode);
        this.writeInteger(dynaForm, "cfg_tekenGegevensbron", c);
        c = configKeeper.getConfiguratie("tekenTekstBoven", appCode);
        this.writeString(dynaForm, "cfg_tekenTekstBoven", c);
        c = configKeeper.getConfiguratie("tekenTekstOnder", appCode);
        this.writeString(dynaForm, "cfg_tekenTekstOnder", c);
        c = configKeeper.getConfiguratie("tekenTitel", appCode);
        this.writeString(dynaForm, "cfg_tekenTitel", c);
        c = configKeeper.getConfiguratie("tekenPlaatje", appCode);
        this.writeString(dynaForm, "cfg_tekenPlaatje", c);
        c = configKeeper.getConfiguratie("bagkaartlaagid", appCode);
        this.writeInteger(dynaForm, "cfg_bagkaartlaagid", c);
        c = configKeeper.getConfiguratie("bagMaxBouwjaar", appCode);
        this.writeInteger(dynaForm, "cfg_bagmaxbouwjaar", c);
        c = configKeeper.getConfiguratie("bagMinBouwjaar", appCode);
        this.writeInteger(dynaForm, "cfg_bagminbouwjaar", c);
        c = configKeeper.getConfiguratie("bagMaxOpp", appCode);
        this.writeInteger(dynaForm, "cfg_bagmaxopp", c);
        c = configKeeper.getConfiguratie("bagMinOpp", appCode);
        this.writeInteger(dynaForm, "cfg_bagminopp", c);
        c = configKeeper.getConfiguratie("bagOppAttr", appCode);
        this.writeString(dynaForm, "cfg_bagOppAttr", c);
        c = configKeeper.getConfiguratie("bagBouwjaarAttr", appCode);
        this.writeString(dynaForm, "cfg_bagBouwjaarAttr", c);
        c = configKeeper.getConfiguratie("bagGebruiksfunctieAttr", appCode);
        this.writeString(dynaForm, "cfg_bagGebruiksfunctieAttr", c);
        c = configKeeper.getConfiguratie("bagGeomAttr", appCode);
        this.writeString(dynaForm, "cfg_bagGeomAttr", c);
        c = configKeeper.getConfiguratie("useUserWmsDropdown", appCode);
        this.writeBoolean(dynaForm, "cfg_useUserWmsDropdown", c);
        c = configKeeper.getConfiguratie("datasetDownload", appCode);
        this.writeBoolean(dynaForm, "cfg_datasetDownload", c);
        c = configKeeper.getConfiguratie("tilingResolutions", appCode);
        this.writeString(dynaForm, "cfg_tilingResolutions", c);
        c = configKeeper.getConfiguratie("showServiceUrl", appCode);
        this.writeBoolean(dynaForm, "cfg_showServiceUrl", c);
        c = configKeeper.getConfiguratie("showInfoTab", appCode);
        this.writeString(dynaForm, "cfg_showInfoTab", c);
        c = configKeeper.getConfiguratie("homeUrl", appCode);
        this.writeString(dynaForm, "cfg_homeUrl", c);
        c = configKeeper.getConfiguratie("helpUrl", appCode);
        this.writeString(dynaForm, "cfg_helpUrl", c);
        c = configKeeper.getConfiguratie("showGoogleMapsIcon", appCode);
        this.writeBoolean(dynaForm, "cfg_showGoogleMapsIcon", c);
        c = configKeeper.getConfiguratie("showBookmarkIcon", appCode);
        this.writeBoolean(dynaForm, "cfg_showBookmarkIcon", c);
        c = configKeeper.getConfiguratie("contactUrl", appCode);
        this.writeString(dynaForm, "cfg_contactUrl", c);
        c = configKeeper.getConfiguratie("logoutUrl", appCode);
        this.writeString(dynaForm, "cfg_logoutUrl", c);
        c = configKeeper.getConfiguratie("tekenKaartlaagId", appCode);
        this.writeInteger(dynaForm, "cfg_tekenKaartlaagId", c);
        c = configKeeper.getConfiguratie("tekenFilterColumn", appCode);
        this.writeString(dynaForm, "cfg_tekenFilterColumn", c);
        c = configKeeper.getConfiguratie("tekenFilterSld", appCode);
        this.writeString(dynaForm, "cfg_tekenFilterSld", c);
        if (dynaForm.get("cfg_highlightFilterSld") != null) {
            c = configKeeper.getConfiguratie("tekenFilterSld", appCode);
            this.writeString(dynaForm, "cfg_highlightFilterSld", c);
        }
        c = configKeeper.getConfiguratie("externelaagid", appCode);
        this.writeInteger(dynaForm, "cfg_externelaagid", c);
        c = configKeeper.getConfiguratie("externeWegvakidAttr", appCode);
        this.writeString(dynaForm, "cfg_externeWegvakidAttr", c);
    }

    private void writeMeldingConfig(DynaValidatorForm dynaForm, String appCode) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ConfigKeeper configKeeper = new ConfigKeeper();
        Configuratie config = configKeeper.getConfiguratie("meldingWelkomtekst", appCode);
        this.writeString(dynaForm, "cfg_meldingwelkomtekst", config);
        config = configKeeper.getConfiguratie("meldingPrefix", appCode);
        this.writeString(dynaForm, "cfg_meldingprefix", config);
        config = configKeeper.getConfiguratie("meldingType", appCode);
        this.writeString(dynaForm, "cfg_meldingtype", config);
        config = configKeeper.getConfiguratie("meldingStatus", appCode);
        this.writeString(dynaForm, "cfg_meldingstatus", config);
        config = configKeeper.getConfiguratie("meldingLayoutEmailMelder", appCode);
        this.writeString(dynaForm, "cfg_meldinglayoutemailmelder", config);
        config = configKeeper.getConfiguratie("meldingNaam", appCode);
        this.writeString(dynaForm, "cfg_meldingnaam", config);
        config = configKeeper.getConfiguratie("meldingEmail", appCode);
        this.writeString(dynaForm, "cfg_meldingemail", config);
        config = configKeeper.getConfiguratie("meldingEmailMelder", appCode);
        this.writeBoolean(dynaForm, "cfg_meldingemailmelder", config);
        config = configKeeper.getConfiguratie("meldingEmailBehandelaar", appCode);
        this.writeBoolean(dynaForm, "cfg_meldingemailbehandelaar", config);
        config = configKeeper.getConfiguratie("meldingLayoutEmailBehandelaar", appCode);
        this.writeString(dynaForm, "cfg_meldinglayoutemailbehandelaar", config);
        config = configKeeper.getConfiguratie("meldingGegevensbron", appCode);
        this.writeInteger(dynaForm, "cfg_meldinggegevensbron", config);
        config = configKeeper.getConfiguratie("meldingObjectSoort", appCode);
        this.writeString(dynaForm, "cfg_meldingobjectsoort", config);
        config = configKeeper.getConfiguratie("meldingTekentoolIcoon", appCode);
        this.writeString(dynaForm, "cfg_meldingtekentoolicoon", config);
        config = configKeeper.getConfiguratie("smtpHost", appCode);
        this.writeString(dynaForm, "cfg_smtpHost", config);
        config = configKeeper.getConfiguratie("fromMailAddress", appCode);
        this.writeString(dynaForm, "cfg_fromMailAddress", config);
        config = configKeeper.getConfiguratie("mailSubject", appCode);
        this.writeString(dynaForm, "cfg_mailSubject", config);
        sess.flush();
    }

    private void writeZoekenConfig(DynaValidatorForm form, String appCode) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ConfigKeeper configKeeper = new ConfigKeeper();
        int lastComma = -1;
        Configuratie configTabs = configKeeper.getConfiguratie("zoekConfigIds", appCode);
        String strBeheerTabs = "";
        if (!form.get("cfg_zoekenid1").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + form.get("cfg_zoekenid1") + ",";
        }
        if (!form.get("cfg_zoekenid2").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + form.get("cfg_zoekenid2") + ",";
        }
        if (!form.get("cfg_zoekenid3").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + form.get("cfg_zoekenid3") + ",";
        }
        if (!form.get("cfg_zoekenid4").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + form.get("cfg_zoekenid4") + ",";
        }
        if (!form.get("cfg_zoekenid5").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + form.get("cfg_zoekenid5") + ",";
        }
        if (!form.get("cfg_zoekenid6").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + form.get("cfg_zoekenid6") + ",";
        }
        if (!form.get("cfg_zoekenid7").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + form.get("cfg_zoekenid7") + ",";
        }
        if (!form.get("cfg_zoekenid8").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + form.get("cfg_zoekenid8") + ",";
        }
        if (!form.get("cfg_zoekenid9").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + form.get("cfg_zoekenid9") + ",";
        }
        if (!form.get("cfg_zoekenid10").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + form.get("cfg_zoekenid10") + ",";
        }
        if ((lastComma = strBeheerTabs.lastIndexOf(",")) > 0) {
            strBeheerTabs = strBeheerTabs.substring(0, lastComma);
        }
        if ((strBeheerTabs = "\"" + strBeheerTabs + "\"") != null && strBeheerTabs.equals("\"\"")) {
            configTabs.setPropval(null);
        } else {
            configTabs.setPropval(strBeheerTabs);
        }
        configTabs.setType("java.lang.String");
        Configuratie config = configKeeper.getConfiguratie("zoekenAutoIdentify", appCode);
        this.writeBoolean(form, "cfg_zoeken_autoidentify", config);
        sess.merge((Object)configTabs);
        sess.flush();
    }

    private void writePlanSelectieIdConfig(DynaValidatorForm form, String appCode) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ConfigKeeper configKeeper = new ConfigKeeper();
        int lastComma = -1;
        Configuratie configTabs = configKeeper.getConfiguratie("planSelectieIds", appCode);
        String strBeheerTabs = "";
        if (!form.get("cfg_planselectieid1").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + form.get("cfg_planselectieid1") + ",";
        }
        if (!form.get("cfg_planselectieid2").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + form.get("cfg_planselectieid2") + ",";
        }
        if ((lastComma = strBeheerTabs.lastIndexOf(",")) > 1) {
            strBeheerTabs = strBeheerTabs.substring(0, lastComma);
        }
        strBeheerTabs = "\"" + strBeheerTabs + "\"";
        configTabs.setPropval(strBeheerTabs);
        configTabs.setType("java.lang.String");
        sess.merge((Object)configTabs);
        sess.flush();
    }

    private void writeTabbladenConfig(DynaValidatorForm form, String appCode) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ConfigKeeper configKeeper = new ConfigKeeper();
        int lastComma = -1;
        Configuratie configTabs = configKeeper.getConfiguratie("tabs", appCode);
        String strBeheerTabs = "";
        if (!form.get("cfg_tab1").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + "\"" + form.get("cfg_tab1") + "\",";
        }
        if (!form.get("cfg_tab2").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + "\"" + form.get("cfg_tab2") + "\",";
        }
        if (!form.get("cfg_tab3").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + "\"" + form.get("cfg_tab3") + "\",";
        }
        if (!form.get("cfg_tab4").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + "\"" + form.get("cfg_tab4") + "\",";
        }
        if (!form.get("cfg_tab5").equals("leeg")) {
            strBeheerTabs = strBeheerTabs + "\"" + form.get("cfg_tab5") + "\",";
        }
        if ((lastComma = strBeheerTabs.lastIndexOf(",")) > 1) {
            strBeheerTabs = strBeheerTabs.substring(0, lastComma);
        }
        if (configTabs != null) {
            configTabs.setPropval(strBeheerTabs);
            configTabs.setType("java.lang.String");
            sess.merge((Object)configTabs);
            sess.flush();
        }
        Configuratie configTabsLeft = configKeeper.getConfiguratie("tabsLeft", appCode);
        String strBeheerTabsLeft = "";
        if (!form.get("cfg_tab1_left").equals("leeg")) {
            strBeheerTabsLeft = strBeheerTabsLeft + "\"" + form.get("cfg_tab1_left") + "\",";
        }
        if (!form.get("cfg_tab2_left").equals("leeg")) {
            strBeheerTabsLeft = strBeheerTabsLeft + "\"" + form.get("cfg_tab2_left") + "\",";
        }
        if (!form.get("cfg_tab3_left").equals("leeg")) {
            strBeheerTabsLeft = strBeheerTabsLeft + "\"" + form.get("cfg_tab3_left") + "\",";
        }
        if (!form.get("cfg_tab4_left").equals("leeg")) {
            strBeheerTabsLeft = strBeheerTabsLeft + "\"" + form.get("cfg_tab4_left") + "\",";
        }
        if (!form.get("cfg_tab5_left").equals("leeg")) {
            strBeheerTabsLeft = strBeheerTabsLeft + "\"" + form.get("cfg_tab5_left") + "\",";
        }
        if ((lastComma = strBeheerTabsLeft.lastIndexOf(",")) > 1) {
            strBeheerTabsLeft = strBeheerTabsLeft.substring(0, lastComma);
        }
        if (configTabsLeft != null) {
            configTabsLeft.setPropval(strBeheerTabsLeft);
            configTabsLeft.setType("java.lang.String");
            sess.merge((Object)configTabsLeft);
            sess.flush();
        }
    }

    private void writeBoolean(DynaValidatorForm form, String field, Configuratie c) {
        if (c != null) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            if (form.get(field) != null && form.get(field).toString().length() > 0) {
                c.setPropval("true");
            } else {
                c.setPropval("false");
            }
            c.setType("java.lang.Boolean");
            sess.merge((Object)c);
            sess.flush();
        }
    }

    private void writeInteger(DynaValidatorForm form, String field, Configuratie c) {
        if (c != null) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            if (form.get(field) != null) {
                c.setPropval(form.get(field).toString());
            } else {
                c.setPropval("0");
            }
            c.setType("java.lang.Integer");
            sess.merge((Object)c);
            sess.flush();
        }
    }

    private void writeString(DynaValidatorForm form, String field, Configuratie c) {
        if (c != null) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            if (form.get(field) != null) {
                c.setPropval(form.get(field).toString());
            } else {
                c.setPropval("");
            }
            c.setType("java.lang.String");
            sess.merge((Object)c);
            sess.flush();
        }
    }

    private void fillTabbladenConfig(DynaValidatorForm dynaForm, Map map) {
        String cfg_tab5;
        String cfg_tab4;
        String cfg_tab3;
        String cfg_tab2;
        String cfg_tab1;
        String tabs = (String)map.get("tabs");
        if (tabs == null) {
            return;
        }
        String[] items = tabs.split(",");
        if (items.length > 0) {
            if (items[0] != null || items[0].equals("")) {
                cfg_tab1 = items[0].replaceAll("\"", "");
                dynaForm.set("cfg_tab1", (Object)cfg_tab1);
            }
        } else {
            dynaForm.set("cfg_tab1", (Object)CONFIGKEEPER_TABS[0]);
        }
        if (items.length > 1) {
            if (items[1] != null || items[1].equals("")) {
                cfg_tab2 = items[1].replaceAll("\"", "");
                dynaForm.set("cfg_tab2", (Object)cfg_tab2);
            }
        } else {
            dynaForm.set("cfg_tab2", (Object)CONFIGKEEPER_TABS[0]);
        }
        if (items.length > 2) {
            if (items[2] != null || items[2].equals("")) {
                cfg_tab3 = items[2].replaceAll("\"", "");
                dynaForm.set("cfg_tab3", (Object)cfg_tab3);
            }
        } else {
            dynaForm.set("cfg_tab3", (Object)CONFIGKEEPER_TABS[0]);
        }
        if (items.length > 3) {
            if (items[3] != null || items[3].equals("")) {
                cfg_tab4 = items[3].replaceAll("\"", "");
                dynaForm.set("cfg_tab4", (Object)cfg_tab4);
            }
        } else {
            dynaForm.set("cfg_tab4", (Object)CONFIGKEEPER_TABS[0]);
        }
        if (items.length > 4) {
            if (items[4] != null || items[4].equals("")) {
                cfg_tab5 = items[4].replaceAll("\"", "");
                dynaForm.set("cfg_tab5", (Object)cfg_tab5);
            }
        } else {
            dynaForm.set("cfg_tab5", (Object)CONFIGKEEPER_TABS[0]);
        }
        if ((tabs = (String)map.get("tabsLeft")) == null) {
            return;
        }
        items = tabs.split(",");
        if (items.length > 0) {
            if (items[0] != null || items[0].equals("")) {
                cfg_tab1 = items[0].replaceAll("\"", "");
                dynaForm.set("cfg_tab1_left", (Object)cfg_tab1);
            }
        } else {
            dynaForm.set("cfg_tab1_left", (Object)CONFIGKEEPER_TABS[0]);
        }
        if (items.length > 1) {
            if (items[1] != null || items[1].equals("")) {
                cfg_tab2 = items[1].replaceAll("\"", "");
                dynaForm.set("cfg_tab2_left", (Object)cfg_tab2);
            }
        } else {
            dynaForm.set("cfg_tab2_left", (Object)CONFIGKEEPER_TABS[0]);
        }
        if (items.length > 2) {
            if (items[2] != null || items[2].equals("")) {
                cfg_tab3 = items[2].replaceAll("\"", "");
                dynaForm.set("cfg_tab3_left", (Object)cfg_tab3);
            }
        } else {
            dynaForm.set("cfg_tab3_left", (Object)CONFIGKEEPER_TABS[0]);
        }
        if (items.length > 3) {
            if (items[3] != null || items[3].equals("")) {
                cfg_tab4 = items[3].replaceAll("\"", "");
                dynaForm.set("cfg_tab4_left", (Object)cfg_tab4);
            }
        } else {
            dynaForm.set("cfg_tab4_left", (Object)CONFIGKEEPER_TABS[0]);
        }
        if (items.length > 4) {
            if (items[4] != null || items[4].equals("")) {
                cfg_tab5 = items[4].replaceAll("\"", "");
                dynaForm.set("cfg_tab5_left", (Object)cfg_tab5);
            }
        } else {
            dynaForm.set("cfg_tab5_left", (Object)CONFIGKEEPER_TABS[0]);
        }
    }

    private void fillZoekConfigBox(DynaValidatorForm dynaForm, HttpServletRequest request, Map map) {
        Boolean autoIdentify = true;
        if (map.containsKey("zoekenAutoIdentify")) {
            autoIdentify = (Boolean)map.get("zoekenAutoIdentify");
        }
        dynaForm.set("cfg_zoeken_autoidentify", (Object)autoIdentify);
        String ids = (String)map.get("zoekConfigIds");
        if (ids == null) {
            return;
        }
        String[] items = ids.replaceAll("\"", "").split(",");
        if (items.length > 0 && (items[0] != null || items[0].equals(""))) {
            dynaForm.set("cfg_zoekenid1", (Object)items[0].replaceAll("\"", ""));
        }
        if (items.length > 1 && (items[1] != null || items[1].equals(""))) {
            dynaForm.set("cfg_zoekenid2", (Object)items[1].replaceAll("\"", ""));
        }
        if (items.length > 2 && (items[2] != null || items[2].equals(""))) {
            dynaForm.set("cfg_zoekenid3", (Object)items[2].replaceAll("\"", ""));
        }
        if (items.length > 3 && (items[3] != null || items[3].equals(""))) {
            dynaForm.set("cfg_zoekenid4", (Object)items[3].replaceAll("\"", ""));
        }
        if (items.length > 4 && (items[4] != null || items[4].equals(""))) {
            dynaForm.set("cfg_zoekenid5", (Object)items[4].replaceAll("\"", ""));
        }
        if (items.length > 5 && (items[5] != null || items[5].equals(""))) {
            dynaForm.set("cfg_zoekenid6", (Object)items[5].replaceAll("\"", ""));
        }
        if (items.length > 6 && (items[6] != null || items[6].equals(""))) {
            dynaForm.set("cfg_zoekenid7", (Object)items[6].replaceAll("\"", ""));
        }
        if (items.length > 7 && (items[7] != null || items[7].equals(""))) {
            dynaForm.set("cfg_zoekenid8", (Object)items[7].replaceAll("\"", ""));
        }
        if (items.length > 8 && (items[8] != null || items[8].equals(""))) {
            dynaForm.set("cfg_zoekenid9", (Object)items[8].replaceAll("\"", ""));
        }
        if (items.length > 9 && (items[9] != null || items[9].equals(""))) {
            dynaForm.set("cfg_zoekenid10", (Object)items[9].replaceAll("\"", ""));
        }
    }

    private void fillPlanSelectieBox(DynaValidatorForm dynaForm, HttpServletRequest request, String ids) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List zoekconfigs = sess.createQuery("from ZoekConfiguratie order by naam").list();
        request.setAttribute("zoekConfigs", (Object)zoekconfigs);
        if (ids == null) {
            return;
        }
        String[] items = ids.replaceAll("\"", "").split(",");
        if (items.length > 0 && (items[0] != null || items[0].equals(""))) {
            dynaForm.set("cfg_planselectieid1", (Object)items[0].replaceAll("\"", ""));
        }
        if (items.length > 1 && (items[1] != null || items[1].equals(""))) {
            dynaForm.set("cfg_planselectieid2", (Object)items[1].replaceAll("\"", ""));
        }
    }

    private void fillMeldingenBox(DynaValidatorForm dynaForm, HttpServletRequest request, Map map) {
        dynaForm.set("cfg_meldingwelkomtekst", (Object)((String)map.get("meldingWelkomtekst")));
        dynaForm.set("cfg_meldingprefix", (Object)((String)map.get("meldingPrefix")));
        dynaForm.set("cfg_meldingtype", (Object)((String)map.get("meldingType")));
        dynaForm.set("cfg_meldingstatus", (Object)((String)map.get("meldingStatus")));
        dynaForm.set("cfg_meldingemailmelder", (Object)((Boolean)map.get("meldingEmailMelder")));
        dynaForm.set("cfg_meldinglayoutemailmelder", (Object)((String)map.get("meldingLayoutEmailMelder")));
        dynaForm.set("cfg_meldingnaam", (Object)((String)map.get("meldingNaam")));
        dynaForm.set("cfg_meldingemail", (Object)((String)map.get("meldingEmail")));
        dynaForm.set("cfg_meldingemailbehandelaar", (Object)((Boolean)map.get("meldingEmailBehandelaar")));
        dynaForm.set("cfg_meldinglayoutemailbehandelaar", (Object)((String)map.get("meldingLayoutEmailBehandelaar")));
        dynaForm.set("cfg_meldinggegevensbron", (Object)((Integer)map.get("meldingGegevensbron")));
        dynaForm.set("cfg_meldingobjectsoort", (Object)((String)map.get("meldingObjectSoort")));
        dynaForm.set("cfg_meldingtekentoolicoon", (Object)((String)map.get("meldingTekentoolIcoon")));
        dynaForm.set("cfg_smtpHost", (Object)((String)map.get("smtpHost")));
        dynaForm.set("cfg_fromMailAddress", (Object)((String)map.get("fromMailAddress")));
        dynaForm.set("cfg_mailSubject", (Object)((String)map.get("mailSubject")));
    }
}

