/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.utils.KaartSelectieUtil;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.db.Applicatie;
import nl.b3p.gis.viewer.db.Configuratie;
import nl.b3p.gis.viewer.db.CyclomediaAccount;
import nl.b3p.gis.viewer.db.UserKaartgroep;
import nl.b3p.gis.viewer.db.UserKaartlaag;
import nl.b3p.gis.viewer.db.UserService;
import nl.b3p.gis.viewer.services.HibernateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.classic.Session;

public class ConfigApplicatieAction
extends ViewerCrudAction {
    private static final Log log = LogFactory.getLog(ConfigApplicatieAction.class);
    protected static final String MAPPING_COPY = "copy";
    protected static final String APPCODE_SPACES_KEY = "error.appcode.space";

    protected Map getActionMethodPropertiesMap() {
        Map map = super.getActionMethodPropertiesMap();
        ExtendedMethodProperties crudProp = null;
        crudProp = new ExtendedMethodProperties(MAPPING_COPY);
        crudProp.setDefaultForwardName("success");
        crudProp.setDefaultMessageKey("message.applicatie.copy.success");
        crudProp.setAlternateForwardName("failure");
        crudProp.setAlternateMessageKey("message.applicatie.copy.failed");
        map.put(MAPPING_COPY, crudProp);
        return map;
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    protected void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List applicaties = sess.createQuery("from Applicatie order by user_copy, naam, versie").list();
        if (applicaties != null && applicaties.size() > 0) {
            request.setAttribute("applicaties", (Object)applicaties);
        }
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Applicatie app;
        if (!this.isTokenValid(request)) {
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Boolean defaultApp = (Boolean)dynaForm.get("defaultApp");
        if (defaultApp != null) {
            this.updateAppsToNonDefault();
        }
        if ((app = this.getApplicatie(dynaForm, request)) == null) {
            app = KaartSelectieUtil.getNewApplicatie();
            this.populateObject(dynaForm, app, request, false);
            ConfigKeeper.createStandardApplicationConfiguration((String)app.getCode());
        } else {
            this.populateObject(dynaForm, app, request, true);
        }
        String formAppcode = FormUtils.nullIfEmpty((String)dynaForm.getString("appCode"));
        if (formAppcode != null && !formAppcode.isEmpty()) {
            if (formAppcode.trim().contains(" ")) {
                this.prepareMethod(dynaForm, request, "list", "edit");
                this.addAlternateMessage(mapping, request, APPCODE_SPACES_KEY);
                return this.getAlternateForward(mapping, request);
            }
            if (!app.getCode().equals(formAppcode)) {
                this.updateAppCode(app.getCode(), formAppcode);
                app.setCode(formAppcode);
            }
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        sess.saveOrUpdate((Object)app);
        sess.flush();
        this.populateForm(app, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward edit(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Applicatie app = this.getApplicatie(dynaForm, request);
        this.populateForm(app, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward copy(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer id = FormUtils.StringToInteger((String)request.getParameter("applicatieID"));
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Applicatie app = (Applicatie)sess.get(Applicatie.class, (Serializable)id);
        if (app == null) {
            this.addAlternateMessage(mapping, request, "failure");
            return this.getAlternateForward(mapping, request);
        }
        Applicatie newApp = KaartSelectieUtil.copyApplicatie((Applicatie)app, (boolean)app.getRead_only(), (boolean)app.getUser_copy());
        if (newApp == null) {
            this.addAlternateMessage(mapping, request, "failure");
            return this.getAlternateForward(mapping, request);
        }
        this.populateForm(newApp, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "success");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Applicatie app = this.getApplicatie(dynaForm, request);
        if (app != null) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            sess.delete((Object)app);
            sess.flush();
            KaartSelectieUtil.removeExistingConfigKeeperSettings((String)app.getCode());
            KaartSelectieUtil.removeExistingUserKaartgroepAndUserKaartlagen((String)app.getCode());
            KaartSelectieUtil.removeExistingUserServices((String)app.getCode());
            KaartSelectieUtil.removeCyclomediaAccount((String)app.getCode());
        }
        dynaForm.initialize(mapping);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    private Applicatie getApplicatie(DynaValidatorForm dynaForm, HttpServletRequest request) {
        Integer id = (Integer)dynaForm.get("applicatieID");
        if (id == null || id < 1) {
            return null;
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Applicatie app = (Applicatie)sess.get(Applicatie.class, (Serializable)id);
        return app;
    }

    private void populateForm(Applicatie app, DynaValidatorForm dynaForm, HttpServletRequest request) {
        if (app == null) {
            return;
        }
        dynaForm.set("applicatieID", (Object)app.getId());
        dynaForm.set("email", (Object)app.getEmail());
        dynaForm.set("naam", (Object)app.getNaam());
        dynaForm.set("gebruikersCode", (Object)app.getGebruikersCode());
        dynaForm.set("appCode", (Object)app.getCode());
        if (app.getParent() != null) {
            dynaForm.set("parent", (Object)app.getParent().getId());
        }
        dynaForm.set("defaultApp", (Object)app.getDefault_app());
        dynaForm.set("readOnly", (Object)app.getRead_only());
        request.setAttribute("appcode", (Object)app.getCode());
    }

    private void populateObject(DynaValidatorForm dynaForm, Applicatie app, HttpServletRequest request, Boolean populateReadOnlyFromForm) {
        Integer id = (Integer)dynaForm.get("applicatieID");
        if (id != null && id != 0) {
            app.setId(id);
        }
        app.setEmail(FormUtils.nullIfEmpty((String)dynaForm.getString("email")));
        app.setNaam(FormUtils.nullIfEmpty((String)dynaForm.getString("naam")));
        app.setGebruikersCode(FormUtils.nullIfEmpty((String)dynaForm.getString("gebruikersCode")));
        app.setParent(null);
        Boolean defaultApp = (Boolean)dynaForm.get("defaultApp");
        if (defaultApp != null) {
            app.setDefault_app(Boolean.valueOf(true));
        } else {
            app.setDefault_app(Boolean.valueOf(false));
        }
        if (populateReadOnlyFromForm.booleanValue()) {
            Boolean readOnly = (Boolean)dynaForm.get("readOnly");
            if (readOnly != null) {
                app.setRead_only(Boolean.valueOf(true));
            } else {
                app.setRead_only(Boolean.valueOf(false));
            }
        }
    }

    private void updateAppCode(String oldAppcode, String newAppcode) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List configs = sess.createQuery("from Configuratie where setting = :old").setParameter("old", (Object)oldAppcode).list();
        for (Configuratie config : configs) {
            config.setSetting(newAppcode);
            sess.save((Object)config);
        }
        List accounts = sess.createQuery("from CyclomediaAccount  where app_code = :old").setParameter("old", (Object)oldAppcode).list();
        for (CyclomediaAccount account : accounts) {
            account.setAppCode(newAppcode);
            sess.save((Object)account);
        }
        List groups = sess.createQuery("from UserKaartgroep where code = :old").setParameter("old", (Object)oldAppcode).list();
        for (UserKaartgroep group : groups) {
            group.setCode(newAppcode);
            sess.save((Object)group);
        }
        List layers = sess.createQuery("from UserKaartlaag where code = :old").setParameter("old", (Object)oldAppcode).list();
        for (UserKaartlaag layer : layers) {
            layer.setCode(newAppcode);
            sess.save((Object)layer);
        }
        List services = sess.createQuery("from UserService where code = :old").setParameter("old", (Object)oldAppcode).list();
        for (UserService service : services) {
            service.setCode(newAppcode);
            sess.save((Object)service);
        }
        sess.flush();
    }

    private void updateAppsToNonDefault() {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List allApps = sess.createQuery("from Applicatie").list();
        for (Applicatie app : allApps) {
            app.setDefault_app(Boolean.valueOf(false));
            sess.save((Object)app);
        }
        sess.flush();
    }
}

